/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/reservation/v1/reservation.proto

package com.google.cloud.bigquery.reservation.v1;

/**
 *
 *
 * <pre>
 * An assignment allows a project to submit jobs
 * of a certain type using slots from the specified reservation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.reservation.v1.Assignment}
 */
public final class Assignment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.reservation.v1.Assignment)
    AssignmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Assignment.newBuilder() to construct.
  private Assignment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Assignment() {
    name_ = "";
    assignee_ = "";
    jobType_ = 0;
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Assignment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_Assignment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_Assignment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.reservation.v1.Assignment.class,
            com.google.cloud.bigquery.reservation.v1.Assignment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Types of job, which could be specified when using the reservation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.reservation.v1.Assignment.JobType}
   */
  public enum JobType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid type. Requests with this value will be rejected with
     * error code `google.rpc.Code.INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>JOB_TYPE_UNSPECIFIED = 0;</code>
     */
    JOB_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Pipeline (load/export) jobs from the project will use the reservation.
     * </pre>
     *
     * <code>PIPELINE = 1;</code>
     */
    PIPELINE(1),
    /**
     *
     *
     * <pre>
     * Query jobs from the project will use the reservation.
     * </pre>
     *
     * <code>QUERY = 2;</code>
     */
    QUERY(2),
    /**
     *
     *
     * <pre>
     * BigQuery ML jobs that use services external to BigQuery for model
     * training. These jobs will not utilize idle slots from other reservations.
     * </pre>
     *
     * <code>ML_EXTERNAL = 3;</code>
     */
    ML_EXTERNAL(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid type. Requests with this value will be rejected with
     * error code `google.rpc.Code.INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>JOB_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int JOB_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Pipeline (load/export) jobs from the project will use the reservation.
     * </pre>
     *
     * <code>PIPELINE = 1;</code>
     */
    public static final int PIPELINE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Query jobs from the project will use the reservation.
     * </pre>
     *
     * <code>QUERY = 2;</code>
     */
    public static final int QUERY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * BigQuery ML jobs that use services external to BigQuery for model
     * training. These jobs will not utilize idle slots from other reservations.
     * </pre>
     *
     * <code>ML_EXTERNAL = 3;</code>
     */
    public static final int ML_EXTERNAL_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static JobType forNumber(int value) {
      switch (value) {
        case 0:
          return JOB_TYPE_UNSPECIFIED;
        case 1:
          return PIPELINE;
        case 2:
          return QUERY;
        case 3:
          return ML_EXTERNAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<JobType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<JobType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<JobType>() {
          public JobType findValueByNumber(int number) {
            return JobType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.Assignment.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final JobType[] VALUES = values();

    public static JobType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private JobType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.reservation.v1.Assignment.JobType)
  }

  /**
   *
   *
   * <pre>
   * Assignment will remain in PENDING state if no active capacity commitment is
   * present. It will become ACTIVE when some capacity commitment becomes
   * active.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.reservation.v1.Assignment.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid state value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Queries from assignee will be executed as on-demand, if related
     * assignment is pending.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * Assignment is ready.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid state value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Queries from assignee will be executed as on-demand, if related
     * assignment is pending.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Assignment is ready.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return ACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.Assignment.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.reservation.v1.Assignment.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Name of the resource. E.g.:
   * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
   * The assignment_id must only contain lower case alphanumeric characters or
   * dashes and the max length is 64 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the resource. E.g.:
   * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
   * The assignment_id must only contain lower case alphanumeric characters or
   * dashes and the max length is 64 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSIGNEE_FIELD_NUMBER = 4;
  private volatile java.lang.Object assignee_;
  /**
   *
   *
   * <pre>
   * The resource which will use the reservation. E.g.
   * `projects/myproject`, `folders/123`, or `organizations/456`.
   * </pre>
   *
   * <code>string assignee = 4;</code>
   *
   * @return The assignee.
   */
  @java.lang.Override
  public java.lang.String getAssignee() {
    java.lang.Object ref = assignee_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assignee_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource which will use the reservation. E.g.
   * `projects/myproject`, `folders/123`, or `organizations/456`.
   * </pre>
   *
   * <code>string assignee = 4;</code>
   *
   * @return The bytes for assignee.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAssigneeBytes() {
    java.lang.Object ref = assignee_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      assignee_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_TYPE_FIELD_NUMBER = 3;
  private int jobType_;
  /**
   *
   *
   * <pre>
   * Which type of jobs will use the reservation.
   * </pre>
   *
   * <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3;</code>
   *
   * @return The enum numeric value on the wire for jobType.
   */
  @java.lang.Override
  public int getJobTypeValue() {
    return jobType_;
  }
  /**
   *
   *
   * <pre>
   * Which type of jobs will use the reservation.
   * </pre>
   *
   * <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3;</code>
   *
   * @return The jobType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.Assignment.JobType getJobType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.reservation.v1.Assignment.JobType result =
        com.google.cloud.bigquery.reservation.v1.Assignment.JobType.valueOf(jobType_);
    return result == null
        ? com.google.cloud.bigquery.reservation.v1.Assignment.JobType.UNRECOGNIZED
        : result;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. State of the assignment.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the assignment.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.Assignment.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.bigquery.reservation.v1.Assignment.State result =
        com.google.cloud.bigquery.reservation.v1.Assignment.State.valueOf(state_);
    return result == null
        ? com.google.cloud.bigquery.reservation.v1.Assignment.State.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (jobType_
        != com.google.cloud.bigquery.reservation.v1.Assignment.JobType.JOB_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, jobType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assignee_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, assignee_);
    }
    if (state_
        != com.google.cloud.bigquery.reservation.v1.Assignment.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, state_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (jobType_
        != com.google.cloud.bigquery.reservation.v1.Assignment.JobType.JOB_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, jobType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(assignee_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, assignee_);
    }
    if (state_
        != com.google.cloud.bigquery.reservation.v1.Assignment.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.reservation.v1.Assignment)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.reservation.v1.Assignment other =
        (com.google.cloud.bigquery.reservation.v1.Assignment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAssignee().equals(other.getAssignee())) return false;
    if (jobType_ != other.jobType_) return false;
    if (state_ != other.state_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ASSIGNEE_FIELD_NUMBER;
    hash = (53 * hash) + getAssignee().hashCode();
    hash = (37 * hash) + JOB_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + jobType_;
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.reservation.v1.Assignment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An assignment allows a project to submit jobs
   * of a certain type using slots from the specified reservation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.reservation.v1.Assignment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.reservation.v1.Assignment)
      com.google.cloud.bigquery.reservation.v1.AssignmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_Assignment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_Assignment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.reservation.v1.Assignment.class,
              com.google.cloud.bigquery.reservation.v1.Assignment.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.reservation.v1.Assignment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      assignee_ = "";

      jobType_ = 0;

      state_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_Assignment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Assignment getDefaultInstanceForType() {
      return com.google.cloud.bigquery.reservation.v1.Assignment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Assignment build() {
      com.google.cloud.bigquery.reservation.v1.Assignment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Assignment buildPartial() {
      com.google.cloud.bigquery.reservation.v1.Assignment result =
          new com.google.cloud.bigquery.reservation.v1.Assignment(this);
      result.name_ = name_;
      result.assignee_ = assignee_;
      result.jobType_ = jobType_;
      result.state_ = state_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.reservation.v1.Assignment) {
        return mergeFrom((com.google.cloud.bigquery.reservation.v1.Assignment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.reservation.v1.Assignment other) {
      if (other == com.google.cloud.bigquery.reservation.v1.Assignment.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getAssignee().isEmpty()) {
        assignee_ = other.assignee_;
        onChanged();
      }
      if (other.jobType_ != 0) {
        setJobTypeValue(other.getJobTypeValue());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 24:
              {
                jobType_ = input.readEnum();

                break;
              } // case 24
            case 34:
              {
                assignee_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 48:
              {
                state_ = input.readEnum();

                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the resource. E.g.:
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     * The assignment_id must only contain lower case alphanumeric characters or
     * dashes and the max length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the resource. E.g.:
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     * The assignment_id must only contain lower case alphanumeric characters or
     * dashes and the max length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the resource. E.g.:
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     * The assignment_id must only contain lower case alphanumeric characters or
     * dashes and the max length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the resource. E.g.:
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     * The assignment_id must only contain lower case alphanumeric characters or
     * dashes and the max length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the resource. E.g.:
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     * The assignment_id must only contain lower case alphanumeric characters or
     * dashes and the max length is 64 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object assignee_ = "";
    /**
     *
     *
     * <pre>
     * The resource which will use the reservation. E.g.
     * `projects/myproject`, `folders/123`, or `organizations/456`.
     * </pre>
     *
     * <code>string assignee = 4;</code>
     *
     * @return The assignee.
     */
    public java.lang.String getAssignee() {
      java.lang.Object ref = assignee_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assignee_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource which will use the reservation. E.g.
     * `projects/myproject`, `folders/123`, or `organizations/456`.
     * </pre>
     *
     * <code>string assignee = 4;</code>
     *
     * @return The bytes for assignee.
     */
    public com.google.protobuf.ByteString getAssigneeBytes() {
      java.lang.Object ref = assignee_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        assignee_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource which will use the reservation. E.g.
     * `projects/myproject`, `folders/123`, or `organizations/456`.
     * </pre>
     *
     * <code>string assignee = 4;</code>
     *
     * @param value The assignee to set.
     * @return This builder for chaining.
     */
    public Builder setAssignee(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      assignee_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource which will use the reservation. E.g.
     * `projects/myproject`, `folders/123`, or `organizations/456`.
     * </pre>
     *
     * <code>string assignee = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssignee() {

      assignee_ = getDefaultInstance().getAssignee();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource which will use the reservation. E.g.
     * `projects/myproject`, `folders/123`, or `organizations/456`.
     * </pre>
     *
     * <code>string assignee = 4;</code>
     *
     * @param value The bytes for assignee to set.
     * @return This builder for chaining.
     */
    public Builder setAssigneeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      assignee_ = value;
      onChanged();
      return this;
    }

    private int jobType_ = 0;
    /**
     *
     *
     * <pre>
     * Which type of jobs will use the reservation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3;</code>
     *
     * @return The enum numeric value on the wire for jobType.
     */
    @java.lang.Override
    public int getJobTypeValue() {
      return jobType_;
    }
    /**
     *
     *
     * <pre>
     * Which type of jobs will use the reservation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3;</code>
     *
     * @param value The enum numeric value on the wire for jobType to set.
     * @return This builder for chaining.
     */
    public Builder setJobTypeValue(int value) {

      jobType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which type of jobs will use the reservation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3;</code>
     *
     * @return The jobType.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Assignment.JobType getJobType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.reservation.v1.Assignment.JobType result =
          com.google.cloud.bigquery.reservation.v1.Assignment.JobType.valueOf(jobType_);
      return result == null
          ? com.google.cloud.bigquery.reservation.v1.Assignment.JobType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Which type of jobs will use the reservation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3;</code>
     *
     * @param value The jobType to set.
     * @return This builder for chaining.
     */
    public Builder setJobType(com.google.cloud.bigquery.reservation.v1.Assignment.JobType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      jobType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which type of jobs will use the reservation.
     * </pre>
     *
     * <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobType() {

      jobType_ = 0;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the assignment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the assignment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the assignment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Assignment.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.bigquery.reservation.v1.Assignment.State result =
          com.google.cloud.bigquery.reservation.v1.Assignment.State.valueOf(state_);
      return result == null
          ? com.google.cloud.bigquery.reservation.v1.Assignment.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the assignment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.reservation.v1.Assignment.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the assignment.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.reservation.v1.Assignment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.reservation.v1.Assignment)
  private static final com.google.cloud.bigquery.reservation.v1.Assignment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.reservation.v1.Assignment();
  }

  public static com.google.cloud.bigquery.reservation.v1.Assignment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Assignment> PARSER =
      new com.google.protobuf.AbstractParser<Assignment>() {
        @java.lang.Override
        public Assignment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Assignment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Assignment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.Assignment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
