/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/deployment_resource_pool_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for QueryDeployedModels method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse}
 */
public final class QueryDeployedModelsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse)
    QueryDeployedModelsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryDeployedModelsResponse.newBuilder() to construct.
  private QueryDeployedModelsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryDeployedModelsResponse() {
    deployedModels_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    deployedModelRefs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryDeployedModelsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.DeploymentResourcePoolServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_QueryDeployedModelsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.DeploymentResourcePoolServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_QueryDeployedModelsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse.class,
            com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse.Builder.class);
  }

  public static final int DEPLOYED_MODELS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModel> deployedModels_;
  /**
   *
   *
   * <pre>
   * DEPRECATED Use deployed_model_refs instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModel> getDeployedModelsList() {
    return deployedModels_;
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED Use deployed_model_refs instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.DeployedModelOrBuilder>
      getDeployedModelsOrBuilderList() {
    return deployedModels_;
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED Use deployed_model_refs instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getDeployedModelsCount() {
    return deployedModels_.size();
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED Use deployed_model_refs instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.DeployedModel getDeployedModels(int index) {
    return deployedModels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED Use deployed_model_refs instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1beta1.DeployedModelOrBuilder getDeployedModelsOrBuilder(
      int index) {
    return deployedModels_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * A token, which can be sent as `page_token` to retrieve the next page.
   * If this field is omitted, there are no subsequent pages.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token, which can be sent as `page_token` to retrieve the next page.
   * If this field is omitted, there are no subsequent pages.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYED_MODEL_REFS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModelRef> deployedModelRefs_;
  /**
   *
   *
   * <pre>
   * References to the DeployedModels that share the specified
   * deploymentResourcePool.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModelRef>
      getDeployedModelRefsList() {
    return deployedModelRefs_;
  }
  /**
   *
   *
   * <pre>
   * References to the DeployedModels that share the specified
   * deploymentResourcePool.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.DeployedModelRefOrBuilder>
      getDeployedModelRefsOrBuilderList() {
    return deployedModelRefs_;
  }
  /**
   *
   *
   * <pre>
   * References to the DeployedModels that share the specified
   * deploymentResourcePool.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
   * </code>
   */
  @java.lang.Override
  public int getDeployedModelRefsCount() {
    return deployedModelRefs_.size();
  }
  /**
   *
   *
   * <pre>
   * References to the DeployedModels that share the specified
   * deploymentResourcePool.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployedModelRef getDeployedModelRefs(int index) {
    return deployedModelRefs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * References to the DeployedModels that share the specified
   * deploymentResourcePool.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DeployedModelRefOrBuilder
      getDeployedModelRefsOrBuilder(int index) {
    return deployedModelRefs_.get(index);
  }

  public static final int TOTAL_DEPLOYED_MODEL_COUNT_FIELD_NUMBER = 4;
  private int totalDeployedModelCount_ = 0;
  /**
   *
   *
   * <pre>
   * The total number of DeployedModels on this DeploymentResourcePool.
   * </pre>
   *
   * <code>int32 total_deployed_model_count = 4;</code>
   *
   * @return The totalDeployedModelCount.
   */
  @java.lang.Override
  public int getTotalDeployedModelCount() {
    return totalDeployedModelCount_;
  }

  public static final int TOTAL_ENDPOINT_COUNT_FIELD_NUMBER = 5;
  private int totalEndpointCount_ = 0;
  /**
   *
   *
   * <pre>
   * The total number of Endpoints that have DeployedModels on this
   * DeploymentResourcePool.
   * </pre>
   *
   * <code>int32 total_endpoint_count = 5;</code>
   *
   * @return The totalEndpointCount.
   */
  @java.lang.Override
  public int getTotalEndpointCount() {
    return totalEndpointCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < deployedModels_.size(); i++) {
      output.writeMessage(1, deployedModels_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < deployedModelRefs_.size(); i++) {
      output.writeMessage(3, deployedModelRefs_.get(i));
    }
    if (totalDeployedModelCount_ != 0) {
      output.writeInt32(4, totalDeployedModelCount_);
    }
    if (totalEndpointCount_ != 0) {
      output.writeInt32(5, totalEndpointCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < deployedModels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, deployedModels_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    for (int i = 0; i < deployedModelRefs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, deployedModelRefs_.get(i));
    }
    if (totalDeployedModelCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, totalDeployedModelCount_);
    }
    if (totalEndpointCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, totalEndpointCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse other =
        (com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse) obj;

    if (!getDeployedModelsList().equals(other.getDeployedModelsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getDeployedModelRefsList().equals(other.getDeployedModelRefsList())) return false;
    if (getTotalDeployedModelCount() != other.getTotalDeployedModelCount()) return false;
    if (getTotalEndpointCount() != other.getTotalEndpointCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDeployedModelsCount() > 0) {
      hash = (37 * hash) + DEPLOYED_MODELS_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedModelsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getDeployedModelRefsCount() > 0) {
      hash = (37 * hash) + DEPLOYED_MODEL_REFS_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedModelRefsList().hashCode();
    }
    hash = (37 * hash) + TOTAL_DEPLOYED_MODEL_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTotalDeployedModelCount();
    hash = (37 * hash) + TOTAL_ENDPOINT_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTotalEndpointCount();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for QueryDeployedModels method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse)
      com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.DeploymentResourcePoolServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_QueryDeployedModelsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.DeploymentResourcePoolServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_QueryDeployedModelsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse.class,
              com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (deployedModelsBuilder_ == null) {
        deployedModels_ = java.util.Collections.emptyList();
      } else {
        deployedModels_ = null;
        deployedModelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      if (deployedModelRefsBuilder_ == null) {
        deployedModelRefs_ = java.util.Collections.emptyList();
      } else {
        deployedModelRefs_ = null;
        deployedModelRefsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      totalDeployedModelCount_ = 0;
      totalEndpointCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.DeploymentResourcePoolServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_QueryDeployedModelsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse build() {
      com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse buildPartial() {
      com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse result =
          new com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse result) {
      if (deployedModelsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          deployedModels_ = java.util.Collections.unmodifiableList(deployedModels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.deployedModels_ = deployedModels_;
      } else {
        result.deployedModels_ = deployedModelsBuilder_.build();
      }
      if (deployedModelRefsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          deployedModelRefs_ = java.util.Collections.unmodifiableList(deployedModelRefs_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.deployedModelRefs_ = deployedModelRefs_;
      } else {
        result.deployedModelRefs_ = deployedModelRefsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.totalDeployedModelCount_ = totalDeployedModelCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.totalEndpointCount_ = totalEndpointCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse.getDefaultInstance())
        return this;
      if (deployedModelsBuilder_ == null) {
        if (!other.deployedModels_.isEmpty()) {
          if (deployedModels_.isEmpty()) {
            deployedModels_ = other.deployedModels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDeployedModelsIsMutable();
            deployedModels_.addAll(other.deployedModels_);
          }
          onChanged();
        }
      } else {
        if (!other.deployedModels_.isEmpty()) {
          if (deployedModelsBuilder_.isEmpty()) {
            deployedModelsBuilder_.dispose();
            deployedModelsBuilder_ = null;
            deployedModels_ = other.deployedModels_;
            bitField0_ = (bitField0_ & ~0x00000001);
            deployedModelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeployedModelsFieldBuilder()
                    : null;
          } else {
            deployedModelsBuilder_.addAllMessages(other.deployedModels_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (deployedModelRefsBuilder_ == null) {
        if (!other.deployedModelRefs_.isEmpty()) {
          if (deployedModelRefs_.isEmpty()) {
            deployedModelRefs_ = other.deployedModelRefs_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureDeployedModelRefsIsMutable();
            deployedModelRefs_.addAll(other.deployedModelRefs_);
          }
          onChanged();
        }
      } else {
        if (!other.deployedModelRefs_.isEmpty()) {
          if (deployedModelRefsBuilder_.isEmpty()) {
            deployedModelRefsBuilder_.dispose();
            deployedModelRefsBuilder_ = null;
            deployedModelRefs_ = other.deployedModelRefs_;
            bitField0_ = (bitField0_ & ~0x00000004);
            deployedModelRefsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeployedModelRefsFieldBuilder()
                    : null;
          } else {
            deployedModelRefsBuilder_.addAllMessages(other.deployedModelRefs_);
          }
        }
      }
      if (other.getTotalDeployedModelCount() != 0) {
        setTotalDeployedModelCount(other.getTotalDeployedModelCount());
      }
      if (other.getTotalEndpointCount() != 0) {
        setTotalEndpointCount(other.getTotalEndpointCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.DeployedModel m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.DeployedModel.parser(),
                        extensionRegistry);
                if (deployedModelsBuilder_ == null) {
                  ensureDeployedModelsIsMutable();
                  deployedModels_.add(m);
                } else {
                  deployedModelsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.DeployedModelRef m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.DeployedModelRef.parser(),
                        extensionRegistry);
                if (deployedModelRefsBuilder_ == null) {
                  ensureDeployedModelRefsIsMutable();
                  deployedModelRefs_.add(m);
                } else {
                  deployedModelRefsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                totalDeployedModelCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                totalEndpointCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModel> deployedModels_ =
        java.util.Collections.emptyList();

    private void ensureDeployedModelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        deployedModels_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.DeployedModel>(
                deployedModels_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployedModel,
            com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployedModelOrBuilder>
        deployedModelsBuilder_;

    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModel>
        getDeployedModelsList() {
      if (deployedModelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deployedModels_);
      } else {
        return deployedModelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getDeployedModelsCount() {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.size();
      } else {
        return deployedModelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.DeployedModel getDeployedModels(int index) {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.get(index);
      } else {
        return deployedModelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDeployedModels(
        int index, com.google.cloud.aiplatform.v1beta1.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.set(index, value);
        onChanged();
      } else {
        deployedModelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDeployedModels(
        int index, com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.set(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addDeployedModels(com.google.cloud.aiplatform.v1beta1.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.add(value);
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addDeployedModels(
        int index, com.google.cloud.aiplatform.v1beta1.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.add(index, value);
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addDeployedModels(
        com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.add(builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addDeployedModels(
        int index, com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.add(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllDeployedModels(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.DeployedModel> values) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deployedModels_);
        onChanged();
      } else {
        deployedModelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearDeployedModels() {
      if (deployedModelsBuilder_ == null) {
        deployedModels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        deployedModelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeDeployedModels(int index) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.remove(index);
        onChanged();
      } else {
        deployedModelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder getDeployedModelsBuilder(
        int index) {
      return getDeployedModelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.DeployedModelOrBuilder getDeployedModelsOrBuilder(
        int index) {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.get(index);
      } else {
        return deployedModelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.DeployedModelOrBuilder>
        getDeployedModelsOrBuilderList() {
      if (deployedModelsBuilder_ != null) {
        return deployedModelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deployedModels_);
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder addDeployedModelsBuilder() {
      return getDeployedModelsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.DeployedModel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder addDeployedModelsBuilder(
        int index) {
      return getDeployedModelsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.DeployedModel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED Use deployed_model_refs instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.DeployedModel deployed_models = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder>
        getDeployedModelsBuilderList() {
      return getDeployedModelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployedModel,
            com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployedModelOrBuilder>
        getDeployedModelsFieldBuilder() {
      if (deployedModelsBuilder_ == null) {
        deployedModelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DeployedModel,
                com.google.cloud.aiplatform.v1beta1.DeployedModel.Builder,
                com.google.cloud.aiplatform.v1beta1.DeployedModelOrBuilder>(
                deployedModels_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        deployedModels_ = null;
      }
      return deployedModelsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModelRef>
        deployedModelRefs_ = java.util.Collections.emptyList();

    private void ensureDeployedModelRefsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        deployedModelRefs_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.DeployedModelRef>(
                deployedModelRefs_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployedModelRef,
            com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployedModelRefOrBuilder>
        deployedModelRefsBuilder_;

    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModelRef>
        getDeployedModelRefsList() {
      if (deployedModelRefsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deployedModelRefs_);
      } else {
        return deployedModelRefsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public int getDeployedModelRefsCount() {
      if (deployedModelRefsBuilder_ == null) {
        return deployedModelRefs_.size();
      } else {
        return deployedModelRefsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployedModelRef getDeployedModelRefs(int index) {
      if (deployedModelRefsBuilder_ == null) {
        return deployedModelRefs_.get(index);
      } else {
        return deployedModelRefsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder setDeployedModelRefs(
        int index, com.google.cloud.aiplatform.v1beta1.DeployedModelRef value) {
      if (deployedModelRefsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelRefsIsMutable();
        deployedModelRefs_.set(index, value);
        onChanged();
      } else {
        deployedModelRefsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder setDeployedModelRefs(
        int index, com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder builderForValue) {
      if (deployedModelRefsBuilder_ == null) {
        ensureDeployedModelRefsIsMutable();
        deployedModelRefs_.set(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelRefsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder addDeployedModelRefs(
        com.google.cloud.aiplatform.v1beta1.DeployedModelRef value) {
      if (deployedModelRefsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelRefsIsMutable();
        deployedModelRefs_.add(value);
        onChanged();
      } else {
        deployedModelRefsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder addDeployedModelRefs(
        int index, com.google.cloud.aiplatform.v1beta1.DeployedModelRef value) {
      if (deployedModelRefsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelRefsIsMutable();
        deployedModelRefs_.add(index, value);
        onChanged();
      } else {
        deployedModelRefsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder addDeployedModelRefs(
        com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder builderForValue) {
      if (deployedModelRefsBuilder_ == null) {
        ensureDeployedModelRefsIsMutable();
        deployedModelRefs_.add(builderForValue.build());
        onChanged();
      } else {
        deployedModelRefsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder addDeployedModelRefs(
        int index, com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder builderForValue) {
      if (deployedModelRefsBuilder_ == null) {
        ensureDeployedModelRefsIsMutable();
        deployedModelRefs_.add(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelRefsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder addAllDeployedModelRefs(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.DeployedModelRef> values) {
      if (deployedModelRefsBuilder_ == null) {
        ensureDeployedModelRefsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deployedModelRefs_);
        onChanged();
      } else {
        deployedModelRefsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder clearDeployedModelRefs() {
      if (deployedModelRefsBuilder_ == null) {
        deployedModelRefs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        deployedModelRefsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public Builder removeDeployedModelRefs(int index) {
      if (deployedModelRefsBuilder_ == null) {
        ensureDeployedModelRefsIsMutable();
        deployedModelRefs_.remove(index);
        onChanged();
      } else {
        deployedModelRefsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder getDeployedModelRefsBuilder(
        int index) {
      return getDeployedModelRefsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployedModelRefOrBuilder
        getDeployedModelRefsOrBuilder(int index) {
      if (deployedModelRefsBuilder_ == null) {
        return deployedModelRefs_.get(index);
      } else {
        return deployedModelRefsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.DeployedModelRefOrBuilder>
        getDeployedModelRefsOrBuilderList() {
      if (deployedModelRefsBuilder_ != null) {
        return deployedModelRefsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deployedModelRefs_);
      }
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder
        addDeployedModelRefsBuilder() {
      return getDeployedModelRefsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.DeployedModelRef.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder addDeployedModelRefsBuilder(
        int index) {
      return getDeployedModelRefsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.DeployedModelRef.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * References to the DeployedModels that share the specified
     * deploymentResourcePool.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.DeployedModelRef deployed_model_refs = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder>
        getDeployedModelRefsBuilderList() {
      return getDeployedModelRefsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DeployedModelRef,
            com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder,
            com.google.cloud.aiplatform.v1beta1.DeployedModelRefOrBuilder>
        getDeployedModelRefsFieldBuilder() {
      if (deployedModelRefsBuilder_ == null) {
        deployedModelRefsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DeployedModelRef,
                com.google.cloud.aiplatform.v1beta1.DeployedModelRef.Builder,
                com.google.cloud.aiplatform.v1beta1.DeployedModelRefOrBuilder>(
                deployedModelRefs_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        deployedModelRefs_ = null;
      }
      return deployedModelRefsBuilder_;
    }

    private int totalDeployedModelCount_;
    /**
     *
     *
     * <pre>
     * The total number of DeployedModels on this DeploymentResourcePool.
     * </pre>
     *
     * <code>int32 total_deployed_model_count = 4;</code>
     *
     * @return The totalDeployedModelCount.
     */
    @java.lang.Override
    public int getTotalDeployedModelCount() {
      return totalDeployedModelCount_;
    }
    /**
     *
     *
     * <pre>
     * The total number of DeployedModels on this DeploymentResourcePool.
     * </pre>
     *
     * <code>int32 total_deployed_model_count = 4;</code>
     *
     * @param value The totalDeployedModelCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalDeployedModelCount(int value) {

      totalDeployedModelCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The total number of DeployedModels on this DeploymentResourcePool.
     * </pre>
     *
     * <code>int32 total_deployed_model_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalDeployedModelCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      totalDeployedModelCount_ = 0;
      onChanged();
      return this;
    }

    private int totalEndpointCount_;
    /**
     *
     *
     * <pre>
     * The total number of Endpoints that have DeployedModels on this
     * DeploymentResourcePool.
     * </pre>
     *
     * <code>int32 total_endpoint_count = 5;</code>
     *
     * @return The totalEndpointCount.
     */
    @java.lang.Override
    public int getTotalEndpointCount() {
      return totalEndpointCount_;
    }
    /**
     *
     *
     * <pre>
     * The total number of Endpoints that have DeployedModels on this
     * DeploymentResourcePool.
     * </pre>
     *
     * <code>int32 total_endpoint_count = 5;</code>
     *
     * @param value The totalEndpointCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalEndpointCount(int value) {

      totalEndpointCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The total number of Endpoints that have DeployedModels on this
     * DeploymentResourcePool.
     * </pre>
     *
     * <code>int32 total_endpoint_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalEndpointCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      totalEndpointCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse)
  private static final com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse();
  }

  public static com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryDeployedModelsResponse> PARSER =
      new com.google.protobuf.AbstractParser<QueryDeployedModelsResponse>() {
        @java.lang.Override
        public QueryDeployedModelsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryDeployedModelsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryDeployedModelsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.QueryDeployedModelsResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
