/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/featurestore_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Details of operations that perform import Feature values.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata}
 */
public final class ImportFeatureValuesOperationMetadata
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata)
    ImportFeatureValuesOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportFeatureValuesOperationMetadata.newBuilder() to construct.
  private ImportFeatureValuesOperationMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportFeatureValuesOperationMetadata() {
    sourceUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
    blockingOperationIds_ = emptyLongList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportFeatureValuesOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata.class,
            com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int GENERIC_METADATA_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata genericMetadata_;
  /**
   *
   *
   * <pre>
   * Operation metadata for Featurestore import Feature values.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
   *
   * @return Whether the genericMetadata field is set.
   */
  @java.lang.Override
  public boolean hasGenericMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Operation metadata for Featurestore import Feature values.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
   *
   * @return The genericMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata getGenericMetadata() {
    return genericMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.getDefaultInstance()
        : genericMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Operation metadata for Featurestore import Feature values.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder
      getGenericMetadataOrBuilder() {
    return genericMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.getDefaultInstance()
        : genericMetadata_;
  }

  public static final int IMPORTED_ENTITY_COUNT_FIELD_NUMBER = 2;
  private long importedEntityCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of entities that have been imported by the operation.
   * </pre>
   *
   * <code>int64 imported_entity_count = 2;</code>
   *
   * @return The importedEntityCount.
   */
  @java.lang.Override
  public long getImportedEntityCount() {
    return importedEntityCount_;
  }

  public static final int IMPORTED_FEATURE_VALUE_COUNT_FIELD_NUMBER = 3;
  private long importedFeatureValueCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of Feature values that have been imported by the operation.
   * </pre>
   *
   * <code>int64 imported_feature_value_count = 3;</code>
   *
   * @return The importedFeatureValueCount.
   */
  @java.lang.Override
  public long getImportedFeatureValueCount() {
    return importedFeatureValueCount_;
  }

  public static final int SOURCE_URIS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The source URI from where Feature values are imported.
   * </pre>
   *
   * <code>repeated string source_uris = 4;</code>
   *
   * @return A list containing the sourceUris.
   */
  public com.google.protobuf.ProtocolStringList getSourceUrisList() {
    return sourceUris_;
  }
  /**
   *
   *
   * <pre>
   * The source URI from where Feature values are imported.
   * </pre>
   *
   * <code>repeated string source_uris = 4;</code>
   *
   * @return The count of sourceUris.
   */
  public int getSourceUrisCount() {
    return sourceUris_.size();
  }
  /**
   *
   *
   * <pre>
   * The source URI from where Feature values are imported.
   * </pre>
   *
   * <code>repeated string source_uris = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceUris at the given index.
   */
  public java.lang.String getSourceUris(int index) {
    return sourceUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The source URI from where Feature values are imported.
   * </pre>
   *
   * <code>repeated string source_uris = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceUris at the given index.
   */
  public com.google.protobuf.ByteString getSourceUrisBytes(int index) {
    return sourceUris_.getByteString(index);
  }

  public static final int INVALID_ROW_COUNT_FIELD_NUMBER = 6;
  private long invalidRowCount_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of rows in input source that weren't imported due to either
   * * Not having any featureValues.
   * * Having a null entityId.
   * * Having a null timestamp.
   * * Not being parsable (applicable for CSV sources).
   * </pre>
   *
   * <code>int64 invalid_row_count = 6;</code>
   *
   * @return The invalidRowCount.
   */
  @java.lang.Override
  public long getInvalidRowCount() {
    return invalidRowCount_;
  }

  public static final int TIMESTAMP_OUTSIDE_RETENTION_ROWS_COUNT_FIELD_NUMBER = 7;
  private long timestampOutsideRetentionRowsCount_ = 0L;
  /**
   *
   *
   * <pre>
   * The number rows that weren't ingested due to having timestamps outside the
   * retention boundary.
   * </pre>
   *
   * <code>int64 timestamp_outside_retention_rows_count = 7;</code>
   *
   * @return The timestampOutsideRetentionRowsCount.
   */
  @java.lang.Override
  public long getTimestampOutsideRetentionRowsCount() {
    return timestampOutsideRetentionRowsCount_;
  }

  public static final int BLOCKING_OPERATION_IDS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList blockingOperationIds_ = emptyLongList();
  /**
   *
   *
   * <pre>
   * List of ImportFeatureValues operations running under a single EntityType
   * that are blocking this operation.
   * </pre>
   *
   * <code>repeated int64 blocking_operation_ids = 8;</code>
   *
   * @return A list containing the blockingOperationIds.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getBlockingOperationIdsList() {
    return blockingOperationIds_;
  }
  /**
   *
   *
   * <pre>
   * List of ImportFeatureValues operations running under a single EntityType
   * that are blocking this operation.
   * </pre>
   *
   * <code>repeated int64 blocking_operation_ids = 8;</code>
   *
   * @return The count of blockingOperationIds.
   */
  public int getBlockingOperationIdsCount() {
    return blockingOperationIds_.size();
  }
  /**
   *
   *
   * <pre>
   * List of ImportFeatureValues operations running under a single EntityType
   * that are blocking this operation.
   * </pre>
   *
   * <code>repeated int64 blocking_operation_ids = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The blockingOperationIds at the given index.
   */
  public long getBlockingOperationIds(int index) {
    return blockingOperationIds_.getLong(index);
  }

  private int blockingOperationIdsMemoizedSerializedSize = -1;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getGenericMetadata());
    }
    if (importedEntityCount_ != 0L) {
      output.writeInt64(2, importedEntityCount_);
    }
    if (importedFeatureValueCount_ != 0L) {
      output.writeInt64(3, importedFeatureValueCount_);
    }
    for (int i = 0; i < sourceUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, sourceUris_.getRaw(i));
    }
    if (invalidRowCount_ != 0L) {
      output.writeInt64(6, invalidRowCount_);
    }
    if (timestampOutsideRetentionRowsCount_ != 0L) {
      output.writeInt64(7, timestampOutsideRetentionRowsCount_);
    }
    if (getBlockingOperationIdsList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(blockingOperationIdsMemoizedSerializedSize);
    }
    for (int i = 0; i < blockingOperationIds_.size(); i++) {
      output.writeInt64NoTag(blockingOperationIds_.getLong(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGenericMetadata());
    }
    if (importedEntityCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, importedEntityCount_);
    }
    if (importedFeatureValueCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, importedFeatureValueCount_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSourceUrisList().size();
    }
    if (invalidRowCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, invalidRowCount_);
    }
    if (timestampOutsideRetentionRowsCount_ != 0L) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              7, timestampOutsideRetentionRowsCount_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < blockingOperationIds_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(
                blockingOperationIds_.getLong(i));
      }
      size += dataSize;
      if (!getBlockingOperationIdsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      blockingOperationIdsMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata other =
        (com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata) obj;

    if (hasGenericMetadata() != other.hasGenericMetadata()) return false;
    if (hasGenericMetadata()) {
      if (!getGenericMetadata().equals(other.getGenericMetadata())) return false;
    }
    if (getImportedEntityCount() != other.getImportedEntityCount()) return false;
    if (getImportedFeatureValueCount() != other.getImportedFeatureValueCount()) return false;
    if (!getSourceUrisList().equals(other.getSourceUrisList())) return false;
    if (getInvalidRowCount() != other.getInvalidRowCount()) return false;
    if (getTimestampOutsideRetentionRowsCount() != other.getTimestampOutsideRetentionRowsCount())
      return false;
    if (!getBlockingOperationIdsList().equals(other.getBlockingOperationIdsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasGenericMetadata()) {
      hash = (37 * hash) + GENERIC_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getGenericMetadata().hashCode();
    }
    hash = (37 * hash) + IMPORTED_ENTITY_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getImportedEntityCount());
    hash = (37 * hash) + IMPORTED_FEATURE_VALUE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getImportedFeatureValueCount());
    if (getSourceUrisCount() > 0) {
      hash = (37 * hash) + SOURCE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceUrisList().hashCode();
    }
    hash = (37 * hash) + INVALID_ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getInvalidRowCount());
    hash = (37 * hash) + TIMESTAMP_OUTSIDE_RETENTION_ROWS_COUNT_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(getTimestampOutsideRetentionRowsCount());
    if (getBlockingOperationIdsCount() > 0) {
      hash = (37 * hash) + BLOCKING_OPERATION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getBlockingOperationIdsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of operations that perform import Feature values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata)
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata.class,
              com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGenericMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      genericMetadata_ = null;
      if (genericMetadataBuilder_ != null) {
        genericMetadataBuilder_.dispose();
        genericMetadataBuilder_ = null;
      }
      importedEntityCount_ = 0L;
      importedFeatureValueCount_ = 0L;
      sourceUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      invalidRowCount_ = 0L;
      timestampOutsideRetentionRowsCount_ = 0L;
      blockingOperationIds_ = emptyLongList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportFeatureValuesOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata build() {
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata result =
          new com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.genericMetadata_ =
            genericMetadataBuilder_ == null ? genericMetadata_ : genericMetadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.importedEntityCount_ = importedEntityCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.importedFeatureValueCount_ = importedFeatureValueCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        sourceUris_.makeImmutable();
        result.sourceUris_ = sourceUris_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.invalidRowCount_ = invalidRowCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.timestampOutsideRetentionRowsCount_ = timestampOutsideRetentionRowsCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        blockingOperationIds_.makeImmutable();
        result.blockingOperationIds_ = blockingOperationIds_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata
              .getDefaultInstance()) return this;
      if (other.hasGenericMetadata()) {
        mergeGenericMetadata(other.getGenericMetadata());
      }
      if (other.getImportedEntityCount() != 0L) {
        setImportedEntityCount(other.getImportedEntityCount());
      }
      if (other.getImportedFeatureValueCount() != 0L) {
        setImportedFeatureValueCount(other.getImportedFeatureValueCount());
      }
      if (!other.sourceUris_.isEmpty()) {
        if (sourceUris_.isEmpty()) {
          sourceUris_ = other.sourceUris_;
          bitField0_ |= 0x00000008;
        } else {
          ensureSourceUrisIsMutable();
          sourceUris_.addAll(other.sourceUris_);
        }
        onChanged();
      }
      if (other.getInvalidRowCount() != 0L) {
        setInvalidRowCount(other.getInvalidRowCount());
      }
      if (other.getTimestampOutsideRetentionRowsCount() != 0L) {
        setTimestampOutsideRetentionRowsCount(other.getTimestampOutsideRetentionRowsCount());
      }
      if (!other.blockingOperationIds_.isEmpty()) {
        if (blockingOperationIds_.isEmpty()) {
          blockingOperationIds_ = other.blockingOperationIds_;
          blockingOperationIds_.makeImmutable();
          bitField0_ |= 0x00000040;
        } else {
          ensureBlockingOperationIdsIsMutable();
          blockingOperationIds_.addAll(other.blockingOperationIds_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGenericMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                importedEntityCount_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                importedFeatureValueCount_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceUrisIsMutable();
                sourceUris_.add(s);
                break;
              } // case 34
            case 48:
              {
                invalidRowCount_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 56:
              {
                timestampOutsideRetentionRowsCount_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 64:
              {
                long v = input.readInt64();
                ensureBlockingOperationIdsIsMutable();
                blockingOperationIds_.addLong(v);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureBlockingOperationIdsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  blockingOperationIds_.addLong(input.readInt64());
                }
                input.popLimit(limit);
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata genericMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata,
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder>
        genericMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     *
     * @return Whether the genericMetadata field is set.
     */
    public boolean hasGenericMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     *
     * @return The genericMetadata.
     */
    public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata getGenericMetadata() {
      if (genericMetadataBuilder_ == null) {
        return genericMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.getDefaultInstance()
            : genericMetadata_;
      } else {
        return genericMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder setGenericMetadata(
        com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata value) {
      if (genericMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        genericMetadata_ = value;
      } else {
        genericMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder setGenericMetadata(
        com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder builderForValue) {
      if (genericMetadataBuilder_ == null) {
        genericMetadata_ = builderForValue.build();
      } else {
        genericMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder mergeGenericMetadata(
        com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata value) {
      if (genericMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && genericMetadata_ != null
            && genericMetadata_
                != com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata
                    .getDefaultInstance()) {
          getGenericMetadataBuilder().mergeFrom(value);
        } else {
          genericMetadata_ = value;
        }
      } else {
        genericMetadataBuilder_.mergeFrom(value);
      }
      if (genericMetadata_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder clearGenericMetadata() {
      bitField0_ = (bitField0_ & ~0x00000001);
      genericMetadata_ = null;
      if (genericMetadataBuilder_ != null) {
        genericMetadataBuilder_.dispose();
        genericMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder
        getGenericMetadataBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getGenericMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder
        getGenericMetadataOrBuilder() {
      if (genericMetadataBuilder_ != null) {
        return genericMetadataBuilder_.getMessageOrBuilder();
      } else {
        return genericMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.getDefaultInstance()
            : genericMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Operation metadata for Featurestore import Feature values.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata,
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder>
        getGenericMetadataFieldBuilder() {
      if (genericMetadataBuilder_ == null) {
        genericMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata,
                com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder>(
                getGenericMetadata(), getParentForChildren(), isClean());
        genericMetadata_ = null;
      }
      return genericMetadataBuilder_;
    }

    private long importedEntityCount_;
    /**
     *
     *
     * <pre>
     * Number of entities that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_entity_count = 2;</code>
     *
     * @return The importedEntityCount.
     */
    @java.lang.Override
    public long getImportedEntityCount() {
      return importedEntityCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of entities that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_entity_count = 2;</code>
     *
     * @param value The importedEntityCount to set.
     * @return This builder for chaining.
     */
    public Builder setImportedEntityCount(long value) {

      importedEntityCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of entities that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_entity_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportedEntityCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      importedEntityCount_ = 0L;
      onChanged();
      return this;
    }

    private long importedFeatureValueCount_;
    /**
     *
     *
     * <pre>
     * Number of Feature values that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_feature_value_count = 3;</code>
     *
     * @return The importedFeatureValueCount.
     */
    @java.lang.Override
    public long getImportedFeatureValueCount() {
      return importedFeatureValueCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of Feature values that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_feature_value_count = 3;</code>
     *
     * @param value The importedFeatureValueCount to set.
     * @return This builder for chaining.
     */
    public Builder setImportedFeatureValueCount(long value) {

      importedFeatureValueCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of Feature values that have been imported by the operation.
     * </pre>
     *
     * <code>int64 imported_feature_value_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportedFeatureValueCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      importedFeatureValueCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceUrisIsMutable() {
      if (!sourceUris_.isModifiable()) {
        sourceUris_ = new com.google.protobuf.LazyStringArrayList(sourceUris_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @return A list containing the sourceUris.
     */
    public com.google.protobuf.ProtocolStringList getSourceUrisList() {
      sourceUris_.makeImmutable();
      return sourceUris_;
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @return The count of sourceUris.
     */
    public int getSourceUrisCount() {
      return sourceUris_.size();
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceUris at the given index.
     */
    public java.lang.String getSourceUris(int index) {
      return sourceUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceUris at the given index.
     */
    public com.google.protobuf.ByteString getSourceUrisBytes(int index) {
      return sourceUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceUris to set.
     * @return This builder for chaining.
     */
    public Builder setSourceUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceUrisIsMutable();
      sourceUris_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @param value The sourceUris to add.
     * @return This builder for chaining.
     */
    public Builder addSourceUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceUrisIsMutable();
      sourceUris_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @param values The sourceUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceUris(java.lang.Iterable<java.lang.String> values) {
      ensureSourceUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceUris_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceUris() {
      sourceUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source URI from where Feature values are imported.
     * </pre>
     *
     * <code>repeated string source_uris = 4;</code>
     *
     * @param value The bytes of the sourceUris to add.
     * @return This builder for chaining.
     */
    public Builder addSourceUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceUrisIsMutable();
      sourceUris_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long invalidRowCount_;
    /**
     *
     *
     * <pre>
     * The number of rows in input source that weren't imported due to either
     * * Not having any featureValues.
     * * Having a null entityId.
     * * Having a null timestamp.
     * * Not being parsable (applicable for CSV sources).
     * </pre>
     *
     * <code>int64 invalid_row_count = 6;</code>
     *
     * @return The invalidRowCount.
     */
    @java.lang.Override
    public long getInvalidRowCount() {
      return invalidRowCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of rows in input source that weren't imported due to either
     * * Not having any featureValues.
     * * Having a null entityId.
     * * Having a null timestamp.
     * * Not being parsable (applicable for CSV sources).
     * </pre>
     *
     * <code>int64 invalid_row_count = 6;</code>
     *
     * @param value The invalidRowCount to set.
     * @return This builder for chaining.
     */
    public Builder setInvalidRowCount(long value) {

      invalidRowCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of rows in input source that weren't imported due to either
     * * Not having any featureValues.
     * * Having a null entityId.
     * * Having a null timestamp.
     * * Not being parsable (applicable for CSV sources).
     * </pre>
     *
     * <code>int64 invalid_row_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvalidRowCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      invalidRowCount_ = 0L;
      onChanged();
      return this;
    }

    private long timestampOutsideRetentionRowsCount_;
    /**
     *
     *
     * <pre>
     * The number rows that weren't ingested due to having timestamps outside the
     * retention boundary.
     * </pre>
     *
     * <code>int64 timestamp_outside_retention_rows_count = 7;</code>
     *
     * @return The timestampOutsideRetentionRowsCount.
     */
    @java.lang.Override
    public long getTimestampOutsideRetentionRowsCount() {
      return timestampOutsideRetentionRowsCount_;
    }
    /**
     *
     *
     * <pre>
     * The number rows that weren't ingested due to having timestamps outside the
     * retention boundary.
     * </pre>
     *
     * <code>int64 timestamp_outside_retention_rows_count = 7;</code>
     *
     * @param value The timestampOutsideRetentionRowsCount to set.
     * @return This builder for chaining.
     */
    public Builder setTimestampOutsideRetentionRowsCount(long value) {

      timestampOutsideRetentionRowsCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number rows that weren't ingested due to having timestamps outside the
     * retention boundary.
     * </pre>
     *
     * <code>int64 timestamp_outside_retention_rows_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimestampOutsideRetentionRowsCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      timestampOutsideRetentionRowsCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList blockingOperationIds_ = emptyLongList();

    private void ensureBlockingOperationIdsIsMutable() {
      if (!blockingOperationIds_.isModifiable()) {
        blockingOperationIds_ = makeMutableCopy(blockingOperationIds_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * List of ImportFeatureValues operations running under a single EntityType
     * that are blocking this operation.
     * </pre>
     *
     * <code>repeated int64 blocking_operation_ids = 8;</code>
     *
     * @return A list containing the blockingOperationIds.
     */
    public java.util.List<java.lang.Long> getBlockingOperationIdsList() {
      blockingOperationIds_.makeImmutable();
      return blockingOperationIds_;
    }
    /**
     *
     *
     * <pre>
     * List of ImportFeatureValues operations running under a single EntityType
     * that are blocking this operation.
     * </pre>
     *
     * <code>repeated int64 blocking_operation_ids = 8;</code>
     *
     * @return The count of blockingOperationIds.
     */
    public int getBlockingOperationIdsCount() {
      return blockingOperationIds_.size();
    }
    /**
     *
     *
     * <pre>
     * List of ImportFeatureValues operations running under a single EntityType
     * that are blocking this operation.
     * </pre>
     *
     * <code>repeated int64 blocking_operation_ids = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The blockingOperationIds at the given index.
     */
    public long getBlockingOperationIds(int index) {
      return blockingOperationIds_.getLong(index);
    }
    /**
     *
     *
     * <pre>
     * List of ImportFeatureValues operations running under a single EntityType
     * that are blocking this operation.
     * </pre>
     *
     * <code>repeated int64 blocking_operation_ids = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The blockingOperationIds to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingOperationIds(int index, long value) {

      ensureBlockingOperationIdsIsMutable();
      blockingOperationIds_.setLong(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ImportFeatureValues operations running under a single EntityType
     * that are blocking this operation.
     * </pre>
     *
     * <code>repeated int64 blocking_operation_ids = 8;</code>
     *
     * @param value The blockingOperationIds to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingOperationIds(long value) {

      ensureBlockingOperationIdsIsMutable();
      blockingOperationIds_.addLong(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ImportFeatureValues operations running under a single EntityType
     * that are blocking this operation.
     * </pre>
     *
     * <code>repeated int64 blocking_operation_ids = 8;</code>
     *
     * @param values The blockingOperationIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllBlockingOperationIds(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureBlockingOperationIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blockingOperationIds_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ImportFeatureValues operations running under a single EntityType
     * that are blocking this operation.
     * </pre>
     *
     * <code>repeated int64 blocking_operation_ids = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockingOperationIds() {
      blockingOperationIds_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata)
  private static final com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata();
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportFeatureValuesOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ImportFeatureValuesOperationMetadata>() {
        @java.lang.Override
        public ImportFeatureValuesOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportFeatureValuesOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportFeatureValuesOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportFeatureValuesOperationMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
