/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/prediction_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for [PredictionService.GenerateContent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateContentResponse}
 */
public final class GenerateContentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateContentResponse)
    GenerateContentResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateContentResponse.newBuilder() to construct.
  private GenerateContentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateContentResponse() {
    candidates_ = java.util.Collections.emptyList();
    modelVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateContentResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.class,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.Builder.class);
  }

  public interface PromptFeedbackOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Blocked reason.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for blockReason.
     */
    int getBlockReasonValue();
    /**
     *
     *
     * <pre>
     * Output only. Blocked reason.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The blockReason.
     */
    com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason
        getBlockReason();

    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1beta1.SafetyRating> getSafetyRatingsList();
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.SafetyRating getSafetyRatings(int index);
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getSafetyRatingsCount();
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder>
        getSafetyRatingsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Output only. A readable block reason message.
     * </pre>
     *
     * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The blockReasonMessage.
     */
    java.lang.String getBlockReasonMessage();
    /**
     *
     *
     * <pre>
     * Output only. A readable block reason message.
     * </pre>
     *
     * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for blockReasonMessage.
     */
    com.google.protobuf.ByteString getBlockReasonMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * Content filter results for a prompt sent in the request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback}
   */
  public static final class PromptFeedback extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback)
      PromptFeedbackOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PromptFeedback.newBuilder() to construct.
    private PromptFeedback(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PromptFeedback() {
      blockReason_ = 0;
      safetyRatings_ = java.util.Collections.emptyList();
      blockReasonMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PromptFeedback();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_PromptFeedback_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_PromptFeedback_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.class,
              com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Blocked reason enumeration.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason}
     */
    public enum BlockedReason implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified blocked reason.
       * </pre>
       *
       * <code>BLOCKED_REASON_UNSPECIFIED = 0;</code>
       */
      BLOCKED_REASON_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Candidates blocked due to safety.
       * </pre>
       *
       * <code>SAFETY = 1;</code>
       */
      SAFETY(1),
      /**
       *
       *
       * <pre>
       * Candidates blocked due to other reason.
       * </pre>
       *
       * <code>OTHER = 2;</code>
       */
      OTHER(2),
      /**
       *
       *
       * <pre>
       * Candidates blocked due to the terms which are included from the
       * terminology blocklist.
       * </pre>
       *
       * <code>BLOCKLIST = 3;</code>
       */
      BLOCKLIST(3),
      /**
       *
       *
       * <pre>
       * Candidates blocked due to prohibited content.
       * </pre>
       *
       * <code>PROHIBITED_CONTENT = 4;</code>
       */
      PROHIBITED_CONTENT(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified blocked reason.
       * </pre>
       *
       * <code>BLOCKED_REASON_UNSPECIFIED = 0;</code>
       */
      public static final int BLOCKED_REASON_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Candidates blocked due to safety.
       * </pre>
       *
       * <code>SAFETY = 1;</code>
       */
      public static final int SAFETY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Candidates blocked due to other reason.
       * </pre>
       *
       * <code>OTHER = 2;</code>
       */
      public static final int OTHER_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Candidates blocked due to the terms which are included from the
       * terminology blocklist.
       * </pre>
       *
       * <code>BLOCKLIST = 3;</code>
       */
      public static final int BLOCKLIST_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Candidates blocked due to prohibited content.
       * </pre>
       *
       * <code>PROHIBITED_CONTENT = 4;</code>
       */
      public static final int PROHIBITED_CONTENT_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static BlockedReason valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static BlockedReason forNumber(int value) {
        switch (value) {
          case 0:
            return BLOCKED_REASON_UNSPECIFIED;
          case 1:
            return SAFETY;
          case 2:
            return OTHER;
          case 3:
            return BLOCKLIST;
          case 4:
            return PROHIBITED_CONTENT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<BlockedReason> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<BlockedReason>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<BlockedReason>() {
                public BlockedReason findValueByNumber(int number) {
                  return BlockedReason.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final BlockedReason[] VALUES = values();

      public static BlockedReason valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private BlockedReason(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason)
    }

    public static final int BLOCK_REASON_FIELD_NUMBER = 1;
    private int blockReason_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Blocked reason.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for blockReason.
     */
    @java.lang.Override
    public int getBlockReasonValue() {
      return blockReason_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Blocked reason.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The blockReason.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason
        getBlockReason() {
      com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason
          result =
              com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
                  .BlockedReason.forNumber(blockReason_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason
              .UNRECOGNIZED
          : result;
    }

    public static final int SAFETY_RATINGS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1beta1.SafetyRating> safetyRatings_;
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1beta1.SafetyRating> getSafetyRatingsList() {
      return safetyRatings_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder>
        getSafetyRatingsOrBuilderList() {
      return safetyRatings_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getSafetyRatingsCount() {
      return safetyRatings_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SafetyRating getSafetyRatings(int index) {
      return safetyRatings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Safety ratings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(
        int index) {
      return safetyRatings_.get(index);
    }

    public static final int BLOCK_REASON_MESSAGE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object blockReasonMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A readable block reason message.
     * </pre>
     *
     * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The blockReasonMessage.
     */
    @java.lang.Override
    public java.lang.String getBlockReasonMessage() {
      java.lang.Object ref = blockReasonMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        blockReasonMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A readable block reason message.
     * </pre>
     *
     * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for blockReasonMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBlockReasonMessageBytes() {
      java.lang.Object ref = blockReasonMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        blockReasonMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (blockReason_
          != com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
              .BlockedReason.BLOCKED_REASON_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, blockReason_);
      }
      for (int i = 0; i < safetyRatings_.size(); i++) {
        output.writeMessage(2, safetyRatings_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(blockReasonMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, blockReasonMessage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (blockReason_
          != com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
              .BlockedReason.BLOCKED_REASON_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, blockReason_);
      }
      for (int i = 0; i < safetyRatings_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, safetyRatings_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(blockReasonMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, blockReasonMessage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback other =
          (com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback) obj;

      if (blockReason_ != other.blockReason_) return false;
      if (!getSafetyRatingsList().equals(other.getSafetyRatingsList())) return false;
      if (!getBlockReasonMessage().equals(other.getBlockReasonMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BLOCK_REASON_FIELD_NUMBER;
      hash = (53 * hash) + blockReason_;
      if (getSafetyRatingsCount() > 0) {
        hash = (37 * hash) + SAFETY_RATINGS_FIELD_NUMBER;
        hash = (53 * hash) + getSafetyRatingsList().hashCode();
      }
      hash = (37 * hash) + BLOCK_REASON_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getBlockReasonMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Content filter results for a prompt sent in the request.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback)
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedbackOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_PromptFeedback_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_PromptFeedback_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.class,
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        blockReason_ = 0;
        if (safetyRatingsBuilder_ == null) {
          safetyRatings_ = java.util.Collections.emptyList();
        } else {
          safetyRatings_ = null;
          safetyRatingsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        blockReasonMessage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_PromptFeedback_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback build() {
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback result =
            new com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback result) {
        if (safetyRatingsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            safetyRatings_ = java.util.Collections.unmodifiableList(safetyRatings_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.safetyRatings_ = safetyRatings_;
        } else {
          result.safetyRatings_ = safetyRatingsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.blockReason_ = blockReason_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.blockReasonMessage_ = blockReasonMessage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
                .getDefaultInstance()) return this;
        if (other.blockReason_ != 0) {
          setBlockReasonValue(other.getBlockReasonValue());
        }
        if (safetyRatingsBuilder_ == null) {
          if (!other.safetyRatings_.isEmpty()) {
            if (safetyRatings_.isEmpty()) {
              safetyRatings_ = other.safetyRatings_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSafetyRatingsIsMutable();
              safetyRatings_.addAll(other.safetyRatings_);
            }
            onChanged();
          }
        } else {
          if (!other.safetyRatings_.isEmpty()) {
            if (safetyRatingsBuilder_.isEmpty()) {
              safetyRatingsBuilder_.dispose();
              safetyRatingsBuilder_ = null;
              safetyRatings_ = other.safetyRatings_;
              bitField0_ = (bitField0_ & ~0x00000002);
              safetyRatingsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSafetyRatingsFieldBuilder()
                      : null;
            } else {
              safetyRatingsBuilder_.addAllMessages(other.safetyRatings_);
            }
          }
        }
        if (!other.getBlockReasonMessage().isEmpty()) {
          blockReasonMessage_ = other.blockReasonMessage_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  blockReason_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  com.google.cloud.aiplatform.v1beta1.SafetyRating m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1beta1.SafetyRating.parser(),
                          extensionRegistry);
                  if (safetyRatingsBuilder_ == null) {
                    ensureSafetyRatingsIsMutable();
                    safetyRatings_.add(m);
                  } else {
                    safetyRatingsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  blockReasonMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int blockReason_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for blockReason.
       */
      @java.lang.Override
      public int getBlockReasonValue() {
        return blockReason_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for blockReason to set.
       * @return This builder for chaining.
       */
      public Builder setBlockReasonValue(int value) {
        blockReason_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The blockReason.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
              .BlockedReason
          getBlockReason() {
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason
            result =
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
                    .BlockedReason.forNumber(blockReason_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
                .BlockedReason.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The blockReason to set.
       * @return This builder for chaining.
       */
      public Builder setBlockReason(
          com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        blockReason_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Blocked reason.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.BlockedReason block_reason = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBlockReason() {
        bitField0_ = (bitField0_ & ~0x00000001);
        blockReason_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.aiplatform.v1beta1.SafetyRating> safetyRatings_ =
          java.util.Collections.emptyList();

      private void ensureSafetyRatingsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          safetyRatings_ =
              new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.SafetyRating>(
                  safetyRatings_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.SafetyRating,
              com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder,
              com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder>
          safetyRatingsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.SafetyRating>
          getSafetyRatingsList() {
        if (safetyRatingsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(safetyRatings_);
        } else {
          return safetyRatingsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getSafetyRatingsCount() {
        if (safetyRatingsBuilder_ == null) {
          return safetyRatings_.size();
        } else {
          return safetyRatingsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SafetyRating getSafetyRatings(int index) {
        if (safetyRatingsBuilder_ == null) {
          return safetyRatings_.get(index);
        } else {
          return safetyRatingsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSafetyRatings(
          int index, com.google.cloud.aiplatform.v1beta1.SafetyRating value) {
        if (safetyRatingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSafetyRatingsIsMutable();
          safetyRatings_.set(index, value);
          onChanged();
        } else {
          safetyRatingsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSafetyRatings(
          int index, com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder builderForValue) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          safetyRatings_.set(index, builderForValue.build());
          onChanged();
        } else {
          safetyRatingsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSafetyRatings(com.google.cloud.aiplatform.v1beta1.SafetyRating value) {
        if (safetyRatingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSafetyRatingsIsMutable();
          safetyRatings_.add(value);
          onChanged();
        } else {
          safetyRatingsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSafetyRatings(
          int index, com.google.cloud.aiplatform.v1beta1.SafetyRating value) {
        if (safetyRatingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSafetyRatingsIsMutable();
          safetyRatings_.add(index, value);
          onChanged();
        } else {
          safetyRatingsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSafetyRatings(
          com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder builderForValue) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          safetyRatings_.add(builderForValue.build());
          onChanged();
        } else {
          safetyRatingsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSafetyRatings(
          int index, com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder builderForValue) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          safetyRatings_.add(index, builderForValue.build());
          onChanged();
        } else {
          safetyRatingsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllSafetyRatings(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.SafetyRating> values) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, safetyRatings_);
          onChanged();
        } else {
          safetyRatingsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearSafetyRatings() {
        if (safetyRatingsBuilder_ == null) {
          safetyRatings_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          safetyRatingsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeSafetyRatings(int index) {
        if (safetyRatingsBuilder_ == null) {
          ensureSafetyRatingsIsMutable();
          safetyRatings_.remove(index);
          onChanged();
        } else {
          safetyRatingsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder getSafetyRatingsBuilder(
          int index) {
        return getSafetyRatingsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(
          int index) {
        if (safetyRatingsBuilder_ == null) {
          return safetyRatings_.get(index);
        } else {
          return safetyRatingsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder>
          getSafetyRatingsOrBuilderList() {
        if (safetyRatingsBuilder_ != null) {
          return safetyRatingsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(safetyRatings_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder addSafetyRatingsBuilder() {
        return getSafetyRatingsFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1beta1.SafetyRating.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder addSafetyRatingsBuilder(
          int index) {
        return getSafetyRatingsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.aiplatform.v1beta1.SafetyRating.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. Safety ratings.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.SafetyRating safety_ratings = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder>
          getSafetyRatingsBuilderList() {
        return getSafetyRatingsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.SafetyRating,
              com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder,
              com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder>
          getSafetyRatingsFieldBuilder() {
        if (safetyRatingsBuilder_ == null) {
          safetyRatingsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.SafetyRating,
                  com.google.cloud.aiplatform.v1beta1.SafetyRating.Builder,
                  com.google.cloud.aiplatform.v1beta1.SafetyRatingOrBuilder>(
                  safetyRatings_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          safetyRatings_ = null;
        }
        return safetyRatingsBuilder_;
      }

      private java.lang.Object blockReasonMessage_ = "";
      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The blockReasonMessage.
       */
      public java.lang.String getBlockReasonMessage() {
        java.lang.Object ref = blockReasonMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          blockReasonMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for blockReasonMessage.
       */
      public com.google.protobuf.ByteString getBlockReasonMessageBytes() {
        java.lang.Object ref = blockReasonMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          blockReasonMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The blockReasonMessage to set.
       * @return This builder for chaining.
       */
      public Builder setBlockReasonMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        blockReasonMessage_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBlockReasonMessage() {
        blockReasonMessage_ = getDefaultInstance().getBlockReasonMessage();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A readable block reason message.
       * </pre>
       *
       * <code>string block_reason_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for blockReasonMessage to set.
       * @return This builder for chaining.
       */
      public Builder setBlockReasonMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        blockReasonMessage_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback)
    private static final com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback();
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PromptFeedback> PARSER =
        new com.google.protobuf.AbstractParser<PromptFeedback>() {
          @java.lang.Override
          public PromptFeedback parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PromptFeedback> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PromptFeedback> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UsageMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of tokens in the request. When `cached_content` is set, this is
     * still the total effective prompt size meaning this includes the number of
     * tokens in the cached content.
     * </pre>
     *
     * <code>int32 prompt_token_count = 1;</code>
     *
     * @return The promptTokenCount.
     */
    int getPromptTokenCount();

    /**
     *
     *
     * <pre>
     * Number of tokens in the response(s).
     * </pre>
     *
     * <code>int32 candidates_token_count = 2;</code>
     *
     * @return The candidatesTokenCount.
     */
    int getCandidatesTokenCount();

    /**
     *
     *
     * <pre>
     * Total token count for prompt and response candidates.
     * </pre>
     *
     * <code>int32 total_token_count = 3;</code>
     *
     * @return The totalTokenCount.
     */
    int getTotalTokenCount();

    /**
     *
     *
     * <pre>
     * Output only. Number of tokens in the cached part in the input (the cached
     * content).
     * </pre>
     *
     * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cachedContentTokenCount.
     */
    int getCachedContentTokenCount();
  }
  /**
   *
   *
   * <pre>
   * Usage metadata about response(s).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata}
   */
  public static final class UsageMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata)
      UsageMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UsageMetadata.newBuilder() to construct.
    private UsageMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UsageMetadata() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UsageMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_UsageMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_UsageMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.class,
              com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.Builder
                  .class);
    }

    public static final int PROMPT_TOKEN_COUNT_FIELD_NUMBER = 1;
    private int promptTokenCount_ = 0;
    /**
     *
     *
     * <pre>
     * Number of tokens in the request. When `cached_content` is set, this is
     * still the total effective prompt size meaning this includes the number of
     * tokens in the cached content.
     * </pre>
     *
     * <code>int32 prompt_token_count = 1;</code>
     *
     * @return The promptTokenCount.
     */
    @java.lang.Override
    public int getPromptTokenCount() {
      return promptTokenCount_;
    }

    public static final int CANDIDATES_TOKEN_COUNT_FIELD_NUMBER = 2;
    private int candidatesTokenCount_ = 0;
    /**
     *
     *
     * <pre>
     * Number of tokens in the response(s).
     * </pre>
     *
     * <code>int32 candidates_token_count = 2;</code>
     *
     * @return The candidatesTokenCount.
     */
    @java.lang.Override
    public int getCandidatesTokenCount() {
      return candidatesTokenCount_;
    }

    public static final int TOTAL_TOKEN_COUNT_FIELD_NUMBER = 3;
    private int totalTokenCount_ = 0;
    /**
     *
     *
     * <pre>
     * Total token count for prompt and response candidates.
     * </pre>
     *
     * <code>int32 total_token_count = 3;</code>
     *
     * @return The totalTokenCount.
     */
    @java.lang.Override
    public int getTotalTokenCount() {
      return totalTokenCount_;
    }

    public static final int CACHED_CONTENT_TOKEN_COUNT_FIELD_NUMBER = 5;
    private int cachedContentTokenCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Number of tokens in the cached part in the input (the cached
     * content).
     * </pre>
     *
     * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cachedContentTokenCount.
     */
    @java.lang.Override
    public int getCachedContentTokenCount() {
      return cachedContentTokenCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (promptTokenCount_ != 0) {
        output.writeInt32(1, promptTokenCount_);
      }
      if (candidatesTokenCount_ != 0) {
        output.writeInt32(2, candidatesTokenCount_);
      }
      if (totalTokenCount_ != 0) {
        output.writeInt32(3, totalTokenCount_);
      }
      if (cachedContentTokenCount_ != 0) {
        output.writeInt32(5, cachedContentTokenCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (promptTokenCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, promptTokenCount_);
      }
      if (candidatesTokenCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, candidatesTokenCount_);
      }
      if (totalTokenCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, totalTokenCount_);
      }
      if (cachedContentTokenCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, cachedContentTokenCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata other =
          (com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata) obj;

      if (getPromptTokenCount() != other.getPromptTokenCount()) return false;
      if (getCandidatesTokenCount() != other.getCandidatesTokenCount()) return false;
      if (getTotalTokenCount() != other.getTotalTokenCount()) return false;
      if (getCachedContentTokenCount() != other.getCachedContentTokenCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROMPT_TOKEN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getPromptTokenCount();
      hash = (37 * hash) + CANDIDATES_TOKEN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCandidatesTokenCount();
      hash = (37 * hash) + TOTAL_TOKEN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTotalTokenCount();
      hash = (37 * hash) + CACHED_CONTENT_TOKEN_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCachedContentTokenCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about response(s).
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata)
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_UsageMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_UsageMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.class,
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        promptTokenCount_ = 0;
        candidatesTokenCount_ = 0;
        totalTokenCount_ = 0;
        cachedContentTokenCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_UsageMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata build() {
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata result =
            new com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.promptTokenCount_ = promptTokenCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.candidatesTokenCount_ = candidatesTokenCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.totalTokenCount_ = totalTokenCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.cachedContentTokenCount_ = cachedContentTokenCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
                .getDefaultInstance()) return this;
        if (other.getPromptTokenCount() != 0) {
          setPromptTokenCount(other.getPromptTokenCount());
        }
        if (other.getCandidatesTokenCount() != 0) {
          setCandidatesTokenCount(other.getCandidatesTokenCount());
        }
        if (other.getTotalTokenCount() != 0) {
          setTotalTokenCount(other.getTotalTokenCount());
        }
        if (other.getCachedContentTokenCount() != 0) {
          setCachedContentTokenCount(other.getCachedContentTokenCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  promptTokenCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  candidatesTokenCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  totalTokenCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 40:
                {
                  cachedContentTokenCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int promptTokenCount_;
      /**
       *
       *
       * <pre>
       * Number of tokens in the request. When `cached_content` is set, this is
       * still the total effective prompt size meaning this includes the number of
       * tokens in the cached content.
       * </pre>
       *
       * <code>int32 prompt_token_count = 1;</code>
       *
       * @return The promptTokenCount.
       */
      @java.lang.Override
      public int getPromptTokenCount() {
        return promptTokenCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of tokens in the request. When `cached_content` is set, this is
       * still the total effective prompt size meaning this includes the number of
       * tokens in the cached content.
       * </pre>
       *
       * <code>int32 prompt_token_count = 1;</code>
       *
       * @param value The promptTokenCount to set.
       * @return This builder for chaining.
       */
      public Builder setPromptTokenCount(int value) {

        promptTokenCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of tokens in the request. When `cached_content` is set, this is
       * still the total effective prompt size meaning this includes the number of
       * tokens in the cached content.
       * </pre>
       *
       * <code>int32 prompt_token_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPromptTokenCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        promptTokenCount_ = 0;
        onChanged();
        return this;
      }

      private int candidatesTokenCount_;
      /**
       *
       *
       * <pre>
       * Number of tokens in the response(s).
       * </pre>
       *
       * <code>int32 candidates_token_count = 2;</code>
       *
       * @return The candidatesTokenCount.
       */
      @java.lang.Override
      public int getCandidatesTokenCount() {
        return candidatesTokenCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of tokens in the response(s).
       * </pre>
       *
       * <code>int32 candidates_token_count = 2;</code>
       *
       * @param value The candidatesTokenCount to set.
       * @return This builder for chaining.
       */
      public Builder setCandidatesTokenCount(int value) {

        candidatesTokenCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of tokens in the response(s).
       * </pre>
       *
       * <code>int32 candidates_token_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCandidatesTokenCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        candidatesTokenCount_ = 0;
        onChanged();
        return this;
      }

      private int totalTokenCount_;
      /**
       *
       *
       * <pre>
       * Total token count for prompt and response candidates.
       * </pre>
       *
       * <code>int32 total_token_count = 3;</code>
       *
       * @return The totalTokenCount.
       */
      @java.lang.Override
      public int getTotalTokenCount() {
        return totalTokenCount_;
      }
      /**
       *
       *
       * <pre>
       * Total token count for prompt and response candidates.
       * </pre>
       *
       * <code>int32 total_token_count = 3;</code>
       *
       * @param value The totalTokenCount to set.
       * @return This builder for chaining.
       */
      public Builder setTotalTokenCount(int value) {

        totalTokenCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total token count for prompt and response candidates.
       * </pre>
       *
       * <code>int32 total_token_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalTokenCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        totalTokenCount_ = 0;
        onChanged();
        return this;
      }

      private int cachedContentTokenCount_;
      /**
       *
       *
       * <pre>
       * Output only. Number of tokens in the cached part in the input (the cached
       * content).
       * </pre>
       *
       * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The cachedContentTokenCount.
       */
      @java.lang.Override
      public int getCachedContentTokenCount() {
        return cachedContentTokenCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of tokens in the cached part in the input (the cached
       * content).
       * </pre>
       *
       * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The cachedContentTokenCount to set.
       * @return This builder for chaining.
       */
      public Builder setCachedContentTokenCount(int value) {

        cachedContentTokenCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of tokens in the cached part in the input (the cached
       * content).
       * </pre>
       *
       * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCachedContentTokenCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        cachedContentTokenCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata)
    private static final com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata();
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UsageMetadata> PARSER =
        new com.google.protobuf.AbstractParser<UsageMetadata>() {
          @java.lang.Override
          public UsageMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UsageMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UsageMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int CANDIDATES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.Candidate> candidates_;
  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.Candidate> getCandidatesList() {
    return candidates_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.CandidateOrBuilder>
      getCandidatesOrBuilderList() {
    return candidates_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getCandidatesCount() {
    return candidates_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Candidate getCandidates(int index) {
    return candidates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.CandidateOrBuilder getCandidatesOrBuilder(int index) {
    return candidates_.get(index);
  }

  public static final int MODEL_VERSION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The model version used to generate the response.
   * </pre>
   *
   * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The modelVersion.
   */
  @java.lang.Override
  public java.lang.String getModelVersion() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The model version used to generate the response.
   * </pre>
   *
   * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for modelVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelVersionBytes() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROMPT_FEEDBACK_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
      promptFeedback_;
  /**
   *
   *
   * <pre>
   * Output only. Content filter results for a prompt sent in the request.
   * Note: Sent only in the first stream chunk.
   * Only happens when no candidates were generated due to content violations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the promptFeedback field is set.
   */
  @java.lang.Override
  public boolean hasPromptFeedback() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Content filter results for a prompt sent in the request.
   * Note: Sent only in the first stream chunk.
   * Only happens when no candidates were generated due to content violations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The promptFeedback.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
      getPromptFeedback() {
    return promptFeedback_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
            .getDefaultInstance()
        : promptFeedback_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Content filter results for a prompt sent in the request.
   * Note: Sent only in the first stream chunk.
   * Only happens when no candidates were generated due to content violations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedbackOrBuilder
      getPromptFeedbackOrBuilder() {
    return promptFeedback_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
            .getDefaultInstance()
        : promptFeedback_;
  }

  public static final int USAGE_METADATA_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usageMetadata_;
  /**
   *
   *
   * <pre>
   * Usage metadata about the response(s).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
   * </code>
   *
   * @return Whether the usageMetadata field is set.
   */
  @java.lang.Override
  public boolean hasUsageMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Usage metadata about the response(s).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
   * </code>
   *
   * @return The usageMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
      getUsageMetadata() {
    return usageMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
            .getDefaultInstance()
        : usageMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Usage metadata about the response(s).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadataOrBuilder
      getUsageMetadataOrBuilder() {
    return usageMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
            .getDefaultInstance()
        : usageMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < candidates_.size(); i++) {
      output.writeMessage(2, candidates_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getPromptFeedback());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUsageMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, modelVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < candidates_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, candidates_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPromptFeedback());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUsageMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, modelVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GenerateContentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.GenerateContentResponse other =
        (com.google.cloud.aiplatform.v1beta1.GenerateContentResponse) obj;

    if (!getCandidatesList().equals(other.getCandidatesList())) return false;
    if (!getModelVersion().equals(other.getModelVersion())) return false;
    if (hasPromptFeedback() != other.hasPromptFeedback()) return false;
    if (hasPromptFeedback()) {
      if (!getPromptFeedback().equals(other.getPromptFeedback())) return false;
    }
    if (hasUsageMetadata() != other.hasUsageMetadata()) return false;
    if (hasUsageMetadata()) {
      if (!getUsageMetadata().equals(other.getUsageMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCandidatesCount() > 0) {
      hash = (37 * hash) + CANDIDATES_FIELD_NUMBER;
      hash = (53 * hash) + getCandidatesList().hashCode();
    }
    hash = (37 * hash) + MODEL_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersion().hashCode();
    if (hasPromptFeedback()) {
      hash = (37 * hash) + PROMPT_FEEDBACK_FIELD_NUMBER;
      hash = (53 * hash) + getPromptFeedback().hashCode();
    }
    if (hasUsageMetadata()) {
      hash = (37 * hash) + USAGE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getUsageMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.GenerateContentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for [PredictionService.GenerateContent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateContentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateContentResponse)
      com.google.cloud.aiplatform.v1beta1.GenerateContentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.class,
              com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCandidatesFieldBuilder();
        getPromptFeedbackFieldBuilder();
        getUsageMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (candidatesBuilder_ == null) {
        candidates_ = java.util.Collections.emptyList();
      } else {
        candidates_ = null;
        candidatesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      modelVersion_ = "";
      promptFeedback_ = null;
      if (promptFeedbackBuilder_ != null) {
        promptFeedbackBuilder_.dispose();
        promptFeedbackBuilder_ = null;
      }
      usageMetadata_ = null;
      if (usageMetadataBuilder_ != null) {
        usageMetadataBuilder_.dispose();
        usageMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateContentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse build() {
      com.google.cloud.aiplatform.v1beta1.GenerateContentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse buildPartial() {
      com.google.cloud.aiplatform.v1beta1.GenerateContentResponse result =
          new com.google.cloud.aiplatform.v1beta1.GenerateContentResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse result) {
      if (candidatesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          candidates_ = java.util.Collections.unmodifiableList(candidates_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.candidates_ = candidates_;
      } else {
        result.candidates_ = candidatesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.GenerateContentResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.modelVersion_ = modelVersion_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.promptFeedback_ =
            promptFeedbackBuilder_ == null ? promptFeedback_ : promptFeedbackBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.usageMetadata_ =
            usageMetadataBuilder_ == null ? usageMetadata_ : usageMetadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.GenerateContentResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.GenerateContentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.GenerateContentResponse other) {
      if (other == com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.getDefaultInstance())
        return this;
      if (candidatesBuilder_ == null) {
        if (!other.candidates_.isEmpty()) {
          if (candidates_.isEmpty()) {
            candidates_ = other.candidates_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCandidatesIsMutable();
            candidates_.addAll(other.candidates_);
          }
          onChanged();
        }
      } else {
        if (!other.candidates_.isEmpty()) {
          if (candidatesBuilder_.isEmpty()) {
            candidatesBuilder_.dispose();
            candidatesBuilder_ = null;
            candidates_ = other.candidates_;
            bitField0_ = (bitField0_ & ~0x00000001);
            candidatesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCandidatesFieldBuilder()
                    : null;
          } else {
            candidatesBuilder_.addAllMessages(other.candidates_);
          }
        }
      }
      if (!other.getModelVersion().isEmpty()) {
        modelVersion_ = other.modelVersion_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPromptFeedback()) {
        mergePromptFeedback(other.getPromptFeedback());
      }
      if (other.hasUsageMetadata()) {
        mergeUsageMetadata(other.getUsageMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.Candidate m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.Candidate.parser(), extensionRegistry);
                if (candidatesBuilder_ == null) {
                  ensureCandidatesIsMutable();
                  candidates_.add(m);
                } else {
                  candidatesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPromptFeedbackFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUsageMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 90:
              {
                modelVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.Candidate> candidates_ =
        java.util.Collections.emptyList();

    private void ensureCandidatesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        candidates_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.Candidate>(candidates_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Candidate,
            com.google.cloud.aiplatform.v1beta1.Candidate.Builder,
            com.google.cloud.aiplatform.v1beta1.CandidateOrBuilder>
        candidatesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Candidate> getCandidatesList() {
      if (candidatesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(candidates_);
      } else {
        return candidatesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getCandidatesCount() {
      if (candidatesBuilder_ == null) {
        return candidates_.size();
      } else {
        return candidatesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Candidate getCandidates(int index) {
      if (candidatesBuilder_ == null) {
        return candidates_.get(index);
      } else {
        return candidatesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCandidates(int index, com.google.cloud.aiplatform.v1beta1.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.set(index, value);
        onChanged();
      } else {
        candidatesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCandidates(
        int index, com.google.cloud.aiplatform.v1beta1.Candidate.Builder builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.set(index, builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidates(com.google.cloud.aiplatform.v1beta1.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.add(value);
        onChanged();
      } else {
        candidatesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidates(int index, com.google.cloud.aiplatform.v1beta1.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.add(index, value);
        onChanged();
      } else {
        candidatesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidates(
        com.google.cloud.aiplatform.v1beta1.Candidate.Builder builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.add(builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidates(
        int index, com.google.cloud.aiplatform.v1beta1.Candidate.Builder builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.add(index, builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllCandidates(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.Candidate> values) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, candidates_);
        onChanged();
      } else {
        candidatesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCandidates() {
      if (candidatesBuilder_ == null) {
        candidates_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        candidatesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeCandidates(int index) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.remove(index);
        onChanged();
      } else {
        candidatesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Candidate.Builder getCandidatesBuilder(int index) {
      return getCandidatesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.CandidateOrBuilder getCandidatesOrBuilder(
        int index) {
      if (candidatesBuilder_ == null) {
        return candidates_.get(index);
      } else {
        return candidatesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.CandidateOrBuilder>
        getCandidatesOrBuilderList() {
      if (candidatesBuilder_ != null) {
        return candidatesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(candidates_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Candidate.Builder addCandidatesBuilder() {
      return getCandidatesFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.Candidate.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.Candidate.Builder addCandidatesBuilder(int index) {
      return getCandidatesFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.Candidate.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.Candidate candidates = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.Candidate.Builder>
        getCandidatesBuilderList() {
      return getCandidatesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.Candidate,
            com.google.cloud.aiplatform.v1beta1.Candidate.Builder,
            com.google.cloud.aiplatform.v1beta1.CandidateOrBuilder>
        getCandidatesFieldBuilder() {
      if (candidatesBuilder_ == null) {
        candidatesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.Candidate,
                com.google.cloud.aiplatform.v1beta1.Candidate.Builder,
                com.google.cloud.aiplatform.v1beta1.CandidateOrBuilder>(
                candidates_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        candidates_ = null;
      }
      return candidatesBuilder_;
    }

    private java.lang.Object modelVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelVersion.
     */
    public java.lang.String getModelVersion() {
      java.lang.Object ref = modelVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelVersion.
     */
    public com.google.protobuf.ByteString getModelVersionBytes() {
      java.lang.Object ref = modelVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersion() {
      modelVersion_ = getDefaultInstance().getModelVersion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The model version used to generate the response.
     * </pre>
     *
     * <code>string model_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        promptFeedback_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedbackOrBuilder>
        promptFeedbackBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the promptFeedback field is set.
     */
    public boolean hasPromptFeedback() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The promptFeedback.
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
        getPromptFeedback() {
      if (promptFeedbackBuilder_ == null) {
        return promptFeedback_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
                .getDefaultInstance()
            : promptFeedback_;
      } else {
        return promptFeedbackBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPromptFeedback(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback value) {
      if (promptFeedbackBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        promptFeedback_ = value;
      } else {
        promptFeedbackBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPromptFeedback(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.Builder
            builderForValue) {
      if (promptFeedbackBuilder_ == null) {
        promptFeedback_ = builderForValue.build();
      } else {
        promptFeedbackBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePromptFeedback(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback value) {
      if (promptFeedbackBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && promptFeedback_ != null
            && promptFeedback_
                != com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
                    .getDefaultInstance()) {
          getPromptFeedbackBuilder().mergeFrom(value);
        } else {
          promptFeedback_ = value;
        }
      } else {
        promptFeedbackBuilder_.mergeFrom(value);
      }
      if (promptFeedback_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPromptFeedback() {
      bitField0_ = (bitField0_ & ~0x00000004);
      promptFeedback_ = null;
      if (promptFeedbackBuilder_ != null) {
        promptFeedbackBuilder_.dispose();
        promptFeedbackBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.Builder
        getPromptFeedbackBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPromptFeedbackFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedbackOrBuilder
        getPromptFeedbackOrBuilder() {
      if (promptFeedbackBuilder_ != null) {
        return promptFeedbackBuilder_.getMessageOrBuilder();
      } else {
        return promptFeedback_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback
                .getDefaultInstance()
            : promptFeedback_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Content filter results for a prompt sent in the request.
     * Note: Sent only in the first stream chunk.
     * Only happens when no candidates were generated due to content violations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback prompt_feedback = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedbackOrBuilder>
        getPromptFeedbackFieldBuilder() {
      if (promptFeedbackBuilder_ == null) {
        promptFeedbackBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback,
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.PromptFeedback.Builder,
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse
                    .PromptFeedbackOrBuilder>(
                getPromptFeedback(), getParentForChildren(), isClean());
        promptFeedback_ = null;
      }
      return promptFeedbackBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        usageMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadataOrBuilder>
        usageMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     *
     * @return Whether the usageMetadata field is set.
     */
    public boolean hasUsageMetadata() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     *
     * @return The usageMetadata.
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
        getUsageMetadata() {
      if (usageMetadataBuilder_ == null) {
        return usageMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
                .getDefaultInstance()
            : usageMetadata_;
      } else {
        return usageMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public Builder setUsageMetadata(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata value) {
      if (usageMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usageMetadata_ = value;
      } else {
        usageMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public Builder setUsageMetadata(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.Builder
            builderForValue) {
      if (usageMetadataBuilder_ == null) {
        usageMetadata_ = builderForValue.build();
      } else {
        usageMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public Builder mergeUsageMetadata(
        com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata value) {
      if (usageMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && usageMetadata_ != null
            && usageMetadata_
                != com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
                    .getDefaultInstance()) {
          getUsageMetadataBuilder().mergeFrom(value);
        } else {
          usageMetadata_ = value;
        }
      } else {
        usageMetadataBuilder_.mergeFrom(value);
      }
      if (usageMetadata_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public Builder clearUsageMetadata() {
      bitField0_ = (bitField0_ & ~0x00000008);
      usageMetadata_ = null;
      if (usageMetadataBuilder_ != null) {
        usageMetadataBuilder_.dispose();
        usageMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.Builder
        getUsageMetadataBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUsageMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadataOrBuilder
        getUsageMetadataOrBuilder() {
      if (usageMetadataBuilder_ != null) {
        return usageMetadataBuilder_.getMessageOrBuilder();
      } else {
        return usageMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata
                .getDefaultInstance()
            : usageMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Usage metadata about the response(s).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata usage_metadata = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadataOrBuilder>
        getUsageMetadataFieldBuilder() {
      if (usageMetadataBuilder_ == null) {
        usageMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata,
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.GenerateContentResponse.UsageMetadataOrBuilder>(
                getUsageMetadata(), getParentForChildren(), isClean());
        usageMetadata_ = null;
      }
      return usageMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateContentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateContentResponse)
  private static final com.google.cloud.aiplatform.v1beta1.GenerateContentResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GenerateContentResponse();
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateContentResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateContentResponse> PARSER =
      new com.google.protobuf.AbstractParser<GenerateContentResponse>() {
        @java.lang.Override
        public GenerateContentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateContentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateContentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateContentResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
