/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/migration_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Runtime operation information for
 * [MigrationService.BatchMigrateResources][google.cloud.aiplatform.v1beta1.MigrationService.BatchMigrateResources].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata}
 */
public final class BatchMigrateResourcesOperationMetadata
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata)
    BatchMigrateResourcesOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchMigrateResourcesOperationMetadata.newBuilder() to construct.
  private BatchMigrateResourcesOperationMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchMigrateResourcesOperationMetadata() {
    partialResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchMigrateResourcesOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.class,
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.Builder
                .class);
  }

  public interface PartialResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The error result of the migration request in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     *
     *
     * <pre>
     * The error result of the migration request in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return The error.
     */
    com.google.rpc.Status getError();
    /**
     *
     *
     * <pre>
     * The error result of the migration request in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    com.google.rpc.StatusOrBuilder getErrorOrBuilder();

    /**
     *
     *
     * <pre>
     * Migrated model resource name.
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the model field is set.
     */
    boolean hasModel();
    /**
     *
     *
     * <pre>
     * Migrated model resource name.
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The model.
     */
    java.lang.String getModel();
    /**
     *
     *
     * <pre>
     * Migrated model resource name.
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for model.
     */
    com.google.protobuf.ByteString getModelBytes();

    /**
     *
     *
     * <pre>
     * Migrated dataset resource name.
     * </pre>
     *
     * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the dataset field is set.
     */
    boolean hasDataset();
    /**
     *
     *
     * <pre>
     * Migrated dataset resource name.
     * </pre>
     *
     * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataset.
     */
    java.lang.String getDataset();
    /**
     *
     *
     * <pre>
     * Migrated dataset resource name.
     * </pre>
     *
     * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataset.
     */
    com.google.protobuf.ByteString getDatasetBytes();

    /**
     *
     *
     * <pre>
     * It's the same as the value in
     * [MigrateResourceRequest.migrate_resource_requests][].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
     *
     * @return Whether the request field is set.
     */
    boolean hasRequest();
    /**
     *
     *
     * <pre>
     * It's the same as the value in
     * [MigrateResourceRequest.migrate_resource_requests][].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
     *
     * @return The request.
     */
    com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest getRequest();
    /**
     *
     *
     * <pre>
     * It's the same as the value in
     * [MigrateResourceRequest.migrate_resource_requests][].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
     */
    com.google.cloud.aiplatform.v1beta1.MigrateResourceRequestOrBuilder getRequestOrBuilder();

    com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            .ResultCase
        getResultCase();
  }
  /**
   *
   *
   * <pre>
   * Represents a partial result in batch migration operation for one
   * [MigrateResourceRequest][google.cloud.aiplatform.v1beta1.MigrateResourceRequest].
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult}
   */
  public static final class PartialResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult)
      PartialResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PartialResult.newBuilder() to construct.
    private PartialResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PartialResult() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PartialResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_PartialResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_PartialResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                  .PartialResult.class,
              com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                  .PartialResult.Builder.class);
    }

    private int bitField0_;
    private int resultCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object result_;

    public enum ResultCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ERROR(2),
      MODEL(3),
      DATASET(4),
      RESULT_NOT_SET(0);
      private final int value;

      private ResultCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResultCase valueOf(int value) {
        return forNumber(value);
      }

      public static ResultCase forNumber(int value) {
        switch (value) {
          case 2:
            return ERROR;
          case 3:
            return MODEL;
          case 4:
            return DATASET;
          case 0:
            return RESULT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public static final int ERROR_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The error result of the migration request in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return resultCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The error result of the migration request in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public com.google.rpc.Status getError() {
      if (resultCase_ == 2) {
        return (com.google.rpc.Status) result_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The error result of the migration request in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 2;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (resultCase_ == 2) {
        return (com.google.rpc.Status) result_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }

    public static final int MODEL_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Migrated model resource name.
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the model field is set.
     */
    public boolean hasModel() {
      return resultCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Migrated model resource name.
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = "";
      if (resultCase_ == 3) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (resultCase_ == 3) {
          result_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Migrated model resource name.
     * </pre>
     *
     * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = "";
      if (resultCase_ == 3) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (resultCase_ == 3) {
          result_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Migrated dataset resource name.
     * </pre>
     *
     * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the dataset field is set.
     */
    public boolean hasDataset() {
      return resultCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Migrated dataset resource name.
     * </pre>
     *
     * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = "";
      if (resultCase_ == 4) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (resultCase_ == 4) {
          result_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Migrated dataset resource name.
     * </pre>
     *
     * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = "";
      if (resultCase_ == 4) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (resultCase_ == 4) {
          result_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REQUEST_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request_;
    /**
     *
     *
     * <pre>
     * It's the same as the value in
     * [MigrateResourceRequest.migrate_resource_requests][].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
     *
     * @return Whether the request field is set.
     */
    @java.lang.Override
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * It's the same as the value in
     * [MigrateResourceRequest.migrate_resource_requests][].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
     *
     * @return The request.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest getRequest() {
      return request_ == null
          ? com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.getDefaultInstance()
          : request_;
    }
    /**
     *
     *
     * <pre>
     * It's the same as the value in
     * [MigrateResourceRequest.migrate_resource_requests][].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequestOrBuilder
        getRequestOrBuilder() {
      return request_ == null
          ? com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.getDefaultInstance()
          : request_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getRequest());
      }
      if (resultCase_ == 2) {
        output.writeMessage(2, (com.google.rpc.Status) result_);
      }
      if (resultCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, result_);
      }
      if (resultCase_ == 4) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, result_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRequest());
      }
      if (resultCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.rpc.Status) result_);
      }
      if (resultCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, result_);
      }
      if (resultCase_ == 4) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, result_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
              .PartialResult)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
          other =
              (com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                      .PartialResult)
                  obj;

      if (hasRequest() != other.hasRequest()) return false;
      if (hasRequest()) {
        if (!getRequest().equals(other.getRequest())) return false;
      }
      if (!getResultCase().equals(other.getResultCase())) return false;
      switch (resultCase_) {
        case 2:
          if (!getError().equals(other.getError())) return false;
          break;
        case 3:
          if (!getModel().equals(other.getModel())) return false;
          break;
        case 4:
          if (!getDataset().equals(other.getDataset())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRequest()) {
        hash = (37 * hash) + REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getRequest().hashCode();
      }
      switch (resultCase_) {
        case 2:
          hash = (37 * hash) + ERROR_FIELD_NUMBER;
          hash = (53 * hash) + getError().hashCode();
          break;
        case 3:
          hash = (37 * hash) + MODEL_FIELD_NUMBER;
          hash = (53 * hash) + getModel().hashCode();
          break;
        case 4:
          hash = (37 * hash) + DATASET_FIELD_NUMBER;
          hash = (53 * hash) + getDataset().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a partial result in batch migration operation for one
     * [MigrateResourceRequest][google.cloud.aiplatform.v1beta1.MigrateResourceRequest].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult)
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_PartialResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_PartialResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                    .PartialResult.class,
                com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                    .PartialResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRequestFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (errorBuilder_ != null) {
          errorBuilder_.clear();
        }
        request_ = null;
        if (requestBuilder_ != null) {
          requestBuilder_.dispose();
          requestBuilder_ = null;
        }
        resultCase_ = 0;
        result_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_PartialResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
              .PartialResult
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
              .PartialResult
          build() {
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
              .PartialResult
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            result =
                new com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                    .PartialResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
              result) {
        result.resultCase_ = resultCase_;
        result.result_ = this.result_;
        if (resultCase_ == 2 && errorBuilder_ != null) {
          result.result_ = errorBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                .PartialResult) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                      .PartialResult)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                .PartialResult.getDefaultInstance()) return this;
        if (other.hasRequest()) {
          mergeRequest(other.getRequest());
        }
        switch (other.getResultCase()) {
          case ERROR:
            {
              mergeError(other.getError());
              break;
            }
          case MODEL:
            {
              resultCase_ = 3;
              result_ = other.result_;
              onChanged();
              break;
            }
          case DATASET:
            {
              resultCase_ = 4;
              result_ = other.result_;
              onChanged();
              break;
            }
          case RESULT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                  resultCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  resultCase_ = 3;
                  result_ = s;
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  resultCase_ = 4;
                  result_ = s;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int resultCase_ = 0;
      private java.lang.Object result_;

      public ResultCase getResultCase() {
        return ResultCase.forNumber(resultCase_);
      }

      public Builder clearResult() {
        resultCase_ = 0;
        result_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          errorBuilder_;
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       *
       * @return Whether the error field is set.
       */
      @java.lang.Override
      public boolean hasError() {
        return resultCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       *
       * @return The error.
       */
      @java.lang.Override
      public com.google.rpc.Status getError() {
        if (errorBuilder_ == null) {
          if (resultCase_ == 2) {
            return (com.google.rpc.Status) result_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        } else {
          if (resultCase_ == 2) {
            return errorBuilder_.getMessage();
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public Builder setError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          result_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        resultCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public Builder setError(com.google.rpc.Status.Builder builderForValue) {
        if (errorBuilder_ == null) {
          result_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        resultCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public Builder mergeError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (resultCase_ == 2 && result_ != com.google.rpc.Status.getDefaultInstance()) {
            result_ =
                com.google.rpc.Status.newBuilder((com.google.rpc.Status) result_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            result_ = value;
          }
          onChanged();
        } else {
          if (resultCase_ == 2) {
            errorBuilder_.mergeFrom(value);
          } else {
            errorBuilder_.setMessage(value);
          }
        }
        resultCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public Builder clearError() {
        if (errorBuilder_ == null) {
          if (resultCase_ == 2) {
            resultCase_ = 0;
            result_ = null;
            onChanged();
          }
        } else {
          if (resultCase_ == 2) {
            resultCase_ = 0;
            result_ = null;
          }
          errorBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      public com.google.rpc.Status.Builder getErrorBuilder() {
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      @java.lang.Override
      public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
        if ((resultCase_ == 2) && (errorBuilder_ != null)) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          if (resultCase_ == 2) {
            return (com.google.rpc.Status) result_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The error result of the migration request in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          if (!(resultCase_ == 2)) {
            result_ = com.google.rpc.Status.getDefaultInstance();
          }
          errorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(
                  (com.google.rpc.Status) result_, getParentForChildren(), isClean());
          result_ = null;
        }
        resultCase_ = 2;
        onChanged();
        return errorBuilder_;
      }

      /**
       *
       *
       * <pre>
       * Migrated model resource name.
       * </pre>
       *
       * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return Whether the model field is set.
       */
      @java.lang.Override
      public boolean hasModel() {
        return resultCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Migrated model resource name.
       * </pre>
       *
       * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The model.
       */
      @java.lang.Override
      public java.lang.String getModel() {
        java.lang.Object ref = "";
        if (resultCase_ == 3) {
          ref = result_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (resultCase_ == 3) {
            result_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Migrated model resource name.
       * </pre>
       *
       * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for model.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = "";
        if (resultCase_ == 3) {
          ref = result_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (resultCase_ == 3) {
            result_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Migrated model resource name.
       * </pre>
       *
       * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The model to set.
       * @return This builder for chaining.
       */
      public Builder setModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resultCase_ = 3;
        result_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Migrated model resource name.
       * </pre>
       *
       * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModel() {
        if (resultCase_ == 3) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Migrated model resource name.
       * </pre>
       *
       * <code>string model = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for model to set.
       * @return This builder for chaining.
       */
      public Builder setModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resultCase_ = 3;
        result_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Migrated dataset resource name.
       * </pre>
       *
       * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return Whether the dataset field is set.
       */
      @java.lang.Override
      public boolean hasDataset() {
        return resultCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Migrated dataset resource name.
       * </pre>
       *
       * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The dataset.
       */
      @java.lang.Override
      public java.lang.String getDataset() {
        java.lang.Object ref = "";
        if (resultCase_ == 4) {
          ref = result_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (resultCase_ == 4) {
            result_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Migrated dataset resource name.
       * </pre>
       *
       * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for dataset.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDatasetBytes() {
        java.lang.Object ref = "";
        if (resultCase_ == 4) {
          ref = result_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (resultCase_ == 4) {
            result_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Migrated dataset resource name.
       * </pre>
       *
       * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resultCase_ = 4;
        result_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Migrated dataset resource name.
       * </pre>
       *
       * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataset() {
        if (resultCase_ == 4) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Migrated dataset resource name.
       * </pre>
       *
       * <code>string dataset = 4 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resultCase_ = 4;
        result_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.Builder,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequestOrBuilder>
          requestBuilder_;
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       *
       * @return Whether the request field is set.
       */
      public boolean hasRequest() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       *
       * @return The request.
       */
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest getRequest() {
        if (requestBuilder_ == null) {
          return request_ == null
              ? com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.getDefaultInstance()
              : request_;
        } else {
          return requestBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       */
      public Builder setRequest(com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest value) {
        if (requestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
        } else {
          requestBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       */
      public Builder setRequest(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.Builder builderForValue) {
        if (requestBuilder_ == null) {
          request_ = builderForValue.build();
        } else {
          requestBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       */
      public Builder mergeRequest(
          com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest value) {
        if (requestBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && request_ != null
              && request_
                  != com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest
                      .getDefaultInstance()) {
            getRequestBuilder().mergeFrom(value);
          } else {
            request_ = value;
          }
        } else {
          requestBuilder_.mergeFrom(value);
        }
        if (request_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       */
      public Builder clearRequest() {
        bitField0_ = (bitField0_ & ~0x00000008);
        request_ = null;
        if (requestBuilder_ != null) {
          requestBuilder_.dispose();
          requestBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.Builder
          getRequestBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getRequestFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.MigrateResourceRequestOrBuilder
          getRequestOrBuilder() {
        if (requestBuilder_ != null) {
          return requestBuilder_.getMessageOrBuilder();
        } else {
          return request_ == null
              ? com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.getDefaultInstance()
              : request_;
        }
      }
      /**
       *
       *
       * <pre>
       * It's the same as the value in
       * [MigrateResourceRequest.migrate_resource_requests][].
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.MigrateResourceRequest request = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.Builder,
              com.google.cloud.aiplatform.v1beta1.MigrateResourceRequestOrBuilder>
          getRequestFieldBuilder() {
        if (requestBuilder_ == null) {
          requestBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest,
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequest.Builder,
                  com.google.cloud.aiplatform.v1beta1.MigrateResourceRequestOrBuilder>(
                  getRequest(), getParentForChildren(), isClean());
          request_ = null;
        }
        return requestBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult)
    private static final com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
              .PartialResult();
    }

    public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PartialResult> PARSER =
        new com.google.protobuf.AbstractParser<PartialResult>() {
          @java.lang.Override
          public PartialResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PartialResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PartialResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int GENERIC_METADATA_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata genericMetadata_;
  /**
   *
   *
   * <pre>
   * The common part of the operation metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
   *
   * @return Whether the genericMetadata field is set.
   */
  @java.lang.Override
  public boolean hasGenericMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The common part of the operation metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
   *
   * @return The genericMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata getGenericMetadata() {
    return genericMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.getDefaultInstance()
        : genericMetadata_;
  }
  /**
   *
   *
   * <pre>
   * The common part of the operation metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder
      getGenericMetadataOrBuilder() {
    return genericMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.getDefaultInstance()
        : genericMetadata_;
  }

  public static final int PARTIAL_RESULTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult>
      partialResults_;
  /**
   *
   *
   * <pre>
   * Partial results that reflect the latest migration operation progress.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult>
      getPartialResultsList() {
    return partialResults_;
  }
  /**
   *
   *
   * <pre>
   * Partial results that reflect the latest migration operation progress.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                  .PartialResultOrBuilder>
      getPartialResultsOrBuilderList() {
    return partialResults_;
  }
  /**
   *
   *
   * <pre>
   * Partial results that reflect the latest migration operation progress.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
   * </code>
   */
  @java.lang.Override
  public int getPartialResultsCount() {
    return partialResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Partial results that reflect the latest migration operation progress.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
      getPartialResults(int index) {
    return partialResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Partial results that reflect the latest migration operation progress.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
          .PartialResultOrBuilder
      getPartialResultsOrBuilder(int index) {
    return partialResults_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getGenericMetadata());
    }
    for (int i = 0; i < partialResults_.size(); i++) {
      output.writeMessage(2, partialResults_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGenericMetadata());
    }
    for (int i = 0; i < partialResults_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, partialResults_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata other =
        (com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata) obj;

    if (hasGenericMetadata() != other.hasGenericMetadata()) return false;
    if (hasGenericMetadata()) {
      if (!getGenericMetadata().equals(other.getGenericMetadata())) return false;
    }
    if (!getPartialResultsList().equals(other.getPartialResultsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasGenericMetadata()) {
      hash = (37 * hash) + GENERIC_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getGenericMetadata().hashCode();
    }
    if (getPartialResultsCount() > 0) {
      hash = (37 * hash) + PARTIAL_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getPartialResultsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Runtime operation information for
   * [MigrationService.BatchMigrateResources][google.cloud.aiplatform.v1beta1.MigrationService.BatchMigrateResources].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata)
      com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.class,
              com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGenericMetadataFieldBuilder();
        getPartialResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      genericMetadata_ = null;
      if (genericMetadataBuilder_ != null) {
        genericMetadataBuilder_.dispose();
        genericMetadataBuilder_ = null;
      }
      if (partialResultsBuilder_ == null) {
        partialResults_ = java.util.Collections.emptyList();
      } else {
        partialResults_ = null;
        partialResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MigrationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_BatchMigrateResourcesOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata build() {
      com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
        buildPartial() {
      com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata result =
          new com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata result) {
      if (partialResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          partialResults_ = java.util.Collections.unmodifiableList(partialResults_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.partialResults_ = partialResults_;
      } else {
        result.partialResults_ = partialResultsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.genericMetadata_ =
            genericMetadataBuilder_ == null ? genericMetadata_ : genericMetadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
              .getDefaultInstance()) return this;
      if (other.hasGenericMetadata()) {
        mergeGenericMetadata(other.getGenericMetadata());
      }
      if (partialResultsBuilder_ == null) {
        if (!other.partialResults_.isEmpty()) {
          if (partialResults_.isEmpty()) {
            partialResults_ = other.partialResults_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePartialResultsIsMutable();
            partialResults_.addAll(other.partialResults_);
          }
          onChanged();
        }
      } else {
        if (!other.partialResults_.isEmpty()) {
          if (partialResultsBuilder_.isEmpty()) {
            partialResultsBuilder_.dispose();
            partialResultsBuilder_ = null;
            partialResults_ = other.partialResults_;
            bitField0_ = (bitField0_ & ~0x00000002);
            partialResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialResultsFieldBuilder()
                    : null;
          } else {
            partialResultsBuilder_.addAllMessages(other.partialResults_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGenericMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                        .PartialResult
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1beta1
                                .BatchMigrateResourcesOperationMetadata.PartialResult.parser(),
                            extensionRegistry);
                if (partialResultsBuilder_ == null) {
                  ensurePartialResultsIsMutable();
                  partialResults_.add(m);
                } else {
                  partialResultsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata genericMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata,
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder>
        genericMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     *
     * @return Whether the genericMetadata field is set.
     */
    public boolean hasGenericMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     *
     * @return The genericMetadata.
     */
    public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata getGenericMetadata() {
      if (genericMetadataBuilder_ == null) {
        return genericMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.getDefaultInstance()
            : genericMetadata_;
      } else {
        return genericMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder setGenericMetadata(
        com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata value) {
      if (genericMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        genericMetadata_ = value;
      } else {
        genericMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder setGenericMetadata(
        com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder builderForValue) {
      if (genericMetadataBuilder_ == null) {
        genericMetadata_ = builderForValue.build();
      } else {
        genericMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder mergeGenericMetadata(
        com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata value) {
      if (genericMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && genericMetadata_ != null
            && genericMetadata_
                != com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata
                    .getDefaultInstance()) {
          getGenericMetadataBuilder().mergeFrom(value);
        } else {
          genericMetadata_ = value;
        }
      } else {
        genericMetadataBuilder_.mergeFrom(value);
      }
      if (genericMetadata_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder clearGenericMetadata() {
      bitField0_ = (bitField0_ & ~0x00000001);
      genericMetadata_ = null;
      if (genericMetadataBuilder_ != null) {
        genericMetadataBuilder_.dispose();
        genericMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder
        getGenericMetadataBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getGenericMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder
        getGenericMetadataOrBuilder() {
      if (genericMetadataBuilder_ != null) {
        return genericMetadataBuilder_.getMessageOrBuilder();
      } else {
        return genericMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.getDefaultInstance()
            : genericMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata,
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder>
        getGenericMetadataFieldBuilder() {
      if (genericMetadataBuilder_ == null) {
        genericMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata,
                com.google.cloud.aiplatform.v1beta1.GenericOperationMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.GenericOperationMetadataOrBuilder>(
                getGenericMetadata(), getParentForChildren(), isClean());
        genericMetadata_ = null;
      }
      return genericMetadataBuilder_;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                .PartialResult>
        partialResults_ = java.util.Collections.emptyList();

    private void ensurePartialResultsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        partialResults_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                    .PartialResult>(partialResults_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                .PartialResult,
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
                .Builder,
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                .PartialResultOrBuilder>
        partialResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                .PartialResult>
        getPartialResultsList() {
      if (partialResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialResults_);
      } else {
        return partialResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public int getPartialResultsCount() {
      if (partialResultsBuilder_ == null) {
        return partialResults_.size();
      } else {
        return partialResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
        getPartialResults(int index) {
      if (partialResultsBuilder_ == null) {
        return partialResults_.get(index);
      } else {
        return partialResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder setPartialResults(
        int index,
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            value) {
      if (partialResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialResultsIsMutable();
        partialResults_.set(index, value);
        onChanged();
      } else {
        partialResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder setPartialResults(
        int index,
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
                .Builder
            builderForValue) {
      if (partialResultsBuilder_ == null) {
        ensurePartialResultsIsMutable();
        partialResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder addPartialResults(
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            value) {
      if (partialResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialResultsIsMutable();
        partialResults_.add(value);
        onChanged();
      } else {
        partialResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder addPartialResults(
        int index,
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            value) {
      if (partialResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialResultsIsMutable();
        partialResults_.add(index, value);
        onChanged();
      } else {
        partialResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder addPartialResults(
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
                .Builder
            builderForValue) {
      if (partialResultsBuilder_ == null) {
        ensurePartialResultsIsMutable();
        partialResults_.add(builderForValue.build());
        onChanged();
      } else {
        partialResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder addPartialResults(
        int index,
        com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
                .Builder
            builderForValue) {
      if (partialResultsBuilder_ == null) {
        ensurePartialResultsIsMutable();
        partialResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder addAllPartialResults(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                        .PartialResult>
            values) {
      if (partialResultsBuilder_ == null) {
        ensurePartialResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialResults_);
        onChanged();
      } else {
        partialResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder clearPartialResults() {
      if (partialResultsBuilder_ == null) {
        partialResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        partialResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public Builder removePartialResults(int index) {
      if (partialResultsBuilder_ == null) {
        ensurePartialResultsIsMutable();
        partialResults_.remove(index);
        onChanged();
      } else {
        partialResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            .Builder
        getPartialResultsBuilder(int index) {
      return getPartialResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
            .PartialResultOrBuilder
        getPartialResultsOrBuilder(int index) {
      if (partialResultsBuilder_ == null) {
        return partialResults_.get(index);
      } else {
        return partialResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                    .PartialResultOrBuilder>
        getPartialResultsOrBuilderList() {
      if (partialResultsBuilder_ != null) {
        return partialResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            .Builder
        addPartialResultsBuilder() {
      return getPartialResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                  .PartialResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
            .Builder
        addPartialResultsBuilder(int index) {
      return getPartialResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                  .PartialResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial results that reflect the latest migration operation progress.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult partial_results = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
                .Builder>
        getPartialResultsBuilderList() {
      return getPartialResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                .PartialResult,
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata.PartialResult
                .Builder,
            com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                .PartialResultOrBuilder>
        getPartialResultsFieldBuilder() {
      if (partialResultsBuilder_ == null) {
        partialResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                    .PartialResult,
                com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                    .PartialResult.Builder,
                com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
                    .PartialResultOrBuilder>(
                partialResults_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        partialResults_ = null;
      }
      return partialResultsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata)
  private static final com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata();
  }

  public static com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchMigrateResourcesOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BatchMigrateResourcesOperationMetadata>() {
        @java.lang.Override
        public BatchMigrateResourcesOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchMigrateResourcesOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchMigrateResourcesOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BatchMigrateResourcesOperationMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
