/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The definition of a artifact type in MLMD.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ArtifactTypeSchema}
 */
public final class ArtifactTypeSchema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ArtifactTypeSchema)
    ArtifactTypeSchemaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ArtifactTypeSchema.newBuilder() to construct.
  private ArtifactTypeSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ArtifactTypeSchema() {
    schemaVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ArtifactTypeSchema();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
        .internal_static_google_cloud_aiplatform_v1beta1_ArtifactTypeSchema_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
        .internal_static_google_cloud_aiplatform_v1beta1_ArtifactTypeSchema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.class,
            com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.Builder.class);
  }

  private int kindCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object kind_;

  public enum KindCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SCHEMA_TITLE(1),
    @java.lang.Deprecated
    SCHEMA_URI(2),
    INSTANCE_SCHEMA(3),
    KIND_NOT_SET(0);
    private final int value;

    private KindCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KindCase valueOf(int value) {
      return forNumber(value);
    }

    public static KindCase forNumber(int value) {
      switch (value) {
        case 1:
          return SCHEMA_TITLE;
        case 2:
          return SCHEMA_URI;
        case 3:
          return INSTANCE_SCHEMA;
        case 0:
          return KIND_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public KindCase getKindCase() {
    return KindCase.forNumber(kindCase_);
  }

  public static final int SCHEMA_TITLE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The name of the type. The format of the title must be:
   * `&lt;namespace&gt;.&lt;title&gt;`.
   * Examples:
   *  - `aiplatform.Model`
   *  - `acme.CustomModel`
   * When this field is set, the type must be pre-registered in the MLMD
   * store.
   * </pre>
   *
   * <code>string schema_title = 1;</code>
   *
   * @return Whether the schemaTitle field is set.
   */
  public boolean hasSchemaTitle() {
    return kindCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The name of the type. The format of the title must be:
   * `&lt;namespace&gt;.&lt;title&gt;`.
   * Examples:
   *  - `aiplatform.Model`
   *  - `acme.CustomModel`
   * When this field is set, the type must be pre-registered in the MLMD
   * store.
   * </pre>
   *
   * <code>string schema_title = 1;</code>
   *
   * @return The schemaTitle.
   */
  public java.lang.String getSchemaTitle() {
    java.lang.Object ref = "";
    if (kindCase_ == 1) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (kindCase_ == 1) {
        kind_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the type. The format of the title must be:
   * `&lt;namespace&gt;.&lt;title&gt;`.
   * Examples:
   *  - `aiplatform.Model`
   *  - `acme.CustomModel`
   * When this field is set, the type must be pre-registered in the MLMD
   * store.
   * </pre>
   *
   * <code>string schema_title = 1;</code>
   *
   * @return The bytes for schemaTitle.
   */
  public com.google.protobuf.ByteString getSchemaTitleBytes() {
    java.lang.Object ref = "";
    if (kindCase_ == 1) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (kindCase_ == 1) {
        kind_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_URI_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Cloud Storage describing the
   * format.
   * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
   * [PipelineArtifactTypeSchema.instance_schema][] instead.
   * </pre>
   *
   * <code>string schema_uri = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
   *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
   * @return Whether the schemaUri field is set.
   */
  @java.lang.Deprecated
  public boolean hasSchemaUri() {
    return kindCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Cloud Storage describing the
   * format.
   * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
   * [PipelineArtifactTypeSchema.instance_schema][] instead.
   * </pre>
   *
   * <code>string schema_uri = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
   *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
   * @return The schemaUri.
   */
  @java.lang.Deprecated
  public java.lang.String getSchemaUri() {
    java.lang.Object ref = "";
    if (kindCase_ == 2) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (kindCase_ == 2) {
        kind_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Cloud Storage describing the
   * format.
   * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
   * [PipelineArtifactTypeSchema.instance_schema][] instead.
   * </pre>
   *
   * <code>string schema_uri = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
   *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
   * @return The bytes for schemaUri.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getSchemaUriBytes() {
    java.lang.Object ref = "";
    if (kindCase_ == 2) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (kindCase_ == 2) {
        kind_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_SCHEMA_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Contains a raw YAML string, describing the format of
   * the properties of the type.
   * </pre>
   *
   * <code>string instance_schema = 3;</code>
   *
   * @return Whether the instanceSchema field is set.
   */
  public boolean hasInstanceSchema() {
    return kindCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Contains a raw YAML string, describing the format of
   * the properties of the type.
   * </pre>
   *
   * <code>string instance_schema = 3;</code>
   *
   * @return The instanceSchema.
   */
  public java.lang.String getInstanceSchema() {
    java.lang.Object ref = "";
    if (kindCase_ == 3) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (kindCase_ == 3) {
        kind_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Contains a raw YAML string, describing the format of
   * the properties of the type.
   * </pre>
   *
   * <code>string instance_schema = 3;</code>
   *
   * @return The bytes for instanceSchema.
   */
  public com.google.protobuf.ByteString getInstanceSchemaBytes() {
    java.lang.Object ref = "";
    if (kindCase_ == 3) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (kindCase_ == 3) {
        kind_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_VERSION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schemaVersion_ = "";
  /**
   *
   *
   * <pre>
   * The schema version of the artifact. If the value is not set, it defaults
   * to the latest version in the system.
   * </pre>
   *
   * <code>string schema_version = 4;</code>
   *
   * @return The schemaVersion.
   */
  @java.lang.Override
  public java.lang.String getSchemaVersion() {
    java.lang.Object ref = schemaVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schemaVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The schema version of the artifact. If the value is not set, it defaults
   * to the latest version in the system.
   * </pre>
   *
   * <code>string schema_version = 4;</code>
   *
   * @return The bytes for schemaVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchemaVersionBytes() {
    java.lang.Object ref = schemaVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schemaVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (kindCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kind_);
    }
    if (kindCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kind_);
    }
    if (kindCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, kind_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, schemaVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (kindCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kind_);
    }
    if (kindCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kind_);
    }
    if (kindCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, kind_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, schemaVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema other =
        (com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema) obj;

    if (!getSchemaVersion().equals(other.getSchemaVersion())) return false;
    if (!getKindCase().equals(other.getKindCase())) return false;
    switch (kindCase_) {
      case 1:
        if (!getSchemaTitle().equals(other.getSchemaTitle())) return false;
        break;
      case 2:
        if (!getSchemaUri().equals(other.getSchemaUri())) return false;
        break;
      case 3:
        if (!getInstanceSchema().equals(other.getInstanceSchema())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SCHEMA_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getSchemaVersion().hashCode();
    switch (kindCase_) {
      case 1:
        hash = (37 * hash) + SCHEMA_TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaTitle().hashCode();
        break;
      case 2:
        hash = (37 * hash) + SCHEMA_URI_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaUri().hashCode();
        break;
      case 3:
        hash = (37 * hash) + INSTANCE_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getInstanceSchema().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The definition of a artifact type in MLMD.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ArtifactTypeSchema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ArtifactTypeSchema)
      com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ArtifactTypeSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ArtifactTypeSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.class,
              com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      schemaVersion_ = "";
      kindCase_ = 0;
      kind_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.UiPipelineSpecProto
          .internal_static_google_cloud_aiplatform_v1beta1_ArtifactTypeSchema_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema build() {
      com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema result =
          new com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.schemaVersion_ = schemaVersion_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema result) {
      result.kindCase_ = kindCase_;
      result.kind_ = this.kind_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.getDefaultInstance())
        return this;
      if (!other.getSchemaVersion().isEmpty()) {
        schemaVersion_ = other.schemaVersion_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      switch (other.getKindCase()) {
        case SCHEMA_TITLE:
          {
            kindCase_ = 1;
            kind_ = other.kind_;
            onChanged();
            break;
          }
        case SCHEMA_URI:
          {
            kindCase_ = 2;
            kind_ = other.kind_;
            onChanged();
            break;
          }
        case INSTANCE_SCHEMA:
          {
            kindCase_ = 3;
            kind_ = other.kind_;
            onChanged();
            break;
          }
        case KIND_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                kindCase_ = 1;
                kind_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                kindCase_ = 2;
                kind_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                kindCase_ = 3;
                kind_ = s;
                break;
              } // case 26
            case 34:
              {
                schemaVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int kindCase_ = 0;
    private java.lang.Object kind_;

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public Builder clearKind() {
      kindCase_ = 0;
      kind_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The name of the type. The format of the title must be:
     * `&lt;namespace&gt;.&lt;title&gt;`.
     * Examples:
     *  - `aiplatform.Model`
     *  - `acme.CustomModel`
     * When this field is set, the type must be pre-registered in the MLMD
     * store.
     * </pre>
     *
     * <code>string schema_title = 1;</code>
     *
     * @return Whether the schemaTitle field is set.
     */
    @java.lang.Override
    public boolean hasSchemaTitle() {
      return kindCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The name of the type. The format of the title must be:
     * `&lt;namespace&gt;.&lt;title&gt;`.
     * Examples:
     *  - `aiplatform.Model`
     *  - `acme.CustomModel`
     * When this field is set, the type must be pre-registered in the MLMD
     * store.
     * </pre>
     *
     * <code>string schema_title = 1;</code>
     *
     * @return The schemaTitle.
     */
    @java.lang.Override
    public java.lang.String getSchemaTitle() {
      java.lang.Object ref = "";
      if (kindCase_ == 1) {
        ref = kind_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (kindCase_ == 1) {
          kind_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the type. The format of the title must be:
     * `&lt;namespace&gt;.&lt;title&gt;`.
     * Examples:
     *  - `aiplatform.Model`
     *  - `acme.CustomModel`
     * When this field is set, the type must be pre-registered in the MLMD
     * store.
     * </pre>
     *
     * <code>string schema_title = 1;</code>
     *
     * @return The bytes for schemaTitle.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchemaTitleBytes() {
      java.lang.Object ref = "";
      if (kindCase_ == 1) {
        ref = kind_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (kindCase_ == 1) {
          kind_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the type. The format of the title must be:
     * `&lt;namespace&gt;.&lt;title&gt;`.
     * Examples:
     *  - `aiplatform.Model`
     *  - `acme.CustomModel`
     * When this field is set, the type must be pre-registered in the MLMD
     * store.
     * </pre>
     *
     * <code>string schema_title = 1;</code>
     *
     * @param value The schemaTitle to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kindCase_ = 1;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the type. The format of the title must be:
     * `&lt;namespace&gt;.&lt;title&gt;`.
     * Examples:
     *  - `aiplatform.Model`
     *  - `acme.CustomModel`
     * When this field is set, the type must be pre-registered in the MLMD
     * store.
     * </pre>
     *
     * <code>string schema_title = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchemaTitle() {
      if (kindCase_ == 1) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the type. The format of the title must be:
     * `&lt;namespace&gt;.&lt;title&gt;`.
     * Examples:
     *  - `aiplatform.Model`
     *  - `acme.CustomModel`
     * When this field is set, the type must be pre-registered in the MLMD
     * store.
     * </pre>
     *
     * <code>string schema_title = 1;</code>
     *
     * @param value The bytes for schemaTitle to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kindCase_ = 1;
      kind_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Cloud Storage describing the
     * format.
     * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
     * [PipelineArtifactTypeSchema.instance_schema][] instead.
     * </pre>
     *
     * <code>string schema_uri = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
     *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
     * @return Whether the schemaUri field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasSchemaUri() {
      return kindCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Cloud Storage describing the
     * format.
     * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
     * [PipelineArtifactTypeSchema.instance_schema][] instead.
     * </pre>
     *
     * <code>string schema_uri = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
     *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
     * @return The schemaUri.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getSchemaUri() {
      java.lang.Object ref = "";
      if (kindCase_ == 2) {
        ref = kind_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (kindCase_ == 2) {
          kind_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Cloud Storage describing the
     * format.
     * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
     * [PipelineArtifactTypeSchema.instance_schema][] instead.
     * </pre>
     *
     * <code>string schema_uri = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
     *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
     * @return The bytes for schemaUri.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getSchemaUriBytes() {
      java.lang.Object ref = "";
      if (kindCase_ == 2) {
        ref = kind_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (kindCase_ == 2) {
          kind_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Cloud Storage describing the
     * format.
     * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
     * [PipelineArtifactTypeSchema.instance_schema][] instead.
     * </pre>
     *
     * <code>string schema_uri = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
     *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
     * @param value The schemaUri to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kindCase_ = 2;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Cloud Storage describing the
     * format.
     * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
     * [PipelineArtifactTypeSchema.instance_schema][] instead.
     * </pre>
     *
     * <code>string schema_uri = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
     *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearSchemaUri() {
      if (kindCase_ == 2) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Cloud Storage describing the
     * format.
     * Deprecated. Use [PipelineArtifactTypeSchema.schema_title][] or
     * [PipelineArtifactTypeSchema.instance_schema][] instead.
     * </pre>
     *
     * <code>string schema_uri = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.ArtifactTypeSchema.schema_uri is deprecated. See
     *     google/cloud/aiplatform/v1beta1/ui_pipeline_spec.proto;l=47
     * @param value The bytes for schemaUri to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kindCase_ = 2;
      kind_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a raw YAML string, describing the format of
     * the properties of the type.
     * </pre>
     *
     * <code>string instance_schema = 3;</code>
     *
     * @return Whether the instanceSchema field is set.
     */
    @java.lang.Override
    public boolean hasInstanceSchema() {
      return kindCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Contains a raw YAML string, describing the format of
     * the properties of the type.
     * </pre>
     *
     * <code>string instance_schema = 3;</code>
     *
     * @return The instanceSchema.
     */
    @java.lang.Override
    public java.lang.String getInstanceSchema() {
      java.lang.Object ref = "";
      if (kindCase_ == 3) {
        ref = kind_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (kindCase_ == 3) {
          kind_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains a raw YAML string, describing the format of
     * the properties of the type.
     * </pre>
     *
     * <code>string instance_schema = 3;</code>
     *
     * @return The bytes for instanceSchema.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInstanceSchemaBytes() {
      java.lang.Object ref = "";
      if (kindCase_ == 3) {
        ref = kind_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (kindCase_ == 3) {
          kind_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains a raw YAML string, describing the format of
     * the properties of the type.
     * </pre>
     *
     * <code>string instance_schema = 3;</code>
     *
     * @param value The instanceSchema to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceSchema(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kindCase_ = 3;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains a raw YAML string, describing the format of
     * the properties of the type.
     * </pre>
     *
     * <code>string instance_schema = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceSchema() {
      if (kindCase_ == 3) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains a raw YAML string, describing the format of
     * the properties of the type.
     * </pre>
     *
     * <code>string instance_schema = 3;</code>
     *
     * @param value The bytes for instanceSchema to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceSchemaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kindCase_ = 3;
      kind_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object schemaVersion_ = "";
    /**
     *
     *
     * <pre>
     * The schema version of the artifact. If the value is not set, it defaults
     * to the latest version in the system.
     * </pre>
     *
     * <code>string schema_version = 4;</code>
     *
     * @return The schemaVersion.
     */
    public java.lang.String getSchemaVersion() {
      java.lang.Object ref = schemaVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The schema version of the artifact. If the value is not set, it defaults
     * to the latest version in the system.
     * </pre>
     *
     * <code>string schema_version = 4;</code>
     *
     * @return The bytes for schemaVersion.
     */
    public com.google.protobuf.ByteString getSchemaVersionBytes() {
      java.lang.Object ref = schemaVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The schema version of the artifact. If the value is not set, it defaults
     * to the latest version in the system.
     * </pre>
     *
     * <code>string schema_version = 4;</code>
     *
     * @param value The schemaVersion to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schemaVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema version of the artifact. If the value is not set, it defaults
     * to the latest version in the system.
     * </pre>
     *
     * <code>string schema_version = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchemaVersion() {
      schemaVersion_ = getDefaultInstance().getSchemaVersion();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema version of the artifact. If the value is not set, it defaults
     * to the latest version in the system.
     * </pre>
     *
     * <code>string schema_version = 4;</code>
     *
     * @param value The bytes for schemaVersion to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schemaVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ArtifactTypeSchema)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ArtifactTypeSchema)
  private static final com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema();
  }

  public static com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ArtifactTypeSchema> PARSER =
      new com.google.protobuf.AbstractParser<ArtifactTypeSchema>() {
        @java.lang.Override
        public ArtifactTypeSchema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ArtifactTypeSchema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ArtifactTypeSchema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ArtifactTypeSchema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
