/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tool.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Specifies the context retrieval config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.RagRetrievalConfig}
 */
public final class RagRetrievalConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagRetrievalConfig)
    RagRetrievalConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RagRetrievalConfig.newBuilder() to construct.
  private RagRetrievalConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagRetrievalConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagRetrievalConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.class,
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.Builder.class);
  }

  public interface FilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagRetrievalConfig.Filter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the vectorDistanceThreshold field is set.
     */
    boolean hasVectorDistanceThreshold();
    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The vectorDistanceThreshold.
     */
    double getVectorDistanceThreshold();

    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector similarity larger than the
     * threshold.
     * </pre>
     *
     * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the vectorSimilarityThreshold field is set.
     */
    boolean hasVectorSimilarityThreshold();
    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector similarity larger than the
     * threshold.
     * </pre>
     *
     * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The vectorSimilarityThreshold.
     */
    double getVectorSimilarityThreshold();

    /**
     *
     *
     * <pre>
     * Optional. String for metadata filtering.
     * </pre>
     *
     * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The metadataFilter.
     */
    java.lang.String getMetadataFilter();
    /**
     *
     *
     * <pre>
     * Optional. String for metadata filtering.
     * </pre>
     *
     * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for metadataFilter.
     */
    com.google.protobuf.ByteString getMetadataFilterBytes();

    com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.VectorDbThresholdCase
        getVectorDbThresholdCase();
  }
  /**
   *
   *
   * <pre>
   * Config for filters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagRetrievalConfig.Filter}
   */
  public static final class Filter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagRetrievalConfig.Filter)
      FilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Filter.newBuilder() to construct.
    private Filter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Filter() {
      metadataFilter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Filter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_Filter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_Filter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.class,
              com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.Builder.class);
    }

    private int vectorDbThresholdCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object vectorDbThreshold_;

    public enum VectorDbThresholdCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VECTOR_DISTANCE_THRESHOLD(3),
      VECTOR_SIMILARITY_THRESHOLD(4),
      VECTORDBTHRESHOLD_NOT_SET(0);
      private final int value;

      private VectorDbThresholdCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static VectorDbThresholdCase valueOf(int value) {
        return forNumber(value);
      }

      public static VectorDbThresholdCase forNumber(int value) {
        switch (value) {
          case 3:
            return VECTOR_DISTANCE_THRESHOLD;
          case 4:
            return VECTOR_SIMILARITY_THRESHOLD;
          case 0:
            return VECTORDBTHRESHOLD_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public VectorDbThresholdCase getVectorDbThresholdCase() {
      return VectorDbThresholdCase.forNumber(vectorDbThresholdCase_);
    }

    public static final int VECTOR_DISTANCE_THRESHOLD_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the vectorDistanceThreshold field is set.
     */
    @java.lang.Override
    public boolean hasVectorDistanceThreshold() {
      return vectorDbThresholdCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector distance smaller than the
     * threshold.
     * </pre>
     *
     * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The vectorDistanceThreshold.
     */
    @java.lang.Override
    public double getVectorDistanceThreshold() {
      if (vectorDbThresholdCase_ == 3) {
        return (java.lang.Double) vectorDbThreshold_;
      }
      return 0D;
    }

    public static final int VECTOR_SIMILARITY_THRESHOLD_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector similarity larger than the
     * threshold.
     * </pre>
     *
     * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the vectorSimilarityThreshold field is set.
     */
    @java.lang.Override
    public boolean hasVectorSimilarityThreshold() {
      return vectorDbThresholdCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only returns contexts with vector similarity larger than the
     * threshold.
     * </pre>
     *
     * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The vectorSimilarityThreshold.
     */
    @java.lang.Override
    public double getVectorSimilarityThreshold() {
      if (vectorDbThresholdCase_ == 4) {
        return (java.lang.Double) vectorDbThreshold_;
      }
      return 0D;
    }

    public static final int METADATA_FILTER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object metadataFilter_ = "";
    /**
     *
     *
     * <pre>
     * Optional. String for metadata filtering.
     * </pre>
     *
     * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The metadataFilter.
     */
    @java.lang.Override
    public java.lang.String getMetadataFilter() {
      java.lang.Object ref = metadataFilter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataFilter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. String for metadata filtering.
     * </pre>
     *
     * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for metadataFilter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMetadataFilterBytes() {
      java.lang.Object ref = metadataFilter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataFilter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metadataFilter_);
      }
      if (vectorDbThresholdCase_ == 3) {
        output.writeDouble(3, (double) ((java.lang.Double) vectorDbThreshold_));
      }
      if (vectorDbThresholdCase_ == 4) {
        output.writeDouble(4, (double) ((java.lang.Double) vectorDbThreshold_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataFilter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, metadataFilter_);
      }
      if (vectorDbThresholdCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                3, (double) ((java.lang.Double) vectorDbThreshold_));
      }
      if (vectorDbThresholdCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                4, (double) ((java.lang.Double) vectorDbThreshold_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter other =
          (com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter) obj;

      if (!getMetadataFilter().equals(other.getMetadataFilter())) return false;
      if (!getVectorDbThresholdCase().equals(other.getVectorDbThresholdCase())) return false;
      switch (vectorDbThresholdCase_) {
        case 3:
          if (java.lang.Double.doubleToLongBits(getVectorDistanceThreshold())
              != java.lang.Double.doubleToLongBits(other.getVectorDistanceThreshold()))
            return false;
          break;
        case 4:
          if (java.lang.Double.doubleToLongBits(getVectorSimilarityThreshold())
              != java.lang.Double.doubleToLongBits(other.getVectorSimilarityThreshold()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + METADATA_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataFilter().hashCode();
      switch (vectorDbThresholdCase_) {
        case 3:
          hash = (37 * hash) + VECTOR_DISTANCE_THRESHOLD_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getVectorDistanceThreshold()));
          break;
        case 4:
          hash = (37 * hash) + VECTOR_SIMILARITY_THRESHOLD_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getVectorSimilarityThreshold()));
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for filters.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RagRetrievalConfig.Filter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagRetrievalConfig.Filter)
        com.google.cloud.aiplatform.v1.RagRetrievalConfig.FilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_Filter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_Filter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.class,
                com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        metadataFilter_ = "";
        vectorDbThresholdCase_ = 0;
        vectorDbThreshold_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_Filter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter build() {
        com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter buildPartial() {
        com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter result =
            new com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.metadataFilter_ = metadataFilter_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter result) {
        result.vectorDbThresholdCase_ = vectorDbThresholdCase_;
        result.vectorDbThreshold_ = this.vectorDbThreshold_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter) {
          return mergeFrom((com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter other) {
        if (other == com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.getDefaultInstance())
          return this;
        if (!other.getMetadataFilter().isEmpty()) {
          metadataFilter_ = other.metadataFilter_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getVectorDbThresholdCase()) {
          case VECTOR_DISTANCE_THRESHOLD:
            {
              setVectorDistanceThreshold(other.getVectorDistanceThreshold());
              break;
            }
          case VECTOR_SIMILARITY_THRESHOLD:
            {
              setVectorSimilarityThreshold(other.getVectorSimilarityThreshold());
              break;
            }
          case VECTORDBTHRESHOLD_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  metadataFilter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 25:
                {
                  vectorDbThreshold_ = input.readDouble();
                  vectorDbThresholdCase_ = 3;
                  break;
                } // case 25
              case 33:
                {
                  vectorDbThreshold_ = input.readDouble();
                  vectorDbThresholdCase_ = 4;
                  break;
                } // case 33
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int vectorDbThresholdCase_ = 0;
      private java.lang.Object vectorDbThreshold_;

      public VectorDbThresholdCase getVectorDbThresholdCase() {
        return VectorDbThresholdCase.forNumber(vectorDbThresholdCase_);
      }

      public Builder clearVectorDbThreshold() {
        vectorDbThresholdCase_ = 0;
        vectorDbThreshold_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the vectorDistanceThreshold field is set.
       */
      public boolean hasVectorDistanceThreshold() {
        return vectorDbThresholdCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The vectorDistanceThreshold.
       */
      public double getVectorDistanceThreshold() {
        if (vectorDbThresholdCase_ == 3) {
          return (java.lang.Double) vectorDbThreshold_;
        }
        return 0D;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The vectorDistanceThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setVectorDistanceThreshold(double value) {

        vectorDbThresholdCase_ = 3;
        vectorDbThreshold_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector distance smaller than the
       * threshold.
       * </pre>
       *
       * <code>double vector_distance_threshold = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVectorDistanceThreshold() {
        if (vectorDbThresholdCase_ == 3) {
          vectorDbThresholdCase_ = 0;
          vectorDbThreshold_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector similarity larger than the
       * threshold.
       * </pre>
       *
       * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the vectorSimilarityThreshold field is set.
       */
      public boolean hasVectorSimilarityThreshold() {
        return vectorDbThresholdCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector similarity larger than the
       * threshold.
       * </pre>
       *
       * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The vectorSimilarityThreshold.
       */
      public double getVectorSimilarityThreshold() {
        if (vectorDbThresholdCase_ == 4) {
          return (java.lang.Double) vectorDbThreshold_;
        }
        return 0D;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector similarity larger than the
       * threshold.
       * </pre>
       *
       * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The vectorSimilarityThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setVectorSimilarityThreshold(double value) {

        vectorDbThresholdCase_ = 4;
        vectorDbThreshold_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only returns contexts with vector similarity larger than the
       * threshold.
       * </pre>
       *
       * <code>double vector_similarity_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVectorSimilarityThreshold() {
        if (vectorDbThresholdCase_ == 4) {
          vectorDbThresholdCase_ = 0;
          vectorDbThreshold_ = null;
          onChanged();
        }
        return this;
      }

      private java.lang.Object metadataFilter_ = "";
      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The metadataFilter.
       */
      public java.lang.String getMetadataFilter() {
        java.lang.Object ref = metadataFilter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metadataFilter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for metadataFilter.
       */
      public com.google.protobuf.ByteString getMetadataFilterBytes() {
        java.lang.Object ref = metadataFilter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metadataFilter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The metadataFilter to set.
       * @return This builder for chaining.
       */
      public Builder setMetadataFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataFilter_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetadataFilter() {
        metadataFilter_ = getDefaultInstance().getMetadataFilter();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. String for metadata filtering.
       * </pre>
       *
       * <code>string metadata_filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for metadataFilter to set.
       * @return This builder for chaining.
       */
      public Builder setMetadataFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        metadataFilter_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagRetrievalConfig.Filter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagRetrievalConfig.Filter)
    private static final com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter();
    }

    public static com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Filter> PARSER =
        new com.google.protobuf.AbstractParser<Filter>() {
          @java.lang.Override
          public Filter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Filter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Filter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TOP_K_FIELD_NUMBER = 1;
  private int topK_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The number of contexts to retrieve.
   * </pre>
   *
   * <code>int32 top_k = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The topK.
   */
  @java.lang.Override
  public int getTopK() {
    return topK_;
  }

  public static final int FILTER_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter_;
  /**
   *
   *
   * <pre>
   * Optional. Config for filters.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Config for filters.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter getFilter() {
    return filter_ == null
        ? com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.getDefaultInstance()
        : filter_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Config for filters.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagRetrievalConfig.FilterOrBuilder getFilterOrBuilder() {
    return filter_ == null
        ? com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.getDefaultInstance()
        : filter_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (topK_ != 0) {
      output.writeInt32(1, topK_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getFilter());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (topK_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, topK_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFilter());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.RagRetrievalConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.RagRetrievalConfig other =
        (com.google.cloud.aiplatform.v1.RagRetrievalConfig) obj;

    if (getTopK() != other.getTopK()) return false;
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOP_K_FIELD_NUMBER;
    hash = (53 * hash) + getTopK();
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.RagRetrievalConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the context retrieval config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagRetrievalConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagRetrievalConfig)
      com.google.cloud.aiplatform.v1.RagRetrievalConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagRetrievalConfig.class,
              com.google.cloud.aiplatform.v1.RagRetrievalConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.RagRetrievalConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFilterFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      topK_ = 0;
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_RagRetrievalConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.RagRetrievalConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig build() {
      com.google.cloud.aiplatform.v1.RagRetrievalConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig buildPartial() {
      com.google.cloud.aiplatform.v1.RagRetrievalConfig result =
          new com.google.cloud.aiplatform.v1.RagRetrievalConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.RagRetrievalConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.topK_ = topK_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.RagRetrievalConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.RagRetrievalConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.RagRetrievalConfig other) {
      if (other == com.google.cloud.aiplatform.v1.RagRetrievalConfig.getDefaultInstance())
        return this;
      if (other.getTopK() != 0) {
        setTopK(other.getTopK());
      }
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                topK_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 26:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int topK_;
    /**
     *
     *
     * <pre>
     * Optional. The number of contexts to retrieve.
     * </pre>
     *
     * <code>int32 top_k = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The topK.
     */
    @java.lang.Override
    public int getTopK() {
      return topK_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of contexts to retrieve.
     * </pre>
     *
     * <code>int32 top_k = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The topK to set.
     * @return This builder for chaining.
     */
    public Builder setTopK(int value) {

      topK_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of contexts to retrieve.
     * </pre>
     *
     * <code>int32 top_k = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopK() {
      bitField0_ = (bitField0_ & ~0x00000001);
      topK_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter,
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.Builder,
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.FilterOrBuilder>
        filterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The filter.
     */
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null
            ? com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.getDefaultInstance()
            : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFilter(com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFilter(
        com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFilter(com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && filter_ != null
            && filter_
                != com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      if (filter_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000002);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.Builder getFilterBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagRetrievalConfig.FilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null
            ? com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.getDefaultInstance()
            : filter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for filters.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagRetrievalConfig.Filter filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter,
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.Builder,
            com.google.cloud.aiplatform.v1.RagRetrievalConfig.FilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter,
                com.google.cloud.aiplatform.v1.RagRetrievalConfig.Filter.Builder,
                com.google.cloud.aiplatform.v1.RagRetrievalConfig.FilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagRetrievalConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagRetrievalConfig)
  private static final com.google.cloud.aiplatform.v1.RagRetrievalConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagRetrievalConfig();
  }

  public static com.google.cloud.aiplatform.v1.RagRetrievalConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagRetrievalConfig> PARSER =
      new com.google.protobuf.AbstractParser<RagRetrievalConfig>() {
        @java.lang.Override
        public RagRetrievalConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagRetrievalConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagRetrievalConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagRetrievalConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
