/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/prediction_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.PredictResponse}
 */
public final class PredictResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PredictResponse)
    PredictResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PredictResponse.newBuilder() to construct.
  private PredictResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PredictResponse() {
    predictions_ = java.util.Collections.emptyList();
    deployedModelId_ = "";
    model_ = "";
    modelVersionId_ = "";
    modelDisplayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PredictResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1_PredictResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1_PredictResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.PredictResponse.class,
            com.google.cloud.aiplatform.v1.PredictResponse.Builder.class);
  }

  private int bitField0_;
  public static final int PREDICTIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Value> predictions_;
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getPredictionsList() {
    return predictions_;
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
      getPredictionsOrBuilderList() {
    return predictions_;
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public int getPredictionsCount() {
    return predictions_.size();
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getPredictions(int index) {
    return predictions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * The schema of any single prediction may be specified via Endpoint's
   * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
   * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
   * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getPredictionsOrBuilder(int index) {
    return predictions_.get(index);
  }

  public static final int DEPLOYED_MODEL_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployedModelId_ = "";
  /**
   *
   *
   * <pre>
   * ID of the Endpoint's DeployedModel that served this prediction.
   * </pre>
   *
   * <code>string deployed_model_id = 2;</code>
   *
   * @return The deployedModelId.
   */
  @java.lang.Override
  public java.lang.String getDeployedModelId() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployedModelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ID of the Endpoint's DeployedModel that served this prediction.
   * </pre>
   *
   * <code>string deployed_model_id = 2;</code>
   *
   * @return The bytes for deployedModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployedModelIdBytes() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployedModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Model which is deployed as the
   * DeployedModel that this prediction hits.
   * </pre>
   *
   * <code>
   * string model = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Model which is deployed as the
   * DeployedModel that this prediction hits.
   * </pre>
   *
   * <code>
   * string model = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_VERSION_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelVersionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The version ID of the Model which is deployed as the
   * DeployedModel that this prediction hits.
   * </pre>
   *
   * <code>string model_version_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The modelVersionId.
   */
  @java.lang.Override
  public java.lang.String getModelVersionId() {
    java.lang.Object ref = modelVersionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The version ID of the Model which is deployed as the
   * DeployedModel that this prediction hits.
   * </pre>
   *
   * <code>string model_version_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for modelVersionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelVersionIdBytes() {
    java.lang.Object ref = modelVersionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_DISPLAY_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelDisplayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The [display
   * name][google.cloud.aiplatform.v1.Model.display_name] of the Model which is
   * deployed as the DeployedModel that this prediction hits.
   * </pre>
   *
   * <code>string model_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The modelDisplayName.
   */
  @java.lang.Override
  public java.lang.String getModelDisplayName() {
    java.lang.Object ref = modelDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The [display
   * name][google.cloud.aiplatform.v1.Model.display_name] of the Model which is
   * deployed as the DeployedModel that this prediction hits.
   * </pre>
   *
   * <code>string model_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for modelDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelDisplayNameBytes() {
    java.lang.Object ref = modelDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 6;
  private com.google.protobuf.Value metadata_;
  /**
   *
   *
   * <pre>
   * Output only. Request-level metadata returned by the model. The metadata
   * type will be dependent upon the model implementation.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Request-level metadata returned by the model. The metadata
   * type will be dependent upon the model implementation.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetadata() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Request-level metadata returned by the model. The metadata
   * type will be dependent upon the model implementation.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < predictions_.size(); i++) {
      output.writeMessage(1, predictions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployedModelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, model_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, modelDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, modelVersionId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < predictions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, predictions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployedModelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, model_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, modelDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, modelVersionId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.PredictResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.PredictResponse other =
        (com.google.cloud.aiplatform.v1.PredictResponse) obj;

    if (!getPredictionsList().equals(other.getPredictionsList())) return false;
    if (!getDeployedModelId().equals(other.getDeployedModelId())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (!getModelVersionId().equals(other.getModelVersionId())) return false;
    if (!getModelDisplayName().equals(other.getModelDisplayName())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPredictionsCount() > 0) {
      hash = (37 * hash) + PREDICTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPredictionsList().hashCode();
    }
    hash = (37 * hash) + DEPLOYED_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployedModelId().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + MODEL_VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersionId().hashCode();
    hash = (37 * hash) + MODEL_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getModelDisplayName().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.PredictResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PredictResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PredictResponse)
      com.google.cloud.aiplatform.v1.PredictResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1_PredictResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1_PredictResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PredictResponse.class,
              com.google.cloud.aiplatform.v1.PredictResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.PredictResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPredictionsFieldBuilder();
        getMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (predictionsBuilder_ == null) {
        predictions_ = java.util.Collections.emptyList();
      } else {
        predictions_ = null;
        predictionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      deployedModelId_ = "";
      model_ = "";
      modelVersionId_ = "";
      modelDisplayName_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1_PredictResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PredictResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.PredictResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PredictResponse build() {
      com.google.cloud.aiplatform.v1.PredictResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PredictResponse buildPartial() {
      com.google.cloud.aiplatform.v1.PredictResponse result =
          new com.google.cloud.aiplatform.v1.PredictResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.PredictResponse result) {
      if (predictionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          predictions_ = java.util.Collections.unmodifiableList(predictions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.predictions_ = predictions_;
      } else {
        result.predictions_ = predictionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.PredictResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployedModelId_ = deployedModelId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.model_ = model_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.modelVersionId_ = modelVersionId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.modelDisplayName_ = modelDisplayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.PredictResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1.PredictResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.PredictResponse other) {
      if (other == com.google.cloud.aiplatform.v1.PredictResponse.getDefaultInstance()) return this;
      if (predictionsBuilder_ == null) {
        if (!other.predictions_.isEmpty()) {
          if (predictions_.isEmpty()) {
            predictions_ = other.predictions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePredictionsIsMutable();
            predictions_.addAll(other.predictions_);
          }
          onChanged();
        }
      } else {
        if (!other.predictions_.isEmpty()) {
          if (predictionsBuilder_.isEmpty()) {
            predictionsBuilder_.dispose();
            predictionsBuilder_ = null;
            predictions_ = other.predictions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            predictionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPredictionsFieldBuilder()
                    : null;
          } else {
            predictionsBuilder_.addAllMessages(other.predictions_);
          }
        }
      }
      if (!other.getDeployedModelId().isEmpty()) {
        deployedModelId_ = other.deployedModelId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getModelVersionId().isEmpty()) {
        modelVersionId_ = other.modelVersionId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getModelDisplayName().isEmpty()) {
        modelDisplayName_ = other.modelDisplayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.Value m =
                    input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
                if (predictionsBuilder_ == null) {
                  ensurePredictionsIsMutable();
                  predictions_.add(m);
                } else {
                  predictionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                deployedModelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                modelDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                modelVersionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.protobuf.Value> predictions_ =
        java.util.Collections.emptyList();

    private void ensurePredictionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        predictions_ = new java.util.ArrayList<com.google.protobuf.Value>(predictions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        predictionsBuilder_;

    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public java.util.List<com.google.protobuf.Value> getPredictionsList() {
      if (predictionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(predictions_);
      } else {
        return predictionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public int getPredictionsCount() {
      if (predictionsBuilder_ == null) {
        return predictions_.size();
      } else {
        return predictionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.Value getPredictions(int index) {
      if (predictionsBuilder_ == null) {
        return predictions_.get(index);
      } else {
        return predictionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder setPredictions(int index, com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.set(index, value);
        onChanged();
      } else {
        predictionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder setPredictions(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.set(index, builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addPredictions(com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.add(value);
        onChanged();
      } else {
        predictionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addPredictions(int index, com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.add(index, value);
        onChanged();
      } else {
        predictionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addPredictions(com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.add(builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addPredictions(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.add(index, builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder addAllPredictions(
        java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, predictions_);
        onChanged();
      } else {
        predictionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder clearPredictions() {
      if (predictionsBuilder_ == null) {
        predictions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        predictionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public Builder removePredictions(int index) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.remove(index);
        onChanged();
      } else {
        predictionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.Value.Builder getPredictionsBuilder(int index) {
      return getPredictionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.ValueOrBuilder getPredictionsOrBuilder(int index) {
      if (predictionsBuilder_ == null) {
        return predictions_.get(index);
      } else {
        return predictionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getPredictionsOrBuilderList() {
      if (predictionsBuilder_ != null) {
        return predictionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(predictions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.Value.Builder addPredictionsBuilder() {
      return getPredictionsFieldBuilder()
          .addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public com.google.protobuf.Value.Builder addPredictionsBuilder(int index) {
      return getPredictionsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * The schema of any single prediction may be specified via Endpoint's
     * DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 1;</code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getPredictionsBuilderList() {
      return getPredictionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getPredictionsFieldBuilder() {
      if (predictionsBuilder_ == null) {
        predictionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                predictions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        predictions_ = null;
      }
      return predictionsBuilder_;
    }

    private java.lang.Object deployedModelId_ = "";
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return The deployedModelId.
     */
    public java.lang.String getDeployedModelId() {
      java.lang.Object ref = deployedModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployedModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return The bytes for deployedModelId.
     */
    public com.google.protobuf.ByteString getDeployedModelIdBytes() {
      java.lang.Object ref = deployedModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployedModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @param value The deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployedModelId() {
      deployedModelId_ = getDefaultInstance().getDeployedModelId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this prediction.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @param value The bytes for deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>
     * string model = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object modelVersionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_version_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelVersionId.
     */
    public java.lang.String getModelVersionId() {
      java.lang.Object ref = modelVersionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_version_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelVersionId.
     */
    public com.google.protobuf.ByteString getModelVersionIdBytes() {
      java.lang.Object ref = modelVersionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_version_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The modelVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelVersionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_version_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersionId() {
      modelVersionId_ = getDefaultInstance().getModelVersionId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the Model which is deployed as the
     * DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_version_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for modelVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelVersionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object modelDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The [display
     * name][google.cloud.aiplatform.v1.Model.display_name] of the Model which is
     * deployed as the DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelDisplayName.
     */
    public java.lang.String getModelDisplayName() {
      java.lang.Object ref = modelDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The [display
     * name][google.cloud.aiplatform.v1.Model.display_name] of the Model which is
     * deployed as the DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelDisplayName.
     */
    public com.google.protobuf.ByteString getModelDisplayNameBytes() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The [display
     * name][google.cloud.aiplatform.v1.Model.display_name] of the Model which is
     * deployed as the DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The modelDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setModelDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelDisplayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [display
     * name][google.cloud.aiplatform.v1.Model.display_name] of the Model which is
     * deployed as the DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelDisplayName() {
      modelDisplayName_ = getDefaultInstance().getModelDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [display
     * name][google.cloud.aiplatform.v1.Model.display_name] of the Model which is
     * deployed as the DeployedModel that this prediction hits.
     * </pre>
     *
     * <code>string model_display_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for modelDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setModelDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelDisplayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metadata.
     */
    public com.google.protobuf.Value getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadata(com.google.protobuf.Value.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && metadata_ != null
            && metadata_ != com.google.protobuf.Value.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000020);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Value.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Request-level metadata returned by the model. The metadata
     * type will be dependent upon the model implementation.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PredictResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PredictResponse)
  private static final com.google.cloud.aiplatform.v1.PredictResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PredictResponse();
  }

  public static com.google.cloud.aiplatform.v1.PredictResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PredictResponse> PARSER =
      new com.google.protobuf.AbstractParser<PredictResponse>() {
        @java.lang.Override
        public PredictResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PredictResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PredictResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PredictResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
