/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tensorboard_time_series.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * TensorboardTimeSeries maps to times series produced in training runs
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.TensorboardTimeSeries}
 */
public final class TensorboardTimeSeries extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.TensorboardTimeSeries)
    TensorboardTimeSeriesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TensorboardTimeSeries.newBuilder() to construct.
  private TensorboardTimeSeries(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TensorboardTimeSeries() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    valueType_ = 0;
    etag_ = "";
    pluginName_ = "";
    pluginData_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TensorboardTimeSeries();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
        .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
        .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.TensorboardTimeSeries.class,
            com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * An enum representing the value type of a TensorboardTimeSeries.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType}
   */
  public enum ValueType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The value type is unspecified.
     * </pre>
     *
     * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
     */
    VALUE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used for TensorboardTimeSeries that is a list of scalars.
     * E.g. accuracy of a model over epochs/time.
     * </pre>
     *
     * <code>SCALAR = 1;</code>
     */
    SCALAR(1),
    /**
     *
     *
     * <pre>
     * Used for TensorboardTimeSeries that is a list of tensors.
     * E.g. histograms of weights of layer in a model over epoch/time.
     * </pre>
     *
     * <code>TENSOR = 2;</code>
     */
    TENSOR(2),
    /**
     *
     *
     * <pre>
     * Used for TensorboardTimeSeries that is a list of blob sequences.
     * E.g. set of sample images with labels over epochs/time.
     * </pre>
     *
     * <code>BLOB_SEQUENCE = 3;</code>
     */
    BLOB_SEQUENCE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The value type is unspecified.
     * </pre>
     *
     * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int VALUE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Used for TensorboardTimeSeries that is a list of scalars.
     * E.g. accuracy of a model over epochs/time.
     * </pre>
     *
     * <code>SCALAR = 1;</code>
     */
    public static final int SCALAR_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Used for TensorboardTimeSeries that is a list of tensors.
     * E.g. histograms of weights of layer in a model over epoch/time.
     * </pre>
     *
     * <code>TENSOR = 2;</code>
     */
    public static final int TENSOR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Used for TensorboardTimeSeries that is a list of blob sequences.
     * E.g. set of sample images with labels over epochs/time.
     * </pre>
     *
     * <code>BLOB_SEQUENCE = 3;</code>
     */
    public static final int BLOB_SEQUENCE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ValueType forNumber(int value) {
      switch (value) {
        case 0:
          return VALUE_TYPE_UNSPECIFIED;
        case 1:
          return SCALAR;
        case 2:
          return TENSOR;
        case 3:
          return BLOB_SEQUENCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ValueType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ValueType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ValueType>() {
          public ValueType findValueByNumber(int number) {
            return ValueType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.TensorboardTimeSeries.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ValueType[] VALUES = values();

    public static ValueType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ValueType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType)
  }

  public interface MetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Max step index of all data points within a
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>int64 max_step = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The maxStep.
     */
    long getMaxStep();

    /**
     *
     *
     * <pre>
     * Output only. Max wall clock timestamp of all data points within a
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the maxWallTime field is set.
     */
    boolean hasMaxWallTime();
    /**
     *
     *
     * <pre>
     * Output only. Max wall clock timestamp of all data points within a
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The maxWallTime.
     */
    com.google.protobuf.Timestamp getMaxWallTime();
    /**
     *
     *
     * <pre>
     * Output only. Max wall clock timestamp of all data points within a
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getMaxWallTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The largest blob sequence length (number of blobs) of all
     * data points in this time series, if its ValueType is BLOB_SEQUENCE.
     * </pre>
     *
     * <code>int64 max_blob_sequence_length = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The maxBlobSequenceLength.
     */
    long getMaxBlobSequenceLength();
  }
  /**
   *
   *
   * <pre>
   * Describes metadata for a TensorboardTimeSeries.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata}
   */
  public static final class Metadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata)
      MetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metadata.newBuilder() to construct.
    private Metadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metadata() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
          .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_Metadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
          .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_Metadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.class,
              com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.Builder.class);
    }

    public static final int MAX_STEP_FIELD_NUMBER = 1;
    private long maxStep_ = 0L;
    /**
     *
     *
     * <pre>
     * Output only. Max step index of all data points within a
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>int64 max_step = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The maxStep.
     */
    @java.lang.Override
    public long getMaxStep() {
      return maxStep_;
    }

    public static final int MAX_WALL_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp maxWallTime_;
    /**
     *
     *
     * <pre>
     * Output only. Max wall clock timestamp of all data points within a
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the maxWallTime field is set.
     */
    @java.lang.Override
    public boolean hasMaxWallTime() {
      return maxWallTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Max wall clock timestamp of all data points within a
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The maxWallTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getMaxWallTime() {
      return maxWallTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : maxWallTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Max wall clock timestamp of all data points within a
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getMaxWallTimeOrBuilder() {
      return maxWallTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : maxWallTime_;
    }

    public static final int MAX_BLOB_SEQUENCE_LENGTH_FIELD_NUMBER = 3;
    private long maxBlobSequenceLength_ = 0L;
    /**
     *
     *
     * <pre>
     * Output only. The largest blob sequence length (number of blobs) of all
     * data points in this time series, if its ValueType is BLOB_SEQUENCE.
     * </pre>
     *
     * <code>int64 max_blob_sequence_length = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The maxBlobSequenceLength.
     */
    @java.lang.Override
    public long getMaxBlobSequenceLength() {
      return maxBlobSequenceLength_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (maxStep_ != 0L) {
        output.writeInt64(1, maxStep_);
      }
      if (maxWallTime_ != null) {
        output.writeMessage(2, getMaxWallTime());
      }
      if (maxBlobSequenceLength_ != 0L) {
        output.writeInt64(3, maxBlobSequenceLength_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (maxStep_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, maxStep_);
      }
      if (maxWallTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMaxWallTime());
      }
      if (maxBlobSequenceLength_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, maxBlobSequenceLength_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata other =
          (com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata) obj;

      if (getMaxStep() != other.getMaxStep()) return false;
      if (hasMaxWallTime() != other.hasMaxWallTime()) return false;
      if (hasMaxWallTime()) {
        if (!getMaxWallTime().equals(other.getMaxWallTime())) return false;
      }
      if (getMaxBlobSequenceLength() != other.getMaxBlobSequenceLength()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAX_STEP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxStep());
      if (hasMaxWallTime()) {
        hash = (37 * hash) + MAX_WALL_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getMaxWallTime().hashCode();
      }
      hash = (37 * hash) + MAX_BLOB_SEQUENCE_LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxBlobSequenceLength());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes metadata for a TensorboardTimeSeries.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata)
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.MetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
            .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_Metadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
            .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_Metadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.class,
                com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        maxStep_ = 0L;
        maxWallTime_ = null;
        if (maxWallTimeBuilder_ != null) {
          maxWallTimeBuilder_.dispose();
          maxWallTimeBuilder_ = null;
        }
        maxBlobSequenceLength_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
            .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_Metadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata build() {
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata buildPartial() {
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata result =
            new com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.maxStep_ = maxStep_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxWallTime_ =
              maxWallTimeBuilder_ == null ? maxWallTime_ : maxWallTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.maxBlobSequenceLength_ = maxBlobSequenceLength_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata) {
          return mergeFrom((com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata other) {
        if (other
            == com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.getDefaultInstance())
          return this;
        if (other.getMaxStep() != 0L) {
          setMaxStep(other.getMaxStep());
        }
        if (other.hasMaxWallTime()) {
          mergeMaxWallTime(other.getMaxWallTime());
        }
        if (other.getMaxBlobSequenceLength() != 0L) {
          setMaxBlobSequenceLength(other.getMaxBlobSequenceLength());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  maxStep_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getMaxWallTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  maxBlobSequenceLength_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long maxStep_;
      /**
       *
       *
       * <pre>
       * Output only. Max step index of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>int64 max_step = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The maxStep.
       */
      @java.lang.Override
      public long getMaxStep() {
        return maxStep_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Max step index of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>int64 max_step = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The maxStep to set.
       * @return This builder for chaining.
       */
      public Builder setMaxStep(long value) {

        maxStep_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Max step index of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>int64 max_step = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxStep() {
        bitField0_ = (bitField0_ & ~0x00000001);
        maxStep_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp maxWallTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          maxWallTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the maxWallTime field is set.
       */
      public boolean hasMaxWallTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The maxWallTime.
       */
      public com.google.protobuf.Timestamp getMaxWallTime() {
        if (maxWallTimeBuilder_ == null) {
          return maxWallTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : maxWallTime_;
        } else {
          return maxWallTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setMaxWallTime(com.google.protobuf.Timestamp value) {
        if (maxWallTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxWallTime_ = value;
        } else {
          maxWallTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setMaxWallTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (maxWallTimeBuilder_ == null) {
          maxWallTime_ = builderForValue.build();
        } else {
          maxWallTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeMaxWallTime(com.google.protobuf.Timestamp value) {
        if (maxWallTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && maxWallTime_ != null
              && maxWallTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getMaxWallTimeBuilder().mergeFrom(value);
          } else {
            maxWallTime_ = value;
          }
        } else {
          maxWallTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearMaxWallTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxWallTime_ = null;
        if (maxWallTimeBuilder_ != null) {
          maxWallTimeBuilder_.dispose();
          maxWallTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getMaxWallTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMaxWallTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getMaxWallTimeOrBuilder() {
        if (maxWallTimeBuilder_ != null) {
          return maxWallTimeBuilder_.getMessageOrBuilder();
        } else {
          return maxWallTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : maxWallTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Max wall clock timestamp of all data points within a
       * TensorboardTimeSeries.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp max_wall_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getMaxWallTimeFieldBuilder() {
        if (maxWallTimeBuilder_ == null) {
          maxWallTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getMaxWallTime(), getParentForChildren(), isClean());
          maxWallTime_ = null;
        }
        return maxWallTimeBuilder_;
      }

      private long maxBlobSequenceLength_;
      /**
       *
       *
       * <pre>
       * Output only. The largest blob sequence length (number of blobs) of all
       * data points in this time series, if its ValueType is BLOB_SEQUENCE.
       * </pre>
       *
       * <code>int64 max_blob_sequence_length = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The maxBlobSequenceLength.
       */
      @java.lang.Override
      public long getMaxBlobSequenceLength() {
        return maxBlobSequenceLength_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The largest blob sequence length (number of blobs) of all
       * data points in this time series, if its ValueType is BLOB_SEQUENCE.
       * </pre>
       *
       * <code>int64 max_blob_sequence_length = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The maxBlobSequenceLength to set.
       * @return This builder for chaining.
       */
      public Builder setMaxBlobSequenceLength(long value) {

        maxBlobSequenceLength_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The largest blob sequence length (number of blobs) of all
       * data points in this time series, if its ValueType is BLOB_SEQUENCE.
       * </pre>
       *
       * <code>int64 max_blob_sequence_length = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxBlobSequenceLength() {
        bitField0_ = (bitField0_ & ~0x00000004);
        maxBlobSequenceLength_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata)
    private static final com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata();
    }

    public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metadata> PARSER =
        new com.google.protobuf.AbstractParser<Metadata>() {
          @java.lang.Override
          public Metadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the TensorboardTimeSeries.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the TensorboardTimeSeries.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. User provided name of this TensorboardTimeSeries.
   * This value should be unique among all TensorboardTimeSeries resources
   * belonging to the same TensorboardRun resource (parent resource).
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. User provided name of this TensorboardTimeSeries.
   * This value should be unique among all TensorboardTimeSeries resources
   * belonging to the same TensorboardRun resource (parent resource).
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of this TensorboardTimeSeries.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of this TensorboardTimeSeries.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_TYPE_FIELD_NUMBER = 4;
  private int valueType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Immutable. Type of TensorboardTimeSeries value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for valueType.
   */
  @java.lang.Override
  public int getValueTypeValue() {
    return valueType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Type of TensorboardTimeSeries value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The valueType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType getValueType() {
    com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType result =
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.forNumber(valueType_);
    return result == null
        ? com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this TensorboardTimeSeries was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this TensorboardTimeSeries was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this TensorboardTimeSeries was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this TensorboardTimeSeries was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this TensorboardTimeSeries was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this TensorboardTimeSeries was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Used to perform a consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 7;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform a consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 7;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PLUGIN_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pluginName_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Name of the plugin this time series pertain to. Such as Scalar,
   * Tensor, Blob
   * </pre>
   *
   * <code>string plugin_name = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The pluginName.
   */
  @java.lang.Override
  public java.lang.String getPluginName() {
    java.lang.Object ref = pluginName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pluginName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Name of the plugin this time series pertain to. Such as Scalar,
   * Tensor, Blob
   * </pre>
   *
   * <code>string plugin_name = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for pluginName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPluginNameBytes() {
    java.lang.Object ref = pluginName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pluginName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PLUGIN_DATA_FIELD_NUMBER = 9;
  private com.google.protobuf.ByteString pluginData_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Data of the current plugin, with the size limited to 65KB.
   * </pre>
   *
   * <code>bytes plugin_data = 9;</code>
   *
   * @return The pluginData.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPluginData() {
    return pluginData_;
  }

  public static final int METADATA_FIELD_NUMBER = 10;
  private com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata_;
  /**
   *
   *
   * <pre>
   * Output only. Scalar, Tensor, or Blob metadata for this
   * TensorboardTimeSeries.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Scalar, Tensor, or Blob metadata for this
   * TensorboardTimeSeries.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Scalar, Tensor, or Blob metadata for this
   * TensorboardTimeSeries.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.MetadataOrBuilder
      getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.getDefaultInstance()
        : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (valueType_
        != com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.VALUE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, valueType_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pluginName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, pluginName_);
    }
    if (!pluginData_.isEmpty()) {
      output.writeBytes(9, pluginData_);
    }
    if (metadata_ != null) {
      output.writeMessage(10, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (valueType_
        != com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.VALUE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, valueType_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pluginName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, pluginName_);
    }
    if (!pluginData_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(9, pluginData_);
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.TensorboardTimeSeries)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.TensorboardTimeSeries other =
        (com.google.cloud.aiplatform.v1.TensorboardTimeSeries) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (valueType_ != other.valueType_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getPluginName().equals(other.getPluginName())) return false;
    if (!getPluginData().equals(other.getPluginData())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + valueType_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + PLUGIN_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getPluginName().hashCode();
    hash = (37 * hash) + PLUGIN_DATA_FIELD_NUMBER;
    hash = (53 * hash) + getPluginData().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.TensorboardTimeSeries prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * TensorboardTimeSeries maps to times series produced in training runs
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.TensorboardTimeSeries}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.TensorboardTimeSeries)
      com.google.cloud.aiplatform.v1.TensorboardTimeSeriesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
          .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
          .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.TensorboardTimeSeries.class,
              com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.TensorboardTimeSeries.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      valueType_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      pluginName_ = "";
      pluginData_ = com.google.protobuf.ByteString.EMPTY;
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.TensorboardTimeSeriesProto
          .internal_static_google_cloud_aiplatform_v1_TensorboardTimeSeries_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.TensorboardTimeSeries.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries build() {
      com.google.cloud.aiplatform.v1.TensorboardTimeSeries result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries buildPartial() {
      com.google.cloud.aiplatform.v1.TensorboardTimeSeries result =
          new com.google.cloud.aiplatform.v1.TensorboardTimeSeries(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.TensorboardTimeSeries result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.valueType_ = valueType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.pluginName_ = pluginName_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.pluginData_ = pluginData_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.TensorboardTimeSeries) {
        return mergeFrom((com.google.cloud.aiplatform.v1.TensorboardTimeSeries) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.TensorboardTimeSeries other) {
      if (other == com.google.cloud.aiplatform.v1.TensorboardTimeSeries.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.valueType_ != 0) {
        setValueTypeValue(other.getValueTypeValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getPluginName().isEmpty()) {
        pluginName_ = other.pluginName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getPluginData() != com.google.protobuf.ByteString.EMPTY) {
        setPluginData(other.getPluginData());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                valueType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                pluginName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                pluginData_ = input.readBytes();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the TensorboardTimeSeries.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the TensorboardTimeSeries.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the TensorboardTimeSeries.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the TensorboardTimeSeries.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the TensorboardTimeSeries.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. User provided name of this TensorboardTimeSeries.
     * This value should be unique among all TensorboardTimeSeries resources
     * belonging to the same TensorboardRun resource (parent resource).
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User provided name of this TensorboardTimeSeries.
     * This value should be unique among all TensorboardTimeSeries resources
     * belonging to the same TensorboardRun resource (parent resource).
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User provided name of this TensorboardTimeSeries.
     * This value should be unique among all TensorboardTimeSeries resources
     * belonging to the same TensorboardRun resource (parent resource).
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User provided name of this TensorboardTimeSeries.
     * This value should be unique among all TensorboardTimeSeries resources
     * belonging to the same TensorboardRun resource (parent resource).
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User provided name of this TensorboardTimeSeries.
     * This value should be unique among all TensorboardTimeSeries resources
     * belonging to the same TensorboardRun resource (parent resource).
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of this TensorboardTimeSeries.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of this TensorboardTimeSeries.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of this TensorboardTimeSeries.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of this TensorboardTimeSeries.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of this TensorboardTimeSeries.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int valueType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of TensorboardTimeSeries value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    @java.lang.Override
    public int getValueTypeValue() {
      return valueType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of TensorboardTimeSeries value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueTypeValue(int value) {
      valueType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of TensorboardTimeSeries value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType getValueType() {
      com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType result =
          com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.forNumber(valueType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of TensorboardTimeSeries value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueType(
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      valueType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Type of TensorboardTimeSeries value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      valueType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this TensorboardTimeSeries was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object pluginName_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Name of the plugin this time series pertain to. Such as Scalar,
     * Tensor, Blob
     * </pre>
     *
     * <code>string plugin_name = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The pluginName.
     */
    public java.lang.String getPluginName() {
      java.lang.Object ref = pluginName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pluginName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the plugin this time series pertain to. Such as Scalar,
     * Tensor, Blob
     * </pre>
     *
     * <code>string plugin_name = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for pluginName.
     */
    public com.google.protobuf.ByteString getPluginNameBytes() {
      java.lang.Object ref = pluginName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pluginName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the plugin this time series pertain to. Such as Scalar,
     * Tensor, Blob
     * </pre>
     *
     * <code>string plugin_name = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The pluginName to set.
     * @return This builder for chaining.
     */
    public Builder setPluginName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pluginName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the plugin this time series pertain to. Such as Scalar,
     * Tensor, Blob
     * </pre>
     *
     * <code>string plugin_name = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPluginName() {
      pluginName_ = getDefaultInstance().getPluginName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the plugin this time series pertain to. Such as Scalar,
     * Tensor, Blob
     * </pre>
     *
     * <code>string plugin_name = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for pluginName to set.
     * @return This builder for chaining.
     */
    public Builder setPluginNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pluginName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString pluginData_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Data of the current plugin, with the size limited to 65KB.
     * </pre>
     *
     * <code>bytes plugin_data = 9;</code>
     *
     * @return The pluginData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPluginData() {
      return pluginData_;
    }
    /**
     *
     *
     * <pre>
     * Data of the current plugin, with the size limited to 65KB.
     * </pre>
     *
     * <code>bytes plugin_data = 9;</code>
     *
     * @param value The pluginData to set.
     * @return This builder for chaining.
     */
    public Builder setPluginData(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pluginData_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data of the current plugin, with the size limited to 65KB.
     * </pre>
     *
     * <code>bytes plugin_data = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPluginData() {
      bitField0_ = (bitField0_ & ~0x00000100);
      pluginData_ = getDefaultInstance().getPluginData();
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata,
            com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.Builder,
            com.google.cloud.aiplatform.v1.TensorboardTimeSeries.MetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metadata.
     */
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadata(
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetadata(
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMetadata(
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && metadata_ != null
            && metadata_
                != com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata
                    .getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000200);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.Builder
        getMetadataBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.MetadataOrBuilder
        getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Scalar, Tensor, or Blob metadata for this
     * TensorboardTimeSeries.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata,
            com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.Builder,
            com.google.cloud.aiplatform.v1.TensorboardTimeSeries.MetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata,
                com.google.cloud.aiplatform.v1.TensorboardTimeSeries.Metadata.Builder,
                com.google.cloud.aiplatform.v1.TensorboardTimeSeries.MetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.TensorboardTimeSeries)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.TensorboardTimeSeries)
  private static final com.google.cloud.aiplatform.v1.TensorboardTimeSeries DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.TensorboardTimeSeries();
  }

  public static com.google.cloud.aiplatform.v1.TensorboardTimeSeries getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TensorboardTimeSeries> PARSER =
      new com.google.protobuf.AbstractParser<TensorboardTimeSeries>() {
        @java.lang.Override
        public TensorboardTimeSeries parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TensorboardTimeSeries> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TensorboardTimeSeries> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardTimeSeries getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
