/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Probe describes a health check to be performed against a container to
 * determine whether it is alive or ready to receive traffic.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Probe}
 */
public final class Probe extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Probe)
    ProbeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Probe.newBuilder() to construct.
  private Probe(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Probe() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Probe();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ModelProto
        .internal_static_google_cloud_aiplatform_v1_Probe_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ModelProto
        .internal_static_google_cloud_aiplatform_v1_Probe_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Probe.class,
            com.google.cloud.aiplatform.v1.Probe.Builder.class);
  }

  public interface ExecActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Probe.ExecAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is simply exec'd, it is not run inside a shell, so
     * traditional shell instructions ('|', etc) won't work. To use a shell, you
     * need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     * </pre>
     *
     * <code>repeated string command = 1;</code>
     *
     * @return A list containing the command.
     */
    java.util.List<java.lang.String> getCommandList();
    /**
     *
     *
     * <pre>
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is simply exec'd, it is not run inside a shell, so
     * traditional shell instructions ('|', etc) won't work. To use a shell, you
     * need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     * </pre>
     *
     * <code>repeated string command = 1;</code>
     *
     * @return The count of command.
     */
    int getCommandCount();
    /**
     *
     *
     * <pre>
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is simply exec'd, it is not run inside a shell, so
     * traditional shell instructions ('|', etc) won't work. To use a shell, you
     * need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     * </pre>
     *
     * <code>repeated string command = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The command at the given index.
     */
    java.lang.String getCommand(int index);
    /**
     *
     *
     * <pre>
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is simply exec'd, it is not run inside a shell, so
     * traditional shell instructions ('|', etc) won't work. To use a shell, you
     * need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     * </pre>
     *
     * <code>repeated string command = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the command at the given index.
     */
    com.google.protobuf.ByteString getCommandBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * ExecAction specifies a command to execute.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Probe.ExecAction}
   */
  public static final class ExecAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Probe.ExecAction)
      ExecActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExecAction.newBuilder() to construct.
    private ExecAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExecAction() {
      command_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExecAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Probe_ExecAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Probe_ExecAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Probe.ExecAction.class,
              com.google.cloud.aiplatform.v1.Probe.ExecAction.Builder.class);
    }

    public static final int COMMAND_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList command_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is simply exec'd, it is not run inside a shell, so
     * traditional shell instructions ('|', etc) won't work. To use a shell, you
     * need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     * </pre>
     *
     * <code>repeated string command = 1;</code>
     *
     * @return A list containing the command.
     */
    public com.google.protobuf.ProtocolStringList getCommandList() {
      return command_;
    }
    /**
     *
     *
     * <pre>
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is simply exec'd, it is not run inside a shell, so
     * traditional shell instructions ('|', etc) won't work. To use a shell, you
     * need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     * </pre>
     *
     * <code>repeated string command = 1;</code>
     *
     * @return The count of command.
     */
    public int getCommandCount() {
      return command_.size();
    }
    /**
     *
     *
     * <pre>
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is simply exec'd, it is not run inside a shell, so
     * traditional shell instructions ('|', etc) won't work. To use a shell, you
     * need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     * </pre>
     *
     * <code>repeated string command = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The command at the given index.
     */
    public java.lang.String getCommand(int index) {
      return command_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Command is the command line to execute inside the container, the working
     * directory for the command is root ('/') in the container's filesystem.
     * The command is simply exec'd, it is not run inside a shell, so
     * traditional shell instructions ('|', etc) won't work. To use a shell, you
     * need to explicitly call out to that shell. Exit status of 0 is treated as
     * live/healthy and non-zero is unhealthy.
     * </pre>
     *
     * <code>repeated string command = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the command at the given index.
     */
    public com.google.protobuf.ByteString getCommandBytes(int index) {
      return command_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < command_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, command_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < command_.size(); i++) {
          dataSize += computeStringSizeNoTag(command_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCommandList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Probe.ExecAction)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Probe.ExecAction other =
          (com.google.cloud.aiplatform.v1.Probe.ExecAction) obj;

      if (!getCommandList().equals(other.getCommandList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getCommandCount() > 0) {
        hash = (37 * hash) + COMMAND_FIELD_NUMBER;
        hash = (53 * hash) + getCommandList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.aiplatform.v1.Probe.ExecAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ExecAction specifies a command to execute.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Probe.ExecAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Probe.ExecAction)
        com.google.cloud.aiplatform.v1.Probe.ExecActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Probe_ExecAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Probe_ExecAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Probe.ExecAction.class,
                com.google.cloud.aiplatform.v1.Probe.ExecAction.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Probe.ExecAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        command_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Probe_ExecAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Probe.ExecAction getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Probe.ExecAction build() {
        com.google.cloud.aiplatform.v1.Probe.ExecAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Probe.ExecAction buildPartial() {
        com.google.cloud.aiplatform.v1.Probe.ExecAction result =
            new com.google.cloud.aiplatform.v1.Probe.ExecAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Probe.ExecAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          command_.makeImmutable();
          result.command_ = command_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Probe.ExecAction) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Probe.ExecAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Probe.ExecAction other) {
        if (other == com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance())
          return this;
        if (!other.command_.isEmpty()) {
          if (command_.isEmpty()) {
            command_ = other.command_;
            bitField0_ |= 0x00000001;
          } else {
            ensureCommandIsMutable();
            command_.addAll(other.command_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCommandIsMutable();
                  command_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList command_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCommandIsMutable() {
        if (!command_.isModifiable()) {
          command_ = new com.google.protobuf.LazyStringArrayList(command_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @return A list containing the command.
       */
      public com.google.protobuf.ProtocolStringList getCommandList() {
        command_.makeImmutable();
        return command_;
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @return The count of command.
       */
      public int getCommandCount() {
        return command_.size();
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The command at the given index.
       */
      public java.lang.String getCommand(int index) {
        return command_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the command at the given index.
       */
      public com.google.protobuf.ByteString getCommandBytes(int index) {
        return command_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The command to set.
       * @return This builder for chaining.
       */
      public Builder setCommand(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommandIsMutable();
        command_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @param value The command to add.
       * @return This builder for chaining.
       */
      public Builder addCommand(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommandIsMutable();
        command_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @param values The command to add.
       * @return This builder for chaining.
       */
      public Builder addAllCommand(java.lang.Iterable<java.lang.String> values) {
        ensureCommandIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, command_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCommand() {
        command_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Command is the command line to execute inside the container, the working
       * directory for the command is root ('/') in the container's filesystem.
       * The command is simply exec'd, it is not run inside a shell, so
       * traditional shell instructions ('|', etc) won't work. To use a shell, you
       * need to explicitly call out to that shell. Exit status of 0 is treated as
       * live/healthy and non-zero is unhealthy.
       * </pre>
       *
       * <code>repeated string command = 1;</code>
       *
       * @param value The bytes of the command to add.
       * @return This builder for chaining.
       */
      public Builder addCommandBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCommandIsMutable();
        command_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Probe.ExecAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Probe.ExecAction)
    private static final com.google.cloud.aiplatform.v1.Probe.ExecAction DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Probe.ExecAction();
    }

    public static com.google.cloud.aiplatform.v1.Probe.ExecAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExecAction> PARSER =
        new com.google.protobuf.AbstractParser<ExecAction>() {
          @java.lang.Override
          public ExecAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExecAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExecAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Probe.ExecAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int probeTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object probeType_;

  public enum ProbeTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXEC(1),
    PROBETYPE_NOT_SET(0);
    private final int value;

    private ProbeTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProbeTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ProbeTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return EXEC;
        case 0:
          return PROBETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ProbeTypeCase getProbeTypeCase() {
    return ProbeTypeCase.forNumber(probeTypeCase_);
  }

  public static final int EXEC_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Exec specifies the action to take.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
   *
   * @return Whether the exec field is set.
   */
  @java.lang.Override
  public boolean hasExec() {
    return probeTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Exec specifies the action to take.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
   *
   * @return The exec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Probe.ExecAction getExec() {
    if (probeTypeCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.Probe.ExecAction) probeType_;
    }
    return com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Exec specifies the action to take.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Probe.ExecActionOrBuilder getExecOrBuilder() {
    if (probeTypeCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.Probe.ExecAction) probeType_;
    }
    return com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance();
  }

  public static final int PERIOD_SECONDS_FIELD_NUMBER = 2;
  private int periodSeconds_ = 0;
  /**
   *
   *
   * <pre>
   * How often (in seconds) to perform the probe. Default to 10 seconds.
   * Minimum value is 1. Must be less than timeout_seconds.
   *
   * Maps to Kubernetes probe argument 'periodSeconds'.
   * </pre>
   *
   * <code>int32 period_seconds = 2;</code>
   *
   * @return The periodSeconds.
   */
  @java.lang.Override
  public int getPeriodSeconds() {
    return periodSeconds_;
  }

  public static final int TIMEOUT_SECONDS_FIELD_NUMBER = 3;
  private int timeoutSeconds_ = 0;
  /**
   *
   *
   * <pre>
   * Number of seconds after which the probe times out. Defaults to 1 second.
   * Minimum value is 1. Must be greater or equal to period_seconds.
   *
   * Maps to Kubernetes probe argument 'timeoutSeconds'.
   * </pre>
   *
   * <code>int32 timeout_seconds = 3;</code>
   *
   * @return The timeoutSeconds.
   */
  @java.lang.Override
  public int getTimeoutSeconds() {
    return timeoutSeconds_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (probeTypeCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.aiplatform.v1.Probe.ExecAction) probeType_);
    }
    if (periodSeconds_ != 0) {
      output.writeInt32(2, periodSeconds_);
    }
    if (timeoutSeconds_ != 0) {
      output.writeInt32(3, timeoutSeconds_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (probeTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1.Probe.ExecAction) probeType_);
    }
    if (periodSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, periodSeconds_);
    }
    if (timeoutSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, timeoutSeconds_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Probe)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Probe other = (com.google.cloud.aiplatform.v1.Probe) obj;

    if (getPeriodSeconds() != other.getPeriodSeconds()) return false;
    if (getTimeoutSeconds() != other.getTimeoutSeconds()) return false;
    if (!getProbeTypeCase().equals(other.getProbeTypeCase())) return false;
    switch (probeTypeCase_) {
      case 1:
        if (!getExec().equals(other.getExec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PERIOD_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getPeriodSeconds();
    hash = (37 * hash) + TIMEOUT_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getTimeoutSeconds();
    switch (probeTypeCase_) {
      case 1:
        hash = (37 * hash) + EXEC_FIELD_NUMBER;
        hash = (53 * hash) + getExec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Probe parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Probe prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Probe describes a health check to be performed against a container to
   * determine whether it is alive or ready to receive traffic.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Probe}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Probe)
      com.google.cloud.aiplatform.v1.ProbeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Probe_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Probe_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Probe.class,
              com.google.cloud.aiplatform.v1.Probe.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Probe.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (execBuilder_ != null) {
        execBuilder_.clear();
      }
      periodSeconds_ = 0;
      timeoutSeconds_ = 0;
      probeTypeCase_ = 0;
      probeType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Probe_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Probe getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Probe.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Probe build() {
      com.google.cloud.aiplatform.v1.Probe result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Probe buildPartial() {
      com.google.cloud.aiplatform.v1.Probe result = new com.google.cloud.aiplatform.v1.Probe(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Probe result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.periodSeconds_ = periodSeconds_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.timeoutSeconds_ = timeoutSeconds_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.Probe result) {
      result.probeTypeCase_ = probeTypeCase_;
      result.probeType_ = this.probeType_;
      if (probeTypeCase_ == 1 && execBuilder_ != null) {
        result.probeType_ = execBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Probe) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Probe) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Probe other) {
      if (other == com.google.cloud.aiplatform.v1.Probe.getDefaultInstance()) return this;
      if (other.getPeriodSeconds() != 0) {
        setPeriodSeconds(other.getPeriodSeconds());
      }
      if (other.getTimeoutSeconds() != 0) {
        setTimeoutSeconds(other.getTimeoutSeconds());
      }
      switch (other.getProbeTypeCase()) {
        case EXEC:
          {
            mergeExec(other.getExec());
            break;
          }
        case PROBETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getExecFieldBuilder().getBuilder(), extensionRegistry);
                probeTypeCase_ = 1;
                break;
              } // case 10
            case 16:
              {
                periodSeconds_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                timeoutSeconds_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int probeTypeCase_ = 0;
    private java.lang.Object probeType_;

    public ProbeTypeCase getProbeTypeCase() {
      return ProbeTypeCase.forNumber(probeTypeCase_);
    }

    public Builder clearProbeType() {
      probeTypeCase_ = 0;
      probeType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Probe.ExecAction,
            com.google.cloud.aiplatform.v1.Probe.ExecAction.Builder,
            com.google.cloud.aiplatform.v1.Probe.ExecActionOrBuilder>
        execBuilder_;
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     *
     * @return Whether the exec field is set.
     */
    @java.lang.Override
    public boolean hasExec() {
      return probeTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     *
     * @return The exec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Probe.ExecAction getExec() {
      if (execBuilder_ == null) {
        if (probeTypeCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.Probe.ExecAction) probeType_;
        }
        return com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance();
      } else {
        if (probeTypeCase_ == 1) {
          return execBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     */
    public Builder setExec(com.google.cloud.aiplatform.v1.Probe.ExecAction value) {
      if (execBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        probeType_ = value;
        onChanged();
      } else {
        execBuilder_.setMessage(value);
      }
      probeTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     */
    public Builder setExec(
        com.google.cloud.aiplatform.v1.Probe.ExecAction.Builder builderForValue) {
      if (execBuilder_ == null) {
        probeType_ = builderForValue.build();
        onChanged();
      } else {
        execBuilder_.setMessage(builderForValue.build());
      }
      probeTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     */
    public Builder mergeExec(com.google.cloud.aiplatform.v1.Probe.ExecAction value) {
      if (execBuilder_ == null) {
        if (probeTypeCase_ == 1
            && probeType_ != com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance()) {
          probeType_ =
              com.google.cloud.aiplatform.v1.Probe.ExecAction.newBuilder(
                      (com.google.cloud.aiplatform.v1.Probe.ExecAction) probeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          probeType_ = value;
        }
        onChanged();
      } else {
        if (probeTypeCase_ == 1) {
          execBuilder_.mergeFrom(value);
        } else {
          execBuilder_.setMessage(value);
        }
      }
      probeTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     */
    public Builder clearExec() {
      if (execBuilder_ == null) {
        if (probeTypeCase_ == 1) {
          probeTypeCase_ = 0;
          probeType_ = null;
          onChanged();
        }
      } else {
        if (probeTypeCase_ == 1) {
          probeTypeCase_ = 0;
          probeType_ = null;
        }
        execBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Probe.ExecAction.Builder getExecBuilder() {
      return getExecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Probe.ExecActionOrBuilder getExecOrBuilder() {
      if ((probeTypeCase_ == 1) && (execBuilder_ != null)) {
        return execBuilder_.getMessageOrBuilder();
      } else {
        if (probeTypeCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.Probe.ExecAction) probeType_;
        }
        return com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Exec specifies the action to take.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Probe.ExecAction exec = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Probe.ExecAction,
            com.google.cloud.aiplatform.v1.Probe.ExecAction.Builder,
            com.google.cloud.aiplatform.v1.Probe.ExecActionOrBuilder>
        getExecFieldBuilder() {
      if (execBuilder_ == null) {
        if (!(probeTypeCase_ == 1)) {
          probeType_ = com.google.cloud.aiplatform.v1.Probe.ExecAction.getDefaultInstance();
        }
        execBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Probe.ExecAction,
                com.google.cloud.aiplatform.v1.Probe.ExecAction.Builder,
                com.google.cloud.aiplatform.v1.Probe.ExecActionOrBuilder>(
                (com.google.cloud.aiplatform.v1.Probe.ExecAction) probeType_,
                getParentForChildren(),
                isClean());
        probeType_ = null;
      }
      probeTypeCase_ = 1;
      onChanged();
      return execBuilder_;
    }

    private int periodSeconds_;
    /**
     *
     *
     * <pre>
     * How often (in seconds) to perform the probe. Default to 10 seconds.
     * Minimum value is 1. Must be less than timeout_seconds.
     *
     * Maps to Kubernetes probe argument 'periodSeconds'.
     * </pre>
     *
     * <code>int32 period_seconds = 2;</code>
     *
     * @return The periodSeconds.
     */
    @java.lang.Override
    public int getPeriodSeconds() {
      return periodSeconds_;
    }
    /**
     *
     *
     * <pre>
     * How often (in seconds) to perform the probe. Default to 10 seconds.
     * Minimum value is 1. Must be less than timeout_seconds.
     *
     * Maps to Kubernetes probe argument 'periodSeconds'.
     * </pre>
     *
     * <code>int32 period_seconds = 2;</code>
     *
     * @param value The periodSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setPeriodSeconds(int value) {

      periodSeconds_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How often (in seconds) to perform the probe. Default to 10 seconds.
     * Minimum value is 1. Must be less than timeout_seconds.
     *
     * Maps to Kubernetes probe argument 'periodSeconds'.
     * </pre>
     *
     * <code>int32 period_seconds = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeriodSeconds() {
      bitField0_ = (bitField0_ & ~0x00000002);
      periodSeconds_ = 0;
      onChanged();
      return this;
    }

    private int timeoutSeconds_;
    /**
     *
     *
     * <pre>
     * Number of seconds after which the probe times out. Defaults to 1 second.
     * Minimum value is 1. Must be greater or equal to period_seconds.
     *
     * Maps to Kubernetes probe argument 'timeoutSeconds'.
     * </pre>
     *
     * <code>int32 timeout_seconds = 3;</code>
     *
     * @return The timeoutSeconds.
     */
    @java.lang.Override
    public int getTimeoutSeconds() {
      return timeoutSeconds_;
    }
    /**
     *
     *
     * <pre>
     * Number of seconds after which the probe times out. Defaults to 1 second.
     * Minimum value is 1. Must be greater or equal to period_seconds.
     *
     * Maps to Kubernetes probe argument 'timeoutSeconds'.
     * </pre>
     *
     * <code>int32 timeout_seconds = 3;</code>
     *
     * @param value The timeoutSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setTimeoutSeconds(int value) {

      timeoutSeconds_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of seconds after which the probe times out. Defaults to 1 second.
     * Minimum value is 1. Must be greater or equal to period_seconds.
     *
     * Maps to Kubernetes probe argument 'timeoutSeconds'.
     * </pre>
     *
     * <code>int32 timeout_seconds = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeoutSeconds() {
      bitField0_ = (bitField0_ & ~0x00000004);
      timeoutSeconds_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Probe)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Probe)
  private static final com.google.cloud.aiplatform.v1.Probe DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Probe();
  }

  public static com.google.cloud.aiplatform.v1.Probe getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Probe> PARSER =
      new com.google.protobuf.AbstractParser<Probe>() {
        @java.lang.Override
        public Probe parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Probe> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Probe> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Probe getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
