/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model.proto

package com.google.cloud.aiplatform.v1;

public interface ModelContainerSpecOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ModelContainerSpec)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Immutable. URI of the Docker image to be used as the custom
   * container for serving predictions. This URI must identify an image in
   * Artifact Registry or Container Registry. Learn more about the [container
   * publishing
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
   * including permissions requirements for the Vertex AI Service Agent.
   *
   * The container image is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
   * stored internally, and this original path is afterwards not used.
   *
   * To learn about the requirements for the Docker image itself, see
   * [Custom container
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
   *
   * You can use the URI to one of Vertex AI's [pre-built container images for
   * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
   * in this field.
   * </pre>
   *
   * <code>
   * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The imageUri.
   */
  java.lang.String getImageUri();
  /**
   *
   *
   * <pre>
   * Required. Immutable. URI of the Docker image to be used as the custom
   * container for serving predictions. This URI must identify an image in
   * Artifact Registry or Container Registry. Learn more about the [container
   * publishing
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
   * including permissions requirements for the Vertex AI Service Agent.
   *
   * The container image is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
   * stored internally, and this original path is afterwards not used.
   *
   * To learn about the requirements for the Docker image itself, see
   * [Custom container
   * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
   *
   * You can use the URI to one of Vertex AI's [pre-built container images for
   * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
   * in this field.
   * </pre>
   *
   * <code>
   * string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for imageUri.
   */
  com.google.protobuf.ByteString getImageUriBytes();

  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This
   * overrides the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   *
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] field or the
   * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
   * if either exists. If this field is not specified and the container does not
   * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
   * `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field. You cannot
   * reference environment variables set in the Docker image. In order for
   * environment variables to be expanded, reference them by using the following
   * syntax: &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; Note that this differs
   * from Bash variable expansion, which does not use parentheses. If a variable
   * cannot be resolved, the reference in the input string is used unchanged. To
   * avoid variable expansion, you can escape this syntax with `$$`; for
   * example: &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; This field corresponds
   * to the `command` field of the Kubernetes Containers [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return A list containing the command.
   */
  java.util.List<java.lang.String> getCommandList();
  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This
   * overrides the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   *
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] field or the
   * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
   * if either exists. If this field is not specified and the container does not
   * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
   * `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field. You cannot
   * reference environment variables set in the Docker image. In order for
   * environment variables to be expanded, reference them by using the following
   * syntax: &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; Note that this differs
   * from Bash variable expansion, which does not use parentheses. If a variable
   * cannot be resolved, the reference in the input string is used unchanged. To
   * avoid variable expansion, you can escape this syntax with `$$`; for
   * example: &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; This field corresponds
   * to the `command` field of the Kubernetes Containers [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The count of command.
   */
  int getCommandCount();
  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This
   * overrides the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   *
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] field or the
   * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
   * if either exists. If this field is not specified and the container does not
   * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
   * `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field. You cannot
   * reference environment variables set in the Docker image. In order for
   * environment variables to be expanded, reference them by using the following
   * syntax: &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; Note that this differs
   * from Bash variable expansion, which does not use parentheses. If a variable
   * cannot be resolved, the reference in the input string is used unchanged. To
   * avoid variable expansion, you can escape this syntax with `$$`; for
   * example: &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; This field corresponds
   * to the `command` field of the Kubernetes Containers [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the element to return.
   * @return The command at the given index.
   */
  java.lang.String getCommand(int index);
  /**
   *
   *
   * <pre>
   * Immutable. Specifies the command that runs when the container starts. This
   * overrides the container's
   * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
   * Specify this field as an array of executable and arguments, similar to a
   * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
   *
   * If you do not specify this field, then the container's `ENTRYPOINT` runs,
   * in conjunction with the
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] field or the
   * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
   * if either exists. If this field is not specified and the container does not
   * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
   * `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * If you specify this field, then you can also specify the `args` field to
   * provide additional arguments for this command. However, if you specify this
   * field, then the container's `CMD` is ignored. See the
   * [Kubernetes documentation about how the
   * `command` and `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * In this field, you can reference [environment variables set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field. You cannot
   * reference environment variables set in the Docker image. In order for
   * environment variables to be expanded, reference them by using the following
   * syntax: &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; Note that this differs
   * from Bash variable expansion, which does not use parentheses. If a variable
   * cannot be resolved, the reference in the input string is used unchanged. To
   * avoid variable expansion, you can escape this syntax with `$$`; for
   * example: &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; This field corresponds
   * to the `command` field of the Kubernetes Containers [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the command at the given index.
   */
  com.google.protobuf.ByteString getCommandBytes(int index);

  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container
   * starts. This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   *
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] field,
   * then the command from the `command` field runs without any additional
   * arguments. See the [Kubernetes documentation about how the `command` and
   * `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field. You cannot
   * reference environment variables set in the Docker image. In order for
   * environment variables to be expanded, reference them by using the following
   * syntax: &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; Note that this differs
   * from Bash variable expansion, which does not use parentheses. If a variable
   * cannot be resolved, the reference in the input string is used unchanged. To
   * avoid variable expansion, you can escape this syntax with `$$`; for
   * example: &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; This field corresponds
   * to the `args` field of the Kubernetes Containers [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return A list containing the args.
   */
  java.util.List<java.lang.String> getArgsList();
  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container
   * starts. This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   *
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] field,
   * then the command from the `command` field runs without any additional
   * arguments. See the [Kubernetes documentation about how the `command` and
   * `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field. You cannot
   * reference environment variables set in the Docker image. In order for
   * environment variables to be expanded, reference them by using the following
   * syntax: &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; Note that this differs
   * from Bash variable expansion, which does not use parentheses. If a variable
   * cannot be resolved, the reference in the input string is used unchanged. To
   * avoid variable expansion, you can escape this syntax with `$$`; for
   * example: &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; This field corresponds
   * to the `args` field of the Kubernetes Containers [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The count of args.
   */
  int getArgsCount();
  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container
   * starts. This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   *
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] field,
   * then the command from the `command` field runs without any additional
   * arguments. See the [Kubernetes documentation about how the `command` and
   * `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field. You cannot
   * reference environment variables set in the Docker image. In order for
   * environment variables to be expanded, reference them by using the following
   * syntax: &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; Note that this differs
   * from Bash variable expansion, which does not use parentheses. If a variable
   * cannot be resolved, the reference in the input string is used unchanged. To
   * avoid variable expansion, you can escape this syntax with `$$`; for
   * example: &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; This field corresponds
   * to the `args` field of the Kubernetes Containers [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  java.lang.String getArgs(int index);
  /**
   *
   *
   * <pre>
   * Immutable. Specifies arguments for the command that runs when the container
   * starts. This overrides the container's
   * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
   * this field as an array of executable and arguments, similar to a Docker
   * `CMD`'s "default parameters" form.
   *
   * If you don't specify this field but do specify the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] field,
   * then the command from the `command` field runs without any additional
   * arguments. See the [Kubernetes documentation about how the `command` and
   * `args` fields interact with a container's `ENTRYPOINT` and
   * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
   *
   * If you don't specify this field and don't specify the `command` field,
   * then the container's
   * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
   * `CMD` determine what runs based on their default behavior. See the Docker
   * documentation about [how `CMD` and `ENTRYPOINT`
   * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
   *
   * In this field, you can reference [environment variables
   * set by Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
   * and environment variables set in the
   * [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field. You cannot
   * reference environment variables set in the Docker image. In order for
   * environment variables to be expanded, reference them by using the following
   * syntax: &lt;code&gt;$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; Note that this differs
   * from Bash variable expansion, which does not use parentheses. If a variable
   * cannot be resolved, the reference in the input string is used unchanged. To
   * avoid variable expansion, you can escape this syntax with `$$`; for
   * example: &lt;code&gt;$$(&lt;var&gt;VARIABLE_NAME&lt;/var&gt;)&lt;/code&gt; This field corresponds
   * to the `args` field of the Kubernetes Containers [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  com.google.protobuf.ByteString getArgsBytes(int index);

  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.EnvVar> getEnvList();
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.cloud.aiplatform.v1.EnvVar getEnv(int index);
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  int getEnvCount();
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.EnvVarOrBuilder> getEnvOrBuilderList();
  /**
   *
   *
   * <pre>
   * Immutable. List of environment variables to set in the container. After the
   * container starts running, code running in the container can read these
   * environment variables.
   *
   * Additionally, the
   * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
   * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can
   * reference these variables. Later entries in this list can also reference
   * earlier entries. For example, the following example sets the variable
   * `VAR_2` to have the value `foo bar`:
   *
   * ```json
   * [
   *   {
   *     "name": "VAR_1",
   *     "value": "foo"
   *   },
   *   {
   *     "name": "VAR_2",
   *     "value": "$(VAR_1) bar"
   *   }
   * ]
   * ```
   *
   * If you switch the order of the variables in the example, then the expansion
   * does not occur.
   *
   * This field corresponds to the `env` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.cloud.aiplatform.v1.EnvVarOrBuilder getEnvOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.Port> getPortsList();
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.cloud.aiplatform.v1.Port getPorts(int index);
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  int getPortsCount();
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.PortOrBuilder> getPortsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends any
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends
   * [liveness and health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
   * to this port.
   *
   * If you do not specify this field, it defaults to following value:
   *
   * ```json
   * [
   *   {
   *     "containerPort": 8080
   *   }
   * ]
   * ```
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers
   * [v1 core
   * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.cloud.aiplatform.v1.PortOrBuilder getPortsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send prediction requests to.
   * Vertex AI forwards requests sent using
   * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * to this path on the container's IP address and port. Vertex AI then returns
   * the container's response in the API response.
   *
   * For example, if you set this field to `/foo`, then when Vertex AI
   * receives a prediction request, it forwards the request body in a POST
   * request to the `/foo` path on the port of your container specified by the
   * first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
   *
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an
   * Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   *
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   *
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
   * [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the
   * `DeployedModel`.
   *   (Vertex AI makes this value available to your container code
   *   as the [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The predictRoute.
   */
  java.lang.String getPredictRoute();
  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send prediction requests to.
   * Vertex AI forwards requests sent using
   * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * to this path on the container's IP address and port. Vertex AI then returns
   * the container's response in the API response.
   *
   * For example, if you set this field to `/foo`, then when Vertex AI
   * receives a prediction request, it forwards the request body in a POST
   * request to the `/foo` path on the port of your container specified by the
   * first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
   *
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an
   * Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   *
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   *
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
   * [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the
   * `DeployedModel`.
   *   (Vertex AI makes this value available to your container code
   *   as the [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for predictRoute.
   */
  com.google.protobuf.ByteString getPredictRouteBytes();

  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send health checks to. Vertex AI
   * intermittently sends GET requests to this path on the container's IP
   * address and port to check that the container is healthy. Read more about
   * [health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
   *
   * For example, if you set this field to `/bar`, then Vertex AI
   * intermittently sends a GET request to the `/bar` path on the port of your
   * container specified by the first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
   *
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an
   * Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   *
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   *
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
   * [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the
   * `DeployedModel`.
   *   (Vertex AI makes this value available to your container code as the
   *   [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The healthRoute.
   */
  java.lang.String getHealthRoute();
  /**
   *
   *
   * <pre>
   * Immutable. HTTP path on the container to send health checks to. Vertex AI
   * intermittently sends GET requests to this path on the container's IP
   * address and port to check that the container is healthy. Read more about
   * [health
   * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
   *
   * For example, if you set this field to `/bar`, then Vertex AI
   * intermittently sends a GET request to the `/bar` path on the port of your
   * container specified by the first value of this `ModelContainerSpec`'s
   * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
   *
   * If you don't specify this field, it defaults to the following value when
   * you [deploy this Model to an
   * Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
   * &lt;code&gt;/v1/endpoints/&lt;var&gt;ENDPOINT&lt;/var&gt;/deployedModels/&lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:predict&lt;/code&gt;
   * The placeholders in this value are replaced as follows:
   *
   * * &lt;var&gt;ENDPOINT&lt;/var&gt;: The last segment (following `endpoints/`)of the
   *   Endpoint.name][] field of the Endpoint where this Model has been
   *   deployed. (Vertex AI makes this value available to your container code
   *   as the [`AIP_ENDPOINT_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   *
   * * &lt;var&gt;DEPLOYED_MODEL&lt;/var&gt;:
   * [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the
   * `DeployedModel`.
   *   (Vertex AI makes this value available to your container code as the
   *   [`AIP_DEPLOYED_MODEL_ID` environment
   *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
   * </pre>
   *
   * <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for healthRoute.
   */
  com.google.protobuf.ByteString getHealthRouteBytes();

  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.Port> getGrpcPortsList();
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.cloud.aiplatform.v1.Port getGrpcPorts(int index);
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  int getGrpcPortsCount();
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.PortOrBuilder>
      getGrpcPortsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Immutable. List of ports to expose from the container. Vertex AI sends gRPC
   * prediction requests that it receives to the first port on this list. Vertex
   * AI also sends liveness and health checks to this port.
   *
   * If you do not specify this field, gRPC requests to the container will be
   * disabled.
   *
   * Vertex AI does not use ports other than the first one listed. This field
   * corresponds to the `ports` field of the Kubernetes Containers v1 core API.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Port grpc_ports = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.cloud.aiplatform.v1.PortOrBuilder getGrpcPortsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Immutable. Deployment timeout.
   * Limit for deployment timeout is 2 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the deploymentTimeout field is set.
   */
  boolean hasDeploymentTimeout();
  /**
   *
   *
   * <pre>
   * Immutable. Deployment timeout.
   * Limit for deployment timeout is 2 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The deploymentTimeout.
   */
  com.google.protobuf.Duration getDeploymentTimeout();
  /**
   *
   *
   * <pre>
   * Immutable. Deployment timeout.
   * Limit for deployment timeout is 2 hours.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration deployment_timeout = 10 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.protobuf.DurationOrBuilder getDeploymentTimeoutOrBuilder();

  /**
   *
   *
   * <pre>
   * Immutable. The amount of the VM memory to reserve as the shared memory for
   * the model in megabytes.
   * </pre>
   *
   * <code>int64 shared_memory_size_mb = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The sharedMemorySizeMb.
   */
  long getSharedMemorySizeMb();

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes startup probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the startupProbe field is set.
   */
  boolean hasStartupProbe();
  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes startup probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The startupProbe.
   */
  com.google.cloud.aiplatform.v1.Probe getStartupProbe();
  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes startup probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Probe startup_probe = 12 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ProbeOrBuilder getStartupProbeOrBuilder();

  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes readiness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the healthProbe field is set.
   */
  boolean hasHealthProbe();
  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes readiness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The healthProbe.
   */
  com.google.cloud.aiplatform.v1.Probe getHealthProbe();
  /**
   *
   *
   * <pre>
   * Immutable. Specification for Kubernetes readiness probe.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Probe health_probe = 13 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ProbeOrBuilder getHealthProbeOrBuilder();
}
