/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/explanation.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Explanation of a prediction (provided in
 * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions])
 * produced by the Model on a given
 * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Explanation}
 */
public final class Explanation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Explanation)
    ExplanationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Explanation.newBuilder() to construct.
  private Explanation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Explanation() {
    attributions_ = java.util.Collections.emptyList();
    neighbors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Explanation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1_Explanation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1_Explanation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Explanation.class,
            com.google.cloud.aiplatform.v1.Explanation.Builder.class);
  }

  public static final int ATTRIBUTIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.Attribution> attributions_;
  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][Attributions.instance_output_value] in descending
   * order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Attribution> getAttributionsList() {
    return attributions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][Attributions.instance_output_value] in descending
   * order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.AttributionOrBuilder>
      getAttributionsOrBuilderList() {
    return attributions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][Attributions.instance_output_value] in descending
   * order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getAttributionsCount() {
    return attributions_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][Attributions.instance_output_value] in descending
   * order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Attribution getAttributions(int index) {
    return attributions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Feature attributions grouped by predicted outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * If users set
   * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
   * the attributions are sorted by
   * [instance_output_value][Attributions.instance_output_value] in descending
   * order. If
   * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
   * is specified, the attributions are stored by
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * in the same order as they appear in the output_indices.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.AttributionOrBuilder getAttributionsOrBuilder(int index) {
    return attributions_.get(index);
  }

  public static final int NEIGHBORS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.Neighbor> neighbors_;
  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Neighbor> getNeighborsList() {
    return neighbors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.NeighborOrBuilder>
      getNeighborsOrBuilderList() {
    return neighbors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getNeighborsCount() {
    return neighbors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Neighbor getNeighbors(int index) {
    return neighbors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of the nearest neighbors for example-based explanations.
   *
   * For models deployed with the examples explanations feature enabled, the
   * attributions field is empty and instead the neighbors field is populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NeighborOrBuilder getNeighborsOrBuilder(int index) {
    return neighbors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < attributions_.size(); i++) {
      output.writeMessage(1, attributions_.get(i));
    }
    for (int i = 0; i < neighbors_.size(); i++) {
      output.writeMessage(2, neighbors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < attributions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, attributions_.get(i));
    }
    for (int i = 0; i < neighbors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, neighbors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Explanation)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Explanation other =
        (com.google.cloud.aiplatform.v1.Explanation) obj;

    if (!getAttributionsList().equals(other.getAttributionsList())) return false;
    if (!getNeighborsList().equals(other.getNeighborsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAttributionsCount() > 0) {
      hash = (37 * hash) + ATTRIBUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAttributionsList().hashCode();
    }
    if (getNeighborsCount() > 0) {
      hash = (37 * hash) + NEIGHBORS_FIELD_NUMBER;
      hash = (53 * hash) + getNeighborsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Explanation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Explanation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Explanation of a prediction (provided in
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions])
   * produced by the Model on a given
   * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Explanation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Explanation)
      com.google.cloud.aiplatform.v1.ExplanationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_Explanation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_Explanation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Explanation.class,
              com.google.cloud.aiplatform.v1.Explanation.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Explanation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (attributionsBuilder_ == null) {
        attributions_ = java.util.Collections.emptyList();
      } else {
        attributions_ = null;
        attributionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (neighborsBuilder_ == null) {
        neighbors_ = java.util.Collections.emptyList();
      } else {
        neighbors_ = null;
        neighborsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_Explanation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Explanation getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Explanation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Explanation build() {
      com.google.cloud.aiplatform.v1.Explanation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Explanation buildPartial() {
      com.google.cloud.aiplatform.v1.Explanation result =
          new com.google.cloud.aiplatform.v1.Explanation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.Explanation result) {
      if (attributionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          attributions_ = java.util.Collections.unmodifiableList(attributions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.attributions_ = attributions_;
      } else {
        result.attributions_ = attributionsBuilder_.build();
      }
      if (neighborsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          neighbors_ = java.util.Collections.unmodifiableList(neighbors_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.neighbors_ = neighbors_;
      } else {
        result.neighbors_ = neighborsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Explanation result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Explanation) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Explanation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Explanation other) {
      if (other == com.google.cloud.aiplatform.v1.Explanation.getDefaultInstance()) return this;
      if (attributionsBuilder_ == null) {
        if (!other.attributions_.isEmpty()) {
          if (attributions_.isEmpty()) {
            attributions_ = other.attributions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAttributionsIsMutable();
            attributions_.addAll(other.attributions_);
          }
          onChanged();
        }
      } else {
        if (!other.attributions_.isEmpty()) {
          if (attributionsBuilder_.isEmpty()) {
            attributionsBuilder_.dispose();
            attributionsBuilder_ = null;
            attributions_ = other.attributions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            attributionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttributionsFieldBuilder()
                    : null;
          } else {
            attributionsBuilder_.addAllMessages(other.attributions_);
          }
        }
      }
      if (neighborsBuilder_ == null) {
        if (!other.neighbors_.isEmpty()) {
          if (neighbors_.isEmpty()) {
            neighbors_ = other.neighbors_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureNeighborsIsMutable();
            neighbors_.addAll(other.neighbors_);
          }
          onChanged();
        }
      } else {
        if (!other.neighbors_.isEmpty()) {
          if (neighborsBuilder_.isEmpty()) {
            neighborsBuilder_.dispose();
            neighborsBuilder_ = null;
            neighbors_ = other.neighbors_;
            bitField0_ = (bitField0_ & ~0x00000002);
            neighborsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNeighborsFieldBuilder()
                    : null;
          } else {
            neighborsBuilder_.addAllMessages(other.neighbors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1.Attribution m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.Attribution.parser(), extensionRegistry);
                if (attributionsBuilder_ == null) {
                  ensureAttributionsIsMutable();
                  attributions_.add(m);
                } else {
                  attributionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1.Neighbor m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.Neighbor.parser(), extensionRegistry);
                if (neighborsBuilder_ == null) {
                  ensureNeighborsIsMutable();
                  neighbors_.add(m);
                } else {
                  neighborsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1.Attribution> attributions_ =
        java.util.Collections.emptyList();

    private void ensureAttributionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        attributions_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.Attribution>(attributions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Attribution,
            com.google.cloud.aiplatform.v1.Attribution.Builder,
            com.google.cloud.aiplatform.v1.AttributionOrBuilder>
        attributionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Attribution> getAttributionsList() {
      if (attributionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attributions_);
      } else {
        return attributionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getAttributionsCount() {
      if (attributionsBuilder_ == null) {
        return attributions_.size();
      } else {
        return attributionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Attribution getAttributions(int index) {
      if (attributionsBuilder_ == null) {
        return attributions_.get(index);
      } else {
        return attributionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttributions(int index, com.google.cloud.aiplatform.v1.Attribution value) {
      if (attributionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributionsIsMutable();
        attributions_.set(index, value);
        onChanged();
      } else {
        attributionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttributions(
        int index, com.google.cloud.aiplatform.v1.Attribution.Builder builderForValue) {
      if (attributionsBuilder_ == null) {
        ensureAttributionsIsMutable();
        attributions_.set(index, builderForValue.build());
        onChanged();
      } else {
        attributionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttributions(com.google.cloud.aiplatform.v1.Attribution value) {
      if (attributionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributionsIsMutable();
        attributions_.add(value);
        onChanged();
      } else {
        attributionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttributions(int index, com.google.cloud.aiplatform.v1.Attribution value) {
      if (attributionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributionsIsMutable();
        attributions_.add(index, value);
        onChanged();
      } else {
        attributionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttributions(
        com.google.cloud.aiplatform.v1.Attribution.Builder builderForValue) {
      if (attributionsBuilder_ == null) {
        ensureAttributionsIsMutable();
        attributions_.add(builderForValue.build());
        onChanged();
      } else {
        attributionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAttributions(
        int index, com.google.cloud.aiplatform.v1.Attribution.Builder builderForValue) {
      if (attributionsBuilder_ == null) {
        ensureAttributionsIsMutable();
        attributions_.add(index, builderForValue.build());
        onChanged();
      } else {
        attributionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllAttributions(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Attribution> values) {
      if (attributionsBuilder_ == null) {
        ensureAttributionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attributions_);
        onChanged();
      } else {
        attributionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAttributions() {
      if (attributionsBuilder_ == null) {
        attributions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        attributionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeAttributions(int index) {
      if (attributionsBuilder_ == null) {
        ensureAttributionsIsMutable();
        attributions_.remove(index);
        onChanged();
      } else {
        attributionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Attribution.Builder getAttributionsBuilder(int index) {
      return getAttributionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.AttributionOrBuilder getAttributionsOrBuilder(int index) {
      if (attributionsBuilder_ == null) {
        return attributions_.get(index);
      } else {
        return attributionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.AttributionOrBuilder>
        getAttributionsOrBuilderList() {
      if (attributionsBuilder_ != null) {
        return attributionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attributions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Attribution.Builder addAttributionsBuilder() {
      return getAttributionsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Attribution.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Attribution.Builder addAttributionsBuilder(int index) {
      return getAttributionsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Attribution.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Feature attributions grouped by predicted outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * If users set
     * [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
     * the attributions are sorted by
     * [instance_output_value][Attributions.instance_output_value] in descending
     * order. If
     * [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
     * is specified, the attributions are stored by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * in the same order as they appear in the output_indices.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Attribution attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Attribution.Builder>
        getAttributionsBuilderList() {
      return getAttributionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Attribution,
            com.google.cloud.aiplatform.v1.Attribution.Builder,
            com.google.cloud.aiplatform.v1.AttributionOrBuilder>
        getAttributionsFieldBuilder() {
      if (attributionsBuilder_ == null) {
        attributionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Attribution,
                com.google.cloud.aiplatform.v1.Attribution.Builder,
                com.google.cloud.aiplatform.v1.AttributionOrBuilder>(
                attributions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        attributions_ = null;
      }
      return attributionsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.Neighbor> neighbors_ =
        java.util.Collections.emptyList();

    private void ensureNeighborsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        neighbors_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.Neighbor>(neighbors_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Neighbor,
            com.google.cloud.aiplatform.v1.Neighbor.Builder,
            com.google.cloud.aiplatform.v1.NeighborOrBuilder>
        neighborsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Neighbor> getNeighborsList() {
      if (neighborsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(neighbors_);
      } else {
        return neighborsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getNeighborsCount() {
      if (neighborsBuilder_ == null) {
        return neighbors_.size();
      } else {
        return neighborsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Neighbor getNeighbors(int index) {
      if (neighborsBuilder_ == null) {
        return neighbors_.get(index);
      } else {
        return neighborsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNeighbors(int index, com.google.cloud.aiplatform.v1.Neighbor value) {
      if (neighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNeighborsIsMutable();
        neighbors_.set(index, value);
        onChanged();
      } else {
        neighborsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNeighbors(
        int index, com.google.cloud.aiplatform.v1.Neighbor.Builder builderForValue) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        neighbors_.set(index, builderForValue.build());
        onChanged();
      } else {
        neighborsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addNeighbors(com.google.cloud.aiplatform.v1.Neighbor value) {
      if (neighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNeighborsIsMutable();
        neighbors_.add(value);
        onChanged();
      } else {
        neighborsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addNeighbors(int index, com.google.cloud.aiplatform.v1.Neighbor value) {
      if (neighborsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNeighborsIsMutable();
        neighbors_.add(index, value);
        onChanged();
      } else {
        neighborsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addNeighbors(com.google.cloud.aiplatform.v1.Neighbor.Builder builderForValue) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        neighbors_.add(builderForValue.build());
        onChanged();
      } else {
        neighborsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addNeighbors(
        int index, com.google.cloud.aiplatform.v1.Neighbor.Builder builderForValue) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        neighbors_.add(index, builderForValue.build());
        onChanged();
      } else {
        neighborsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllNeighbors(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Neighbor> values) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, neighbors_);
        onChanged();
      } else {
        neighborsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNeighbors() {
      if (neighborsBuilder_ == null) {
        neighbors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        neighborsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeNeighbors(int index) {
      if (neighborsBuilder_ == null) {
        ensureNeighborsIsMutable();
        neighbors_.remove(index);
        onChanged();
      } else {
        neighborsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Neighbor.Builder getNeighborsBuilder(int index) {
      return getNeighborsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NeighborOrBuilder getNeighborsOrBuilder(int index) {
      if (neighborsBuilder_ == null) {
        return neighbors_.get(index);
      } else {
        return neighborsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.NeighborOrBuilder>
        getNeighborsOrBuilderList() {
      if (neighborsBuilder_ != null) {
        return neighborsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(neighbors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Neighbor.Builder addNeighborsBuilder() {
      return getNeighborsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Neighbor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Neighbor.Builder addNeighborsBuilder(int index) {
      return getNeighborsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Neighbor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of the nearest neighbors for example-based explanations.
     *
     * For models deployed with the examples explanations feature enabled, the
     * attributions field is empty and instead the neighbors field is populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Neighbor neighbors = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Neighbor.Builder>
        getNeighborsBuilderList() {
      return getNeighborsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Neighbor,
            com.google.cloud.aiplatform.v1.Neighbor.Builder,
            com.google.cloud.aiplatform.v1.NeighborOrBuilder>
        getNeighborsFieldBuilder() {
      if (neighborsBuilder_ == null) {
        neighborsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Neighbor,
                com.google.cloud.aiplatform.v1.Neighbor.Builder,
                com.google.cloud.aiplatform.v1.NeighborOrBuilder>(
                neighbors_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        neighbors_ = null;
      }
      return neighborsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Explanation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Explanation)
  private static final com.google.cloud.aiplatform.v1.Explanation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Explanation();
  }

  public static com.google.cloud.aiplatform.v1.Explanation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Explanation> PARSER =
      new com.google.protobuf.AbstractParser<Explanation>() {
        @java.lang.Override
        public Explanation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Explanation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Explanation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Explanation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
