/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.BundleMerger;
import com.google.api.gax.bundling.BundlingFlowController;
import com.google.api.gax.bundling.BundlingSettings;
import com.google.api.gax.bundling.BundlingThreshold;
import com.google.api.gax.bundling.ElementCounter;
import com.google.api.gax.bundling.NumericThreshold;
import com.google.api.gax.bundling.ThresholdBundler;
import com.google.api.gax.core.FlowControlSettings;
import com.google.api.gax.core.FlowController;
import com.google.api.gax.grpc.Bundle;
import com.google.api.gax.grpc.BundleExecutor;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;

public final class BundlerFactory<RequestT, ResponseT> {
    private final Map<String, ThresholdBundler<Bundle<RequestT, ResponseT>>> bundlers = new ConcurrentHashMap<String, ThresholdBundler<Bundle<RequestT, ResponseT>>>();
    private final ScheduledExecutorService executor;
    private final BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
    private final FlowController flowController;
    private final BundlingSettings bundlingSettings;
    private final Object lock = new Object();

    public BundlerFactory(BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, BundlingSettings bundlingSettings, ScheduledExecutorService executor) {
        this(bundlingDescriptor, bundlingSettings, executor, new FlowController(bundlingSettings.getFlowControlSettings() != null ? bundlingSettings.getFlowControlSettings() : FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build()));
    }

    public BundlerFactory(BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, BundlingSettings bundlingSettings, ScheduledExecutorService executor, FlowController flowController) {
        this.bundlingDescriptor = bundlingDescriptor;
        this.bundlingSettings = bundlingSettings;
        this.executor = executor;
        this.flowController = flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThresholdBundler<Bundle<RequestT, ResponseT>> getPushingBundler(String partitionKey) {
        ThresholdBundler<Bundle<RequestT, ResponseT>> bundler = this.bundlers.get(partitionKey);
        if (bundler == null) {
            Object object = this.lock;
            synchronized (object) {
                bundler = this.bundlers.get(partitionKey);
                if (bundler == null) {
                    bundler = this.createBundler(partitionKey);
                    this.bundlers.put(partitionKey, bundler);
                }
            }
        }
        return bundler;
    }

    BundlingSettings getBundlingSettings() {
        return this.bundlingSettings;
    }

    private ThresholdBundler<Bundle<RequestT, ResponseT>> createBundler(String partitionKey) {
        BundleExecutor<RequestT, ResponseT> processor = new BundleExecutor<RequestT, ResponseT>(this.bundlingDescriptor, partitionKey);
        return ThresholdBundler.newBuilder().setThresholds((Collection<BundlingThreshold<Bundle<RequestT, ResponseT>>>)this.getThresholds(this.bundlingSettings)).setExecutor(this.executor).setMaxDelay(this.bundlingSettings.getDelayThreshold()).setReceiver(processor).setFlowController(this.createBundlingFlowController()).setBundleMerger(this.createBundleMerger()).build();
    }

    private BundlingFlowController<Bundle<RequestT, ResponseT>> createBundlingFlowController() {
        return new BundlingFlowController<Bundle<RequestT, ResponseT>>(this.flowController, new ElementCounter<Bundle<RequestT, ResponseT>>(){

            @Override
            public long count(Bundle<RequestT, ResponseT> bundlablePublish) {
                return BundlerFactory.this.bundlingDescriptor.countElements(bundlablePublish.getRequest());
            }
        }, new ElementCounter<Bundle<RequestT, ResponseT>>(){

            @Override
            public long count(Bundle<RequestT, ResponseT> bundlablePublish) {
                return bundlablePublish.getByteCount();
            }
        });
    }

    private BundleMerger<Bundle<RequestT, ResponseT>> createBundleMerger() {
        return new BundleMerger<Bundle<RequestT, ResponseT>>(){

            @Override
            public void merge(Bundle<RequestT, ResponseT> bundle, Bundle<RequestT, ResponseT> newBundle) {
                bundle.merge(newBundle);
            }
        };
    }

    private ImmutableList<BundlingThreshold<Bundle<RequestT, ResponseT>>> getThresholds(BundlingSettings bundlingSettings) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        if (bundlingSettings.getElementCountThreshold() != null) {
            ElementCounter elementCounter = new ElementCounter<Bundle<RequestT, ResponseT>>(){

                @Override
                public long count(Bundle<RequestT, ResponseT> bundlablePublish) {
                    return BundlerFactory.this.bundlingDescriptor.countElements(bundlablePublish.getRequest());
                }
            };
            NumericThreshold countThreshold = new NumericThreshold(bundlingSettings.getElementCountThreshold(), elementCounter);
            listBuilder.add(countThreshold);
        }
        if (bundlingSettings.getRequestByteThreshold() != null) {
            ElementCounter requestByteCounter = new ElementCounter<Bundle<RequestT, ResponseT>>(){

                @Override
                public long count(Bundle<RequestT, ResponseT> bundlablePublish) {
                    return bundlablePublish.getByteCount();
                }
            };
            NumericThreshold byteThreshold = new NumericThreshold(bundlingSettings.getRequestByteThreshold(), requestByteCounter);
            listBuilder.add(byteThreshold);
        }
        return listBuilder.build();
    }
}

