/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.reflect;

import com.google.ads.googleads.lib.logging.scrub.FieldDescriptorCache;
import com.google.ads.googleads.lib.reflect.ImmutableTreeNode;
import com.google.protobuf.Descriptors;
import java.util.List;
import java.util.Optional;

class ReflectionTraversal {
    private static final FieldDescriptorCache FIELD_DESCRIPTOR_CACHE = FieldDescriptorCache.getDefault();

    ReflectionTraversal() {
    }

    public static <TreeNodeType extends ImmutableTreeNode> void visitFieldPath(TreeNodeType node, List<String> fieldPathElements, Visitor<TreeNodeType> visitor) {
        Object currentNode = node;
        for (int fieldIndex = 0; fieldIndex < fieldPathElements.size(); ++fieldIndex) {
            Descriptors.FieldDescriptor fieldDescriptor = ReflectionTraversal.lookupFieldDescriptor(fieldPathElements, currentNode, fieldIndex);
            if (!fieldDescriptor.isRepeated() && !currentNode.hasField(fieldDescriptor)) {
                return;
            }
            if (fieldIndex == fieldPathElements.size() - 1) {
                if (fieldDescriptor.isRepeated()) {
                    visitor.visitRepeatedField(currentNode, fieldDescriptor);
                } else {
                    visitor.visitUnaryField(currentNode, fieldDescriptor);
                }
                return;
            }
            if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
                throw new IllegalStateException("Unable to access subfield of " + fieldDescriptor + " which is not a Message");
            }
            if (fieldDescriptor.isRepeated()) {
                ReflectionTraversal.recurseIntoRepeatedMessage(currentNode, fieldDescriptor, visitor, fieldPathElements.subList(fieldIndex + 1, fieldPathElements.size()));
                return;
            }
            currentNode = currentNode.getChildNode(fieldDescriptor);
        }
    }

    private static void recurseIntoRepeatedMessage(ImmutableTreeNode currentNode, Descriptors.FieldDescriptor fieldDescriptor, Visitor visitor, List<String> remainingFieldPathElements) {
        int numRepeatedValues = currentNode.getRepeatedFieldCount(fieldDescriptor);
        for (int i = 0; i < numRepeatedValues; ++i) {
            ReflectionTraversal.visitFieldPath(currentNode.getRepeatedMessageNode(fieldDescriptor, i), remainingFieldPathElements, visitor);
        }
    }

    private static Descriptors.FieldDescriptor lookupFieldDescriptor(List<String> fieldPathElements, ImmutableTreeNode currentNode, int fieldIndex) {
        String fieldName = fieldPathElements.get(fieldIndex);
        Optional<Descriptors.FieldDescriptor> fieldDescriptorLookup = FIELD_DESCRIPTOR_CACHE.lookupField(fieldName, currentNode.getMessageOrBuilder());
        if (!fieldDescriptorLookup.isPresent()) {
            throw new IllegalStateException("Unknown field " + fieldName + " in " + currentNode.getClass());
        }
        return fieldDescriptorLookup.get();
    }

    static interface Visitor<TreeNodeType extends ImmutableTreeNode> {
        public void visitUnaryField(TreeNodeType var1, Descriptors.FieldDescriptor var2);

        public void visitRepeatedField(TreeNodeType var1, Descriptors.FieldDescriptor var2);
    }
}

