/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.logging;

import com.google.ads.googleads.lib.catalog.ApiCatalog;
import com.google.ads.googleads.lib.catalog.Version;
import com.google.ads.googleads.lib.logging.AutoValue_Event_Detail;
import com.google.ads.googleads.lib.logging.AutoValue_Event_Summary;
import com.google.ads.googleads.lib.stubs.exceptions.BaseGoogleAdsException;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class Event {
    Event() {
    }

    @Nullable
    public abstract Status getResponseStatus();

    public abstract boolean isSuccess();

    @Nullable
    public abstract String getMethodName();

    @Nullable
    public abstract String getEndpoint();

    public Status.Code getResponseCode() {
        return this.getResponseStatus() == null ? null : this.getResponseStatus().getCode();
    }

    public String getResponseDescription() {
        return this.getResponseStatus() == null ? null : this.getResponseStatus().getDescription();
    }

    @AutoValue
    static abstract class Detail
    extends Event {
        Detail() {
        }

        public static Builder builder() {
            return new AutoValue_Event_Detail.Builder();
        }

        @Nullable
        public abstract ImmutableMap<String, String> getRawRequestHeaders();

        public abstract ImmutableMap<String, String> getScrubbedRequestHeaders();

        @Nullable
        public abstract Metadata getResponseHeaderMetadata();

        @Nullable
        public abstract Metadata getResponseTrailerMetadata();

        @Nullable
        public abstract Object getResponse();

        @Nullable
        public abstract Object getRequest();

        public String getResponseAsText() {
            return this.getResponse() == null ? null : this.getResponse().toString();
        }

        public Optional<Message> deserializeFailureMessage() throws InvalidProtocolBufferException {
            Metadata trailers = this.getResponseTrailerMetadata();
            if (trailers != null) {
                for (Version version : ApiCatalog.getDefault().getSupportedVersions()) {
                    BaseGoogleAdsException.Factory exceptionFactory = version.getExceptionFactory();
                    Metadata.Key trailerKey = exceptionFactory.getTrailerKey();
                    if (!trailers.containsKey(trailerKey)) continue;
                    return Optional.ofNullable(exceptionFactory.createGoogleAdsFailure((byte[])trailers.get(trailerKey)));
                }
            }
            return Optional.empty();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            public abstract Detail build();

            public abstract Builder setResponseStatus(Status var1);

            public abstract Builder setSuccess(boolean var1);

            public abstract Builder setMethodName(String var1);

            public abstract Builder setRawRequestHeaders(Map<String, String> var1);

            public abstract Builder setScrubbedRequestHeaders(Map<String, String> var1);

            public abstract Builder setEndpoint(String var1);

            public abstract Builder setRequest(Object var1);

            public abstract Builder setResponseHeaderMetadata(Metadata var1);

            public abstract Builder setResponseTrailerMetadata(Metadata var1);

            public abstract Builder setResponse(Object var1);
        }
    }

    @AutoValue
    static abstract class Summary
    extends Event {
        Summary() {
        }

        public static Builder builder() {
            return new AutoValue_Event_Summary.Builder();
        }

        @Nullable
        public abstract String getCustomerId();

        @Nullable
        public abstract String getRequestId();

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            public abstract Summary build();

            public abstract Builder setResponseStatus(Status var1);

            public abstract Builder setSuccess(boolean var1);

            public abstract Builder setMethodName(String var1);

            public abstract Builder setCustomerId(String var1);

            public abstract Builder setEndpoint(String var1);

            public abstract Builder setRequestId(String var1);
        }
    }
}

