/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.stubs.exceptions.BaseGoogleAdsException;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.Objects;

public final class Version
implements Comparable<Version> {
    private final Class<?> descriptorClass;
    private final String versionName;
    private final BaseGoogleAdsException.Factory exceptionFactory;
    private final int versionNumber;
    private final String packageNameIdentifier;

    Version(String versionName, BaseGoogleAdsException.Factory exceptionFactory, Class<?> descriptorClass) {
        Preconditions.checkArgument((boolean)versionName.matches("v[0-9]+"), (String)"Invalid version name: %", (Object)versionName);
        this.versionName = (String)Preconditions.checkNotNull((Object)versionName);
        this.versionNumber = (Integer)Preconditions.checkNotNull((Object)Version.extractVersionNumber(versionName));
        this.descriptorClass = (Class)Preconditions.checkNotNull(descriptorClass);
        this.exceptionFactory = (BaseGoogleAdsException.Factory)Preconditions.checkNotNull((Object)exceptionFactory);
        this.packageNameIdentifier = new StringBuilder(2 + String.valueOf(versionName).length()).append(".").append(versionName).append(".").toString();
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public String getVersionName() {
        return this.versionName;
    }

    @Override
    public int compareTo(Version o) {
        return o.getVersionNumber() - this.getVersionNumber();
    }

    public Class<?> getServiceClientFactoryClass() {
        return this.descriptorClass;
    }

    public BaseGoogleAdsException.Factory getExceptionFactory() {
        return this.exceptionFactory;
    }

    public boolean containsMessage(Message input) {
        return input.getClass().getPackage().getName().contains(this.packageNameIdentifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.versionName.equals(version.versionName);
    }

    public int hashCode() {
        return Objects.hash(this.versionName);
    }

    private static int extractVersionNumber(String versionName) {
        return Integer.valueOf(versionName.substring(1));
    }
}

