/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib;

import com.google.ads.googleads.lib.$AutoValue_GoogleAdsHeaderProvider;
import com.google.ads.googleads.v7.services.stub.GoogleAdsServiceStubSettings;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
public abstract class GoogleAdsHeaderProvider
implements HeaderProvider {
    private static final Logger logger = LoggerFactory.getLogger(GoogleAdsHeaderProvider.class);

    public static Builder newBuilder() {
        return new $AutoValue_GoogleAdsHeaderProvider.Builder();
    }

    public abstract String getDeveloperToken();

    @Nullable
    public abstract Long getLoginCustomerId();

    @Nullable
    public abstract Long getLinkedCustomerId();

    @Memoized
    public ImmutableMap<String, String> getHeaders() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"developer-token", (Object)this.getDeveloperToken());
        if (this.getLoginCustomerId() != null) {
            builder.put((Object)"login-customer-id", (Object)String.valueOf(this.getLoginCustomerId()));
        }
        if (this.getLinkedCustomerId() != null) {
            builder.put((Object)"linked-customer-id", (Object)String.valueOf(this.getLinkedCustomerId()));
        }
        ApiClientHeaderProvider apiClient = ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GoogleAdsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion()).setClientLibToken("gccl", GoogleAdsHeaderProvider.getLibraryVersion()).build();
        builder.putAll(apiClient.getHeaders());
        return builder.build();
    }

    private static String getLibraryVersion() {
        String implementationVersion = GoogleAdsHeaderProvider.class.getPackage().getImplementationVersion();
        return implementationVersion == null ? "0.0.0" : implementationVersion;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setDeveloperToken(String var1);

        public abstract Builder setLoginCustomerId(Long var1);

        public abstract Builder setLinkedCustomerId(Long var1);

        public abstract GoogleAdsHeaderProvider build();
    }
}

