/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib;

import com.google.ads.googleads.lib.AbstractGoogleAdsClient;
import com.google.ads.googleads.lib.AutoValue_GoogleAdsClient;
import com.google.ads.googleads.lib.GoogleAdsAllVersions;
import com.google.ads.googleads.lib.GoogleAdsHeaderProvider;
import com.google.ads.googleads.lib.catalog.ApiCatalog;
import com.google.ads.googleads.lib.catalog.Primer;
import com.google.ads.googleads.lib.logging.LoggingInterceptor;
import com.google.ads.googleads.lib.logging.RequestLogger;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@AutoValue
@Immutable
@ThreadSafe
public abstract class GoogleAdsClient
extends AbstractGoogleAdsClient {
    private static final String DEFAULT_ENDPOINT = "googleads.googleapis.com:443";

    public static Builder newBuilder() {
        AutoValue_GoogleAdsClient.Builder clientBuilder = new AutoValue_GoogleAdsClient.Builder();
        InstantiatingGrpcChannelProvider transportChannelProvider = InstantiatingGrpcChannelProvider.newBuilder().setInterceptorProvider(() -> ImmutableList.of((Object)new LoggingInterceptor(new RequestLogger(), clientBuilder.getHeaders(), clientBuilder.getEndpoint()))).setMaxInboundMetadataSize(Integer.valueOf(0x1000000)).setMaxInboundMessageSize(Integer.valueOf(0x4000000)).build();
        clientBuilder.setEndpoint(DEFAULT_ENDPOINT).setTransportChannelProvider((TransportChannelProvider)transportChannelProvider);
        return clientBuilder;
    }

    @Nullable
    public abstract Credentials getCredentials();

    public abstract String getDeveloperToken();

    public abstract String getEndpoint();

    @Nullable
    public abstract Long getLoginCustomerId();

    @Nullable
    public abstract Long getLinkedCustomerId();

    public abstract Builder toBuilder();

    abstract TransportChannelProvider getTransportChannelProvider();

    static {
        Primer.primeBasicsIfEnabled();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public static final String DEFAULT_PROPERTIES_CONFIG_FILE_NAME = "ads.properties";
        private static final String GOOGLE_ADS_API_SCOPE = "https://www.googleapis.com/auth/adwords";
        private static final ImmutableSet<ConfigPropertyKey> INSTALLED_APP_OAUTH_KEYS = ImmutableSet.of((Object)((Object)ConfigPropertyKey.CLIENT_ID), (Object)((Object)ConfigPropertyKey.CLIENT_SECRET), (Object)((Object)ConfigPropertyKey.REFRESH_TOKEN));
        private static final ImmutableSet<ConfigPropertyKey> SERVICE_ACCOUNT_OAUTH_KEYS = ImmutableSet.of((Object)((Object)ConfigPropertyKey.SERVICE_ACCOUNT_SECRETS_PATH), (Object)((Object)ConfigPropertyKey.SERVICE_ACCOUNT_USER));
        private Function<String, String> environmentValueGetter = System::getenv;
        private Supplier<File> configurationFileSupplier = () -> {
            String envConfigFilePath = this.environmentValueGetter.apply(AdsEnvironmentVariable.GOOGLE_ADS_CONFIGURATION_FILE_PATH.name());
            if (envConfigFilePath != null) {
                return new File(envConfigFilePath);
            }
            return new File(System.getProperty("user.home"), DEFAULT_PROPERTIES_CONFIG_FILE_NAME);
        };
        private Optional<GoogleCredentials.Builder> credentialsBuilder = Optional.empty();

        public abstract Credentials getCredentials();

        public abstract Builder setCredentials(Credentials var1);

        private void setCredentials(Properties properties) throws IOException {
            boolean hasInstalledAppKeys = INSTALLED_APP_OAUTH_KEYS.stream().anyMatch(k -> k.getPropertyValue(properties) != null);
            boolean hasServiceAccountKeys = SERVICE_ACCOUNT_OAUTH_KEYS.stream().anyMatch(k -> k.getPropertyValue(properties) != null);
            if (!hasInstalledAppKeys && !hasServiceAccountKeys) {
                return;
            }
            if (hasInstalledAppKeys && hasServiceAccountKeys) {
                throw new IllegalArgumentException(String.format("Entries found in properties for both %s and %s. Please modify properties to either include entries for %s if using installed application/web flow credentials, or %s if using service account credentials.", new Object[]{ConfigPropertyKey.SERVICE_ACCOUNT_SECRETS_PATH, ConfigPropertyKey.REFRESH_TOKEN, INSTALLED_APP_OAUTH_KEYS, SERVICE_ACCOUNT_OAUTH_KEYS}));
            }
            if (this.credentialsBuilder.isPresent()) {
                if (this.credentialsBuilder.get() instanceof UserCredentials.Builder && hasServiceAccountKeys) {
                    throw new IllegalArgumentException("Entries found in properties for service account credentials, but this builder is already partially configured for installed application/web flow credentials.");
                }
                if (this.credentialsBuilder.get() instanceof ServiceAccountCredentials.Builder && hasInstalledAppKeys) {
                    throw new IllegalArgumentException("Entries found in properties for installed application/web flow credentials, but this builder is already partially configured for service account credentials.");
                }
            }
            this.setCredentials((Credentials)null);
            GoogleCredentials.Builder updatedBuilder = hasInstalledAppKeys ? this.configureUserCredentials(properties, this.credentialsBuilder) : this.configureServiceAccountCredentials(properties, this.credentialsBuilder);
            this.credentialsBuilder = Optional.of(updatedBuilder);
        }

        private GoogleCredentials.Builder configureUserCredentials(Properties properties, Optional<GoogleCredentials.Builder> optionalBuilder) {
            String clientSecret;
            String clientId;
            UserCredentials.Builder userCredentialsBuilder;
            if (optionalBuilder.isPresent()) {
                Preconditions.checkState((boolean)(optionalBuilder.get() instanceof UserCredentials.Builder), (Object)"Cannot apply installed app/web flow credential settings. Builder is already partially configured for the service account flow.");
                userCredentialsBuilder = (UserCredentials.Builder)optionalBuilder.get();
            } else {
                userCredentialsBuilder = UserCredentials.newBuilder();
            }
            String refreshToken = ConfigPropertyKey.REFRESH_TOKEN.getPropertyValue(properties);
            if (refreshToken != null) {
                userCredentialsBuilder.setRefreshToken(refreshToken);
            }
            if ((clientId = ConfigPropertyKey.CLIENT_ID.getPropertyValue(properties)) != null) {
                userCredentialsBuilder.setClientId(clientId);
            }
            if ((clientSecret = ConfigPropertyKey.CLIENT_SECRET.getPropertyValue(properties)) != null) {
                userCredentialsBuilder.setClientSecret(clientSecret);
            }
            return userCredentialsBuilder;
        }

        private GoogleCredentials.Builder configureServiceAccountCredentials(Properties properties, Optional<GoogleCredentials.Builder> optionalBuilder) throws IOException {
            String serviceAccountUser;
            ServiceAccountCredentials.Builder builder;
            if (optionalBuilder.isPresent()) {
                Preconditions.checkState((boolean)(optionalBuilder.get() instanceof ServiceAccountCredentials.Builder), (Object)"Cannot apply service account credential settings. Builder is already partially configured for the installed app/web flow.");
                builder = (ServiceAccountCredentials.Builder)optionalBuilder.get();
            } else {
                builder = ServiceAccountCredentials.newBuilder().setScopes(Collections.singleton(GOOGLE_ADS_API_SCOPE));
            }
            String serviceAccountSecretsPath = ConfigPropertyKey.SERVICE_ACCOUNT_SECRETS_PATH.getPropertyValue(properties);
            if (serviceAccountSecretsPath != null) {
                ServiceAccountCredentials.Builder newBuilder = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(serviceAccountSecretsPath)).toBuilder();
                newBuilder.setServiceAccountUser(builder.getServiceAccountUser());
                newBuilder.setScopes(builder.getScopes());
                builder = newBuilder;
            }
            if ((serviceAccountUser = ConfigPropertyKey.SERVICE_ACCOUNT_USER.getPropertyValue(properties)) != null) {
                builder.setServiceAccountUser(serviceAccountUser);
            }
            return builder;
        }

        @VisibleForTesting
        abstract TransportChannelProvider getTransportChannelProvider();

        abstract Builder setTransportChannelProvider(TransportChannelProvider var1);

        public abstract String getDeveloperToken();

        public abstract Builder setDeveloperToken(String var1);

        private void setDeveloperToken(Properties properties) {
            String devToken = ConfigPropertyKey.DEVELOPER_TOKEN.getPropertyValue(properties);
            if (devToken != null) {
                this.setDeveloperToken(devToken);
            }
        }

        public abstract Long getLoginCustomerId();

        public abstract Long getLinkedCustomerId();

        public abstract Builder setLinkedCustomerId(Long var1);

        public abstract Builder setLoginCustomerId(Long var1);

        private long checkLongString(String longString, String fieldName) {
            try {
                return Long.parseLong(longString);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(fieldName).length() + String.valueOf(longString).length()).append("Invalid ").append(fieldName).append(", must be a number, provided: ").append(longString).toString(), ex);
            }
        }

        private void setLoginCustomerId(Properties properties) {
            String configuredLoginCustomer = ConfigPropertyKey.LOGIN_CUSTOMER_ID.getPropertyValue(properties);
            if (configuredLoginCustomer != null) {
                this.setLoginCustomerId(this.checkLongString(configuredLoginCustomer, "loginCustomerId"));
            }
        }

        private void setLinkedCustomerId(Properties properties) {
            String configuredLinkedCustomer = ConfigPropertyKey.LINKED_CUSTOMER_ID.getPropertyValue(properties);
            if (configuredLinkedCustomer != null) {
                this.setLinkedCustomerId(this.checkLongString(configuredLinkedCustomer, "linkedCustomerId"));
            }
        }

        public abstract String getEndpoint();

        public abstract Builder setEndpoint(String var1);

        private void setEndpoint(Properties properties) {
            String endpoint = (String)MoreObjects.firstNonNull((Object)ConfigPropertyKey.ENDPOINT.getPropertyValue(properties), (Object)((String)MoreObjects.firstNonNull((Object)ConfigPropertyKey.ENDPOINT.getPropertyValue(System.getProperties()), (Object)GoogleAdsClient.DEFAULT_ENDPOINT)));
            this.setEndpoint(endpoint);
        }

        abstract Builder setGoogleAdsAllVersions(GoogleAdsAllVersions var1);

        abstract GoogleAdsClient autoBuild();

        public Builder fromPropertiesFile() throws IOException {
            return this.fromPropertiesFile(this.configurationFileSupplier.get());
        }

        public Builder fromPropertiesFile(File propertiesFile) throws IOException {
            Preconditions.checkNotNull((Object)propertiesFile, (Object)"Null properties file");
            Properties adsProperties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
                adsProperties.load(fileInputStream);
            }
            return this.fromProperties(adsProperties);
        }

        public Builder fromProperties(Properties properties) {
            try {
                this.setCredentials(properties);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to create credentials from properties", ioe);
            }
            this.setDeveloperToken(properties);
            this.setEndpoint(properties);
            this.setLoginCustomerId(properties);
            this.setLinkedCustomerId(properties);
            return this;
        }

        public Builder fromEnvironment() {
            Properties properties = new Properties();
            for (AdsEnvironmentVariable adsEnvVar : AdsEnvironmentVariable.values()) {
                String envVarValue;
                if (!adsEnvVar.configPropertyKey.isPresent() || (envVarValue = this.environmentValueGetter.apply(adsEnvVar.name())) == null) continue;
                properties.put(((ConfigPropertyKey)((Object)adsEnvVar.configPropertyKey.get())).getPropertyKey(), envVarValue);
            }
            return this.fromProperties(properties);
        }

        ImmutableMap<String, String> getHeaders() {
            return GoogleAdsHeaderProvider.newBuilder().setDeveloperToken(this.getDeveloperToken()).setLoginCustomerId(this.getLoginCustomerId()).setLinkedCustomerId(this.getLinkedCustomerId()).build().getHeaders();
        }

        public GoogleAdsClient build() {
            if (this.getCredentials() == null) {
                if (this.credentialsBuilder.isPresent()) {
                    this.setCredentials((Credentials)this.credentialsBuilder.get().build());
                } else {
                    throw new IllegalStateException("Property \"credentials\" has not been set");
                }
            }
            Primer.getInstance().ifPresent(p -> p.primeCredentialsAsync(this.getCredentials()));
            TransportChannelProvider transportChannelProvider = this.getTransportChannelProvider();
            if (transportChannelProvider.needsHeaders()) {
                transportChannelProvider = transportChannelProvider.withHeaders(this.getHeaders());
            }
            if (transportChannelProvider.needsEndpoint()) {
                transportChannelProvider = transportChannelProvider.withEndpoint(this.getEndpoint());
            }
            this.setTransportChannelProvider(transportChannelProvider);
            GoogleAdsAllVersions allVersionsClient = ApiCatalog.getDefault().createAllVersionsClient(this.getTransportChannelProvider(), this.getCredentials());
            this.setGoogleAdsAllVersions(allVersionsClient);
            GoogleAdsClient provider = this.autoBuild();
            Long loginCustomerId = provider.getLoginCustomerId();
            String string = String.valueOf(loginCustomerId);
            Preconditions.checkArgument((provider.getLoginCustomerId() == null || loginCustomerId > 0L && loginCustomerId <= 9999999999L ? 1 : 0) != 0, (Object)new StringBuilder(80 + String.valueOf(string).length()).append("Invalid loginCustomerId, must be 0 < loginCustomerId < 9,999,999,999, provided: ").append(string).toString());
            return provider;
        }

        @VisibleForTesting
        Builder setConfigurationFileSupplier(Supplier<File> configurationFileSupplier) {
            this.configurationFileSupplier = configurationFileSupplier;
            return this;
        }

        @VisibleForTesting
        Builder setEnvironmentValueGetter(Function<String, String> environmentValueGetter) {
            this.environmentValueGetter = environmentValueGetter;
            return this;
        }

        public static enum ConfigPropertyKey {
            CLIENT_ID("api.googleads.clientId"),
            CLIENT_SECRET("api.googleads.clientSecret"),
            DEVELOPER_TOKEN("api.googleads.developerToken"),
            REFRESH_TOKEN("api.googleads.refreshToken"),
            ENDPOINT("api.googleads.endpoint"),
            LOGIN_CUSTOMER_ID("api.googleads.loginCustomerId"),
            LINKED_CUSTOMER_ID("api.googleads.linkedCustomerId"),
            SERVICE_ACCOUNT_SECRETS_PATH("api.googleads.serviceAccountSecretsPath"),
            SERVICE_ACCOUNT_USER("api.googleads.serviceAccountUser");

            private final String key;

            private ConfigPropertyKey(String key) {
                this.key = key;
            }

            public String getPropertyKey() {
                return this.key;
            }

            public String getPropertyValue(Properties properties) {
                return ((Properties)Preconditions.checkNotNull((Object)properties, (Object)"Null properties")).getProperty(this.getPropertyKey());
            }
        }

        public static enum AdsEnvironmentVariable {
            GOOGLE_ADS_CONFIGURATION_FILE_PATH,
            GOOGLE_ADS_CLIENT_ID(ConfigPropertyKey.CLIENT_ID),
            GOOGLE_ADS_CLIENT_SECRET(ConfigPropertyKey.CLIENT_SECRET),
            GOOGLE_ADS_REFRESH_TOKEN(ConfigPropertyKey.REFRESH_TOKEN),
            GOOGLE_ADS_JSON_KEY_FILE_PATH(ConfigPropertyKey.SERVICE_ACCOUNT_SECRETS_PATH),
            GOOGLE_ADS_IMPERSONATED_EMAIL(ConfigPropertyKey.SERVICE_ACCOUNT_USER),
            GOOGLE_ADS_DEVELOPER_TOKEN(ConfigPropertyKey.DEVELOPER_TOKEN),
            GOOGLE_ADS_LOGIN_CUSTOMER_ID(ConfigPropertyKey.LOGIN_CUSTOMER_ID),
            GOOGLE_ADS_LINKED_CUSTOMER_ID(ConfigPropertyKey.LINKED_CUSTOMER_ID),
            GOOGLE_ADS_ENDPOINT(ConfigPropertyKey.ENDPOINT);

            private Optional<ConfigPropertyKey> configPropertyKey;

            private AdsEnvironmentVariable(ConfigPropertyKey configPropertyKey) {
                this.configPropertyKey = Optional.of(configPropertyKey);
            }

            private AdsEnvironmentVariable() {
                this.configPropertyKey = Optional.empty();
            }
        }
    }
}

