// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.GoogleAdsAllVersions;
import com.google.ads.googleads.v7.services.AccountBudgetProposalServiceClient;
import com.google.ads.googleads.v7.services.AccountBudgetProposalServiceSettings;
import com.google.ads.googleads.v7.services.AccountBudgetServiceClient;
import com.google.ads.googleads.v7.services.AccountBudgetServiceSettings;
import com.google.ads.googleads.v7.services.AccountLinkServiceClient;
import com.google.ads.googleads.v7.services.AccountLinkServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupAdAssetViewServiceClient;
import com.google.ads.googleads.v7.services.AdGroupAdAssetViewServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupAdLabelServiceClient;
import com.google.ads.googleads.v7.services.AdGroupAdLabelServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupAdServiceClient;
import com.google.ads.googleads.v7.services.AdGroupAdServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupAssetServiceClient;
import com.google.ads.googleads.v7.services.AdGroupAssetServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupAudienceViewServiceClient;
import com.google.ads.googleads.v7.services.AdGroupAudienceViewServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupBidModifierServiceClient;
import com.google.ads.googleads.v7.services.AdGroupBidModifierServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupCriterionLabelServiceClient;
import com.google.ads.googleads.v7.services.AdGroupCriterionLabelServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupCriterionServiceClient;
import com.google.ads.googleads.v7.services.AdGroupCriterionServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupCriterionSimulationServiceClient;
import com.google.ads.googleads.v7.services.AdGroupCriterionSimulationServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupExtensionSettingServiceClient;
import com.google.ads.googleads.v7.services.AdGroupExtensionSettingServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupFeedServiceClient;
import com.google.ads.googleads.v7.services.AdGroupFeedServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupLabelServiceClient;
import com.google.ads.googleads.v7.services.AdGroupLabelServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupServiceClient;
import com.google.ads.googleads.v7.services.AdGroupServiceSettings;
import com.google.ads.googleads.v7.services.AdGroupSimulationServiceClient;
import com.google.ads.googleads.v7.services.AdGroupSimulationServiceSettings;
import com.google.ads.googleads.v7.services.AdParameterServiceClient;
import com.google.ads.googleads.v7.services.AdParameterServiceSettings;
import com.google.ads.googleads.v7.services.AdScheduleViewServiceClient;
import com.google.ads.googleads.v7.services.AdScheduleViewServiceSettings;
import com.google.ads.googleads.v7.services.AdServiceClient;
import com.google.ads.googleads.v7.services.AdServiceSettings;
import com.google.ads.googleads.v7.services.AgeRangeViewServiceClient;
import com.google.ads.googleads.v7.services.AgeRangeViewServiceSettings;
import com.google.ads.googleads.v7.services.AssetServiceClient;
import com.google.ads.googleads.v7.services.AssetServiceSettings;
import com.google.ads.googleads.v7.services.BatchJobServiceClient;
import com.google.ads.googleads.v7.services.BatchJobServiceSettings;
import com.google.ads.googleads.v7.services.BiddingStrategyServiceClient;
import com.google.ads.googleads.v7.services.BiddingStrategyServiceSettings;
import com.google.ads.googleads.v7.services.BiddingStrategySimulationServiceClient;
import com.google.ads.googleads.v7.services.BiddingStrategySimulationServiceSettings;
import com.google.ads.googleads.v7.services.BillingSetupServiceClient;
import com.google.ads.googleads.v7.services.BillingSetupServiceSettings;
import com.google.ads.googleads.v7.services.CampaignAssetServiceClient;
import com.google.ads.googleads.v7.services.CampaignAssetServiceSettings;
import com.google.ads.googleads.v7.services.CampaignAudienceViewServiceClient;
import com.google.ads.googleads.v7.services.CampaignAudienceViewServiceSettings;
import com.google.ads.googleads.v7.services.CampaignBidModifierServiceClient;
import com.google.ads.googleads.v7.services.CampaignBidModifierServiceSettings;
import com.google.ads.googleads.v7.services.CampaignBudgetServiceClient;
import com.google.ads.googleads.v7.services.CampaignBudgetServiceSettings;
import com.google.ads.googleads.v7.services.CampaignCriterionServiceClient;
import com.google.ads.googleads.v7.services.CampaignCriterionServiceSettings;
import com.google.ads.googleads.v7.services.CampaignCriterionSimulationServiceClient;
import com.google.ads.googleads.v7.services.CampaignCriterionSimulationServiceSettings;
import com.google.ads.googleads.v7.services.CampaignDraftServiceClient;
import com.google.ads.googleads.v7.services.CampaignDraftServiceSettings;
import com.google.ads.googleads.v7.services.CampaignExperimentServiceClient;
import com.google.ads.googleads.v7.services.CampaignExperimentServiceSettings;
import com.google.ads.googleads.v7.services.CampaignExtensionSettingServiceClient;
import com.google.ads.googleads.v7.services.CampaignExtensionSettingServiceSettings;
import com.google.ads.googleads.v7.services.CampaignFeedServiceClient;
import com.google.ads.googleads.v7.services.CampaignFeedServiceSettings;
import com.google.ads.googleads.v7.services.CampaignLabelServiceClient;
import com.google.ads.googleads.v7.services.CampaignLabelServiceSettings;
import com.google.ads.googleads.v7.services.CampaignServiceClient;
import com.google.ads.googleads.v7.services.CampaignServiceSettings;
import com.google.ads.googleads.v7.services.CampaignSharedSetServiceClient;
import com.google.ads.googleads.v7.services.CampaignSharedSetServiceSettings;
import com.google.ads.googleads.v7.services.CampaignSimulationServiceClient;
import com.google.ads.googleads.v7.services.CampaignSimulationServiceSettings;
import com.google.ads.googleads.v7.services.CarrierConstantServiceClient;
import com.google.ads.googleads.v7.services.CarrierConstantServiceSettings;
import com.google.ads.googleads.v7.services.ChangeStatusServiceClient;
import com.google.ads.googleads.v7.services.ChangeStatusServiceSettings;
import com.google.ads.googleads.v7.services.ClickViewServiceClient;
import com.google.ads.googleads.v7.services.ClickViewServiceSettings;
import com.google.ads.googleads.v7.services.CombinedAudienceServiceClient;
import com.google.ads.googleads.v7.services.CombinedAudienceServiceSettings;
import com.google.ads.googleads.v7.services.ConversionActionServiceClient;
import com.google.ads.googleads.v7.services.ConversionActionServiceSettings;
import com.google.ads.googleads.v7.services.ConversionAdjustmentUploadServiceClient;
import com.google.ads.googleads.v7.services.ConversionAdjustmentUploadServiceSettings;
import com.google.ads.googleads.v7.services.ConversionCustomVariableServiceClient;
import com.google.ads.googleads.v7.services.ConversionCustomVariableServiceSettings;
import com.google.ads.googleads.v7.services.ConversionUploadServiceClient;
import com.google.ads.googleads.v7.services.ConversionUploadServiceSettings;
import com.google.ads.googleads.v7.services.CurrencyConstantServiceClient;
import com.google.ads.googleads.v7.services.CurrencyConstantServiceSettings;
import com.google.ads.googleads.v7.services.CustomAudienceServiceClient;
import com.google.ads.googleads.v7.services.CustomAudienceServiceSettings;
import com.google.ads.googleads.v7.services.CustomInterestServiceClient;
import com.google.ads.googleads.v7.services.CustomInterestServiceSettings;
import com.google.ads.googleads.v7.services.CustomerAssetServiceClient;
import com.google.ads.googleads.v7.services.CustomerAssetServiceSettings;
import com.google.ads.googleads.v7.services.CustomerClientLinkServiceClient;
import com.google.ads.googleads.v7.services.CustomerClientLinkServiceSettings;
import com.google.ads.googleads.v7.services.CustomerClientServiceClient;
import com.google.ads.googleads.v7.services.CustomerClientServiceSettings;
import com.google.ads.googleads.v7.services.CustomerExtensionSettingServiceClient;
import com.google.ads.googleads.v7.services.CustomerExtensionSettingServiceSettings;
import com.google.ads.googleads.v7.services.CustomerFeedServiceClient;
import com.google.ads.googleads.v7.services.CustomerFeedServiceSettings;
import com.google.ads.googleads.v7.services.CustomerLabelServiceClient;
import com.google.ads.googleads.v7.services.CustomerLabelServiceSettings;
import com.google.ads.googleads.v7.services.CustomerManagerLinkServiceClient;
import com.google.ads.googleads.v7.services.CustomerManagerLinkServiceSettings;
import com.google.ads.googleads.v7.services.CustomerNegativeCriterionServiceClient;
import com.google.ads.googleads.v7.services.CustomerNegativeCriterionServiceSettings;
import com.google.ads.googleads.v7.services.CustomerServiceClient;
import com.google.ads.googleads.v7.services.CustomerServiceSettings;
import com.google.ads.googleads.v7.services.CustomerUserAccessInvitationServiceClient;
import com.google.ads.googleads.v7.services.CustomerUserAccessInvitationServiceSettings;
import com.google.ads.googleads.v7.services.CustomerUserAccessServiceClient;
import com.google.ads.googleads.v7.services.CustomerUserAccessServiceSettings;
import com.google.ads.googleads.v7.services.DetailPlacementViewServiceClient;
import com.google.ads.googleads.v7.services.DetailPlacementViewServiceSettings;
import com.google.ads.googleads.v7.services.DisplayKeywordViewServiceClient;
import com.google.ads.googleads.v7.services.DisplayKeywordViewServiceSettings;
import com.google.ads.googleads.v7.services.DistanceViewServiceClient;
import com.google.ads.googleads.v7.services.DistanceViewServiceSettings;
import com.google.ads.googleads.v7.services.DomainCategoryServiceClient;
import com.google.ads.googleads.v7.services.DomainCategoryServiceSettings;
import com.google.ads.googleads.v7.services.DynamicSearchAdsSearchTermViewServiceClient;
import com.google.ads.googleads.v7.services.DynamicSearchAdsSearchTermViewServiceSettings;
import com.google.ads.googleads.v7.services.ExpandedLandingPageViewServiceClient;
import com.google.ads.googleads.v7.services.ExpandedLandingPageViewServiceSettings;
import com.google.ads.googleads.v7.services.ExtensionFeedItemServiceClient;
import com.google.ads.googleads.v7.services.ExtensionFeedItemServiceSettings;
import com.google.ads.googleads.v7.services.FeedItemServiceClient;
import com.google.ads.googleads.v7.services.FeedItemServiceSettings;
import com.google.ads.googleads.v7.services.FeedItemSetLinkServiceClient;
import com.google.ads.googleads.v7.services.FeedItemSetLinkServiceSettings;
import com.google.ads.googleads.v7.services.FeedItemSetServiceClient;
import com.google.ads.googleads.v7.services.FeedItemSetServiceSettings;
import com.google.ads.googleads.v7.services.FeedItemTargetServiceClient;
import com.google.ads.googleads.v7.services.FeedItemTargetServiceSettings;
import com.google.ads.googleads.v7.services.FeedMappingServiceClient;
import com.google.ads.googleads.v7.services.FeedMappingServiceSettings;
import com.google.ads.googleads.v7.services.FeedPlaceholderViewServiceClient;
import com.google.ads.googleads.v7.services.FeedPlaceholderViewServiceSettings;
import com.google.ads.googleads.v7.services.FeedServiceClient;
import com.google.ads.googleads.v7.services.FeedServiceSettings;
import com.google.ads.googleads.v7.services.GenderViewServiceClient;
import com.google.ads.googleads.v7.services.GenderViewServiceSettings;
import com.google.ads.googleads.v7.services.GeoTargetConstantServiceClient;
import com.google.ads.googleads.v7.services.GeoTargetConstantServiceSettings;
import com.google.ads.googleads.v7.services.GeographicViewServiceClient;
import com.google.ads.googleads.v7.services.GeographicViewServiceSettings;
import com.google.ads.googleads.v7.services.GoogleAdsFieldServiceClient;
import com.google.ads.googleads.v7.services.GoogleAdsFieldServiceSettings;
import com.google.ads.googleads.v7.services.GoogleAdsServiceClient;
import com.google.ads.googleads.v7.services.GoogleAdsServiceSettings;
import com.google.ads.googleads.v7.services.GoogleAdsVersion;
import com.google.ads.googleads.v7.services.GroupPlacementViewServiceClient;
import com.google.ads.googleads.v7.services.GroupPlacementViewServiceSettings;
import com.google.ads.googleads.v7.services.HotelGroupViewServiceClient;
import com.google.ads.googleads.v7.services.HotelGroupViewServiceSettings;
import com.google.ads.googleads.v7.services.HotelPerformanceViewServiceClient;
import com.google.ads.googleads.v7.services.HotelPerformanceViewServiceSettings;
import com.google.ads.googleads.v7.services.IncomeRangeViewServiceClient;
import com.google.ads.googleads.v7.services.IncomeRangeViewServiceSettings;
import com.google.ads.googleads.v7.services.InvoiceServiceClient;
import com.google.ads.googleads.v7.services.InvoiceServiceSettings;
import com.google.ads.googleads.v7.services.KeywordPlanAdGroupKeywordServiceClient;
import com.google.ads.googleads.v7.services.KeywordPlanAdGroupKeywordServiceSettings;
import com.google.ads.googleads.v7.services.KeywordPlanAdGroupServiceClient;
import com.google.ads.googleads.v7.services.KeywordPlanAdGroupServiceSettings;
import com.google.ads.googleads.v7.services.KeywordPlanCampaignKeywordServiceClient;
import com.google.ads.googleads.v7.services.KeywordPlanCampaignKeywordServiceSettings;
import com.google.ads.googleads.v7.services.KeywordPlanCampaignServiceClient;
import com.google.ads.googleads.v7.services.KeywordPlanCampaignServiceSettings;
import com.google.ads.googleads.v7.services.KeywordPlanIdeaServiceClient;
import com.google.ads.googleads.v7.services.KeywordPlanIdeaServiceSettings;
import com.google.ads.googleads.v7.services.KeywordPlanServiceClient;
import com.google.ads.googleads.v7.services.KeywordPlanServiceSettings;
import com.google.ads.googleads.v7.services.KeywordViewServiceClient;
import com.google.ads.googleads.v7.services.KeywordViewServiceSettings;
import com.google.ads.googleads.v7.services.LabelServiceClient;
import com.google.ads.googleads.v7.services.LabelServiceSettings;
import com.google.ads.googleads.v7.services.LandingPageViewServiceClient;
import com.google.ads.googleads.v7.services.LandingPageViewServiceSettings;
import com.google.ads.googleads.v7.services.LanguageConstantServiceClient;
import com.google.ads.googleads.v7.services.LanguageConstantServiceSettings;
import com.google.ads.googleads.v7.services.LifeEventServiceClient;
import com.google.ads.googleads.v7.services.LifeEventServiceSettings;
import com.google.ads.googleads.v7.services.LocationViewServiceClient;
import com.google.ads.googleads.v7.services.LocationViewServiceSettings;
import com.google.ads.googleads.v7.services.ManagedPlacementViewServiceClient;
import com.google.ads.googleads.v7.services.ManagedPlacementViewServiceSettings;
import com.google.ads.googleads.v7.services.MediaFileServiceClient;
import com.google.ads.googleads.v7.services.MediaFileServiceSettings;
import com.google.ads.googleads.v7.services.MerchantCenterLinkServiceClient;
import com.google.ads.googleads.v7.services.MerchantCenterLinkServiceSettings;
import com.google.ads.googleads.v7.services.MobileAppCategoryConstantServiceClient;
import com.google.ads.googleads.v7.services.MobileAppCategoryConstantServiceSettings;
import com.google.ads.googleads.v7.services.MobileDeviceConstantServiceClient;
import com.google.ads.googleads.v7.services.MobileDeviceConstantServiceSettings;
import com.google.ads.googleads.v7.services.OfflineUserDataJobServiceClient;
import com.google.ads.googleads.v7.services.OfflineUserDataJobServiceSettings;
import com.google.ads.googleads.v7.services.OperatingSystemVersionConstantServiceClient;
import com.google.ads.googleads.v7.services.OperatingSystemVersionConstantServiceSettings;
import com.google.ads.googleads.v7.services.PaidOrganicSearchTermViewServiceClient;
import com.google.ads.googleads.v7.services.PaidOrganicSearchTermViewServiceSettings;
import com.google.ads.googleads.v7.services.ParentalStatusViewServiceClient;
import com.google.ads.googleads.v7.services.ParentalStatusViewServiceSettings;
import com.google.ads.googleads.v7.services.PaymentsAccountServiceClient;
import com.google.ads.googleads.v7.services.PaymentsAccountServiceSettings;
import com.google.ads.googleads.v7.services.ProductBiddingCategoryConstantServiceClient;
import com.google.ads.googleads.v7.services.ProductBiddingCategoryConstantServiceSettings;
import com.google.ads.googleads.v7.services.ProductGroupViewServiceClient;
import com.google.ads.googleads.v7.services.ProductGroupViewServiceSettings;
import com.google.ads.googleads.v7.services.ReachPlanServiceClient;
import com.google.ads.googleads.v7.services.ReachPlanServiceSettings;
import com.google.ads.googleads.v7.services.RecommendationServiceClient;
import com.google.ads.googleads.v7.services.RecommendationServiceSettings;
import com.google.ads.googleads.v7.services.RemarketingActionServiceClient;
import com.google.ads.googleads.v7.services.RemarketingActionServiceSettings;
import com.google.ads.googleads.v7.services.SearchTermViewServiceClient;
import com.google.ads.googleads.v7.services.SearchTermViewServiceSettings;
import com.google.ads.googleads.v7.services.SharedCriterionServiceClient;
import com.google.ads.googleads.v7.services.SharedCriterionServiceSettings;
import com.google.ads.googleads.v7.services.SharedSetServiceClient;
import com.google.ads.googleads.v7.services.SharedSetServiceSettings;
import com.google.ads.googleads.v7.services.ShoppingPerformanceViewServiceClient;
import com.google.ads.googleads.v7.services.ShoppingPerformanceViewServiceSettings;
import com.google.ads.googleads.v7.services.ThirdPartyAppAnalyticsLinkServiceClient;
import com.google.ads.googleads.v7.services.ThirdPartyAppAnalyticsLinkServiceSettings;
import com.google.ads.googleads.v7.services.TopicConstantServiceClient;
import com.google.ads.googleads.v7.services.TopicConstantServiceSettings;
import com.google.ads.googleads.v7.services.TopicViewServiceClient;
import com.google.ads.googleads.v7.services.TopicViewServiceSettings;
import com.google.ads.googleads.v7.services.UserDataServiceClient;
import com.google.ads.googleads.v7.services.UserDataServiceSettings;
import com.google.ads.googleads.v7.services.UserInterestServiceClient;
import com.google.ads.googleads.v7.services.UserInterestServiceSettings;
import com.google.ads.googleads.v7.services.UserListServiceClient;
import com.google.ads.googleads.v7.services.UserListServiceSettings;
import com.google.ads.googleads.v7.services.UserLocationViewServiceClient;
import com.google.ads.googleads.v7.services.UserLocationViewServiceSettings;
import com.google.ads.googleads.v7.services.VideoServiceClient;
import com.google.ads.googleads.v7.services.VideoServiceSettings;
import com.google.ads.googleads.v7.services.WebpageViewServiceClient;
import com.google.ads.googleads.v7.services.WebpageViewServiceSettings;
import com.google.ads.googleads.v8.services.AccessibleBiddingStrategyServiceClient;
import com.google.ads.googleads.v8.services.AccessibleBiddingStrategyServiceSettings;
import com.google.ads.googleads.v8.services.AssetFieldTypeViewServiceClient;
import com.google.ads.googleads.v8.services.AssetFieldTypeViewServiceSettings;
import com.google.ads.googleads.v8.services.BiddingDataExclusionServiceClient;
import com.google.ads.googleads.v8.services.BiddingDataExclusionServiceSettings;
import com.google.ads.googleads.v8.services.BiddingSeasonalityAdjustmentServiceClient;
import com.google.ads.googleads.v8.services.BiddingSeasonalityAdjustmentServiceSettings;
import com.google.ads.googleads.v8.services.ConversionValueRuleServiceClient;
import com.google.ads.googleads.v8.services.ConversionValueRuleServiceSettings;
import com.google.ads.googleads.v8.services.ConversionValueRuleSetServiceClient;
import com.google.ads.googleads.v8.services.ConversionValueRuleSetServiceSettings;
import com.google.ads.googleads.v8.services.DetailedDemographicServiceClient;
import com.google.ads.googleads.v8.services.DetailedDemographicServiceSettings;
import com.google.ads.googleads.v8.services.KeywordThemeConstantServiceClient;
import com.google.ads.googleads.v8.services.KeywordThemeConstantServiceSettings;
import com.google.ads.googleads.v8.services.SmartCampaignSearchTermViewServiceClient;
import com.google.ads.googleads.v8.services.SmartCampaignSearchTermViewServiceSettings;
import com.google.ads.googleads.v8.services.SmartCampaignSettingServiceClient;
import com.google.ads.googleads.v8.services.SmartCampaignSettingServiceSettings;
import com.google.ads.googleads.v8.services.SmartCampaignSuggestServiceClient;
import com.google.ads.googleads.v8.services.SmartCampaignSuggestServiceSettings;
import com.google.ads.googleads.v9.services.AdGroupCriterionCustomizerServiceClient;
import com.google.ads.googleads.v9.services.AdGroupCriterionCustomizerServiceSettings;
import com.google.ads.googleads.v9.services.AdGroupCustomizerServiceClient;
import com.google.ads.googleads.v9.services.AdGroupCustomizerServiceSettings;
import com.google.ads.googleads.v9.services.AssetGroupAssetServiceClient;
import com.google.ads.googleads.v9.services.AssetGroupAssetServiceSettings;
import com.google.ads.googleads.v9.services.AssetGroupListingGroupFilterServiceClient;
import com.google.ads.googleads.v9.services.AssetGroupListingGroupFilterServiceSettings;
import com.google.ads.googleads.v9.services.AssetGroupServiceClient;
import com.google.ads.googleads.v9.services.AssetGroupServiceSettings;
import com.google.ads.googleads.v9.services.AssetSetAssetServiceClient;
import com.google.ads.googleads.v9.services.AssetSetAssetServiceSettings;
import com.google.ads.googleads.v9.services.AssetSetServiceClient;
import com.google.ads.googleads.v9.services.AssetSetServiceSettings;
import com.google.ads.googleads.v9.services.CampaignAssetSetServiceClient;
import com.google.ads.googleads.v9.services.CampaignAssetSetServiceSettings;
import com.google.ads.googleads.v9.services.CampaignConversionGoalServiceClient;
import com.google.ads.googleads.v9.services.CampaignConversionGoalServiceSettings;
import com.google.ads.googleads.v9.services.CampaignCustomizerServiceClient;
import com.google.ads.googleads.v9.services.CampaignCustomizerServiceSettings;
import com.google.ads.googleads.v9.services.ConversionGoalCampaignConfigServiceClient;
import com.google.ads.googleads.v9.services.ConversionGoalCampaignConfigServiceSettings;
import com.google.ads.googleads.v9.services.CustomConversionGoalServiceClient;
import com.google.ads.googleads.v9.services.CustomConversionGoalServiceSettings;
import com.google.ads.googleads.v9.services.CustomerConversionGoalServiceClient;
import com.google.ads.googleads.v9.services.CustomerConversionGoalServiceSettings;
import com.google.ads.googleads.v9.services.CustomerCustomizerServiceClient;
import com.google.ads.googleads.v9.services.CustomerCustomizerServiceSettings;
import com.google.ads.googleads.v9.services.CustomizerAttributeServiceClient;
import com.google.ads.googleads.v9.services.CustomizerAttributeServiceSettings;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.SortedSet;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class GeneratedCatalog implements ApiCatalog {
  private static GeneratedCatalog instance;

  static {
    try {
      instance = new GeneratedCatalog(VersionFactory.getVersions());
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InstantiationException e) {
      throw new RuntimeException(e);
    }
  }

  private final ImmutableSortedSet<Version> supportedVersions;

  /**
   * Creates a new constant catalog from a known collection of versions. */
  public GeneratedCatalog(ImmutableSet<Version> versions) {
    supportedVersions = ImmutableSortedSet.copyOf(versions);
  }

  public static GeneratedCatalog getDefault() {
    return instance;
  }

  public SortedSet<Version> getSupportedVersions() {
    return supportedVersions;
  }

  public Version getLatestVersion() {
    return getSupportedVersions().first();
  }

  public GoogleAdsAllVersions createAllVersionsClient(TransportChannelProvider provider,
      Credentials credentials) {
    return new GoogleAdsAllVersions() {
      @Override
      public GoogleAdsVersion getVersion7() {
        return new V7Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v8.services.GoogleAdsVersion getVersion8() {
        return new V8Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v9.services.GoogleAdsVersion getVersion9() {
        return new V9Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v9.services.GoogleAdsVersion getLatestVersion() {
        return getVersion9();
      }
    };
  }

  private static class V7Client implements GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V7Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient() {
      try {
        AccountBudgetProposalServiceSettings settings =
          AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AccountBudgetServiceClient createAccountBudgetServiceClient() {
      try {
        AccountBudgetServiceSettings settings =
          AccountBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AccountLinkServiceClient createAccountLinkServiceClient() {
      try {
        AccountLinkServiceSettings settings =
          AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdAssetViewServiceClient createAdGroupAdAssetViewServiceClient() {
      try {
        AdGroupAdAssetViewServiceSettings settings =
          AdGroupAdAssetViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdAssetViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient() {
      try {
        AdGroupAdLabelServiceSettings settings =
          AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdServiceClient createAdGroupAdServiceClient() {
      try {
        AdGroupAdServiceSettings settings =
          AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAssetServiceClient createAdGroupAssetServiceClient() {
      try {
        AdGroupAssetServiceSettings settings =
          AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAudienceViewServiceClient createAdGroupAudienceViewServiceClient() {
      try {
        AdGroupAudienceViewServiceSettings settings =
          AdGroupAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient() {
      try {
        AdGroupBidModifierServiceSettings settings =
          AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient() {
      try {
        AdGroupCriterionLabelServiceSettings settings =
          AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionServiceClient createAdGroupCriterionServiceClient() {
      try {
        AdGroupCriterionServiceSettings settings =
          AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionSimulationServiceClient createAdGroupCriterionSimulationServiceClient() {
      try {
        AdGroupCriterionSimulationServiceSettings settings =
          AdGroupCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient() {
      try {
        AdGroupExtensionSettingServiceSettings settings =
          AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupFeedServiceClient createAdGroupFeedServiceClient() {
      try {
        AdGroupFeedServiceSettings settings =
          AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupLabelServiceClient createAdGroupLabelServiceClient() {
      try {
        AdGroupLabelServiceSettings settings =
          AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupServiceClient createAdGroupServiceClient() {
      try {
        AdGroupServiceSettings settings =
          AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupSimulationServiceClient createAdGroupSimulationServiceClient() {
      try {
        AdGroupSimulationServiceSettings settings =
          AdGroupSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdParameterServiceClient createAdParameterServiceClient() {
      try {
        AdParameterServiceSettings settings =
          AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdScheduleViewServiceClient createAdScheduleViewServiceClient() {
      try {
        AdScheduleViewServiceSettings settings =
          AdScheduleViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdScheduleViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdServiceClient createAdServiceClient() {
      try {
        AdServiceSettings settings =
          AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AgeRangeViewServiceClient createAgeRangeViewServiceClient() {
      try {
        AgeRangeViewServiceSettings settings =
          AgeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AgeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetServiceClient createAssetServiceClient() {
      try {
        AssetServiceSettings settings =
          AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BatchJobServiceClient createBatchJobServiceClient() {
      try {
        BatchJobServiceSettings settings =
          BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingStrategyServiceClient createBiddingStrategyServiceClient() {
      try {
        BiddingStrategyServiceSettings settings =
          BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingStrategySimulationServiceClient createBiddingStrategySimulationServiceClient() {
      try {
        BiddingStrategySimulationServiceSettings settings =
          BiddingStrategySimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingStrategySimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BillingSetupServiceClient createBillingSetupServiceClient() {
      try {
        BillingSetupServiceSettings settings =
          BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetServiceClient createCampaignAssetServiceClient() {
      try {
        CampaignAssetServiceSettings settings =
          CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAudienceViewServiceClient createCampaignAudienceViewServiceClient() {
      try {
        CampaignAudienceViewServiceSettings settings =
          CampaignAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBidModifierServiceClient createCampaignBidModifierServiceClient() {
      try {
        CampaignBidModifierServiceSettings settings =
          CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBudgetServiceClient createCampaignBudgetServiceClient() {
      try {
        CampaignBudgetServiceSettings settings =
          CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCriterionServiceClient createCampaignCriterionServiceClient() {
      try {
        CampaignCriterionServiceSettings settings =
          CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCriterionSimulationServiceClient createCampaignCriterionSimulationServiceClient(
        ) {
      try {
        CampaignCriterionSimulationServiceSettings settings =
          CampaignCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignDraftServiceClient createCampaignDraftServiceClient() {
      try {
        CampaignDraftServiceSettings settings =
          CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignExperimentServiceClient createCampaignExperimentServiceClient() {
      try {
        CampaignExperimentServiceSettings settings =
          CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient() {
      try {
        CampaignExtensionSettingServiceSettings settings =
          CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignFeedServiceClient createCampaignFeedServiceClient() {
      try {
        CampaignFeedServiceSettings settings =
          CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLabelServiceClient createCampaignLabelServiceClient() {
      try {
        CampaignLabelServiceSettings settings =
          CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignServiceClient createCampaignServiceClient() {
      try {
        CampaignServiceSettings settings =
          CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignSharedSetServiceClient createCampaignSharedSetServiceClient() {
      try {
        CampaignSharedSetServiceSettings settings =
          CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignSimulationServiceClient createCampaignSimulationServiceClient() {
      try {
        CampaignSimulationServiceSettings settings =
          CampaignSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CarrierConstantServiceClient createCarrierConstantServiceClient() {
      try {
        CarrierConstantServiceSettings settings =
          CarrierConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CarrierConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ChangeStatusServiceClient createChangeStatusServiceClient() {
      try {
        ChangeStatusServiceSettings settings =
          ChangeStatusServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ChangeStatusServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ClickViewServiceClient createClickViewServiceClient() {
      try {
        ClickViewServiceSettings settings =
          ClickViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ClickViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CombinedAudienceServiceClient createCombinedAudienceServiceClient() {
      try {
        CombinedAudienceServiceSettings settings =
          CombinedAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CombinedAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionActionServiceClient createConversionActionServiceClient() {
      try {
        ConversionActionServiceSettings settings =
          ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient() {
      try {
        ConversionAdjustmentUploadServiceSettings settings =
          ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient() {
      try {
        ConversionCustomVariableServiceSettings settings =
          ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionUploadServiceClient createConversionUploadServiceClient() {
      try {
        ConversionUploadServiceSettings settings =
          ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CurrencyConstantServiceClient createCurrencyConstantServiceClient() {
      try {
        CurrencyConstantServiceSettings settings =
          CurrencyConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CurrencyConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomAudienceServiceClient createCustomAudienceServiceClient() {
      try {
        CustomAudienceServiceSettings settings =
          CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomInterestServiceClient createCustomInterestServiceClient() {
      try {
        CustomInterestServiceSettings settings =
          CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerAssetServiceClient createCustomerAssetServiceClient() {
      try {
        CustomerAssetServiceSettings settings =
          CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerClientLinkServiceClient createCustomerClientLinkServiceClient() {
      try {
        CustomerClientLinkServiceSettings settings =
          CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerClientServiceClient createCustomerClientServiceClient() {
      try {
        CustomerClientServiceSettings settings =
          CustomerClientServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerClientServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient() {
      try {
        CustomerExtensionSettingServiceSettings settings =
          CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerFeedServiceClient createCustomerFeedServiceClient() {
      try {
        CustomerFeedServiceSettings settings =
          CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLabelServiceClient createCustomerLabelServiceClient() {
      try {
        CustomerLabelServiceSettings settings =
          CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient() {
      try {
        CustomerManagerLinkServiceSettings settings =
          CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient() {
      try {
        CustomerNegativeCriterionServiceSettings settings =
          CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerServiceClient createCustomerServiceClient() {
      try {
        CustomerServiceSettings settings =
          CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        CustomerUserAccessInvitationServiceSettings settings =
          CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessServiceClient createCustomerUserAccessServiceClient() {
      try {
        CustomerUserAccessServiceSettings settings =
          CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DetailPlacementViewServiceClient createDetailPlacementViewServiceClient() {
      try {
        DetailPlacementViewServiceSettings settings =
          DetailPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DetailPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DisplayKeywordViewServiceClient createDisplayKeywordViewServiceClient() {
      try {
        DisplayKeywordViewServiceSettings settings =
          DisplayKeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DisplayKeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DistanceViewServiceClient createDistanceViewServiceClient() {
      try {
        DistanceViewServiceSettings settings =
          DistanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DistanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DomainCategoryServiceClient createDomainCategoryServiceClient() {
      try {
        DomainCategoryServiceSettings settings =
          DomainCategoryServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DomainCategoryServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DynamicSearchAdsSearchTermViewServiceClient createDynamicSearchAdsSearchTermViewServiceClient(
        ) {
      try {
        DynamicSearchAdsSearchTermViewServiceSettings settings =
          DynamicSearchAdsSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DynamicSearchAdsSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExpandedLandingPageViewServiceClient createExpandedLandingPageViewServiceClient() {
      try {
        ExpandedLandingPageViewServiceSettings settings =
          ExpandedLandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExpandedLandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient() {
      try {
        ExtensionFeedItemServiceSettings settings =
          ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemServiceClient createFeedItemServiceClient() {
      try {
        FeedItemServiceSettings settings =
          FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient() {
      try {
        FeedItemSetLinkServiceSettings settings =
          FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetServiceClient createFeedItemSetServiceClient() {
      try {
        FeedItemSetServiceSettings settings =
          FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemTargetServiceClient createFeedItemTargetServiceClient() {
      try {
        FeedItemTargetServiceSettings settings =
          FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedMappingServiceClient createFeedMappingServiceClient() {
      try {
        FeedMappingServiceSettings settings =
          FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedPlaceholderViewServiceClient createFeedPlaceholderViewServiceClient() {
      try {
        FeedPlaceholderViewServiceSettings settings =
          FeedPlaceholderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedPlaceholderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedServiceClient createFeedServiceClient() {
      try {
        FeedServiceSettings settings =
          FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GenderViewServiceClient createGenderViewServiceClient() {
      try {
        GenderViewServiceSettings settings =
          GenderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GenderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GeoTargetConstantServiceClient createGeoTargetConstantServiceClient() {
      try {
        GeoTargetConstantServiceSettings settings =
          GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GeographicViewServiceClient createGeographicViewServiceClient() {
      try {
        GeographicViewServiceSettings settings =
          GeographicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GeographicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient() {
      try {
        GoogleAdsFieldServiceSettings settings =
          GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsServiceClient createGoogleAdsServiceClient() {
      try {
        GoogleAdsServiceSettings settings =
          GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GroupPlacementViewServiceClient createGroupPlacementViewServiceClient() {
      try {
        GroupPlacementViewServiceSettings settings =
          GroupPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GroupPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public HotelGroupViewServiceClient createHotelGroupViewServiceClient() {
      try {
        HotelGroupViewServiceSettings settings =
          HotelGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return HotelGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public HotelPerformanceViewServiceClient createHotelPerformanceViewServiceClient() {
      try {
        HotelPerformanceViewServiceSettings settings =
          HotelPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return HotelPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public IncomeRangeViewServiceClient createIncomeRangeViewServiceClient() {
      try {
        IncomeRangeViewServiceSettings settings =
          IncomeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return IncomeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public InvoiceServiceClient createInvoiceServiceClient() {
      try {
        InvoiceServiceSettings settings =
          InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient() {
      try {
        KeywordPlanAdGroupKeywordServiceSettings settings =
          KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient() {
      try {
        KeywordPlanAdGroupServiceSettings settings =
          KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient() {
      try {
        KeywordPlanCampaignKeywordServiceSettings settings =
          KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient() {
      try {
        KeywordPlanCampaignServiceSettings settings =
          KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient() {
      try {
        KeywordPlanIdeaServiceSettings settings =
          KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanServiceClient createKeywordPlanServiceClient() {
      try {
        KeywordPlanServiceSettings settings =
          KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordViewServiceClient createKeywordViewServiceClient() {
      try {
        KeywordViewServiceSettings settings =
          KeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LabelServiceClient createLabelServiceClient() {
      try {
        LabelServiceSettings settings =
          LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LandingPageViewServiceClient createLandingPageViewServiceClient() {
      try {
        LandingPageViewServiceSettings settings =
          LandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LanguageConstantServiceClient createLanguageConstantServiceClient() {
      try {
        LanguageConstantServiceSettings settings =
          LanguageConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LanguageConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LifeEventServiceClient createLifeEventServiceClient() {
      try {
        LifeEventServiceSettings settings =
          LifeEventServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LifeEventServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LocationViewServiceClient createLocationViewServiceClient() {
      try {
        LocationViewServiceSettings settings =
          LocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ManagedPlacementViewServiceClient createManagedPlacementViewServiceClient() {
      try {
        ManagedPlacementViewServiceSettings settings =
          ManagedPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ManagedPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MediaFileServiceClient createMediaFileServiceClient() {
      try {
        MediaFileServiceSettings settings =
          MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient() {
      try {
        MerchantCenterLinkServiceSettings settings =
          MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MobileAppCategoryConstantServiceClient createMobileAppCategoryConstantServiceClient() {
      try {
        MobileAppCategoryConstantServiceSettings settings =
          MobileAppCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MobileAppCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MobileDeviceConstantServiceClient createMobileDeviceConstantServiceClient() {
      try {
        MobileDeviceConstantServiceSettings settings =
          MobileDeviceConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MobileDeviceConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient() {
      try {
        OfflineUserDataJobServiceSettings settings =
          OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public OperatingSystemVersionConstantServiceClient createOperatingSystemVersionConstantServiceClient(
        ) {
      try {
        OperatingSystemVersionConstantServiceSettings settings =
          OperatingSystemVersionConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return OperatingSystemVersionConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public PaidOrganicSearchTermViewServiceClient createPaidOrganicSearchTermViewServiceClient() {
      try {
        PaidOrganicSearchTermViewServiceSettings settings =
          PaidOrganicSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return PaidOrganicSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ParentalStatusViewServiceClient createParentalStatusViewServiceClient() {
      try {
        ParentalStatusViewServiceSettings settings =
          ParentalStatusViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ParentalStatusViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public PaymentsAccountServiceClient createPaymentsAccountServiceClient() {
      try {
        PaymentsAccountServiceSettings settings =
          PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductBiddingCategoryConstantServiceClient createProductBiddingCategoryConstantServiceClient(
        ) {
      try {
        ProductBiddingCategoryConstantServiceSettings settings =
          ProductBiddingCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductBiddingCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductGroupViewServiceClient createProductGroupViewServiceClient() {
      try {
        ProductGroupViewServiceSettings settings =
          ProductGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ReachPlanServiceClient createReachPlanServiceClient() {
      try {
        ReachPlanServiceSettings settings =
          ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationServiceClient createRecommendationServiceClient() {
      try {
        RecommendationServiceSettings settings =
          RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RemarketingActionServiceClient createRemarketingActionServiceClient() {
      try {
        RemarketingActionServiceSettings settings =
          RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SearchTermViewServiceClient createSearchTermViewServiceClient() {
      try {
        SearchTermViewServiceSettings settings =
          SearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedCriterionServiceClient createSharedCriterionServiceClient() {
      try {
        SharedCriterionServiceSettings settings =
          SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedSetServiceClient createSharedSetServiceClient() {
      try {
        SharedSetServiceSettings settings =
          SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ShoppingPerformanceViewServiceClient createShoppingPerformanceViewServiceClient() {
      try {
        ShoppingPerformanceViewServiceSettings settings =
          ShoppingPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ShoppingPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient() {
      try {
        ThirdPartyAppAnalyticsLinkServiceSettings settings =
          ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public TopicConstantServiceClient createTopicConstantServiceClient() {
      try {
        TopicConstantServiceSettings settings =
          TopicConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return TopicConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public TopicViewServiceClient createTopicViewServiceClient() {
      try {
        TopicViewServiceSettings settings =
          TopicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return TopicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserDataServiceClient createUserDataServiceClient() {
      try {
        UserDataServiceSettings settings =
          UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserInterestServiceClient createUserInterestServiceClient() {
      try {
        UserInterestServiceSettings settings =
          UserInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserListServiceClient createUserListServiceClient() {
      try {
        UserListServiceSettings settings =
          UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserLocationViewServiceClient createUserLocationViewServiceClient() {
      try {
        UserLocationViewServiceSettings settings =
          UserLocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserLocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public VideoServiceClient createVideoServiceClient() {
      try {
        VideoServiceSettings settings =
          VideoServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return VideoServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public WebpageViewServiceClient createWebpageViewServiceClient() {
      try {
        WebpageViewServiceSettings settings =
          WebpageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return WebpageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V8Client implements com.google.ads.googleads.v8.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V8Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public AccessibleBiddingStrategyServiceClient createAccessibleBiddingStrategyServiceClient() {
      try {
        AccessibleBiddingStrategyServiceSettings settings =
          AccessibleBiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccessibleBiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v8.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AccountBudgetServiceClient createAccountBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AccountBudgetServiceSettings settings =
          com.google.ads.googleads.v8.services.AccountBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AccountBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v8.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupAdAssetViewServiceClient createAdGroupAdAssetViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupAdAssetViewServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupAdAssetViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupAdAssetViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupAudienceViewServiceClient createAdGroupAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupAudienceViewServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupCriterionSimulationServiceClient createAdGroupCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupFeedServiceClient createAdGroupFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupFeedServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v8.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdGroupSimulationServiceClient createAdGroupSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdGroupSimulationServiceSettings settings =
          com.google.ads.googleads.v8.services.AdGroupSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdGroupSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v8.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdScheduleViewServiceClient createAdScheduleViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AdScheduleViewServiceSettings settings =
          com.google.ads.googleads.v8.services.AdScheduleViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdScheduleViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v8.services.AdServiceSettings settings =
          com.google.ads.googleads.v8.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AgeRangeViewServiceClient createAgeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.AgeRangeViewServiceSettings settings =
          com.google.ads.googleads.v8.services.AgeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AgeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetFieldTypeViewServiceClient createAssetFieldTypeViewServiceClient() {
      try {
        AssetFieldTypeViewServiceSettings settings =
          AssetFieldTypeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetFieldTypeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v8.services.AssetServiceSettings settings =
          com.google.ads.googleads.v8.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v8.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient() {
      try {
        BiddingDataExclusionServiceSettings settings =
          BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        BiddingSeasonalityAdjustmentServiceSettings settings =
          BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v8.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.BiddingStrategySimulationServiceClient createBiddingStrategySimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.BiddingStrategySimulationServiceSettings settings =
          com.google.ads.googleads.v8.services.BiddingStrategySimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.BiddingStrategySimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v8.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignAudienceViewServiceClient createCampaignAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignAudienceViewServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignCriterionSimulationServiceClient createCampaignCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignExperimentServiceClient createCampaignExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignExperimentServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignFeedServiceClient createCampaignFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignFeedServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CampaignSimulationServiceClient createCampaignSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CampaignSimulationServiceSettings settings =
          com.google.ads.googleads.v8.services.CampaignSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CampaignSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CarrierConstantServiceClient createCarrierConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CarrierConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.CarrierConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CarrierConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ChangeStatusServiceClient createChangeStatusServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ChangeStatusServiceSettings settings =
          com.google.ads.googleads.v8.services.ChangeStatusServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ChangeStatusServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ClickViewServiceClient createClickViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ClickViewServiceSettings settings =
          com.google.ads.googleads.v8.services.ClickViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ClickViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CombinedAudienceServiceClient createCombinedAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CombinedAudienceServiceSettings settings =
          com.google.ads.googleads.v8.services.CombinedAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CombinedAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v8.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v8.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v8.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v8.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleServiceClient createConversionValueRuleServiceClient() {
      try {
        ConversionValueRuleServiceSettings settings =
          ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient() {
      try {
        ConversionValueRuleSetServiceSettings settings =
          ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CurrencyConstantServiceClient createCurrencyConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CurrencyConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.CurrencyConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CurrencyConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerClientServiceClient createCustomerClientServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerClientServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerClientServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerClientServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerFeedServiceClient createCustomerFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerFeedServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v8.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.DetailPlacementViewServiceClient createDetailPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.DetailPlacementViewServiceSettings settings =
          com.google.ads.googleads.v8.services.DetailPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.DetailPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DetailedDemographicServiceClient createDetailedDemographicServiceClient() {
      try {
        DetailedDemographicServiceSettings settings =
          DetailedDemographicServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DetailedDemographicServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.DisplayKeywordViewServiceClient createDisplayKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.DisplayKeywordViewServiceSettings settings =
          com.google.ads.googleads.v8.services.DisplayKeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.DisplayKeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.DistanceViewServiceClient createDistanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.DistanceViewServiceSettings settings =
          com.google.ads.googleads.v8.services.DistanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.DistanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.DomainCategoryServiceClient createDomainCategoryServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.DomainCategoryServiceSettings settings =
          com.google.ads.googleads.v8.services.DomainCategoryServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.DomainCategoryServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.DynamicSearchAdsSearchTermViewServiceClient createDynamicSearchAdsSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.DynamicSearchAdsSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v8.services.DynamicSearchAdsSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.DynamicSearchAdsSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ExpandedLandingPageViewServiceClient createExpandedLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ExpandedLandingPageViewServiceSettings settings =
          com.google.ads.googleads.v8.services.ExpandedLandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ExpandedLandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ExtensionFeedItemServiceSettings settings =
          com.google.ads.googleads.v8.services.ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.FeedItemServiceClient createFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.FeedItemServiceSettings settings =
          com.google.ads.googleads.v8.services.FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.FeedItemSetLinkServiceSettings settings =
          com.google.ads.googleads.v8.services.FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.FeedItemSetServiceClient createFeedItemSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.FeedItemSetServiceSettings settings =
          com.google.ads.googleads.v8.services.FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.FeedItemTargetServiceClient createFeedItemTargetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.FeedItemTargetServiceSettings settings =
          com.google.ads.googleads.v8.services.FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.FeedMappingServiceClient createFeedMappingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.FeedMappingServiceSettings settings =
          com.google.ads.googleads.v8.services.FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.FeedPlaceholderViewServiceClient createFeedPlaceholderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.FeedPlaceholderViewServiceSettings settings =
          com.google.ads.googleads.v8.services.FeedPlaceholderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.FeedPlaceholderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.FeedServiceClient createFeedServiceClient() {
      try {
        com.google.ads.googleads.v8.services.FeedServiceSettings settings =
          com.google.ads.googleads.v8.services.FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.GenderViewServiceClient createGenderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.GenderViewServiceSettings settings =
          com.google.ads.googleads.v8.services.GenderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.GenderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.GeographicViewServiceClient createGeographicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.GeographicViewServiceSettings settings =
          com.google.ads.googleads.v8.services.GeographicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.GeographicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v8.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v8.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.GroupPlacementViewServiceClient createGroupPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.GroupPlacementViewServiceSettings settings =
          com.google.ads.googleads.v8.services.GroupPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.GroupPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.HotelGroupViewServiceClient createHotelGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.HotelGroupViewServiceSettings settings =
          com.google.ads.googleads.v8.services.HotelGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.HotelGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.HotelPerformanceViewServiceClient createHotelPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.HotelPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v8.services.HotelPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.HotelPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.IncomeRangeViewServiceClient createIncomeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.IncomeRangeViewServiceSettings settings =
          com.google.ads.googleads.v8.services.IncomeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.IncomeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v8.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v8.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v8.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v8.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v8.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v8.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v8.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v8.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient() {
      try {
        KeywordThemeConstantServiceSettings settings =
          KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.KeywordViewServiceClient createKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.KeywordViewServiceSettings settings =
          com.google.ads.googleads.v8.services.KeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.KeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v8.services.LabelServiceSettings settings =
          com.google.ads.googleads.v8.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.LandingPageViewServiceClient createLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.LandingPageViewServiceSettings settings =
          com.google.ads.googleads.v8.services.LandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.LandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.LanguageConstantServiceClient createLanguageConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.LanguageConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.LanguageConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.LanguageConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.LifeEventServiceClient createLifeEventServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.LifeEventServiceSettings settings =
          com.google.ads.googleads.v8.services.LifeEventServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.LifeEventServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.LocationViewServiceClient createLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.LocationViewServiceSettings settings =
          com.google.ads.googleads.v8.services.LocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.LocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ManagedPlacementViewServiceClient createManagedPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ManagedPlacementViewServiceSettings settings =
          com.google.ads.googleads.v8.services.ManagedPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ManagedPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.MediaFileServiceClient createMediaFileServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.MediaFileServiceSettings settings =
          com.google.ads.googleads.v8.services.MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.MerchantCenterLinkServiceSettings settings =
          com.google.ads.googleads.v8.services.MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.MobileAppCategoryConstantServiceClient createMobileAppCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.MobileAppCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.MobileAppCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.MobileAppCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.MobileDeviceConstantServiceClient createMobileDeviceConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.MobileDeviceConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.MobileDeviceConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.MobileDeviceConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v8.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.OperatingSystemVersionConstantServiceClient createOperatingSystemVersionConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.OperatingSystemVersionConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.OperatingSystemVersionConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.OperatingSystemVersionConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.PaidOrganicSearchTermViewServiceClient createPaidOrganicSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.PaidOrganicSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v8.services.PaidOrganicSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.PaidOrganicSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ParentalStatusViewServiceClient createParentalStatusViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ParentalStatusViewServiceSettings settings =
          com.google.ads.googleads.v8.services.ParentalStatusViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ParentalStatusViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v8.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ProductBiddingCategoryConstantServiceClient createProductBiddingCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ProductBiddingCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.ProductBiddingCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ProductBiddingCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ProductGroupViewServiceClient createProductGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ProductGroupViewServiceSettings settings =
          com.google.ads.googleads.v8.services.ProductGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ProductGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v8.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v8.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v8.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.SearchTermViewServiceClient createSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.SearchTermViewServiceSettings settings =
          com.google.ads.googleads.v8.services.SearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.SearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v8.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v8.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ShoppingPerformanceViewServiceClient createShoppingPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ShoppingPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v8.services.ShoppingPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ShoppingPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSearchTermViewServiceClient createSmartCampaignSearchTermViewServiceClient(
        ) {
      try {
        SmartCampaignSearchTermViewServiceSettings settings =
          SmartCampaignSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient() {
      try {
        SmartCampaignSettingServiceSettings settings =
          SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient() {
      try {
        SmartCampaignSuggestServiceSettings settings =
          SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v8.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.TopicConstantServiceClient createTopicConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.TopicConstantServiceSettings settings =
          com.google.ads.googleads.v8.services.TopicConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.TopicConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.TopicViewServiceClient createTopicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.TopicViewServiceSettings settings =
          com.google.ads.googleads.v8.services.TopicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.TopicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v8.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.UserInterestServiceClient createUserInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.UserInterestServiceSettings settings =
          com.google.ads.googleads.v8.services.UserInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.UserInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.UserListServiceSettings settings =
          com.google.ads.googleads.v8.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.UserLocationViewServiceClient createUserLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.UserLocationViewServiceSettings settings =
          com.google.ads.googleads.v8.services.UserLocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.UserLocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.VideoServiceClient createVideoServiceClient() {
      try {
        com.google.ads.googleads.v8.services.VideoServiceSettings settings =
          com.google.ads.googleads.v8.services.VideoServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.VideoServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v8.services.WebpageViewServiceClient createWebpageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v8.services.WebpageViewServiceSettings settings =
          com.google.ads.googleads.v8.services.WebpageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v8.services.WebpageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V9Client implements com.google.ads.googleads.v9.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V9Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v9.services.AccessibleBiddingStrategyServiceClient createAccessibleBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AccessibleBiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v9.services.AccessibleBiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AccessibleBiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v9.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AccountBudgetServiceClient createAccountBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AccountBudgetServiceSettings settings =
          com.google.ads.googleads.v9.services.AccountBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AccountBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient() {
      try {
        AdGroupCriterionCustomizerServiceSettings settings =
          AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient() {
      try {
        AdGroupCustomizerServiceSettings settings =
          AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupAssetServiceClient createAssetGroupAssetServiceClient() {
      try {
        AssetGroupAssetServiceSettings settings =
          AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        AssetGroupListingGroupFilterServiceSettings settings =
          AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupServiceClient createAssetGroupServiceClient() {
      try {
        AssetGroupServiceSettings settings =
          AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetAssetServiceClient createAssetSetAssetServiceClient() {
      try {
        AssetSetAssetServiceSettings settings =
          AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetServiceClient createAssetSetServiceClient() {
      try {
        AssetSetServiceSettings settings =
          AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetSetServiceClient createCampaignAssetSetServiceClient() {
      try {
        CampaignAssetSetServiceSettings settings =
          CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient() {
      try {
        CampaignConversionGoalServiceSettings settings =
          CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCustomizerServiceClient createCampaignCustomizerServiceClient() {
      try {
        CampaignCustomizerServiceSettings settings =
          CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        ConversionGoalCampaignConfigServiceSettings settings =
          ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomConversionGoalServiceClient createCustomConversionGoalServiceClient() {
      try {
        CustomConversionGoalServiceSettings settings =
          CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v9.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupAdAssetViewServiceClient createAdGroupAdAssetViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupAdAssetViewServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupAdAssetViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupAdAssetViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupAudienceViewServiceClient createAdGroupAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupAudienceViewServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupCriterionSimulationServiceClient createAdGroupCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupFeedServiceClient createAdGroupFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupFeedServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v9.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdGroupSimulationServiceClient createAdGroupSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdGroupSimulationServiceSettings settings =
          com.google.ads.googleads.v9.services.AdGroupSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdGroupSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v9.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdScheduleViewServiceClient createAdScheduleViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AdScheduleViewServiceSettings settings =
          com.google.ads.googleads.v9.services.AdScheduleViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdScheduleViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v9.services.AdServiceSettings settings =
          com.google.ads.googleads.v9.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AgeRangeViewServiceClient createAgeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AgeRangeViewServiceSettings settings =
          com.google.ads.googleads.v9.services.AgeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AgeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AssetFieldTypeViewServiceClient createAssetFieldTypeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.AssetFieldTypeViewServiceSettings settings =
          com.google.ads.googleads.v9.services.AssetFieldTypeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AssetFieldTypeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v9.services.AssetServiceSettings settings =
          com.google.ads.googleads.v9.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v9.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v9.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v9.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v9.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.BiddingStrategySimulationServiceClient createBiddingStrategySimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.BiddingStrategySimulationServiceSettings settings =
          com.google.ads.googleads.v9.services.BiddingStrategySimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.BiddingStrategySimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v9.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignAudienceViewServiceClient createCampaignAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignAudienceViewServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignCriterionSimulationServiceClient createCampaignCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignExperimentServiceClient createCampaignExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignExperimentServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignFeedServiceClient createCampaignFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignFeedServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CampaignSimulationServiceClient createCampaignSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CampaignSimulationServiceSettings settings =
          com.google.ads.googleads.v9.services.CampaignSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CampaignSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CarrierConstantServiceClient createCarrierConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CarrierConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.CarrierConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CarrierConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ChangeStatusServiceClient createChangeStatusServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ChangeStatusServiceSettings settings =
          com.google.ads.googleads.v9.services.ChangeStatusServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ChangeStatusServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ClickViewServiceClient createClickViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ClickViewServiceSettings settings =
          com.google.ads.googleads.v9.services.ClickViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ClickViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CombinedAudienceServiceClient createCombinedAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CombinedAudienceServiceSettings settings =
          com.google.ads.googleads.v9.services.CombinedAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CombinedAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v9.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v9.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v9.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v9.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v9.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v9.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CurrencyConstantServiceClient createCurrencyConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CurrencyConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.CurrencyConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CurrencyConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerClientServiceClient createCustomerClientServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerClientServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerClientServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerClientServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerFeedServiceClient createCustomerFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerFeedServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v9.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.DetailPlacementViewServiceClient createDetailPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.DetailPlacementViewServiceSettings settings =
          com.google.ads.googleads.v9.services.DetailPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.DetailPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.DetailedDemographicServiceClient createDetailedDemographicServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.DetailedDemographicServiceSettings settings =
          com.google.ads.googleads.v9.services.DetailedDemographicServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.DetailedDemographicServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.DisplayKeywordViewServiceClient createDisplayKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.DisplayKeywordViewServiceSettings settings =
          com.google.ads.googleads.v9.services.DisplayKeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.DisplayKeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.DistanceViewServiceClient createDistanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.DistanceViewServiceSettings settings =
          com.google.ads.googleads.v9.services.DistanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.DistanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.DomainCategoryServiceClient createDomainCategoryServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.DomainCategoryServiceSettings settings =
          com.google.ads.googleads.v9.services.DomainCategoryServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.DomainCategoryServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.DynamicSearchAdsSearchTermViewServiceClient createDynamicSearchAdsSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.DynamicSearchAdsSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v9.services.DynamicSearchAdsSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.DynamicSearchAdsSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ExpandedLandingPageViewServiceClient createExpandedLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ExpandedLandingPageViewServiceSettings settings =
          com.google.ads.googleads.v9.services.ExpandedLandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ExpandedLandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ExtensionFeedItemServiceSettings settings =
          com.google.ads.googleads.v9.services.ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.FeedItemServiceClient createFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.FeedItemServiceSettings settings =
          com.google.ads.googleads.v9.services.FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.FeedItemSetLinkServiceSettings settings =
          com.google.ads.googleads.v9.services.FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.FeedItemSetServiceClient createFeedItemSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.FeedItemSetServiceSettings settings =
          com.google.ads.googleads.v9.services.FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.FeedItemTargetServiceClient createFeedItemTargetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.FeedItemTargetServiceSettings settings =
          com.google.ads.googleads.v9.services.FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.FeedMappingServiceClient createFeedMappingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.FeedMappingServiceSettings settings =
          com.google.ads.googleads.v9.services.FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.FeedPlaceholderViewServiceClient createFeedPlaceholderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.FeedPlaceholderViewServiceSettings settings =
          com.google.ads.googleads.v9.services.FeedPlaceholderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.FeedPlaceholderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.FeedServiceClient createFeedServiceClient() {
      try {
        com.google.ads.googleads.v9.services.FeedServiceSettings settings =
          com.google.ads.googleads.v9.services.FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.GenderViewServiceClient createGenderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.GenderViewServiceSettings settings =
          com.google.ads.googleads.v9.services.GenderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.GenderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.GeographicViewServiceClient createGeographicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.GeographicViewServiceSettings settings =
          com.google.ads.googleads.v9.services.GeographicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.GeographicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v9.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v9.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.GroupPlacementViewServiceClient createGroupPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.GroupPlacementViewServiceSettings settings =
          com.google.ads.googleads.v9.services.GroupPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.GroupPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.HotelGroupViewServiceClient createHotelGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.HotelGroupViewServiceSettings settings =
          com.google.ads.googleads.v9.services.HotelGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.HotelGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.HotelPerformanceViewServiceClient createHotelPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.HotelPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v9.services.HotelPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.HotelPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.IncomeRangeViewServiceClient createIncomeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.IncomeRangeViewServiceSettings settings =
          com.google.ads.googleads.v9.services.IncomeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.IncomeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v9.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v9.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v9.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v9.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v9.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v9.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v9.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v9.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.KeywordViewServiceClient createKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.KeywordViewServiceSettings settings =
          com.google.ads.googleads.v9.services.KeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.KeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v9.services.LabelServiceSettings settings =
          com.google.ads.googleads.v9.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.LandingPageViewServiceClient createLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.LandingPageViewServiceSettings settings =
          com.google.ads.googleads.v9.services.LandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.LandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.LanguageConstantServiceClient createLanguageConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.LanguageConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.LanguageConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.LanguageConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.LifeEventServiceClient createLifeEventServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.LifeEventServiceSettings settings =
          com.google.ads.googleads.v9.services.LifeEventServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.LifeEventServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.LocationViewServiceClient createLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.LocationViewServiceSettings settings =
          com.google.ads.googleads.v9.services.LocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.LocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ManagedPlacementViewServiceClient createManagedPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ManagedPlacementViewServiceSettings settings =
          com.google.ads.googleads.v9.services.ManagedPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ManagedPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.MediaFileServiceClient createMediaFileServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.MediaFileServiceSettings settings =
          com.google.ads.googleads.v9.services.MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.MerchantCenterLinkServiceSettings settings =
          com.google.ads.googleads.v9.services.MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.MobileAppCategoryConstantServiceClient createMobileAppCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.MobileAppCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.MobileAppCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.MobileAppCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.MobileDeviceConstantServiceClient createMobileDeviceConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.MobileDeviceConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.MobileDeviceConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.MobileDeviceConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v9.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.OperatingSystemVersionConstantServiceClient createOperatingSystemVersionConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.OperatingSystemVersionConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.OperatingSystemVersionConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.OperatingSystemVersionConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.PaidOrganicSearchTermViewServiceClient createPaidOrganicSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.PaidOrganicSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v9.services.PaidOrganicSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.PaidOrganicSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ParentalStatusViewServiceClient createParentalStatusViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ParentalStatusViewServiceSettings settings =
          com.google.ads.googleads.v9.services.ParentalStatusViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ParentalStatusViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v9.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ProductBiddingCategoryConstantServiceClient createProductBiddingCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ProductBiddingCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.ProductBiddingCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ProductBiddingCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ProductGroupViewServiceClient createProductGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ProductGroupViewServiceSettings settings =
          com.google.ads.googleads.v9.services.ProductGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ProductGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v9.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v9.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v9.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.SearchTermViewServiceClient createSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.SearchTermViewServiceSettings settings =
          com.google.ads.googleads.v9.services.SearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.SearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v9.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v9.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ShoppingPerformanceViewServiceClient createShoppingPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ShoppingPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v9.services.ShoppingPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ShoppingPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.SmartCampaignSearchTermViewServiceClient createSmartCampaignSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.SmartCampaignSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v9.services.SmartCampaignSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.SmartCampaignSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v9.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v9.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v9.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.TopicConstantServiceClient createTopicConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.TopicConstantServiceSettings settings =
          com.google.ads.googleads.v9.services.TopicConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.TopicConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.TopicViewServiceClient createTopicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.TopicViewServiceSettings settings =
          com.google.ads.googleads.v9.services.TopicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.TopicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v9.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.UserInterestServiceClient createUserInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.UserInterestServiceSettings settings =
          com.google.ads.googleads.v9.services.UserInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.UserInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.UserListServiceSettings settings =
          com.google.ads.googleads.v9.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.UserLocationViewServiceClient createUserLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.UserLocationViewServiceSettings settings =
          com.google.ads.googleads.v9.services.UserLocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.UserLocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.VideoServiceClient createVideoServiceClient() {
      try {
        com.google.ads.googleads.v9.services.VideoServiceSettings settings =
          com.google.ads.googleads.v9.services.VideoServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.VideoServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v9.services.WebpageViewServiceClient createWebpageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v9.services.WebpageViewServiceSettings settings =
          com.google.ads.googleads.v9.services.WebpageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v9.services.WebpageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient() {
      try {
        CustomerConversionGoalServiceSettings settings =
          CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerCustomizerServiceClient createCustomerCustomizerServiceClient() {
      try {
        CustomerCustomizerServiceSettings settings =
          CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomizerAttributeServiceClient createCustomizerAttributeServiceClient() {
      try {
        CustomizerAttributeServiceSettings settings =
          CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
}
