/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.stubs.callables;

import com.google.ads.googleads.lib.stubs.callables.ExceptionTransformation;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;

public class ExceptionTransformingServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;
    private final ExceptionTransformation exceptionTransformation;

    public ExceptionTransformingServerStreamingCallable(ServerStreamingCallable<RequestT, ResponseT> innerCallable, ExceptionTransformation exceptionTransformation) {
        this.innerCallable = innerCallable;
        this.exceptionTransformation = exceptionTransformation;
    }

    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        this.innerCallable.call(request, (ResponseObserver)new ExceptionTransformingStreamObserver(responseObserver), context);
    }

    private class ExceptionTransformingStreamObserver
    implements ResponseObserver<ResponseT> {
        private final ResponseObserver<ResponseT> innerObserver;

        public ExceptionTransformingStreamObserver(ResponseObserver<ResponseT> innerObserver) {
            this.innerObserver = innerObserver;
        }

        public void onStart(StreamController controller) {
            this.innerObserver.onStart(controller);
        }

        public void onResponse(ResponseT response) {
            this.innerObserver.onResponse(response);
        }

        public void onError(Throwable t) {
            if (t instanceof ApiException) {
                t = ExceptionTransformingServerStreamingCallable.this.exceptionTransformation.transform(t);
            }
            this.innerObserver.onError(t);
        }

        public void onComplete() {
            this.innerObserver.onComplete();
        }
    }
}

