/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.google.adk.tools.mcp.McpTransportBuilder;
import com.google.adk.tools.mcp.SseServerParameters;
import com.google.adk.tools.mcp.StreamableHttpServerParameters;
import com.google.common.collect.ImmutableMap;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.client.transport.HttpClientStreamableHttpTransport;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.client.transport.StdioClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import java.util.Collection;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class DefaultMcpTransportBuilder
implements McpTransportBuilder {
    @Override
    public McpClientTransport build(Object connectionParams) {
        if (connectionParams instanceof ServerParameters) {
            ServerParameters serverParameters = (ServerParameters)connectionParams;
            return new StdioClientTransport(serverParameters);
        }
        if (connectionParams instanceof SseServerParameters) {
            SseServerParameters sseServerParams = (SseServerParameters)connectionParams;
            return HttpClientSseClientTransport.builder((String)sseServerParams.url()).sseEndpoint(sseServerParams.sseEndpoint() == null ? "sse" : sseServerParams.sseEndpoint()).customizeRequest(builder -> Optional.ofNullable(sseServerParams.headers()).map(ImmutableMap::entrySet).stream().flatMap(Collection::stream).forEach(entry -> builder.header((String)entry.getKey(), Optional.ofNullable(entry.getValue()).map(Object::toString).orElse("")))).build();
        }
        if (connectionParams instanceof StreamableHttpServerParameters) {
            StreamableHttpServerParameters streamableParams = (StreamableHttpServerParameters)connectionParams;
            return HttpClientStreamableHttpTransport.builder((String)streamableParams.url()).connectTimeout(streamableParams.timeout()).asyncHttpRequestCustomizer((builder, method, uri, body) -> {
                streamableParams.headers().forEach((key, value) -> builder.header((String)key, (String)value));
                return Mono.just((Object)builder);
            }).build();
        }
        throw new IllegalArgumentException("DefaultMcpTransportBuilder supports only ServerParameters, SseServerParameters, or StreamableHttpServerParameters, but got " + connectionParams.getClass().getName());
    }
}

