/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.applicationintegrationtoolset;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.tools.applicationintegrationtoolset.IntegrationConnectorTool;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConnectionsClient {
    private final String project;
    private final String location;
    private final String connection;
    private static final String CONNECTOR_URL = "https://connectors.googleapis.com";
    private final IntegrationConnectorTool.HttpExecutor httpExecutor;
    private final ObjectMapper objectMapper;

    public ConnectionsClient(String project, String location, String connection, IntegrationConnectorTool.HttpExecutor httpExecutor, ObjectMapper objectMapper) {
        this.project = project;
        this.location = location;
        this.connection = connection;
        this.httpExecutor = httpExecutor;
        this.objectMapper = objectMapper;
    }

    public ConnectionDetails getConnectionDetails() throws IOException, InterruptedException {
        String url = String.format("%s/v1/projects/%s/locations/%s/connections/%s?view=BASIC", CONNECTOR_URL, this.project, this.location, this.connection);
        HttpResponse<String> response = this.executeApiCall(url);
        Map<String, Object> connectionData = this.parseJson(response.body());
        ConnectionDetails details = new ConnectionDetails();
        details.name = (String)connectionData.getOrDefault("name", "");
        details.serviceName = (String)connectionData.getOrDefault("serviceDirectory", "");
        details.host = (String)connectionData.getOrDefault("host", "");
        if (details.host != null && !details.host.isEmpty()) {
            details.serviceName = (String)connectionData.getOrDefault("tlsServiceDirectory", "");
        }
        return details;
    }

    public EntitySchemaAndOperations getEntitySchemaAndOperations(String entity) throws IOException, InterruptedException {
        String url = String.format("%s/v1/projects/%s/locations/%s/connections/%s/connectionSchemaMetadata:getEntityType?entityId=%s", CONNECTOR_URL, this.project, this.location, this.connection, entity);
        HttpResponse<String> initialResponse = this.executeApiCall(url);
        String operationId = (String)this.parseJson(initialResponse.body()).get("name");
        if (Strings.isNullOrEmpty((String)operationId)) {
            throw new IOException("Failed to get operation ID for entity: " + entity);
        }
        Map<String, Object> operationResponse = this.pollOperation(operationId);
        Map responseData = (Map)operationResponse.getOrDefault("response", ImmutableMap.of());
        Map schema = (Map)responseData.getOrDefault("jsonSchema", ImmutableMap.of());
        List operations = (List)responseData.getOrDefault("operations", ImmutableList.of());
        EntitySchemaAndOperations entitySchemaAndOperations = new EntitySchemaAndOperations();
        entitySchemaAndOperations.schema = schema;
        entitySchemaAndOperations.operations = operations;
        return entitySchemaAndOperations;
    }

    public ActionSchema getActionSchema(String action) throws IOException, InterruptedException {
        String url = String.format("%s/v1/projects/%s/locations/%s/connections/%s/connectionSchemaMetadata:getAction?actionId=%s", CONNECTOR_URL, this.project, this.location, this.connection, action);
        HttpResponse<String> initialResponse = this.executeApiCall(url);
        String operationId = (String)this.parseJson(initialResponse.body()).get("name");
        if (Strings.isNullOrEmpty((String)operationId)) {
            throw new IOException("Failed to get operation ID for action: " + action);
        }
        Map<String, Object> operationResponse = this.pollOperation(operationId);
        Map responseData = (Map)operationResponse.getOrDefault("response", ImmutableMap.of());
        ActionSchema actionSchema = new ActionSchema();
        actionSchema.inputSchema = (Map)responseData.getOrDefault("inputJsonSchema", ImmutableMap.of());
        actionSchema.outputSchema = (Map)responseData.getOrDefault("outputJsonSchema", ImmutableMap.of());
        actionSchema.description = responseData.getOrDefault("description", "");
        actionSchema.displayName = responseData.getOrDefault("displayName", "");
        return actionSchema;
    }

    private HttpResponse<String> executeApiCall(String url) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.httpExecutor.getToken()).GET().build();
        HttpResponse<String> response = this.httpExecutor.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() >= 400) {
            String body = response.body();
            if (response.statusCode() == 400 || response.statusCode() == 404) {
                throw new IllegalArgumentException(String.format("Invalid request. Please check the provided values of project(%s), location(%s), connection(%s). Error: %s", this.project, this.location, this.connection, body));
            }
            if (response.statusCode() == 401 || response.statusCode() == 403) {
                throw new SecurityException(String.format("Permission error (status %d): %s", response.statusCode(), body));
            }
            throw new IOException(String.format("API call failed with status %d: %s", response.statusCode(), body));
        }
        return response;
    }

    private Map<String, Object> pollOperation(String operationId) throws IOException, InterruptedException {
        boolean operationDone = false;
        Map<String, Object> operationResponse = null;
        while (!operationDone) {
            String getOperationUrl = String.format("%s/v1/%s", CONNECTOR_URL, operationId);
            HttpResponse<String> response = this.executeApiCall(getOperationUrl);
            operationResponse = this.parseJson(response.body());
            Object doneObj = operationResponse.get("done");
            if (doneObj instanceof Boolean) {
                Boolean b = (Boolean)doneObj;
                operationDone = b;
            }
            if (operationDone) continue;
            Thread.sleep(1000L);
        }
        return operationResponse;
    }

    public Map<String, Object> convertJsonSchemaToOpenApiSchema(Map<String, Object> jsonSchema) {
        HashMap<String, Object> openapiSchema = new HashMap<String, Object>();
        if (jsonSchema.containsKey("description")) {
            openapiSchema.put("description", jsonSchema.get("description"));
        }
        if (jsonSchema.containsKey("type")) {
            Object type = jsonSchema.get("type");
            if (type instanceof List) {
                List typeList = (List)type;
                if (typeList.contains("null")) {
                    openapiSchema.put("nullable", true);
                    typeList.stream().filter(t -> t instanceof String && !t.equals("null")).findFirst().ifPresent(t -> openapiSchema.put("type", t));
                } else if (!typeList.isEmpty()) {
                    openapiSchema.put("type", typeList.get(0));
                }
            } else {
                openapiSchema.put("type", type);
            }
        }
        if (Objects.equals(openapiSchema.get("type"), "object") && jsonSchema.containsKey("properties")) {
            Map properties = (Map)jsonSchema.get("properties");
            HashMap<String, Map<String, Object>> convertedProperties = new HashMap<String, Map<String, Object>>();
            for (Map.Entry entry : properties.entrySet()) {
                convertedProperties.put((String)entry.getKey(), this.convertJsonSchemaToOpenApiSchema((Map)entry.getValue()));
            }
            openapiSchema.put("properties", convertedProperties);
        } else if (Objects.equals(openapiSchema.get("type"), "array") && jsonSchema.containsKey("items")) {
            Map itemsSchema = (Map)jsonSchema.get("items");
            openapiSchema.put("items", this.convertJsonSchemaToOpenApiSchema(itemsSchema));
        }
        return openapiSchema;
    }

    public Map<String, Object> connectorPayload(Map<String, Object> jsonSchema) {
        return this.convertJsonSchemaToOpenApiSchema(jsonSchema);
    }

    private Map<String, Object> parseJson(String json) throws IOException {
        return (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static ImmutableMap<String, Object> getConnectorBaseSpec() {
        return ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("openapi", "3.0.1"), Map.entry("info", ImmutableMap.of((Object)"title", (Object)"ExecuteConnection", (Object)"description", (Object)"This tool can execute a query on connection", (Object)"version", (Object)"4")), Map.entry("servers", ImmutableList.of((Object)ImmutableMap.of((Object)"url", (Object)"https://integrations.googleapis.com"))), Map.entry("security", ImmutableList.of((Object)ImmutableMap.of((Object)"google_auth", (Object)ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform")))), Map.entry("paths", ImmutableMap.of()), Map.entry("components", ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("schemas", ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("operation", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"LIST_ENTITIES", (Object)"description", (Object)"Operation to execute. Possible values are LIST_ENTITIES, GET_ENTITY, CREATE_ENTITY, UPDATE_ENTITY, DELETE_ENTITY in case of entities. EXECUTE_ACTION in case of actions. and EXECUTE_QUERY in case of custom queries.")), Map.entry("entityId", ImmutableMap.of((Object)"type", (Object)"string", (Object)"description", (Object)"Name of the entity")), Map.entry("connectorInputPayload", ImmutableMap.of((Object)"type", (Object)"object")), Map.entry("filterClause", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"", (Object)"description", (Object)"WHERE clause in SQL query")), Map.entry("pageSize", ImmutableMap.of((Object)"type", (Object)"integer", (Object)"default", (Object)50, (Object)"description", (Object)"Number of entities to return in the response")), Map.entry("pageToken", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"", (Object)"description", (Object)"Page token to return the next page of entities")), Map.entry("connectionName", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"", (Object)"description", (Object)"Connection resource name to run the query for")), Map.entry("serviceName", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"", (Object)"description", (Object)"Service directory for the connection")), Map.entry("host", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"", (Object)"description", (Object)"Host name incase of tls service directory")), Map.entry("entity", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"Issues", (Object)"description", (Object)"Entity to run the query for")), Map.entry("action", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"ExecuteCustomQuery", (Object)"description", (Object)"Action to run the query for")), Map.entry("query", ImmutableMap.of((Object)"type", (Object)"string", (Object)"default", (Object)"", (Object)"description", (Object)"Custom Query to execute on the connection")), Map.entry("timeout", ImmutableMap.of((Object)"type", (Object)"integer", (Object)"default", (Object)120, (Object)"description", (Object)"Timeout in seconds for execution of custom query")), Map.entry("sortByColumns", ImmutableMap.of((Object)"type", (Object)"array", (Object)"items", (Object)ImmutableMap.of((Object)"type", (Object)"string"), (Object)"default", (Object)ImmutableList.of(), (Object)"description", (Object)"Column to sort the results by")), Map.entry("connectorOutputPayload", ImmutableMap.of((Object)"type", (Object)"object")), Map.entry("nextPageToken", ImmutableMap.of((Object)"type", (Object)"string")), Map.entry("execute-connector_Response", ImmutableMap.of((Object)"required", (Object)ImmutableList.of((Object)"connectorOutputPayload"), (Object)"type", (Object)"object", (Object)"properties", (Object)ImmutableMap.of((Object)"connectorOutputPayload", (Object)ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/connectorOutputPayload"), (Object)"nextPageToken", (Object)ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/nextPageToken"))))})), Map.entry("securitySchemes", ImmutableMap.of((Object)"google_auth", (Object)ImmutableMap.of((Object)"type", (Object)"oauth2", (Object)"flows", (Object)ImmutableMap.of((Object)"implicit", (Object)ImmutableMap.of((Object)"authorizationUrl", (Object)"https://accounts.google.com/o/oauth2/auth", (Object)"scopes", (Object)ImmutableMap.of((Object)"https://www.googleapis.com/auth/cloud-platform", (Object)"Auth for google cloud services"))))))}))});
    }

    public static ImmutableMap<String, Object> getActionOperation(String action, String operation, String actionDisplayName, String toolName, String toolInstructions) {
        String description = "Use this tool to execute " + action;
        if (Objects.equals(operation, "EXECUTE_QUERY")) {
            description = description + " Use pageSize = 50 and timeout = 120 until user specifies a different value otherwise. If user provides a query in natural language, convert it to SQL query and then execute it using the tool.";
        }
        return ImmutableMap.of((Object)"post", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("summary", actionDisplayName), Map.entry("description", description + " " + toolInstructions), Map.entry("operationId", toolName + "_" + actionDisplayName), Map.entry("x-action", action), Map.entry("x-operation", operation), Map.entry("requestBody", ImmutableMap.of((Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)String.format("#/components/schemas/%s_Request", actionDisplayName)))))), Map.entry("responses", ImmutableMap.of((Object)"200", (Object)ImmutableMap.of((Object)"description", (Object)"Success response", (Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)String.format("#/components/schemas/%s_Response", actionDisplayName)))))))}));
    }

    public static ImmutableMap<String, Object> listOperation(String entity, String schemaAsString, String toolName, String toolInstructions) {
        return ImmutableMap.of((Object)"post", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("summary", "List " + entity), Map.entry("description", String.format("Returns the list of %s data. If the page token was available in the response, let users know there are more records available. Ask if the user wants to fetch the next page of results. When passing filter use the following format: `field_name1='value1' AND field_name2='value2'`. %s", entity, toolInstructions)), Map.entry("x-operation", "LIST_ENTITIES"), Map.entry("x-entity", entity), Map.entry("operationId", toolName + "_list_" + entity), Map.entry("requestBody", ImmutableMap.of((Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/list_" + entity + "_Request")))))), Map.entry("responses", ImmutableMap.of((Object)"200", (Object)ImmutableMap.of((Object)"description", (Object)"Success response", (Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"description", (Object)String.format("Returns a list of %s of json schema: %s", entity, schemaAsString), (Object)"$ref", (Object)"#/components/schemas/execute-connector_Response"))))))}));
    }

    public static ImmutableMap<String, Object> getOperation(String entity, String schemaAsString, String toolName, String toolInstructions) {
        return ImmutableMap.of((Object)"post", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("summary", "Get " + entity), Map.entry("description", String.format("Returns the details of the %s. %s", entity, toolInstructions)), Map.entry("operationId", toolName + "_get_" + entity), Map.entry("x-operation", "GET_ENTITY"), Map.entry("x-entity", entity), Map.entry("requestBody", ImmutableMap.of((Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/get_" + entity + "_Request")))))), Map.entry("responses", ImmutableMap.of((Object)"200", (Object)ImmutableMap.of((Object)"description", (Object)"Success response", (Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"description", (Object)String.format("Returns %s of json schema: %s", entity, schemaAsString), (Object)"$ref", (Object)"#/components/schemas/execute-connector_Response"))))))}));
    }

    public static ImmutableMap<String, Object> createOperation(String entity, String toolName, String toolInstructions) {
        return ImmutableMap.of((Object)"post", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("summary", "Creates a new " + entity), Map.entry("description", String.format("Creates a new %s. %s", entity, toolInstructions)), Map.entry("x-operation", "CREATE_ENTITY"), Map.entry("x-entity", entity), Map.entry("operationId", toolName + "_create_" + entity), Map.entry("requestBody", ImmutableMap.of((Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/create_" + entity + "_Request")))))), Map.entry("responses", ImmutableMap.of((Object)"200", (Object)ImmutableMap.of((Object)"description", (Object)"Success response", (Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/execute-connector_Response"))))))}));
    }

    public static ImmutableMap<String, Object> updateOperation(String entity, String toolName, String toolInstructions) {
        return ImmutableMap.of((Object)"post", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("summary", "Updates the " + entity), Map.entry("description", String.format("Updates the %s. %s", entity, toolInstructions)), Map.entry("x-operation", "UPDATE_ENTITY"), Map.entry("x-entity", entity), Map.entry("operationId", toolName + "_update_" + entity), Map.entry("requestBody", ImmutableMap.of((Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/update_" + entity + "_Request")))))), Map.entry("responses", ImmutableMap.of((Object)"200", (Object)ImmutableMap.of((Object)"description", (Object)"Success response", (Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/execute-connector_Response"))))))}));
    }

    public static ImmutableMap<String, Object> deleteOperation(String entity, String toolName, String toolInstructions) {
        return ImmutableMap.of((Object)"post", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("summary", "Delete the " + entity), Map.entry("description", String.format("Deletes the %s. %s", entity, toolInstructions)), Map.entry("x-operation", "DELETE_ENTITY"), Map.entry("x-entity", entity), Map.entry("operationId", toolName + "_delete_" + entity), Map.entry("requestBody", ImmutableMap.of((Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/delete_" + entity + "_Request")))))), Map.entry("responses", ImmutableMap.of((Object)"200", (Object)ImmutableMap.of((Object)"description", (Object)"Success response", (Object)"content", (Object)ImmutableMap.of((Object)"application/json", (Object)ImmutableMap.of((Object)"schema", (Object)ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/execute-connector_Response"))))))}));
    }

    public static ImmutableMap<String, Object> createOperationRequest(String entity) {
        return ImmutableMap.of((Object)"type", (Object)"object", (Object)"required", (Object)ImmutableList.of((Object)"connectorInputPayload", (Object)"operation", (Object)"connectionName", (Object)"serviceName", (Object)"host", (Object)"entity"), (Object)"properties", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("connectorInputPayload", ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/connectorInputPayload_" + entity))), Map.entry("operation", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/operation")), Map.entry("connectionName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/connectionName")), Map.entry("serviceName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/serviceName")), Map.entry("host", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/host")), Map.entry("entity", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/entity"))}));
    }

    public static ImmutableMap<String, Object> updateOperationRequest(String entity) {
        return ImmutableMap.of((Object)"type", (Object)"object", (Object)"required", (Object)ImmutableList.of((Object)"connectorInputPayload", (Object)"entityId", (Object)"operation", (Object)"connectionName", (Object)"serviceName", (Object)"host", (Object)"entity"), (Object)"properties", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("connectorInputPayload", ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/connectorInputPayload_" + entity))), Map.entry("entityId", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/entityId")), Map.entry("operation", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/operation")), Map.entry("connectionName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/connectionName")), Map.entry("serviceName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/serviceName")), Map.entry("host", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/host")), Map.entry("entity", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/entity")), Map.entry("filterClause", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/filterClause"))}));
    }

    public static ImmutableMap<String, Object> getOperationRequest() {
        return ImmutableMap.of((Object)"type", (Object)"object", (Object)"required", (Object)ImmutableList.of((Object)"entityId", (Object)"operation", (Object)"connectionName", (Object)"serviceName", (Object)"host", (Object)"entity"), (Object)"properties", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("entityId", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/entityId")), Map.entry("operation", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/operation")), Map.entry("connectionName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/connectionName")), Map.entry("serviceName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/serviceName")), Map.entry("host", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/host")), Map.entry("entity", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/entity"))}));
    }

    public static ImmutableMap<String, Object> deleteOperationRequest() {
        return ImmutableMap.of((Object)"type", (Object)"object", (Object)"required", (Object)ImmutableList.of((Object)"entityId", (Object)"operation", (Object)"connectionName", (Object)"serviceName", (Object)"host", (Object)"entity"), (Object)"properties", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("entityId", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/entityId")), Map.entry("operation", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/operation")), Map.entry("connectionName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/connectionName")), Map.entry("serviceName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/serviceName")), Map.entry("host", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/host")), Map.entry("entity", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/entity")), Map.entry("filterClause", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/filterClause"))}));
    }

    public static ImmutableMap<String, Object> listOperationRequest() {
        return ImmutableMap.of((Object)"type", (Object)"object", (Object)"required", (Object)ImmutableList.of((Object)"operation", (Object)"connectionName", (Object)"serviceName", (Object)"host", (Object)"entity"), (Object)"properties", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("filterClause", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/filterClause")), Map.entry("pageSize", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/pageSize")), Map.entry("pageToken", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/pageToken")), Map.entry("operation", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/operation")), Map.entry("connectionName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/connectionName")), Map.entry("serviceName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/serviceName")), Map.entry("host", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/host")), Map.entry("entity", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/entity")), Map.entry("sortByColumns", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/sortByColumns"))}));
    }

    public static ImmutableMap<String, Object> actionRequest(String action) {
        return ImmutableMap.of((Object)"type", (Object)"object", (Object)"required", (Object)ImmutableList.of((Object)"operation", (Object)"connectionName", (Object)"serviceName", (Object)"host", (Object)"action", (Object)"connectorInputPayload"), (Object)"properties", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("operation", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/operation")), Map.entry("connectionName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/connectionName")), Map.entry("serviceName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/serviceName")), Map.entry("host", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/host")), Map.entry("action", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/action")), Map.entry("connectorInputPayload", ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/connectorInputPayload_" + action)))}));
    }

    public static ImmutableMap<String, Object> actionResponse(String action) {
        return ImmutableMap.of((Object)"type", (Object)"object", (Object)"properties", (Object)ImmutableMap.of((Object)"connectorOutputPayload", (Object)ImmutableMap.of((Object)"$ref", (Object)("#/components/schemas/connectorOutputPayload_" + action))));
    }

    public static ImmutableMap<String, Object> executeCustomQueryRequest() {
        return ImmutableMap.of((Object)"type", (Object)"object", (Object)"required", (Object)ImmutableList.of((Object)"operation", (Object)"connectionName", (Object)"serviceName", (Object)"host", (Object)"action", (Object)"query", (Object)"timeout", (Object)"pageSize"), (Object)"properties", (Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("operation", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/operation")), Map.entry("connectionName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/connectionName")), Map.entry("serviceName", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/serviceName")), Map.entry("host", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/host")), Map.entry("action", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/action")), Map.entry("query", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/query")), Map.entry("timeout", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/timeout")), Map.entry("pageSize", ImmutableMap.of((Object)"$ref", (Object)"#/components/schemas/pageSize"))}));
    }

    public static class ConnectionDetails {
        public String name;
        public String serviceName;
        public String host;
    }

    public static class EntitySchemaAndOperations {
        public Map<String, Object> schema;
        public List<String> operations;
    }

    public static class ActionSchema {
        public Map<String, Object> inputSchema;
        public Map<String, Object> outputSchema;
        public String description;
        public String displayName;
    }
}

