/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.codeexecutors;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.google.adk.agents.InvocationContext;
import com.google.adk.codeexecutors.BaseCodeExecutor;
import com.google.adk.codeexecutors.CodeExecutionUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerCodeExecutor
extends BaseCodeExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ContainerCodeExecutor.class);
    private static final String DEFAULT_IMAGE_TAG = "adk-code-executor:latest";
    private final Optional<String> baseUrl;
    private final String image;
    private final Optional<String> dockerPath;
    private final DockerClient dockerClient;
    private Container container;

    public ContainerCodeExecutor(Optional<String> baseUrl, Optional<String> image, Optional<String> dockerPath) {
        if (image.isEmpty() && dockerPath.isEmpty()) {
            throw new IllegalArgumentException("Either image or dockerPath must be set for ContainerCodeExecutor.");
        }
        this.baseUrl = baseUrl;
        this.image = image.orElse(DEFAULT_IMAGE_TAG);
        this.dockerPath = dockerPath.map(p -> Paths.get(p, new String[0]).toAbsolutePath().toString());
        if (baseUrl.isPresent()) {
            DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(baseUrl.get()).build();
            this.dockerClient = DockerClientBuilder.getInstance((DockerClientConfig)config).build();
        } else {
            this.dockerClient = DockerClientBuilder.getInstance().build();
        }
        this.initContainer();
        Runtime.getRuntime().addShutdownHook(new Thread(this::cleanupContainer));
    }

    @Override
    public boolean stateful() {
        return false;
    }

    @Override
    public boolean optimizeDataFile() {
        return false;
    }

    @Override
    public CodeExecutionUtils.CodeExecutionResult executeCode(InvocationContext invocationContext, CodeExecutionUtils.CodeExecutionInput codeExecutionInput) {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(this.container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"python3", "-c", codeExecutionInput.code()}).exec();
        try {
            ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)new ExecStartResultCallback((OutputStream)stdout, (OutputStream)stderr))).awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Code execution was interrupted.", e);
        }
        return CodeExecutionUtils.CodeExecutionResult.builder().stdout(stdout.toString(StandardCharsets.UTF_8)).stderr(stderr.toString(StandardCharsets.UTF_8)).build();
    }

    private void buildDockerImage() {
        if (this.dockerPath.isEmpty()) {
            throw new IllegalStateException("Docker path is not set.");
        }
        File dockerfile = new File(this.dockerPath.get());
        if (!dockerfile.exists()) {
            throw new UncheckedIOException(new IOException("Invalid Docker path: " + this.dockerPath.get()));
        }
        logger.info("Building Docker image...");
        try {
            this.dockerClient.buildImageCmd(dockerfile).withTag(this.image).start().awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Docker image build was interrupted.", e);
        }
        logger.info("Docker image: {} built.", (Object)this.image);
    }

    private void verifyPythonInstallation() {
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(this.container.getId()).withCmd(new String[]{"which", "python3"}).exec();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        try (ExecStartResultCallback callback = new ExecStartResultCallback((OutputStream)stdout, (OutputStream)stderr);){
            ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)callback)).awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Python verification was interrupted.", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void initContainer() {
        if (this.dockerClient == null) {
            throw new IllegalStateException("Docker client is not initialized.");
        }
        if (this.dockerPath.isPresent()) {
            this.buildDockerImage();
        } else {
            logger.info("Ensuring image {} is available locally...", (Object)this.image);
            try {
                this.dockerClient.pullImageCmd(this.image).start().awaitCompletion();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Docker image pull was interrupted.", e);
            }
            logger.info("Image {} is available.", (Object)this.image);
        }
        logger.info("Starting container for ContainerCodeExecutor...");
        CreateContainerResponse createContainerResponse = this.dockerClient.createContainerCmd(this.image).withTty(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)).exec();
        this.dockerClient.startContainerCmd(createContainerResponse.getId()).exec();
        List containers = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        this.container = containers.stream().filter(c -> c.getId().equals(createContainerResponse.getId())).findFirst().orElseThrow(() -> new IllegalStateException("Failed to find the created container."));
        logger.info("Container {} started.", (Object)this.container.getId());
        this.verifyPythonInstallation();
    }

    private void cleanupContainer() {
        if (this.container == null) {
            return;
        }
        logger.info("[Cleanup] Stopping the container...");
        this.dockerClient.stopContainerCmd(this.container.getId()).exec();
        this.dockerClient.removeContainerCmd(this.container.getId()).exec();
        logger.info("Container {} stopped and removed.", (Object)this.container.getId());
        try {
            this.dockerClient.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close docker client", (Throwable)e);
        }
    }
}

