/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.artifacts;

import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.artifacts.ListArtifactsResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;

public final class InMemoryArtifactService
implements BaseArtifactService {
    private final Map<String, Map<String, Map<String, Map<String, List<Part>>>>> artifacts = new HashMap<String, Map<String, Map<String, Map<String, List<Part>>>>>();

    @Override
    public Single<Integer> saveArtifact(String appName, String userId, String sessionId, String filename, Part artifact) {
        List versions = this.artifacts.computeIfAbsent(appName, k -> new HashMap()).computeIfAbsent(userId, k -> new HashMap()).computeIfAbsent(sessionId, k -> new HashMap()).computeIfAbsent(filename, k -> new ArrayList());
        versions.add(artifact);
        return Single.just((Object)(versions.size() - 1));
    }

    @Override
    public Maybe<Part> loadArtifact(String appName, String userId, String sessionId, String filename, Optional<Integer> version) {
        List versions = ((Map)((Map)((Map)this.artifacts.getOrDefault(appName, new HashMap())).getOrDefault(userId, new HashMap())).getOrDefault(sessionId, new HashMap())).getOrDefault(filename, new ArrayList());
        if (versions.isEmpty()) {
            return Maybe.empty();
        }
        if (version.isPresent()) {
            int v = version.get();
            if (v >= 0 && v < versions.size()) {
                return Maybe.just((Object)((Part)versions.get(v)));
            }
            return Maybe.empty();
        }
        return Maybe.fromOptional((Optional)Streams.findLast(versions.stream()));
    }

    @Override
    public Single<ListArtifactsResponse> listArtifactKeys(String appName, String userId, String sessionId) {
        return Single.just((Object)ListArtifactsResponse.builder().filenames((List<String>)ImmutableList.copyOf(((Map)((Map)((Map)this.artifacts.getOrDefault(appName, new HashMap())).getOrDefault(userId, new HashMap())).getOrDefault(sessionId, new HashMap())).keySet())).build());
    }

    @Override
    public Completable deleteArtifact(String appName, String userId, String sessionId, String filename) {
        ((Map)((Map)((Map)this.artifacts.getOrDefault(appName, new HashMap())).getOrDefault(userId, new HashMap())).getOrDefault(sessionId, new HashMap())).remove(filename);
        return Completable.complete();
    }

    @Override
    public Single<ImmutableList<Integer>> listVersions(String appName, String userId, String sessionId, String filename) {
        int size = ((List)((Map)((Map)((Map)this.artifacts.getOrDefault(appName, new HashMap())).getOrDefault(userId, new HashMap())).getOrDefault(sessionId, new HashMap())).getOrDefault(filename, new ArrayList())).size();
        if (size == 0) {
            return Single.just((Object)ImmutableList.of());
        }
        return Single.just((Object)((ImmutableList)IntStream.range(0, size).boxed().collect(ImmutableList.toImmutableList())));
    }
}

