/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.adk.tools;

/** Exits the loop. */
public final class ExitLoopTool {
  public static void exitLoop(ToolContext toolContext) {
    // Exits the loop.
    // Call this function only when you are instructed to do so.
    // TODO: b/414077461 - EventActions mutable, instead of autovalue.
    toolContext.setActions(toolContext.actions().toBuilder().escalate(true).build());
  }

  private ExitLoopTool() {}
}
