package com.google.adk.sessions;

import com.google.adk.events.Event;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ListEventsResponse extends ListEventsResponse {

  private final ImmutableList<Event> events;

  private final Optional<String> nextPageToken;

  private AutoValue_ListEventsResponse(
      ImmutableList<Event> events,
      Optional<String> nextPageToken) {
    this.events = events;
    this.nextPageToken = nextPageToken;
  }

  @Override
  public ImmutableList<Event> events() {
    return events;
  }

  @Override
  public Optional<String> nextPageToken() {
    return nextPageToken;
  }

  @Override
  public String toString() {
    return "ListEventsResponse{"
        + "events=" + events + ", "
        + "nextPageToken=" + nextPageToken
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ListEventsResponse) {
      ListEventsResponse that = (ListEventsResponse) o;
      return this.events.equals(that.events())
          && this.nextPageToken.equals(that.nextPageToken());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= events.hashCode();
    h$ *= 1000003;
    h$ ^= nextPageToken.hashCode();
    return h$;
  }

  static final class Builder extends ListEventsResponse.Builder {
    private ImmutableList<Event> events;
    private Optional<String> nextPageToken = Optional.empty();
    Builder() {
    }
    @Override
    public ListEventsResponse.Builder events(List<Event> events) {
      this.events = ImmutableList.copyOf(events);
      return this;
    }
    @Override
    public ListEventsResponse.Builder nextPageToken(String nextPageToken) {
      this.nextPageToken = Optional.of(nextPageToken);
      return this;
    }
    @Override
    public ListEventsResponse build() {
      if (this.events == null) {
        String missing = " events";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ListEventsResponse(
          this.events,
          this.nextPageToken);
    }
  }

}
