package com.google.adk.agents;

import com.google.common.collect.ImmutableList;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.Modality;
import com.google.genai.types.SpeechConfig;
import javax.annotation.processing.Generated;
import org.jspecify.annotations.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RunConfig extends RunConfig {

  private final @Nullable SpeechConfig speechConfig;

  private final ImmutableList<Modality> responseModalities;

  private final boolean saveInputBlobsAsArtifacts;

  private final RunConfig.StreamingMode streamingMode;

  private final @Nullable AudioTranscriptionConfig outputAudioTranscription;

  private final int maxLlmCalls;

  private AutoValue_RunConfig(
      @Nullable SpeechConfig speechConfig,
      ImmutableList<Modality> responseModalities,
      boolean saveInputBlobsAsArtifacts,
      RunConfig.StreamingMode streamingMode,
      @Nullable AudioTranscriptionConfig outputAudioTranscription,
      int maxLlmCalls) {
    this.speechConfig = speechConfig;
    this.responseModalities = responseModalities;
    this.saveInputBlobsAsArtifacts = saveInputBlobsAsArtifacts;
    this.streamingMode = streamingMode;
    this.outputAudioTranscription = outputAudioTranscription;
    this.maxLlmCalls = maxLlmCalls;
  }

  @Override
  public @Nullable SpeechConfig speechConfig() {
    return speechConfig;
  }

  @Override
  public ImmutableList<Modality> responseModalities() {
    return responseModalities;
  }

  @Override
  public boolean saveInputBlobsAsArtifacts() {
    return saveInputBlobsAsArtifacts;
  }

  @Override
  public RunConfig.StreamingMode streamingMode() {
    return streamingMode;
  }

  @Override
  public @Nullable AudioTranscriptionConfig outputAudioTranscription() {
    return outputAudioTranscription;
  }

  @Override
  public int maxLlmCalls() {
    return maxLlmCalls;
  }

  @Override
  public String toString() {
    return "RunConfig{"
        + "speechConfig=" + speechConfig + ", "
        + "responseModalities=" + responseModalities + ", "
        + "saveInputBlobsAsArtifacts=" + saveInputBlobsAsArtifacts + ", "
        + "streamingMode=" + streamingMode + ", "
        + "outputAudioTranscription=" + outputAudioTranscription + ", "
        + "maxLlmCalls=" + maxLlmCalls
        + "}";
  }

  @Override
  public boolean equals(@Nullable Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RunConfig) {
      RunConfig that = (RunConfig) o;
      return (this.speechConfig == null ? that.speechConfig() == null : this.speechConfig.equals(that.speechConfig()))
          && this.responseModalities.equals(that.responseModalities())
          && this.saveInputBlobsAsArtifacts == that.saveInputBlobsAsArtifacts()
          && this.streamingMode.equals(that.streamingMode())
          && (this.outputAudioTranscription == null ? that.outputAudioTranscription() == null : this.outputAudioTranscription.equals(that.outputAudioTranscription()))
          && this.maxLlmCalls == that.maxLlmCalls();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (speechConfig == null) ? 0 : speechConfig.hashCode();
    h$ *= 1000003;
    h$ ^= responseModalities.hashCode();
    h$ *= 1000003;
    h$ ^= saveInputBlobsAsArtifacts ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= streamingMode.hashCode();
    h$ *= 1000003;
    h$ ^= (outputAudioTranscription == null) ? 0 : outputAudioTranscription.hashCode();
    h$ *= 1000003;
    h$ ^= maxLlmCalls;
    return h$;
  }

  static final class Builder extends RunConfig.Builder {
    private @Nullable SpeechConfig speechConfig;
    private @Nullable ImmutableList<Modality> responseModalities;
    private boolean saveInputBlobsAsArtifacts;
    private RunConfig.@Nullable StreamingMode streamingMode;
    private @Nullable AudioTranscriptionConfig outputAudioTranscription;
    private int maxLlmCalls;
    private byte set$0;
    Builder() {
    }
    @Override
    public RunConfig.Builder setSpeechConfig(SpeechConfig speechConfig) {
      this.speechConfig = speechConfig;
      return this;
    }
    @Override
    public RunConfig.Builder setResponseModalities(Iterable<Modality> responseModalities) {
      this.responseModalities = ImmutableList.copyOf(responseModalities);
      return this;
    }
    @Override
    public RunConfig.Builder setSaveInputBlobsAsArtifacts(boolean saveInputBlobsAsArtifacts) {
      this.saveInputBlobsAsArtifacts = saveInputBlobsAsArtifacts;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public RunConfig.Builder setStreamingMode(RunConfig.StreamingMode streamingMode) {
      if (streamingMode == null) {
        throw new NullPointerException("Null streamingMode");
      }
      this.streamingMode = streamingMode;
      return this;
    }
    @Override
    public RunConfig.Builder setOutputAudioTranscription(AudioTranscriptionConfig outputAudioTranscription) {
      this.outputAudioTranscription = outputAudioTranscription;
      return this;
    }
    @Override
    public RunConfig.Builder setMaxLlmCalls(int maxLlmCalls) {
      this.maxLlmCalls = maxLlmCalls;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    RunConfig autoBuild() {
      if (set$0 != 3
          || this.responseModalities == null
          || this.streamingMode == null) {
        StringBuilder missing = new StringBuilder();
        if (this.responseModalities == null) {
          missing.append(" responseModalities");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" saveInputBlobsAsArtifacts");
        }
        if (this.streamingMode == null) {
          missing.append(" streamingMode");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" maxLlmCalls");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RunConfig(
          this.speechConfig,
          this.responseModalities,
          this.saveInputBlobsAsArtifacts,
          this.streamingMode,
          this.outputAudioTranscription,
          this.maxLlmCalls);
    }
  }

}
