/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.models.LlmRequest;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GoogleSearch;
import com.google.genai.types.GoogleSearchRetrieval;
import com.google.genai.types.Tool;
import io.reactivex.rxjava3.core.Completable;
import java.util.List;

public final class GoogleSearchTool
extends BaseTool {
    public GoogleSearchTool() {
        super("google_search", "google_search");
    }

    @Override
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        GenerateContentConfig.Builder configBuilder = llmRequestBuilder.build().config().map(GenerateContentConfig::toBuilder).orElse(GenerateContentConfig.builder());
        List existingTools = (List)configBuilder.build().tools().orElse(ImmutableList.of());
        ImmutableList.Builder updatedToolsBuilder = ImmutableList.builder();
        updatedToolsBuilder.addAll((Iterable)existingTools);
        String model = llmRequestBuilder.build().model().get();
        if (model != null && model.startsWith("gemini-1")) {
            if (!updatedToolsBuilder.build().isEmpty()) {
                System.out.println(configBuilder.build().tools().get());
                return Completable.error((Throwable)new IllegalArgumentException("Google search tool cannot be used with other tools in Gemini 1.x."));
            }
            updatedToolsBuilder.add((Object)Tool.builder().googleSearchRetrieval(GoogleSearchRetrieval.builder().build()).build());
            configBuilder.tools((List)updatedToolsBuilder.build());
        } else if (model != null && model.startsWith("gemini-2")) {
            updatedToolsBuilder.add((Object)Tool.builder().googleSearch(GoogleSearch.builder().build()).build());
            configBuilder.tools((List)updatedToolsBuilder.build());
        } else {
            return Completable.error((Throwable)new IllegalArgumentException("Google search tool is not supported for model " + model));
        }
        llmRequestBuilder.config(configBuilder.build());
        return Completable.complete();
    }
}

