/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.google.common.collect.ImmutableList;
import com.google.genai.types.Blob;
import com.google.genai.types.Content;
import com.google.genai.types.Part;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;

public final class SessionUtils {
    public static Content encodeContent(Content content) {
        ArrayList<Part> encodedParts = new ArrayList<Part>();
        for (Part part : (List)content.parts().orElse(ImmutableList.of())) {
            Blob inlineDataBlob;
            Optional dataOptional;
            Optional inlineDataOptional;
            boolean isInlineDataPresent = false;
            if (part.inlineData() != null && (inlineDataOptional = part.inlineData()).isPresent() && (dataOptional = (inlineDataBlob = (Blob)inlineDataOptional.get()).data()).isPresent()) {
                byte[] dataBytes = (byte[])dataOptional.get();
                byte[] encodedData = Base64.getEncoder().encode(dataBytes);
                encodedParts.add(part.toBuilder().inlineData(Blob.builder().data(encodedData).build()).build());
                isInlineDataPresent = true;
            }
            if (isInlineDataPresent) continue;
            encodedParts.add(part);
        }
        return Content.builder().parts(encodedParts).build();
    }

    public static Content decodeContent(Content content) {
        ArrayList<Part> decodedParts = new ArrayList<Part>();
        for (Part part : (List)content.parts().orElse(ImmutableList.of())) {
            Blob inlineDataBlob;
            Optional dataOptional;
            Optional inlineDataOptional;
            boolean isInlineDataPresent = false;
            if (part.inlineData() != null && (inlineDataOptional = part.inlineData()).isPresent() && (dataOptional = (inlineDataBlob = (Blob)inlineDataOptional.get()).data()).isPresent()) {
                byte[] dataBytes = (byte[])dataOptional.get();
                byte[] decodedData = Base64.getDecoder().decode(dataBytes);
                decodedParts.add(part.toBuilder().inlineData(Blob.builder().data(decodedData).build()).build());
                isInlineDataPresent = true;
            }
            if (isInlineDataPresent) continue;
            decodedParts.add(part);
        }
        return Content.builder().parts(decodedParts).build();
    }
}

