/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.events.Event;
import com.google.adk.flows.llmflows.RequestProcessor;
import com.google.adk.models.LlmRequest;
import com.google.adk.sessions.Session;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Instructions
implements RequestProcessor {
    private static final Pattern INSTRUCTION_PATTERN = Pattern.compile("\\{+[^\\{\\}]*\\}+");

    @Override
    public Single<RequestProcessor.RequestProcessingResult> processRequest(InvocationContext context, LlmRequest request) {
        LlmAgent rootAgent;
        if (!(context.agent() instanceof LlmAgent)) {
            throw new IllegalArgumentException("Agent in InvocationContext is not an instance of Agent.");
        }
        LlmAgent agent = (LlmAgent)context.agent();
        LlmRequest.Builder builder = request.toBuilder();
        if (agent.rootAgent() instanceof LlmAgent && (rootAgent = (LlmAgent)agent.rootAgent()).globalInstruction().isPresent()) {
            builder.appendInstructions((List<String>)ImmutableList.of((Object)this.buildSystemInstruction(context, rootAgent.globalInstruction().get())));
        }
        if (agent.instruction().isPresent()) {
            builder.appendInstructions((List<String>)ImmutableList.of((Object)this.buildSystemInstruction(context, agent.instruction().get())));
        }
        return Single.just((Object)RequestProcessor.RequestProcessingResult.create(builder.build(), (Iterable<Event>)ImmutableList.of()));
    }

    private String buildSystemInstruction(InvocationContext context, String instructionTemplate) {
        StringBuffer builder = new StringBuffer();
        Matcher matcher = INSTRUCTION_PATTERN.matcher(instructionTemplate);
        while (matcher.find()) {
            String placeholder = matcher.group();
            String varName = matcher.group();
            varName = varName.replaceAll("^\\{+", "").replaceAll("\\}+$", "").trim();
            boolean optional = false;
            if (varName.endsWith("?")) {
                optional = true;
                varName = varName.substring(0, varName.length() - 1);
            }
            if (varName.startsWith("artifact.")) {
                varName = varName.substring("artifact.".length());
                Session session = context.session();
                Part artifact = (Part)context.artifactService().loadArtifact(session.appName(), session.userId(), session.id(), varName, Optional.empty()).blockingGet(null);
                if (artifact == null) {
                    throw new IllegalArgumentException(String.format("Artifact %s not found.", varName));
                }
                matcher.appendReplacement(builder, Matcher.quoteReplacement(artifact.toString()));
                continue;
            }
            if (!this.isValidStateName(varName)) {
                matcher.appendReplacement(builder, Matcher.quoteReplacement(placeholder));
                continue;
            }
            if (context.session().state().containsKey(varName)) {
                Object value = context.session().state().get(varName);
                matcher.appendReplacement(builder, Matcher.quoteReplacement(String.valueOf(value)));
                continue;
            }
            if (optional) {
                matcher.appendReplacement(builder, "");
                continue;
            }
            throw new IllegalArgumentException(String.format("Context variable not found: `%s`.", varName));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private boolean isValidStateName(String varName) {
        if (varName.isEmpty()) {
            return false;
        }
        String[] parts = varName.split(":", 2);
        if (parts.length == 1) {
            return this.isValidIdentifier(parts[0]);
        }
        if (parts.length == 2) {
            String prefixPart = parts[0] + ":";
            ImmutableSet validPrefixes = ImmutableSet.of((Object)"app:", (Object)"user:", (Object)"temp:");
            if (validPrefixes.contains((Object)prefixPart)) {
                return this.isValidIdentifier(parts[1]);
            }
        }
        return false;
    }

    private boolean isValidIdentifier(String s) {
        if (s.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

