/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach;

import com.gluonhq.attach.AttachService;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AttachServiceDefinition {
    private String name;
    private AttachService service;

    AttachServiceDefinition(String name) {
        this.name = name;
        try {
            this.service = AttachService.valueOf(name.replace('-', '_').toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            String services = Stream.of(AttachService.values()).map(AttachService::getServiceName).collect(Collectors.joining(", "));
            throw new RuntimeException("Invalid name for Attach service: " + name + " from list of services: " + services, e);
        }
    }

    AttachService getService() {
        return this.service;
    }

    String getSupportedPlatform(String target) {
        switch (target) {
            case "host": 
            case "linux-aarch64": {
                return this.getService().isDesktopSupported() ? "desktop" : "";
            }
            case "ios": 
            case "ios-sim": {
                return this.getService().isIosSupported() ? "ios" : "";
            }
            case "android": {
                return this.getService().isAndroidSupported() ? "android" : "";
            }
        }
        throw new RuntimeException("No valid target found for " + target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachServiceDefinition that = (AttachServiceDefinition)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

