/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach.util;

import com.gluonhq.attach.util.impl.DefaultServiceFactory;
import com.gluonhq.attach.util.impl.ServiceFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class Services<T> {
    private static final Logger LOGGER = Logger.getLogger(Services.class.getName());
    private static final Map<Class, ServiceFactory> FACTORY_MAP = new HashMap<Class, ServiceFactory>();
    private static final Map<Class, Object> SERVICE_MAP = new HashMap<Class, Object>();

    private Services() {
    }

    public static <T> void registerServiceFactory(ServiceFactory<T> factory) {
        LOGGER.fine("Register " + factory);
        FACTORY_MAP.put(factory.getServiceType(), factory);
    }

    public static <T> Optional<T> get(Class<T> service) {
        LOGGER.fine("Get Service " + service.getName());
        if (!FACTORY_MAP.containsKey(service)) {
            ServiceFactory<T> factory = Services.getFactory(service);
            if (factory != null) {
                Services.registerServiceFactory(factory);
            } else {
                throw new RuntimeException("The service " + service.getSimpleName() + " can't be registered. Call Services.registerServiceFactory() with a valid ServiceFactory");
            }
        }
        if (!SERVICE_MAP.containsKey(service)) {
            FACTORY_MAP.get(service).getInstance().ifPresent(t -> SERVICE_MAP.put(service, t));
        }
        LOGGER.fine("Return service: " + SERVICE_MAP.get(service));
        return Optional.ofNullable(SERVICE_MAP.get(service));
    }

    private static <T> ServiceFactory<T> getFactory(Class<T> service) {
        return new DefaultServiceFactory<T>(service);
    }
}

