/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.IconLoader;
import java.awt.Component;
import java.awt.Graphics;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public abstract class LazyIcon
implements Icon,
UIResource {
    private static final Logger LOGGER = Logger.getLogger(LazyIcon.class.getName());
    protected final String path;
    protected final IconLoader.IconKey key;
    protected final Class<?> parentClass;
    private boolean loaded;
    private Icon icon;

    public LazyIcon(String path, IconLoader.IconKey key, Class<?> parentClass) {
        this.path = path;
        this.key = key;
        this.parentClass = parentClass;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.ensureLoaded();
        this.icon.paintIcon(c, g, x, y);
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            LOGGER.fine(() -> "Loading icon '" + this.path + "'. Resolving from " + this.parentClass);
            this.icon = this.loadIcon();
            this.loaded = true;
            if (this.icon == null) {
                throw new IllegalStateException("Could not load icon '" + this.path + "'");
            }
            this.key.w = this.icon.getIconWidth();
            this.key.h = this.icon.getIconHeight();
        }
    }

    protected abstract Icon loadIcon();

    @Override
    public int getIconWidth() {
        this.ensureLoaded();
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        this.ensureLoaded();
        return this.icon.getIconHeight();
    }
}

