/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.Pair;
import com.kitfox.svg.Defs;
import com.kitfox.svg.LinearGradient;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.Stop;
import com.kitfox.svg.app.beans.SVGIcon;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public final class IconColorMapper {
    private static final Logger LOGGER = Logger.getLogger(IconLoader.class.getName());
    private static final Color FALLBACK_COLOR = Color.RED;

    public static void patchColors(SVGIcon svgIcon) {
        SVGUniverse universe = svgIcon.getSvgUniverse();
        SVGDiagram diagram = universe.getDiagram(svgIcon.getSvgURI());
        try {
            IconColorMapper.loadColors(diagram);
        }
        catch (SVGElementException e) {
            LOGGER.log(Level.SEVERE, "Failed patching colors. " + e.getMessage(), e.getStackTrace());
        }
    }

    private static void loadColors(SVGDiagram diagram) throws SVGElementException {
        SVGRoot root = diagram.getRoot();
        SVGElement defs = diagram.getElement("colors");
        if (defs == null) {
            return;
        }
        List children = defs.getChildren(null);
        root.removeChild(defs);
        Defs themedDefs = new Defs();
        themedDefs.addAttribute("id", 1, "colors");
        root.loaderAddChild(null, (SVGElement)themedDefs);
        for (Object child : children) {
            if (!(child instanceof LinearGradient)) continue;
            String id = ((LinearGradient)child).getId();
            String[] fallbacks = IconColorMapper.getFallbacks((LinearGradient)child);
            Color c = IconColorMapper.resolveColor(id, fallbacks, FALLBACK_COLOR);
            Pair<LinearGradient, Runnable> result = IconColorMapper.createColor(c, id);
            LinearGradient gradient = (LinearGradient)result.getFirst();
            Runnable finalizer = (Runnable)result.getSecond();
            themedDefs.loaderAddChild(null, (SVGElement)gradient);
            finalizer.run();
        }
    }

    private static Color resolveColor(String key, String[] fallbacks, Color fallbackColor) {
        Color color = UIManager.getColor(key);
        for (int i = 0; i < fallbacks.length && color == null; ++i) {
            color = UIManager.getColor(fallbacks[i]);
        }
        if (color == null) {
            color = fallbackColor;
            LOGGER.warning("Could not load color with id'" + key + "' fallbacks" + Arrays.toString(fallbacks) + " Using color " + fallbackColor + " instead.");
        }
        return color;
    }

    private static String[] getFallbacks(LinearGradient child) {
        StyleAttribute attribute = new StyleAttribute();
        attribute.setName("fallback");
        try {
            child.getStyle(attribute);
        }
        catch (SVGException e) {
            return new String[0];
        }
        return attribute.getStringList();
    }

    private static Pair<LinearGradient, Runnable> createColor(Color c, String name) throws SVGElementException {
        LinearGradient grad = new LinearGradient();
        grad.addAttribute("id", 1, name);
        return new Pair((Object)grad, () -> {
            Stop stop1 = new Stop();
            Stop stop2 = new Stop();
            String color = IconColorMapper.toHexString(c);
            try {
                stop1.addAttribute("stop-color", 1, color);
                stop1.addAttribute("offset", 1, "0");
                stop2.addAttribute("stop-color", 1, color);
                stop2.addAttribute("offset", 1, "1");
                grad.loaderAddChild(null, (SVGElement)stop1);
                grad.loaderAddChild(null, (SVGElement)stop2);
            }
            catch (SVGElementException e) {
                e.printStackTrace();
            }
        });
    }

    private static String toHexString(Color color) {
        return "#" + ColorUtil.toHex((Color)color);
    }
}

