/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.p2.maven;

import com.github.veithen.cosmos.p2.maven.P2Coordinate;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;

public final class ArtifactCoordinateMapper {
    private ArtifactCoordinateMapper() {
    }

    public static Artifact createArtifact(P2Coordinate p2Coordinate) {
        String classifier;
        String artifactId;
        String id = p2Coordinate.getId();
        if (id.endsWith(".source")) {
            artifactId = id.substring(0, id.length() - 7);
            classifier = "sources";
        } else {
            artifactId = id;
            classifier = null;
        }
        Version version = p2Coordinate.getVersion();
        return new DefaultArtifact(p2Coordinate.getClassifier(), artifactId, classifier, "jar", version == null ? "" : version.toString());
    }

    public static P2Coordinate createP2Coordinate(Artifact artifact) {
        Version version;
        String id;
        String classifier = artifact.getClassifier();
        if (classifier.isEmpty()) {
            id = artifact.getArtifactId();
        } else if (classifier.equals("sources")) {
            id = artifact.getArtifactId() + ".source";
        } else {
            return null;
        }
        try {
            version = Version.create((String)artifact.getVersion());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        return new P2Coordinate(artifact.getGroupId(), id, version);
    }

    public static ArtifactKeyQuery createArtifactKeyQuery(String groupId, String artifactId) {
        return new ArtifactKeyQuery(groupId, artifactId, null);
    }
}

