/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.service.log;

import com.github.veithen.cosmos.osgi.service.log.LogLevel;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LoggerConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLogger
implements org.osgi.service.log.Logger {
    private final Logger logger;
    private final String prefix;

    AbstractLogger(Bundle bundle, String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.prefix = String.format("[%s] ", bundle.getSymbolicName());
    }

    public String getName() {
        return this.logger.getName();
    }

    private void log(LogLevel level, String message) {
        level.log(this.logger, this.prefix + message, null);
    }

    protected abstract void formatAndLog(Logger var1, LogLevel var2, String var3, String var4, Object[] var5, Throwable var6);

    private void internalLog(LogLevel level, String format, Object ... arguments) {
        int removeArgs = 0;
        ServiceReference sr = null;
        Throwable t = null;
        if (arguments.length > 0) {
            Object arg = arguments[arguments.length - 1];
            if (arg instanceof Throwable) {
                ++removeArgs;
                t = (Throwable)arg;
                if (arguments.length > 1 && (arg = arguments[arguments.length - 2]) instanceof ServiceReference) {
                    ++removeArgs;
                    sr = (ServiceReference)arg;
                }
            } else if (arg instanceof ServiceReference) {
                ++removeArgs;
                sr = (ServiceReference)arg;
                if (arguments.length > 1 && (arg = arguments[arguments.length - 2]) instanceof Throwable) {
                    ++removeArgs;
                    t = (Throwable)arg;
                }
            }
        }
        String prefix = this.prefix;
        if (sr != null) {
            prefix = prefix + "[" + sr.getProperty("service.id") + "] ";
        }
        if (removeArgs == arguments.length) {
            level.log(this.logger, prefix + format, t);
        } else {
            if (removeArgs > 0) {
                Object[] newArguments = new Object[arguments.length - removeArgs];
                System.arraycopy(arguments, 0, newArguments, 0, newArguments.length);
                arguments = newArguments;
            }
            this.formatAndLog(this.logger, level, prefix, format, arguments, t);
        }
    }

    void log(LogLevel level, String format, Object ... arguments) {
        if (level.isEnabled(this.logger)) {
            this.internalLog(level, format, arguments);
        }
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String message) {
        if (this.logger.isTraceEnabled()) {
            this.log(LogLevel.TRACE, message);
        }
    }

    public void trace(String format, Object arg) {
        if (this.logger.isTraceEnabled()) {
            this.internalLog(LogLevel.TRACE, format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.isTraceEnabled()) {
            this.internalLog(LogLevel.TRACE, format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            this.internalLog(LogLevel.TRACE, format, arguments);
        }
    }

    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        if (this.logger.isTraceEnabled()) {
            consumer.accept((org.osgi.service.log.Logger)this);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String message) {
        if (this.logger.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, message);
        }
    }

    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            this.internalLog(LogLevel.DEBUG, format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            this.internalLog(LogLevel.DEBUG, format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            this.internalLog(LogLevel.DEBUG, format, arguments);
        }
    }

    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        if (this.logger.isDebugEnabled()) {
            consumer.accept((org.osgi.service.log.Logger)this);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.log(LogLevel.INFO, message);
        }
    }

    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            this.internalLog(LogLevel.INFO, format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            this.internalLog(LogLevel.INFO, format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.logger.isInfoEnabled()) {
            this.internalLog(LogLevel.INFO, format, arguments);
        }
    }

    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        if (this.logger.isInfoEnabled()) {
            consumer.accept((org.osgi.service.log.Logger)this);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String message) {
        if (this.logger.isWarnEnabled()) {
            this.log(LogLevel.WARN, message);
        }
    }

    public void warn(String format, Object arg) {
        if (this.logger.isWarnEnabled()) {
            this.internalLog(LogLevel.WARN, format, arg);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isWarnEnabled()) {
            this.internalLog(LogLevel.WARN, format, arg1, arg2);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.logger.isWarnEnabled()) {
            this.internalLog(LogLevel.WARN, format, arguments);
        }
    }

    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        if (this.logger.isWarnEnabled()) {
            consumer.accept((org.osgi.service.log.Logger)this);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String message) {
        if (this.logger.isErrorEnabled()) {
            this.log(LogLevel.ERROR, message);
        }
    }

    public void error(String format, Object arg) {
        if (this.logger.isErrorEnabled()) {
            this.internalLog(LogLevel.ERROR, format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isErrorEnabled()) {
            this.internalLog(LogLevel.ERROR, format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.logger.isErrorEnabled()) {
            this.internalLog(LogLevel.ERROR, format, arguments);
        }
    }

    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        if (this.logger.isErrorEnabled()) {
            consumer.accept((org.osgi.service.log.Logger)this);
        }
    }

    public void audit(String message) {
        this.info(message);
    }

    public void audit(String format, Object arg) {
        this.info(format, arg);
    }

    public void audit(String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void audit(String format, Object ... arguments) {
        this.info(format, arguments);
    }
}

