/*
 * Decompiled with CFR 0.152.
 */
package com.github.valdr.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.valdr.ConstraintParser;
import com.github.valdr.Options;
import com.github.valdr.cli.GracefulCliParser;
import com.github.valdr.cli.IncompleteCliException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class ValdrBeanValidation {
    private ValdrBeanValidation() {
    }

    public static void main(String[] args) {
        org.apache.commons.cli.Options cliOptions = ValdrBeanValidation.createCliOptions();
        try {
            CommandLine cli = ValdrBeanValidation.parseCli(args, cliOptions);
            Options options = ValdrBeanValidation.loadOptions(cli);
            ValdrBeanValidation.validate(options);
            ConstraintParser parser = new ConstraintParser(options);
            try {
                ValdrBeanValidation.output(parser, options.getOutputFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IncompleteCliException e) {
            ValdrBeanValidation.printErrorWithUsageAndHelp(cliOptions);
        }
    }

    private static Options loadOptions(CommandLine cli) {
        Options options;
        InputStream inputStream = null;
        String configFile = cli.getOptionValue("cf");
        String outputFile = cli.getOptionValue("outputFile");
        try {
            if (StringUtils.isEmpty((CharSequence)configFile)) {
                inputStream = ValdrBeanValidation.class.getResourceAsStream("/valdr-bean-validation.json");
                System.out.println("Building parser configuration from default file path. Looking for '/valdr-bean-validation.json' in classpath.");
            } else {
                System.out.println("Building parser configuration from configured file path '" + configFile + "'.");
                inputStream = new FileInputStream(new File(configFile));
            }
            Options options2 = (Options)new ObjectMapper().readValue(inputStream, Options.class);
            if (StringUtils.isNotEmpty((CharSequence)outputFile)) {
                System.out.println("Setting 'outputFile' to '" + outputFile + "' as passed to CLI.");
                options2.setOutputFile(outputFile);
            }
            options = options2;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Cannot read config file.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return options;
    }

    private static void validate(Options options) {
        options.validate();
        System.out.println("Provided configuration validated: ok.");
    }

    private static void printErrorWithUsageAndHelp(org.apache.commons.cli.Options cliOptions) {
        System.out.println("Error. Not all mandatory args provided.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + ValdrBeanValidation.class.getSimpleName(), cliOptions, true);
    }

    private static CommandLine parseCli(String[] args, org.apache.commons.cli.Options options) throws IncompleteCliException {
        GracefulCliParser parser = new GracefulCliParser();
        try {
            CommandLine commandLine = parser.parse(options, args);
            if (parser.isIncomplete()) {
                throw new IncompleteCliException();
            }
            return commandLine;
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse command line.", e);
        }
    }

    private static org.apache.commons.cli.Options createCliOptions() {
        org.apache.commons.cli.Options options = new org.apache.commons.cli.Options();
        options.addOption(new Option("cf", true, "path to JSON config file, if omitted valdr-bean-validation.json is expected at root of class path"));
        options.addOption(new Option("outputFile", true, "path to output file, which will be used, if no outputFile is specified in the JSON config"));
        return options;
    }

    private static void output(ConstraintParser parser, String outputFile) throws IOException {
        String output = parser.parse();
        if (StringUtils.isEmpty((CharSequence)outputFile)) {
            System.out.println(output);
        } else {
            File file = new File(outputFile);
            file.getParentFile().mkdirs();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");){
                writer.write(output);
            }
        }
    }
}

