/*
 * Decompiled with CFR 0.152.
 */
package com.github.valdr;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.valdr.ConstraintParser;
import com.github.valdr.Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationRulesServlet
extends HttpServlet {
    private final Logger logger = LoggerFactory.getLogger(ValidationRulesServlet.class);
    private boolean correctlyConfigured = false;
    private String corsAllowOriginPattern;
    private String invalidConfigurationMessage;
    private ConstraintParser parser;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Options options = this.loadOptions();
        this.invalidConfigurationMessage = this.validate(options);
        this.correctlyConfigured = StringUtils.isEmpty((CharSequence)this.invalidConfigurationMessage);
        this.corsAllowOriginPattern = options.getCorsAllowOriginPattern();
        this.parser = new ConstraintParser(options);
        this.logConfigurationStatus();
        this.logCorsStatus();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.correctlyConfigured) {
            String json = this.parser.parse();
            this.returnJson(response, json);
        } else {
            this.sendErrorInvalidConfiguration(response);
        }
    }

    private Options loadOptions() {
        Options options;
        InputStream inputStream = null;
        String configFile = this.getInitParameter("configFile");
        try {
            if (StringUtils.isEmpty((CharSequence)configFile)) {
                this.logger.info("Building parser configuration from default file path. Looking for '{}' in classpath.", (Object)"/valdr-bean-validation.json");
                inputStream = ValidationRulesServlet.class.getResourceAsStream("/valdr-bean-validation.json");
            } else {
                this.logger.info("Building parser configuration from configured file path '{}'.", (Object)configFile);
                inputStream = new FileInputStream(new File(configFile));
            }
            options = (Options)new ObjectMapper().readValue(inputStream, Options.class);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Cannot read config file.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return options;
    }

    private String validate(Options options) {
        String validationMsg = "";
        try {
            options.validate();
        }
        catch (Options.InvalidConfigurationException e) {
            validationMsg = "Invalid configuration: " + e.getMessage();
        }
        return validationMsg;
    }

    private void logConfigurationStatus() {
        if (this.correctlyConfigured) {
            this.logger.info("The Servlet appears to be correctly configured.");
        } else {
            this.logger.warn(this.invalidConfigurationMessage);
        }
    }

    private void logCorsStatus() {
        String logMsg = "Configured CORS allow-origin pattern is '{}'.";
        if (StringUtils.isEmpty((CharSequence)this.corsAllowOriginPattern)) {
            logMsg = logMsg + " Therefore, not using CORS.";
        }
        this.logger.info(logMsg, (Object)this.corsAllowOriginPattern);
    }

    private void sendErrorInvalidConfiguration(HttpServletResponse response) throws IOException {
        response.sendError(500, this.invalidConfigurationMessage);
    }

    private void returnJson(HttpServletResponse response, String json) throws IOException {
        this.setCorsHeader(response);
        response.setContentType("application/json;charset=UTF-8");
        response.setContentLength(json.getBytes("utf-8").length);
        PrintWriter writer = response.getWriter();
        writer.write(json);
        writer.close();
    }

    private void setCorsHeader(HttpServletResponse response) {
        if (StringUtils.isNotEmpty((CharSequence)this.corsAllowOriginPattern)) {
            response.setHeader("Access-Control-Allow-Origin", this.corsAllowOriginPattern);
        }
    }
}

