/*
 * Decompiled with CFR 0.152.
 */
package com.github.valdr;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.valdr.AnnotatedClass;
import com.github.valdr.BuiltInConstraint;
import com.github.valdr.ClassConstraints;
import com.github.valdr.ClasspathScanner;
import com.github.valdr.MinimalMap;
import com.github.valdr.Options;
import com.github.valdr.serializer.MinimalMapSerializer;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintParser {
    private final Logger logger = LoggerFactory.getLogger(ConstraintParser.class);
    private final ClasspathScanner classpathScanner;
    private final Iterable<Class<? extends Annotation>> allRelevantAnnotationClasses;
    private final Options options;

    public ConstraintParser(Options options) {
        this.options = options;
        this.classpathScanner = new ClasspathScanner(options);
        this.allRelevantAnnotationClasses = Iterables.concat(BuiltInConstraint.getAllBeanValidationAnnotations(), this.getConfiguredCustomAnnotations());
    }

    public String parse() {
        HashMap<String, ClassConstraints> classNameToValidationRulesMap = new HashMap<String, ClassConstraints>();
        for (Class<?> clazz : this.classpathScanner.findClassesToParse()) {
            ClassConstraints classValidationRules;
            if (clazz == null || (classValidationRules = new AnnotatedClass(clazz, this.options.getExcludedFields(), this.allRelevantAnnotationClasses).extractValidationRules()).size() <= 0) continue;
            String name = this.options.getOutputFullTypeName() != false ? clazz.getName() : clazz.getSimpleName();
            classNameToValidationRulesMap.put(name, classValidationRules);
        }
        return this.toJson(classNameToValidationRulesMap);
    }

    private String toJson(Map<String, ClassConstraints> classNameToValidationRulesMap) {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(MinimalMap.class, new MinimalMapSerializer());
        objectMapper.registerModule((Module)module);
        ObjectWriter ow = objectMapper.writer().withDefaultPrettyPrinter();
        return ow.writeValueAsString(classNameToValidationRulesMap);
    }

    private Iterable<? extends Class<? extends Annotation>> getConfiguredCustomAnnotations() {
        return Iterables.transform(this.options.getCustomAnnotationClasses(), (Function)new Function<String, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(String className) {
                Class validatorClass = ReflectionUtils.forName((String)className, (ClassLoader[])new ClassLoader[0]);
                if (validatorClass.isAnnotation()) {
                    return validatorClass;
                }
                ConstraintParser.this.logger.warn("The configured custom annotation class '{}' is not an annotation. It will be ignored.", (Object)validatorClass);
                return null;
            }
        });
    }
}

