/*
 * Decompiled with CFR 0.152.
 */
package com.github.valdr;

import com.github.valdr.Options;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanner {
    private final Logger logger = LoggerFactory.getLogger(ClasspathScanner.class);
    private final Options options;

    public ClasspathScanner(Options options) {
        this.options = options;
    }

    public Set<Class<?>> findClassesToParse() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(this.buildClassLoaderUrls()).setScanners(new Scanner[]{new SubTypesScanner(false)}).filterInputsBy(this.buildPackagePredicates()));
        return reflections.getSubTypesOf(Object.class);
    }

    private Collection<URL> buildClassLoaderUrls() {
        HashSet urls = Sets.newHashSet();
        for (String packageName : this.options.getModelPackages()) {
            if (!StringUtils.isNotEmpty((CharSequence)packageName)) continue;
            urls.addAll(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0]));
        }
        return urls;
    }

    private Predicate<String> buildPackagePredicates() {
        FilterBuilder filterBuilder = new FilterBuilder();
        for (String packageName : this.options.getModelPackages()) {
            filterBuilder.include(FilterBuilder.prefix((String)packageName));
        }
        for (String excludedClassName : this.options.getExcludedClasses()) {
            filterBuilder.exclude("^" + StringUtils.replace((String)excludedClassName, (String)".", (String)"\\.") + "\\.class$");
        }
        return filterBuilder;
    }
}

