/*
 * Decompiled with CFR 0.152.
 */
package com.github.valdr;

import com.github.valdr.ConstraintAttributes;
import com.github.valdr.decorator.AbstractConstraintAttributesDecorator;
import com.github.valdr.decorator.NullDecorator;
import com.github.valdr.decorator.PatternDecorator;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.URL;

public enum BuiltInConstraint {
    REQUIRED("required", NotNull.class),
    MIN("min", Min.class),
    MAX("max", Max.class),
    SIZE("size", Size.class),
    DIGITS("digits", Digits.class),
    PATTERN("pattern", Pattern.class, PatternDecorator.class),
    FUTURE("future", Future.class),
    PAST("past", Past.class),
    EMAIL("hibernateEmail", Email.class),
    URL("hibernateUrl", URL.class);

    private final Class<? extends Annotation> beanValidationAnnotation;
    private final Class<? extends AbstractConstraintAttributesDecorator> decorator;
    private final String camelCaseName;

    private BuiltInConstraint(String camelCaseName, Class<? extends Annotation> beanValidationAnnotation) {
        this(camelCaseName, beanValidationAnnotation, NullDecorator.class);
    }

    private BuiltInConstraint(String camelCaseName, Class<? extends Annotation> beanValidationAnnotation, Class<? extends AbstractConstraintAttributesDecorator> decorator) {
        this.camelCaseName = camelCaseName;
        this.decorator = decorator;
        this.beanValidationAnnotation = beanValidationAnnotation;
    }

    public String toString() {
        return this.camelCaseName;
    }

    public AbstractConstraintAttributesDecorator createDecoratorFor(ConstraintAttributes attributes) {
        return this.decorator.getConstructor(ConstraintAttributes.class).newInstance(attributes);
    }

    public static Iterable<Class<? extends Annotation>> getAllBeanValidationAnnotations() {
        return Iterables.transform(Arrays.asList(BuiltInConstraint.values()), (Function)new Function<BuiltInConstraint, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(BuiltInConstraint input) {
                if (input == null) {
                    throw new NullPointerException("Passed validator must not be null.");
                }
                return input.getBeanValidationAnnotation();
            }
        });
    }

    public static BuiltInConstraint valueOfAnnotationClassOrNull(Class<? extends Annotation> beanValidationAnnotation) {
        for (BuiltInConstraint supportedValidator : BuiltInConstraint.values()) {
            if (!supportedValidator.getBeanValidationAnnotation().equals(beanValidationAnnotation)) continue;
            return supportedValidator;
        }
        return null;
    }

    public Class<? extends Annotation> getBeanValidationAnnotation() {
        return this.beanValidationAnnotation;
    }
}

