/*
 * Decompiled with CFR 0.152.
 */
package com.github.valdr;

import com.github.valdr.BuiltInConstraint;
import com.github.valdr.ConstraintAttributes;
import com.github.valdr.FieldConstraints;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class AnnotatedField {
    private final Field field;
    private final Iterable<Class<? extends Annotation>> relevantAnnotationClasses;

    AnnotatedField(Field field, Iterable<Class<? extends Annotation>> relevantAnnotationClasses) {
        this.field = field;
        this.relevantAnnotationClasses = relevantAnnotationClasses;
    }

    FieldConstraints extractValidationRules() {
        Annotation[] annotations = this.field.getAnnotations();
        FieldConstraints fieldConstraints = new FieldConstraints();
        for (Annotation annotation : annotations) {
            if (!Iterables.contains(this.relevantAnnotationClasses, annotation.annotationType())) continue;
            ConstraintAttributes constraintAttributes = new ConstraintAttributes(annotation);
            BuiltInConstraint supportedValidator = BuiltInConstraint.valueOfAnnotationClassOrNull(annotation.annotationType());
            if (supportedValidator == null) {
                fieldConstraints.put(annotation.annotationType().getName(), constraintAttributes);
                continue;
            }
            fieldConstraints.put(supportedValidator.toString(), supportedValidator.createDecoratorFor(constraintAttributes));
        }
        return fieldConstraints;
    }
}

