/*
 * Decompiled with CFR 0.152.
 */
package com.github.valdr;

import com.github.valdr.AnnotatedField;
import com.github.valdr.ClassConstraints;
import com.github.valdr.FieldConstraints;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.reflections.ReflectionUtils;

public class AnnotatedClass {
    private final Class clazz;
    private final List<String> excludedFields;
    private final Iterable<Class<? extends Annotation>> relevantAnnotationClasses;

    AnnotatedClass(Class clazz, List<String> excludedFields, Iterable<Class<? extends Annotation>> relevantAnnotationClasses) {
        this.clazz = clazz;
        this.excludedFields = excludedFields;
        this.relevantAnnotationClasses = relevantAnnotationClasses;
    }

    ClassConstraints extractValidationRules() {
        ClassConstraints classConstraints = new ClassConstraints();
        Set allFields = ReflectionUtils.getAllFields((Class)this.clazz, (Predicate[])new Predicate[]{this.buildAnnotationsPredicate()});
        for (Field field : allFields) {
            FieldConstraints fieldValidationRules;
            if (!this.isNotExcluded(field) || (fieldValidationRules = new AnnotatedField(field, this.relevantAnnotationClasses).extractValidationRules()).size() <= 0) continue;
            classConstraints.put(field.getName(), fieldValidationRules);
        }
        return classConstraints;
    }

    private boolean isNotExcluded(Field field) {
        String fullyQualifiedFieldName = field.getDeclaringClass().getName() + "#" + field.getName();
        return !this.excludedFields.contains(fullyQualifiedFieldName);
    }

    private Predicate<? super Field> buildAnnotationsPredicate() {
        ArrayList predicates = Lists.newArrayList();
        for (Class<? extends Annotation> annotationClass : this.relevantAnnotationClasses) {
            predicates.add(ReflectionUtils.withAnnotation(annotationClass));
        }
        return Predicates.or((Iterable)predicates);
    }
}

