/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DefaultLazyEncryptor
implements StringEncryptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultLazyEncryptor.class);
    private final Singleton<StringEncryptor> singleton = new Singleton<StringEncryptor>(() -> {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(DefaultLazyEncryptor.getRequiredProperty(e, "jasypt.encryptor.password"));
        config.setAlgorithm(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.algorithm", "PBEWithMD5AndDES"));
        config.setKeyObtentionIterations(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.keyObtentionIterations", "1000"));
        config.setPoolSize(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.poolSize", "1"));
        config.setProviderName(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.providerName", null));
        config.setSaltGeneratorClassName(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.saltGeneratorClassname", "org.jasypt.salt.RandomSaltGenerator"));
        config.setStringOutputType(DefaultLazyEncryptor.getProperty(e, "jasypt.encryptor.stringOutputType", "base64"));
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    });

    public DefaultLazyEncryptor(Environment e) {
    }

    private static String getProperty(Environment environment, String key, String defaultValue) {
        if (!DefaultLazyEncryptor.propertyExists(environment, key)) {
            log.info("Encryptor config not found for property {}, using default value: {}", (Object)key, (Object)defaultValue);
        }
        return environment.getProperty(key, defaultValue);
    }

    private static boolean propertyExists(Environment environment, String key) {
        return environment.getProperty(key) != null;
    }

    private static String getRequiredProperty(Environment environment, String key) {
        if (!DefaultLazyEncryptor.propertyExists(environment, key)) {
            throw new IllegalStateException(String.format("Required Encryption configuration property missing: %s", key));
        }
        return environment.getProperty(key);
    }

    public String encrypt(String message) {
        return this.singleton.get().encrypt(message);
    }

    public String decrypt(String encryptedMessage) {
        return this.singleton.get().decrypt(encryptedMessage);
    }
}

