/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.annotation.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.annotation.EncryptablePropertySources;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableEnumerablePropertySourceWrapper;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.env.PropertySourcesLoader;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EncryptablePropertySourceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(EncryptablePropertySourceBeanFactoryPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurableEnvironment env = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        DefaultResourceLoader ac = new DefaultResourceLoader();
        EncryptablePropertyResolver resolver = (EncryptablePropertyResolver)beanFactory.getBean(env.resolveRequiredPlaceholders("${jasypt.encryptor.property.resolver-bean:encryptablePropertyResolver}"), EncryptablePropertyResolver.class);
        MutablePropertySources propertySources = env.getPropertySources();
        Stream<AnnotationAttributes> encryptablePropertySourcesMetadata = EncryptablePropertySourceBeanFactoryPostProcessor.getEncryptablePropertySourcesMetadata(beanFactory);
        encryptablePropertySourcesMetadata.forEach(arg_0 -> EncryptablePropertySourceBeanFactoryPostProcessor.lambda$postProcessBeanFactory$0(env, (ResourceLoader)ac, resolver, propertySources, arg_0));
    }

    private static void loadEncryptablePropertySource(AnnotationAttributes encryptablePropertySource, ConfigurableEnvironment env, ResourceLoader resourceLoader, EncryptablePropertyResolver resolver, MutablePropertySources propertySources) throws BeansException {
        try {
            PropertySource ps = EncryptablePropertySourceBeanFactoryPostProcessor.createPropertySource(encryptablePropertySource, env, resourceLoader, resolver);
            if (ps != null) {
                propertySources.addLast(ps);
                log.info("Created Encryptable Property Source '{}' from locations: {}", (Object)ps.getName(), Arrays.asList(encryptablePropertySource.getStringArray("value")));
            } else {
                log.info("Ignoring NOT FOUND Encryptable Property Source '{}' from locations: {}", (Object)encryptablePropertySource.getString("name"), Arrays.asList(encryptablePropertySource.getStringArray("value")));
            }
        }
        catch (Exception e) {
            throw new ApplicationContextException("Exception Creating PropertySource", (Throwable)e);
        }
    }

    private static PropertySource createPropertySource(AnnotationAttributes attributes, ConfigurableEnvironment environment, ResourceLoader resourceLoader, EncryptablePropertyResolver resolver) throws Exception {
        String name = attributes.getString("name");
        String[] locations = attributes.getStringArray("value");
        boolean ignoreResourceNotFound = attributes.getBoolean("ignoreResourceNotFound");
        CompositePropertySource compositePropertySource = new CompositePropertySource(EncryptablePropertySourceBeanFactoryPostProcessor.generateName(name));
        Assert.isTrue((locations.length > 0 ? 1 : 0) != 0, (String)"At least one @PropertySource(value) location is required");
        for (String location : locations) {
            String resolvedLocation = environment.resolveRequiredPlaceholders(location);
            Resource resource = resourceLoader.getResource(resolvedLocation);
            if (!resource.exists() && !ignoreResourceNotFound) {
                throw new IllegalStateException("Resource not found: " + location);
            }
            PropertySourcesLoader loader = new PropertySourcesLoader();
            PropertySource propertySource = loader.load(resource, resolvedLocation, null);
            if (propertySource == null) continue;
            compositePropertySource.addPropertySource(propertySource);
        }
        return new EncryptableEnumerablePropertySourceWrapper(compositePropertySource, resolver);
    }

    private static String generateName(String name) {
        return !StringUtils.isEmpty((Object)name) ? name : "EncryptedPropertySource#" + System.currentTimeMillis();
    }

    private static Stream<AnnotationAttributes> getEncryptablePropertySourcesMetadata(ConfigurableListableBeanFactory beanFactory) {
        Stream<AnnotationAttributes> source = EncryptablePropertySourceBeanFactoryPostProcessor.getBeanDefinitionsForAnnotation(beanFactory, EncryptablePropertySource.class);
        Stream sources = EncryptablePropertySourceBeanFactoryPostProcessor.getBeanDefinitionsForAnnotation(beanFactory, EncryptablePropertySources.class).flatMap(map -> Arrays.stream((AnnotationAttributes[])map.get((Object)"value")));
        return Stream.concat(source, sources);
    }

    private static Stream<AnnotationAttributes> getBeanDefinitionsForAnnotation(ConfigurableListableBeanFactory bf, Class<? extends Annotation> annotation) {
        return Arrays.stream(bf.getBeanNamesForAnnotation(annotation)).map(arg_0 -> ((ConfigurableListableBeanFactory)bf).getBeanDefinition(arg_0)).filter(bd -> bd instanceof AnnotatedBeanDefinition).map(bd -> (AnnotatedBeanDefinition)bd).map(AnnotatedBeanDefinition::getMetadata).filter(md -> md.hasAnnotation(annotation.getName())).map(md -> (AnnotationAttributes)md.getAnnotationAttributes(annotation.getName()));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static /* synthetic */ void lambda$postProcessBeanFactory$0(ConfigurableEnvironment env, ResourceLoader ac, EncryptablePropertyResolver resolver, MutablePropertySources propertySources, AnnotationAttributes eps) {
        EncryptablePropertySourceBeanFactoryPostProcessor.loadEncryptablePropertySource(eps, env, ac, resolver, propertySources);
    }
}

