/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class EnableEncryptablePropertiesBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationListener<ApplicationEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(EnableEncryptablePropertiesBeanFactoryPostProcessor.class);
    private ConfigurableEnvironment environment;
    private InterceptionMode interceptionMode;

    public EnableEncryptablePropertiesBeanFactoryPostProcessor() {
        this.interceptionMode = InterceptionMode.PROXY;
    }

    public EnableEncryptablePropertiesBeanFactoryPostProcessor(ConfigurableEnvironment environment, InterceptionMode interceptionMode) {
        this.environment = environment;
        this.interceptionMode = interceptionMode;
    }

    private <T> PropertySource<T> makeEncryptable(PropertySource<T> propertySource, ConfigurableListableBeanFactory registry) {
        EncryptablePropertyResolver resolver = (EncryptablePropertyResolver)registry.getBean(this.environment.resolveRequiredPlaceholders("${jasypt.encryptor.property.resolver-bean:encryptablePropertyResolver}"), EncryptablePropertyResolver.class);
        PropertySource<T> encryptablePropertySource = this.interceptionMode == InterceptionMode.PROXY ? EncryptablePropertySourceConverter.proxyPropertySource(propertySource, resolver) : EncryptablePropertySourceConverter.instantiatePropertySource(propertySource, resolver);
        LOG.info("Converting PropertySource {} [{}] to {}", new Object[]{propertySource.getName(), propertySource.getClass().getName(), AopUtils.isAopProxy(encryptablePropertySource) ? "AOP Proxy" : encryptablePropertySource.getClass().getSimpleName()});
        return encryptablePropertySource;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        LOG.info("Post-processing PropertySource instances");
        MutablePropertySources propSources = this.environment.getPropertySources();
        StreamSupport.stream(propSources.spliterator(), false).filter(ps -> !(ps instanceof EncryptablePropertySource)).map(s -> this.makeEncryptable((PropertySource)s, beanFactory)).collect(Collectors.toList()).forEach(ps -> propSources.replace(ps.getName(), ps));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        LOG.debug("Application Event Raised: {}", (Object)event.getClass().getSimpleName());
    }
}

