/*
 * Decompiled with CFR 0.152.
 */
package org.treeleafj.xdoc.spring.framework;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.treeleafj.xdoc.framework.AbstractHttpFramework;
import org.treeleafj.xdoc.model.ApiAction;
import org.treeleafj.xdoc.model.ApiModule;
import org.treeleafj.xdoc.model.http.HttpApiAction;

public class SpringWebHttpFramework
extends AbstractHttpFramework {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public boolean support(Class<?> classz) {
        return classz.getAnnotation(Controller.class) != null || classz.getAnnotation(RestController.class) != null;
    }

    public List<ApiModule> extend(List<ApiModule> apiModules) {
        apiModules = super.extend(apiModules);
        ArrayList<ApiModule> newApiModules = new ArrayList<ApiModule>();
        for (ApiModule apiModule : apiModules) {
            ApiModule newApiModule = new ApiModule();
            newApiModule.setComment(apiModule.getComment());
            newApiModule.setType(apiModule.getType());
            boolean isjson = this.isJson(apiModule.getType());
            for (ApiAction apiAction : apiModule.getApiActions()) {
                HttpApiAction saa = this.buildSpringApiAction(newApiModule, apiAction, isjson);
                if (saa == null) continue;
                newApiModule.getApiActions().add(saa);
            }
            newApiModules.add(newApiModule);
        }
        return newApiModules;
    }

    private HttpApiAction buildSpringApiAction(ApiModule apiModule, ApiAction apiAction, boolean isjson) {
        boolean isMappingMethod;
        HttpApiAction saa = new HttpApiAction();
        try {
            BeanUtils.copyProperties((Object)saa, (Object)apiAction);
        }
        catch (Exception e) {
            this.logger.error("copy ApiAction to HttpApiAction properties error", (Throwable)e);
            return null;
        }
        if (isjson || apiAction.getMethod().getAnnotation(ResponseBody.class) != null) {
            saa.setJson(true);
        }
        if (!(isMappingMethod = this.setUrisAndMethods(apiModule, apiAction, saa))) {
            return null;
        }
        return saa;
    }

    private boolean setUrisAndMethods(ApiModule apiModule, ApiAction apiAction, HttpApiAction saa) {
        RequestMapping methodRequestMappingAnno;
        RequestMapping classRequestMappingAnno = apiModule.getType().getAnnotation(RequestMapping.class);
        String[] parentPath = new String[]{};
        if (classRequestMappingAnno != null) {
            parentPath = classRequestMappingAnno.value();
        }
        if ((methodRequestMappingAnno = apiAction.getMethod().getAnnotation(RequestMapping.class)) != null) {
            saa.setUris(this.getUris(parentPath, methodRequestMappingAnno.value()));
            saa.setMethods(this.getMethods(methodRequestMappingAnno.method()));
            return true;
        }
        PostMapping postMapping = apiAction.getMethod().getAnnotation(PostMapping.class);
        if (postMapping != null) {
            saa.setUris(this.getUris(parentPath, postMapping.value()));
            saa.setMethods(this.getMethods(RequestMethod.POST));
            return true;
        }
        GetMapping getMapping = apiAction.getMethod().getAnnotation(GetMapping.class);
        if (getMapping != null) {
            saa.setUris(this.getUris(parentPath, getMapping.value()));
            saa.setMethods(this.getMethods(RequestMethod.GET));
            return true;
        }
        PutMapping putMapping = apiAction.getMethod().getAnnotation(PutMapping.class);
        if (putMapping != null) {
            saa.setUris(this.getUris(parentPath, putMapping.value()));
            saa.setMethods(this.getMethods(RequestMethod.PUT));
            return true;
        }
        DeleteMapping deleteMapping = apiAction.getMethod().getAnnotation(DeleteMapping.class);
        if (deleteMapping != null) {
            saa.setUris(this.getUris(parentPath, deleteMapping.value()));
            saa.setMethods(this.getMethods(RequestMethod.DELETE));
            return true;
        }
        PatchMapping patchMapping = apiAction.getMethod().getAnnotation(PatchMapping.class);
        if (patchMapping != null) {
            saa.setUris(this.getUris(parentPath, patchMapping.value()));
            saa.setMethods(this.getMethods(RequestMethod.PATCH));
            return true;
        }
        return false;
    }

    protected List<String> getUris(String[] parentPaths, String[] values) {
        if (parentPaths.length == 0) {
            parentPaths = new String[]{""};
        }
        ArrayList<String> uris = new ArrayList<String>(1);
        for (String parentPath : parentPaths) {
            for (String value : values) {
                String uri = parentPath.endsWith("/") && value.startsWith("/") ? parentPath.substring(0, parentPath.length() - 1) + value : (parentPath.length() > 0 && !parentPath.endsWith("/") && !value.startsWith("/") ? parentPath + '/' + value : parentPath + value);
                uris.add(uri);
            }
        }
        return uris;
    }

    protected List<String> getMethods(RequestMethod ... methods) {
        ArrayList<String> methodStrs = new ArrayList<String>();
        for (RequestMethod requestMethod : methods) {
            methodStrs.add(requestMethod.name());
        }
        return methodStrs;
    }

    protected boolean isJson(Class<?> classz) {
        RestController restControllerAnno = classz.getAnnotation(RestController.class);
        ResponseBody responseBody = classz.getAnnotation(ResponseBody.class);
        return responseBody != null || restControllerAnno != null;
    }
}

