/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.store.RequestJournalStore;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;

public class InMemoryRequestJournalStore
implements RequestJournalStore {
    private final Queue<ServeEvent> serveEvents = new ConcurrentLinkedQueue<ServeEvent>();

    @Override
    public void add(ServeEvent event) {
        this.serveEvents.add(event);
    }

    @Override
    public Stream<ServeEvent> getAll() {
        return this.serveEvents.stream();
    }

    @Override
    public void removeLast() {
        this.serveEvents.poll();
    }

    @Override
    public Stream<UUID> getAllKeys() {
        return this.getAll().map(ServeEvent::getId);
    }

    @Override
    public Optional<ServeEvent> get(UUID id) {
        return this.serveEvents.stream().filter(event -> event.getId().equals(id)).findFirst();
    }

    @Override
    public void put(UUID key, ServeEvent event) {
        this.add(event);
    }

    @Override
    public void remove(UUID key) {
        this.get(key).ifPresent(this.serveEvents::remove);
    }

    @Override
    public void clear() {
        this.serveEvents.clear();
    }
}

