/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecordingStatus;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.UUID;

public class RecorderState {
    private final RecordingStatus status;
    private final StubMapping proxyMapping;
    private final RecordSpec spec;
    private final UUID startingServeEventId;
    private final UUID finishingServeEventId;

    public RecorderState(@JsonProperty(value="status") RecordingStatus status, @JsonProperty(value="proxyMapping") StubMapping proxyMapping, @JsonProperty(value="spec") RecordSpec spec, @JsonProperty(value="startingServeEventId") UUID startingServeEventId, @JsonProperty(value="finishingServeEventId") UUID finishingServeEventId) {
        this.status = status;
        this.proxyMapping = proxyMapping;
        this.spec = spec;
        this.startingServeEventId = startingServeEventId;
        this.finishingServeEventId = finishingServeEventId;
    }

    public static RecorderState initial() {
        return new RecorderState(RecordingStatus.NeverStarted, null, null, null, null);
    }

    public RecorderState start(UUID startingServeEventId, StubMapping proxyMapping, RecordSpec spec) {
        return new RecorderState(RecordingStatus.Recording, proxyMapping, spec, startingServeEventId, null);
    }

    public RecorderState stop(UUID finishingServeEventId) {
        return new RecorderState(RecordingStatus.Stopped, this.proxyMapping, this.spec, this.startingServeEventId, finishingServeEventId);
    }

    public RecordingStatus getStatus() {
        return this.status;
    }

    public StubMapping getProxyMapping() {
        return this.proxyMapping;
    }

    public RecordSpec getSpec() {
        return this.spec;
    }

    public UUID getStartingServeEventId() {
        return this.startingServeEventId;
    }

    public UUID getFinishingServeEventId() {
        return this.finishingServeEventId;
    }
}

