/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import com.google.common.base.MoreObjects;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.Promise;

public class ManInTheMiddleSslConnectHandler
extends ConnectHandler {
    private final ServerConnector mitmProxyConnector;

    public ManInTheMiddleSslConnectHandler(ServerConnector mitmProxyConnector) {
        this.mitmProxyConnector = mitmProxyConnector;
    }

    protected void connectToServer(HttpServletRequest request, String ignoredHost, int ignoredPort, Promise<SocketChannel> promise) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.socket().setTcpNoDelay(true);
            channel.configureBlocking(false);
            String host = (String)MoreObjects.firstNonNull((Object)this.mitmProxyConnector.getHost(), (Object)"localhost");
            int port = this.mitmProxyConnector.getLocalPort();
            InetSocketAddress address = this.newConnectAddress(host, port);
            channel.connect(address);
            promise.succeeded((Object)channel);
        }
        catch (Throwable x) {
            this.close(channel);
            promise.failed(x);
        }
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

